/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.codeWithMe.ClientId;
import com.intellij.microservices.HttpReferenceService;
import com.intellij.microservices.url.references.UrlSegmentReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B;\b\u0007\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\n\u0010\u001a\u001a\u00020\u0005H\u0096\u0080\u0004R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/intellij/microservices/url/references/AuthorityReference;", "Lcom/intellij/psi/PsiReferenceBase$Poly;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/microservices/url/references/UrlSegmentReference;", "givenValue", "", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "range", "Lcom/intellij/openapi/util/TextRange;", "customNavigate", "Lkotlin/Function1;", "", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiLanguageInjectionHost;Lcom/intellij/openapi/util/TextRange;Lkotlin/jvm/functions/Function1;)V", "getGivenValue", "()Ljava/lang/String;", "getCustomNavigate", "()Lkotlin/jvm/functions/Function1;", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "resolve", "toString", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nAuthorityReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorityReference.kt\ncom/intellij/microservices/url/references/AuthorityReference\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,26:1\n42#2,3:27\n*S KotlinDebug\n*F\n+ 1 AuthorityReference.kt\ncom/intellij/microservices/url/references/AuthorityReference\n*L\n19#1:27,3\n*E\n"})
public final class AuthorityReference
extends PsiReferenceBase.Poly<PsiElement>
implements UrlSegmentReference {
    @Nullable
    private final String givenValue;
    @Nullable
    private final Function1<UrlSegmentReference, Unit> customNavigate;

    @JvmOverloads
    public AuthorityReference(@Nullable String givenValue, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange range, @Nullable Function1<? super UrlSegmentReference, Unit> customNavigate) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super((PsiElement)host, range, false);
        this.givenValue = givenValue;
        this.customNavigate = customNavigate;
    }

    public /* synthetic */ AuthorityReference(String string, PsiLanguageInjectionHost psiLanguageInjectionHost, TextRange textRange, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        this(string, psiLanguageInjectionHost, textRange, (Function1<? super UrlSegmentReference, Unit>)function1);
    }

    @Nullable
    public final String getGivenValue() {
        return this.givenValue;
    }

    @Nullable
    public final Function1<UrlSegmentReference, Unit> getCustomNavigate() {
        return this.customNavigate;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiElement[] psiElementArray = new PsiElement[]{this.resolve()};
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])psiElementArray);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"createResults(...)");
        return resolveResultArray;
    }

    @NotNull
    public PsiElement resolve() {
        boolean $i$f$service = false;
        Class<HttpReferenceService> serviceClass$iv = HttpReferenceService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        HttpReferenceService httpReferenceService = (HttpReferenceService)object;
        UrlSegmentReference urlSegmentReference = this;
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        String string = this.givenValue;
        if (string == null) {
            String string2 = this.getValue();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
        }
        return httpReferenceService.resolveAuthorityReference(urlSegmentReference, psiElement, string, this.customNavigate);
    }

    @NotNull
    public String toString() {
        String string = this.givenValue;
        if (string == null) {
            String string2 = this.getValue();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
        }
        String refValue = string;
        return "AuthorityReference(" + refValue + ", " + this.getRangeInElement() + ")";
    }

    @JvmOverloads
    public AuthorityReference(@Nullable String givenValue, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(givenValue, host, range, null, 8, null);
    }
}

