/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.microservices.url.FrameworkUrlPathSpecification;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolverManager;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.util.PartiallyKnownString;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a0\u0010\u0006\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\n\u001a\u001c\u0010\r\u001a\u00020\u0003*\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001f\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u001a\u001a\n\u0010\u001b\u001a\u00020\u001a*\u00020\u001a\u001a\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u001a\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u001a\u0016\u0010\u001f\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\"\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"resolveTargets", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "Lcom/intellij/microservices/url/references/UrlPathContext;", "project", "Lcom/intellij/openapi/project/Project;", "applyFromParsed", "parsedUrl", "Lcom/intellij/microservices/url/references/UrlPksParser$ParsedPksUrl;", "scheme", "", "auth", "path", "configureFromStringHeuristically", "url", "", "specification", "Lcom/intellij/microservices/url/FrameworkUrlPathSpecification;", "canBuildUrlContext", "Ljava/lang/ThreadLocal;", "forbidExpensiveUrlContext", "T", "call", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "chopLeadingEmptyBlock", "Lcom/intellij/microservices/url/UrlPath;", "chopTrailingEmptyBlock", "", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "segments", "hasEmptyTrailingBlock", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nUrlPathContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathContext.kt\ncom/intellij/microservices/url/references/UrlPathContextKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
public final class UrlPathContextKt {
    @NotNull
    private static final ThreadLocal<Boolean> canBuildUrlContext;

    @NotNull
    public static final Set<UrlTargetInfo> resolveTargets(@NotNull UrlPathContext $this$resolveTargets, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveTargets, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        UrlResolverManager urlResolver = UrlResolverManager.Companion.getInstance(project);
        return UrlPathModelKt.filterBestUrlPathMatches$default(SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence($this$resolveTargets.getResolveRequests()), arg_0 -> UrlPathContextKt.resolveTargets$lambda$0(urlResolver, arg_0))), null, 2, null);
    }

    @NotNull
    public static final UrlPathContext applyFromParsed(@NotNull UrlPathContext $this$applyFromParsed, @NotNull UrlPksParser.ParsedPksUrl parsedUrl, boolean scheme, boolean auth, boolean path) {
        UrlPath urlPath;
        Object it;
        Object result;
        block13: {
            Object object;
            block14: {
                Object authorityValue;
                block11: {
                    Object object2;
                    block12: {
                        Object object3;
                        Object object4;
                        Intrinsics.checkNotNullParameter((Object)$this$applyFromParsed, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)parsedUrl, (String)"parsedUrl");
                        result = null;
                        result = $this$applyFromParsed;
                        Object object5 = parsedUrl.getAuthority();
                        if (object5 != null && (object5 = ((PartiallyKnownString)object5).getValueIfKnown()) != null) {
                            Object object6;
                            it = object6 = object5;
                            boolean bl = false;
                            v1 = ((CharSequence)it).length() > 0 ? object6 : null;
                        } else {
                            v1 = authorityValue = null;
                        }
                        if ((object4 = parsedUrl.getScheme()) != null && (object4 = ((PartiallyKnownString)object4).getValueIfKnown()) != null) {
                            Object it2 = it = object4;
                            boolean bl = false;
                            object3 = ((CharSequence)it2).length() > 0 && !Intrinsics.areEqual((Object)it2, (Object)authorityValue) ? it : null;
                        } else {
                            object3 = null;
                        }
                        UrlPathContext schemeValue = object3;
                        urlPath = parsedUrl.getUrlPath();
                        if (!scheme) break block11;
                        object2 = schemeValue;
                        if (object2 == null) break block12;
                        UrlPathContext it3 = object2;
                        boolean bl = false;
                        UrlPathContext urlPathContext = ((UrlPathContext)result).withSchemes(SetsKt.setOf((Object)it3));
                        object2 = urlPathContext;
                        if (urlPathContext != null) break block11;
                    }
                    object2 = result = result;
                }
                if (!auth) break block13;
                object = authorityValue;
                if (object == null) break block14;
                Object it4 = object;
                boolean bl = false;
                UrlPathContext urlPathContext = ((UrlPathContext)result).withAuthorities(SetsKt.setOf((Object)it4));
                object = urlPathContext;
                if (urlPathContext != null) break block13;
            }
            object = result = result;
        }
        if (path) {
            it = urlPath;
            boolean bl = false;
            result = ((UrlPathContext)result).subContext((UrlPath)it);
        }
        return result;
    }

    public static /* synthetic */ UrlPathContext applyFromParsed$default(UrlPathContext urlPathContext, UrlPksParser.ParsedPksUrl parsedPksUrl, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return UrlPathContextKt.applyFromParsed(urlPathContext, parsedPksUrl, bl, bl2, bl3);
    }

    @NotNull
    public static final UrlPathContext configureFromStringHeuristically(@NotNull UrlPathContext $this$configureFromStringHeuristically, @Nullable String url, @NotNull FrameworkUrlPathSpecification specification) {
        Intrinsics.checkNotNullParameter((Object)$this$configureFromStringHeuristically, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        if (url == null) {
            return $this$configureFromStringHeuristically;
        }
        PartiallyKnownString pks = new PartiallyKnownString(url);
        UrlPathContext pathContext = $this$configureFromStringHeuristically;
        UrlPksParser.ParsedPksUrl fullUrl = specification.getParser().parseFullUrl(pks);
        PartiallyKnownString partiallyKnownString = fullUrl.getAuthority();
        CharSequence charSequence = partiallyKnownString != null ? partiallyKnownString.getValueIfKnown() : null;
        pathContext = !(charSequence == null || charSequence.length() == 0) ? UrlPathContextKt.applyFromParsed$default(pathContext, fullUrl, false, false, false, 14, null) : pathContext.subContext(specification.getParser().parseUrlPath(pks).getUrlPath());
        return pathContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T forbidExpensiveUrlContext(@NotNull Function0<? extends T> call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Boolean prev = canBuildUrlContext.get();
        try {
            canBuildUrlContext.set(false);
            Object object = call.invoke();
            return (T)object;
        }
        finally {
            canBuildUrlContext.set(prev);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final UrlPath chopLeadingEmptyBlock(@NotNull UrlPath $this$chopLeadingEmptyBlock) {
        UrlPath urlPath;
        Intrinsics.checkNotNullParameter((Object)$this$chopLeadingEmptyBlock, (String)"<this>");
        if ($this$chopLeadingEmptyBlock != UrlPath.Companion.getEMPTY()) {
            UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)CollectionsKt.firstOrNull($this$chopLeadingEmptyBlock.getSegments());
            boolean bl = pathSegment != null ? pathSegment.isEmpty() : false;
            if (bl) {
                List<UrlPath.PathSegment> newSegments = UrlPathContextKt.chopLeadingEmptyBlock($this$chopLeadingEmptyBlock.getSegments());
                if (newSegments.isEmpty()) {
                    urlPath = UrlPath.Companion.getEMPTY();
                    return urlPath;
                }
                urlPath = new UrlPath(newSegments);
                return urlPath;
            }
        }
        urlPath = $this$chopLeadingEmptyBlock;
        return urlPath;
    }

    @NotNull
    public static final UrlPath chopTrailingEmptyBlock(@NotNull UrlPath $this$chopTrailingEmptyBlock) {
        List<UrlPath.PathSegment> newSegments;
        Intrinsics.checkNotNullParameter((Object)$this$chopTrailingEmptyBlock, (String)"<this>");
        return $this$chopTrailingEmptyBlock != UrlPath.Companion.getEMPTY() && UrlPathContextKt.hasEmptyTrailingBlock($this$chopTrailingEmptyBlock.getSegments()) ? ((newSegments = UrlPathContextKt.chopTrailingEmptyBlock($this$chopTrailingEmptyBlock.getSegments())).isEmpty() ? UrlPath.Companion.getEMPTY() : new UrlPath(newSegments)) : $this$chopTrailingEmptyBlock;
    }

    private static final List<UrlPath.PathSegment> chopLeadingEmptyBlock(List<? extends UrlPath.PathSegment> segments) {
        UrlPath.PathSegment pathSegment = (UrlPath.PathSegment)CollectionsKt.firstOrNull(segments);
        return (pathSegment != null ? pathSegment.isEmpty() : false) ? segments.subList(1, segments.size()) : segments;
    }

    private static final List<UrlPath.PathSegment> chopTrailingEmptyBlock(List<? extends UrlPath.PathSegment> segments) {
        return UrlPathContextKt.hasEmptyTrailingBlock(segments) ? segments.subList(0, segments.size() - 1) : segments;
    }

    private static final boolean hasEmptyTrailingBlock(List<? extends UrlPath.PathSegment> segments) {
        return segments.size() > 1 && ((UrlPath.PathSegment)CollectionsKt.last(segments)).isEmpty();
    }

    private static final Sequence resolveTargets$lambda$0(UrlResolverManager $urlResolver, UrlResolveRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.asSequence($urlResolver.resolve(it));
    }

    private static final Boolean canBuildUrlContext$lambda$0() {
        return true;
    }

    public static final /* synthetic */ ThreadLocal access$getCanBuildUrlContext$p() {
        return canBuildUrlContext;
    }

    public static final /* synthetic */ List access$chopTrailingEmptyBlock(List segments) {
        return UrlPathContextKt.chopTrailingEmptyBlock(segments);
    }

    public static final /* synthetic */ List access$chopLeadingEmptyBlock(List segments) {
        return UrlPathContextKt.chopLeadingEmptyBlock(segments);
    }

    static {
        ThreadLocal<Boolean> threadLocal = ThreadLocal.withInitial(UrlPathContextKt::canBuildUrlContext$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        canBuildUrlContext = threadLocal;
    }
}

