/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.parameters.QueryParameterNameReference;
import com.intellij.microservices.url.references.AuthorityReference;
import com.intellij.microservices.url.references.DefaultExactPathSegmentHandler;
import com.intellij.microservices.url.references.PathSegmentHandler;
import com.intellij.microservices.url.references.SchemeReference;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.microservices.url.references.UrlPathReferenceInjector;
import com.intellij.microservices.url.references.UrlPathReferenceInjectorKt;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.microservices.url.references.UrlSegmentReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.psi.util.StringEntry;
import com.intellij.util.SmartList;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 D*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002DEB'\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\u0006J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J.\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002 \u0010%\u001a\u001c\u0012\u0004\u0012\u00020\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00190\u0006J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010'\u001a\u00020\u0013J \u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0006J!\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00028\u00002\u0006\u0010.\u001a\u00020\u001a\u00a2\u0006\u0002\u0010/J\u0013\u00100\u001a\u0002012\u0006\u00102\u001a\u00028\u0000\u00a2\u0006\u0002\u00103J\u0013\u00104\u001a\u0002052\u0006\u0010-\u001a\u00028\u0000\u00a2\u0006\u0002\u00106J!\u00107\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00028\u00002\u0006\u0010.\u001a\u00020\u001a\u00a2\u0006\u0002\u0010/J?\u00108\u001a\b\u0012\u0004\u0012\u00020,0\"2\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\"2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020,0\"2\u0006\u00102\u001a\u00028\u00002\u0006\u0010.\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010<J\u0013\u0010=\u001a\u00020>2\u0006\u00102\u001a\u00028\u0000\u00a2\u0006\u0002\u0010?J;\u0010@\u001a\b\u0012\u0004\u0012\u00020,0\"2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00070\"2\b\u0010B\u001a\u0004\u0018\u00010\r2\u0006\u00102\u001a\u00028\u00002\u0006\u0010.\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010CR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\u0017\u001a\u001c\u0012\u0004\u0012\u00020\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00190\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000f\"\u0004\b\u001d\u0010\u0011\u00a8\u0006F"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "S", "", "urlParser", "Lcom/intellij/microservices/url/references/UrlPksParser;", "splitRetrieval", "Lkotlin/Function1;", "Lcom/intellij/psi/util/PartiallyKnownString;", "<init>", "(Lcom/intellij/microservices/url/references/UrlPksParser;Lkotlin/jvm/functions/Function1;)V", "getUrlParser", "()Lcom/intellij/microservices/url/references/UrlPksParser;", "defaultRootContextProvider", "Lcom/intellij/microservices/url/references/UrlPathContext;", "getDefaultRootContextProvider", "()Lkotlin/jvm/functions/Function1;", "setDefaultRootContextProvider", "(Lkotlin/jvm/functions/Function1;)V", "pathSegmentHandler", "Lcom/intellij/microservices/url/references/PathSegmentHandler;", "navigationHandler", "Lcom/intellij/microservices/url/references/UrlSegmentReference;", "", "alignToHost", "Lcom/intellij/psi/util/StringEntry;", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/TextRange;", "getAlignToHost", "setAlignToHost", "withDefaultRootContextProviderFactory", "factory", "withSchemesSupport", "schemes", "", "", "withCustomHostAligner", "converter", "withPathSegmentHandler", "handler", "withCustomNavigationHandler", "navigate", "buildFullUrlReference", "", "Lcom/intellij/psi/PsiReference;", "uElement", "host", "(Ljava/lang/Object;Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "buildReferences", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector$MappedReferences;", "source", "(Ljava/lang/Object;)Lcom/intellij/microservices/url/references/UrlPathReferenceInjector$MappedReferences;", "hasCompleteScheme", "", "(Ljava/lang/Object;)Z", "buildAbsoluteOrRelativeReferences", "buildQueryParamReferences", "queryParameters", "Lcom/intellij/microservices/url/references/UrlPksParser$QueryParameter;", "urlPathReferences", "(Ljava/util/List;Ljava/util/List;Ljava/lang/Object;Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "toUrlPath", "Lcom/intellij/microservices/url/UrlPath;", "(Ljava/lang/Object;)Lcom/intellij/microservices/url/UrlPath;", "buildReferencesForGivenSplit", "slashesSplit", "rootContextProvider", "(Ljava/util/List;Lcom/intellij/microservices/url/references/UrlPathContext;Ljava/lang/Object;Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "Companion", "MappedReferences", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nUrlPathReferenceInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathReferenceInjector.kt\ncom/intellij/microservices/url/references/UrlPathReferenceInjector\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,259:1\n19#2:260\n1651#3:261\n1915#3:262\n1916#3:264\n1652#3:265\n1586#3:266\n1661#3,3:267\n1#4:263\n37#5,2:270\n*S KotlinDebug\n*F\n+ 1 UrlPathReferenceInjector.kt\ncom/intellij/microservices/url/references/UrlPathReferenceInjector\n*L\n184#1:260\n187#1:261\n187#1:262\n187#1:264\n187#1:265\n216#1:266\n216#1:267,3\n187#1:263\n128#1:270,2\n*E\n"})
public final class UrlPathReferenceInjector<S> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlPksParser urlParser;
    @NotNull
    private final Function1<S, PartiallyKnownString> splitRetrieval;
    @NotNull
    private Function1<? super S, UrlPathContext> defaultRootContextProvider;
    @NotNull
    private PathSegmentHandler pathSegmentHandler;
    @Nullable
    private Function1<? super UrlSegmentReference, Unit> navigationHandler;
    @NotNull
    private Function1<? super StringEntry, ? extends Pair<? extends PsiElement, ? extends TextRange>> alignToHost;

    private UrlPathReferenceInjector(UrlPksParser urlParser, Function1<? super S, PartiallyKnownString> splitRetrieval) {
        this.urlParser = urlParser;
        this.splitRetrieval = splitRetrieval;
        this.defaultRootContextProvider = UrlPathReferenceInjector::defaultRootContextProvider$lambda$0;
        this.pathSegmentHandler = DefaultExactPathSegmentHandler.INSTANCE;
        this.alignToHost = UrlPathReferenceInjector::alignToHost$lambda$0;
    }

    @NotNull
    public final UrlPksParser getUrlParser() {
        return this.urlParser;
    }

    @NotNull
    public final Function1<S, UrlPathContext> getDefaultRootContextProvider() {
        return this.defaultRootContextProvider;
    }

    public final void setDefaultRootContextProvider(@NotNull Function1<? super S, UrlPathContext> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.defaultRootContextProvider = function1;
    }

    @NotNull
    public final Function1<StringEntry, Pair<PsiElement, TextRange>> getAlignToHost() {
        return this.alignToHost;
    }

    public final void setAlignToHost(@NotNull Function1<? super StringEntry, ? extends Pair<? extends PsiElement, ? extends TextRange>> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.alignToHost = function1;
    }

    @NotNull
    public final UrlPathReferenceInjector<S> withDefaultRootContextProviderFactory(@NotNull Function1<? super S, UrlPathContext> factory) {
        UrlPathReferenceInjector urlPathReferenceInjector;
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        UrlPathReferenceInjector $this$withDefaultRootContextProviderFactory_u24lambda_u240 = urlPathReferenceInjector = this;
        boolean bl = false;
        $this$withDefaultRootContextProviderFactory_u24lambda_u240.defaultRootContextProvider = factory;
        return urlPathReferenceInjector;
    }

    @NotNull
    public final UrlPathReferenceInjector<S> withSchemesSupport(@NotNull List<String> schemes) {
        UrlPathReferenceInjector urlPathReferenceInjector;
        Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
        UrlPathReferenceInjector $this$withSchemesSupport_u24lambda_u240 = urlPathReferenceInjector = this;
        boolean bl = false;
        UrlPathContext provider = UrlPathContext.Companion.supportingSchemes$default(UrlPathContext.Companion, schemes, null, 2, null);
        $this$withSchemesSupport_u24lambda_u240.defaultRootContextProvider = arg_0 -> UrlPathReferenceInjector.withSchemesSupport$lambda$0$0(provider, arg_0);
        return urlPathReferenceInjector;
    }

    @NotNull
    public final UrlPathReferenceInjector<S> withCustomHostAligner(@NotNull Function1<? super StringEntry, ? extends Pair<? extends PsiElement, ? extends TextRange>> converter) {
        UrlPathReferenceInjector urlPathReferenceInjector;
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        UrlPathReferenceInjector $this$withCustomHostAligner_u24lambda_u240 = urlPathReferenceInjector = this;
        boolean bl = false;
        $this$withCustomHostAligner_u24lambda_u240.alignToHost = converter;
        return urlPathReferenceInjector;
    }

    @NotNull
    public final UrlPathReferenceInjector<S> withPathSegmentHandler(@NotNull PathSegmentHandler handler) {
        UrlPathReferenceInjector urlPathReferenceInjector;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        UrlPathReferenceInjector $this$withPathSegmentHandler_u24lambda_u240 = urlPathReferenceInjector = this;
        boolean bl = false;
        $this$withPathSegmentHandler_u24lambda_u240.pathSegmentHandler = handler;
        return urlPathReferenceInjector;
    }

    @NotNull
    public final UrlPathReferenceInjector<S> withCustomNavigationHandler(@NotNull Function1<? super UrlSegmentReference, Unit> navigate) {
        UrlPathReferenceInjector urlPathReferenceInjector;
        Intrinsics.checkNotNullParameter(navigate, (String)"navigate");
        UrlPathReferenceInjector $this$withCustomNavigationHandler_u24lambda_u240 = urlPathReferenceInjector = this;
        boolean bl = false;
        $this$withCustomNavigationHandler_u24lambda_u240.navigationHandler = navigate;
        return urlPathReferenceInjector;
    }

    @NotNull
    public final PsiReference[] buildFullUrlReference(S uElement, @NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PartiallyKnownString partiallyKnownString = (PartiallyKnownString)this.splitRetrieval.invoke(uElement);
        if (partiallyKnownString == null) {
            return new PsiReference[0];
        }
        PartiallyKnownString pkwString = partiallyKnownString;
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)host);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        TextRange hostTextRange = textRange;
        UrlPksParser.ParsedPksUrl parsedUrl = this.urlParser.parseFullUrl(pkwString);
        PartiallyKnownString partiallyKnownString2 = parsedUrl.getScheme();
        if (partiallyKnownString2 == null) {
            return new PsiReference[0];
        }
        PartiallyKnownString scheme = partiallyKnownString2;
        return (PsiReference[])UrlPathContextKt.forbidExpensiveUrlContext(() -> UrlPathReferenceInjector.buildFullUrlReference$lambda$0(scheme, host, this, uElement, parsedUrl, hostTextRange));
    }

    @NotNull
    public final MappedReferences buildReferences(S source) {
        PartiallyKnownString partiallyKnownString = (PartiallyKnownString)this.splitRetrieval.invoke(source);
        if (partiallyKnownString == null) {
            return MappedReferences.Empty.INSTANCE;
        }
        PartiallyKnownString pkwString = partiallyKnownString;
        UrlPksParser.ParsedPksUrlPath parsedUrl = this.urlParser.parseUrlPath(pkwString);
        return new MappedReferences(this, source, parsedUrl){
            private UrlPathContext currentRootContextProvider;
            final /* synthetic */ UrlPathReferenceInjector<S> this$0;
            final /* synthetic */ S $source;
            final /* synthetic */ UrlPksParser.ParsedPksUrlPath $parsedUrl;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                this.$parsedUrl = $parsedUrl;
            }

            public final UrlPathContext rootContext() {
                UrlPathContext urlPathContext = this.currentRootContextProvider;
                if (urlPathContext == null) {
                    urlPathContext = (UrlPathContext)this.this$0.getDefaultRootContextProvider().invoke(this.$source);
                }
                return urlPathContext;
            }

            public MappedReferences withRootContextProvider(UrlPathContext rooContextProvider) {
                buildReferences.1 var2_2;
                Intrinsics.checkNotNullParameter((Object)rooContextProvider, (String)"rooContextProvider");
                buildReferences.1 $this$withRootContextProvider_u24lambda_u240 = var2_2 = this;
                boolean bl = false;
                $this$withRootContextProvider_u24lambda_u240.currentRootContextProvider = rooContextProvider;
                return var2_2;
            }

            public PsiReference[] forPsiElement(PsiElement host) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                return (PsiReference[])UrlPathContextKt.forbidExpensiveUrlContext(() -> buildReferences.1.forPsiElement$lambda$1(this.$parsedUrl, this.this$0, this, this.$source, host));
            }

            private static final PsiReference[] forPsiElement$lambda$1(UrlPksParser.ParsedPksUrlPath $parsedUrl, UrlPathReferenceInjector this$0, buildReferences.1 this$1, Object $source, PsiElement $host) {
                List urlPathReferences = !((Collection)$parsedUrl.getSlashesSplit()).isEmpty() ? UrlPathReferenceInjector.access$buildReferencesForGivenSplit(this$0, $parsedUrl.getSlashesSplit(), this$1.rootContext(), $source, $host) : CollectionsKt.emptyList();
                SmartList result = new SmartList();
                result.addAll((Collection)urlPathReferences);
                result.addAll((Collection)UrlPathReferenceInjector.access$buildQueryParamReferences(this$0, $parsedUrl.getQueryParameters(), urlPathReferences, $source, $host));
                Collection $this$toTypedArray$iv = (Collection)result;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new PsiReference[0]);
            }
        };
    }

    public final boolean hasCompleteScheme(S uElement) {
        PartiallyKnownString partiallyKnownString = (PartiallyKnownString)this.splitRetrieval.invoke(uElement);
        if (partiallyKnownString == null) {
            return false;
        }
        PartiallyKnownString pks = partiallyKnownString;
        UrlPksParser.ParsedPksUrl parsed = this.urlParser.parseFullUrl(pks);
        Object object = parsed.getScheme();
        if (object == null || (object = ((PartiallyKnownString)object).getValueIfKnown()) == null) {
            return false;
        }
        Object schemeValue = object;
        return StringsKt.endsWith$default((String)schemeValue, (String)"://", (boolean)false, (int)2, null);
    }

    @NotNull
    public final PsiReference[] buildAbsoluteOrRelativeReferences(S uElement, @NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Object[] fullReferences = this.buildFullUrlReference(uElement, host);
        if (Companion.hasConsistentFullUrl((PsiReference[])fullReferences) || this.hasCompleteScheme(uElement)) {
            return fullReferences;
        }
        Object[] contextReferences = this.buildReferences(uElement).forPsiElement(host);
        return (PsiReference[])ArraysKt.plus((Object[])fullReferences, (Object[])contextReferences);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<PsiReference> buildQueryParamReferences(List<UrlPksParser.QueryParameter> queryParameters, List<? extends PsiReference> urlPathReferences, S source, PsiElement host) {
        if (queryParameters.isEmpty() || !(host instanceof PsiLanguageInjectionHost)) {
            return CollectionsKt.emptyList();
        }
        result = new SmartList();
        var7_6 /* !! */  = (PsiReference)CollectionsKt.lastOrNull(urlPathReferences);
        if (var7_6 /* !! */  == null) ** GOTO lbl-1000
        $this$asSafely$iv /* !! */  = var7_6 /* !! */ ;
        $i$f$asSafely = false;
        v0 = $this$asSafely$iv /* !! */ ;
        if (!(v0 instanceof UrlPathReference)) {
            v0 = null;
        }
        if ((var8_11 = (UrlPathReference)v0) != null && ($this$asSafely$iv /* !! */  = var8_11.getContext()) != null) {
            v1 = $this$asSafely$iv /* !! */ ;
        } else lbl-1000:
        // 2 sources

        {
            v1 = (UrlPathContext)this.defaultRootContextProvider.invoke(source);
        }
        urlPathContext = v1;
        var7_6 /* !! */  = queryParameters;
        destination$iv = (Collection)result;
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        $i$f$forEach = false;
        var12_14 = $this$forEach$iv$iv.iterator();
        while (var12_14.hasNext()) {
            block8: {
                element$iv = element$iv$iv = var12_14.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv = false;
                queryParameter = (UrlPksParser.QueryParameter)element$iv;
                $i$a$-mapNotNullTo-UrlPathReferenceInjector$buildQueryParamReferences$1 = false;
                var18_20 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)queryParameter.getName().getSegments()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, buildQueryParamReferences$lambda$0$0(com.intellij.psi.PsiElement com.intellij.psi.util.StringEntry ), (Lcom/intellij/psi/util/StringEntry;)Ljava/lang/Boolean;)((PsiElement)host));
                var19_21 = this.alignToHost;
                var20_22 = var18_20.iterator();
                while (var20_22.hasNext()) {
                    var21_23 = var19_21.invoke(var20_22.next());
                    if (var21_23 == null) continue;
                    v2 = var21_23;
                    break block8;
                }
                v2 = null;
            }
            var22_25 = (Pair)v2;
            if (var22_25 != null && (var18_20 = (TextRange)var22_25.getSecond()) != null) {
                nameRangeInHost = var18_20;
                $i$a$-let-UrlPathReferenceInjector$buildQueryParamReferences$1$2 = false;
                v3 = new QueryParameterNameReference(urlPathContext, (PsiLanguageInjectionHost)host, (TextRange)nameRangeInHost, false, 8, null);
            } else {
                v3 = null;
            }
            if (v3 == null) continue;
            it$iv = v3;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv = false;
            destination$iv.add(it$iv);
        }
        return (List)result;
    }

    @NotNull
    public final UrlPath toUrlPath(S source) {
        PartiallyKnownString partiallyKnownString = (PartiallyKnownString)this.splitRetrieval.invoke(source);
        if (partiallyKnownString == null) {
            return UrlPath.Companion.getEMPTY();
        }
        PartiallyKnownString sourceString = partiallyKnownString;
        int schemePosition = PartiallyKnownString.findIndexOfInKnown$default(sourceString, "://", 0, 2, null);
        return schemePosition != -1 ? this.urlParser.parseFullUrl(sourceString).getUrlPath() : this.urlParser.parseUrlPath(sourceString).getUrlPath();
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiReference> buildReferencesForGivenSplit(List<PartiallyKnownString> slashesSplit, UrlPathContext rootContextProvider, S source, PsiElement host) {
        void $this$mapTo$iv$iv;
        Map hostsUrlsMap = UrlPathReferenceInjectorKt.access$mapHostRangesToPathFirTree(this, slashesSplit);
        List currentHostUrls = (List)hostsUrlsMap.get(host);
        Collection collection = currentHostUrls;
        if (collection == null || collection.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Integer n = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)currentHostUrls), UrlPathReferenceInjector::buildReferencesForGivenSplit$lambda$0));
        int maxSegments = n != null ? n : -1;
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)host);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        TextRange valueTextRange = textRange;
        Iterable $this$map$iv = currentHostUrls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            TextRange range = (TextRange)pair.component1();
            UrlPath paths = (UrlPath)pair.component2();
            UrlPathContext urlPathContext = rootContextProvider;
            if (urlPathContext == null) {
                urlPathContext = (UrlPathContext)this.defaultRootContextProvider.invoke(source);
            }
            UrlPathContext contextProvider = urlPathContext;
            UrlPathContext urlPathContext2 = contextProvider.subContext(paths);
            TextRange textRange2 = valueTextRange.intersection(range);
            if (textRange2 == null) {
                textRange2 = valueTextRange;
            }
            collection2.add(new UrlPathReference(urlPathContext2, host, textRange2, paths.getSegments().size() == maxSegments, false, this.pathSegmentHandler, this.navigationHandler, 16, null));
        }
        return (List)destination$iv$iv;
    }

    private static final UrlPathContext defaultRootContextProvider$lambda$0(Object it) {
        return UrlPathContext.Companion.emptyRoot();
    }

    private static final Pair alignToHost$lambda$0(StringEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRangeAlignedToHost();
    }

    private static final UrlPathContext withSchemesSupport$lambda$0$0(UrlPathContext $provider, Object it) {
        return $provider;
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiReference[] buildFullUrlReference$lambda$0(PartiallyKnownString $scheme, PsiElement $host, UrlPathReferenceInjector this$0, Object $uElement, UrlPksParser.ParsedPksUrl $parsedUrl, TextRange $hostTextRange) {
        void $this$toTypedArray$iv;
        Object object;
        block10: {
            Object object2;
            SmartList result;
            block12: {
                block13: {
                    UrlPathContext rootContextFromParsedBaseUrl;
                    block11: {
                        AuthorityReference authorityReference;
                        AuthorityReference authorityReference2;
                        result = object = new SmartList();
                        boolean bl = false;
                        TextRange rangeInHost = $scheme.getRangeInHost($host);
                        if (rangeInHost != null && $host instanceof PsiLanguageInjectionHost) {
                            UrlPathContext contextRoot = (UrlPathContext)this$0.defaultRootContextProvider.invoke($uElement);
                            result.add((Object)new SchemeReference($scheme.getValueIfKnown(), contextRoot.getSchemes(), (PsiLanguageInjectionHost)$host, rangeInHost));
                        }
                        PartiallyKnownString partiallyKnownString = $parsedUrl.getAuthority();
                        if (partiallyKnownString == null) break block10;
                        PartiallyKnownString authority = partiallyKnownString;
                        boolean bl2 = false;
                        UrlPathReferenceInjector $this$buildFullUrlReference_u24lambda_u240_u240_u240_u240 = this$0;
                        boolean bl3 = false;
                        if (!($host instanceof PsiLanguageInjectionHost)) {
                            authorityReference2 = null;
                        } else {
                            TextRange authorityRangeInHost = authority.getRangeInHost($host);
                            if (authorityRangeInHost != null) {
                                String string = authority.getValueIfKnown();
                                PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)$host;
                                TextRange textRange = $hostTextRange.intersection(authorityRangeInHost);
                                if (textRange == null) {
                                    textRange = $hostTextRange;
                                }
                                authorityReference2 = new AuthorityReference(string, psiLanguageInjectionHost, textRange, $this$buildFullUrlReference_u24lambda_u240_u240_u240_u240.navigationHandler);
                            } else {
                                CharSequence charSequence = $scheme.getValueIfKnown();
                                authorityReference2 = !(charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)authority.getValueIfKnown()) == null || charSequence.length() == 0) && $parsedUrl.getSlashesSplit().isEmpty() ? new AuthorityReference(authority.getValueIfKnown(), (PsiLanguageInjectionHost)$host, new TextRange($hostTextRange.getEndOffset(), $hostTextRange.getEndOffset()), $this$buildFullUrlReference_u24lambda_u240_u240_u240_u240.navigationHandler) : null;
                            }
                        }
                        if ((authorityReference = authorityReference2) != null) {
                            result.add(authorityReference);
                        }
                        rootContextFromParsedBaseUrl = UrlPathContextKt.applyFromParsed$default((UrlPathContext)this$0.defaultRootContextProvider.invoke($uElement), $parsedUrl, false, false, false, 6, null);
                        if (!(!((Collection)$parsedUrl.getSlashesSplit()).isEmpty())) break block11;
                        object2 = this$0.buildReferencesForGivenSplit($parsedUrl.getSlashesSplit(), rootContextFromParsedBaseUrl, $uElement, $host);
                        break block12;
                    }
                    object2 = (PsiReference)CollectionsKt.lastOrNull((List)((List)result));
                    if (object2 == null || (object2 = object2.getRangeInElement()) == null) break block13;
                    Object lastRef = object2;
                    boolean bl = false;
                    List list = CollectionsKt.listOf((Object)new UrlPathReference(rootContextFromParsedBaseUrl, $host, new TextRange(lastRef.getEndOffset(), lastRef.getEndOffset()), true, false, this$0.pathSegmentHandler, this$0.navigationHandler, 16, null));
                    object2 = list;
                    if (list != null) break block12;
                }
                object2 = CollectionsKt.emptyList();
            }
            Object urlPathReferences = object2;
            result.addAll((Collection)urlPathReferences);
            result.addAll((Collection)this$0.buildQueryParamReferences($parsedUrl.getQueryParameters(), (List<PsiReference>)urlPathReferences, $uElement, $host));
        }
        object = (Collection)object;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    private static final boolean buildQueryParamReferences$lambda$0$0(PsiElement $host, StringEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getHost(), (Object)$host);
    }

    private static final int buildReferencesForGivenSplit$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((UrlPath)it.getSecond()).getSegments().size();
    }

    @JvmStatic
    @NotNull
    public static final <S> UrlPathReferenceInjector<S> forPartialStringFrom(@NotNull UrlPksParser urlParser, @NotNull Function1<? super S, PartiallyKnownString> retrievalFun) {
        return Companion.forPartialStringFrom(urlParser, retrievalFun);
    }

    @JvmStatic
    @NotNull
    public static final <S> UrlPathReferenceInjector<S> forPartialStringFrom(@NotNull Function1<? super S, PartiallyKnownString> retrievalFun) {
        return Companion.forPartialStringFrom(retrievalFun);
    }

    @JvmStatic
    public static final boolean hasConsistentFullUrl(@NotNull PsiReference[] reference) {
        return Companion.hasConsistentFullUrl(reference);
    }

    public /* synthetic */ UrlPathReferenceInjector(UrlPksParser urlParser, Function1 splitRetrieval, DefaultConstructorMarker $constructor_marker) {
        this(urlParser, splitRetrieval);
    }

    public static final /* synthetic */ List access$buildReferencesForGivenSplit(UrlPathReferenceInjector $this, List slashesSplit, UrlPathContext rootContextProvider, Object source, PsiElement host) {
        return $this.buildReferencesForGivenSplit(slashesSplit, rootContextProvider, source, host);
    }

    public static final /* synthetic */ List access$buildQueryParamReferences(UrlPathReferenceInjector $this, List queryParameters, List urlPathReferences, Object source, PsiElement host) {
        return $this.buildQueryParamReferences(queryParameters, urlPathReferences, source, host);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u0002H\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0007J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u0002H\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0007J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReferenceInjector$Companion;", "", "<init>", "()V", "forPartialStringFrom", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector;", "S", "urlParser", "Lcom/intellij/microservices/url/references/UrlPksParser;", "retrievalFun", "Lkotlin/Function1;", "Lcom/intellij/psi/util/PartiallyKnownString;", "hasConsistentFullUrl", "", "reference", "", "Lcom/intellij/psi/PsiReference;", "([Lcom/intellij/psi/PsiReference;)Z", "intellij.platform.lang"})
    @SourceDebugExtension(value={"SMAP\nUrlPathReferenceInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathReferenceInjector.kt\ncom/intellij/microservices/url/references/UrlPathReferenceInjector$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n3279#2,11:260\n3279#2,11:272\n4253#2,12:283\n1#3:271\n2792#4,3:295\n*S KotlinDebug\n*F\n+ 1 UrlPathReferenceInjector.kt\ncom/intellij/microservices/url/references/UrlPathReferenceInjector$Companion\n*L\n61#1:260,11\n62#1:272,11\n63#1:283,12\n65#1:295,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <S> UrlPathReferenceInjector<S> forPartialStringFrom(@NotNull UrlPksParser urlParser, @NotNull Function1<? super S, PartiallyKnownString> retrievalFun) {
            Intrinsics.checkNotNullParameter((Object)urlParser, (String)"urlParser");
            Intrinsics.checkNotNullParameter(retrievalFun, (String)"retrievalFun");
            return new UrlPathReferenceInjector(urlParser, retrievalFun, null);
        }

        @JvmStatic
        @NotNull
        public final <S> UrlPathReferenceInjector<S> forPartialStringFrom(@NotNull Function1<? super S, PartiallyKnownString> retrievalFun) {
            Intrinsics.checkNotNullParameter(retrievalFun, (String)"retrievalFun");
            return this.forPartialStringFrom(new UrlPksParser(null, null, false, 7, null), retrievalFun);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean hasConsistentFullUrl(@NotNull PsiReference[] reference) {
            boolean bl;
            block18: {
                void $this$filterIsInstanceTo$iv$iv;
                Object object;
                PsiReference[] single$iv;
                TextRange schemeRange;
                block22: {
                    block21: {
                        PsiReference[] psiReferenceArray;
                        block17: {
                            Object object2;
                            int n;
                            block20: {
                                block19: {
                                    TextRange textRange;
                                    TextRange single$iv2;
                                    block16: {
                                        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                                        PsiReference[] $this$singleOrNull$iv = reference;
                                        boolean $i$f$singleOrNull = false;
                                        single$iv2 = null;
                                        boolean found$iv = false;
                                        n = $this$singleOrNull$iv.length;
                                        for (int i = 0; i < n; ++i) {
                                            PsiReference element$iv;
                                            PsiReference it = element$iv = $this$singleOrNull$iv[i];
                                            boolean bl2 = false;
                                            if (!(it instanceof SchemeReference)) continue;
                                            if (found$iv) {
                                                textRange = null;
                                                break block16;
                                            }
                                            single$iv2 = element$iv;
                                            found$iv = true;
                                        }
                                        textRange = object2 = !found$iv ? null : single$iv2;
                                    }
                                    if (textRange == null || (object2 = object2.getRangeInElement()) == null) break block19;
                                    TextRange it = single$iv2 = object2;
                                    boolean bl3 = false;
                                    object2 = !it.isEmpty() ? single$iv2 : null;
                                    if (object2 != null) break block20;
                                }
                                return false;
                            }
                            schemeRange = object2;
                            PsiReference[] $this$singleOrNull$iv = reference;
                            boolean $i$f$singleOrNull = false;
                            single$iv = null;
                            boolean found$iv = false;
                            int element$iv = $this$singleOrNull$iv.length;
                            for (n = 0; n < element$iv; ++n) {
                                PsiReference element$iv2;
                                PsiReference it = element$iv2 = $this$singleOrNull$iv[n];
                                boolean bl4 = false;
                                if (!(it instanceof AuthorityReference)) continue;
                                if (found$iv) {
                                    psiReferenceArray = null;
                                    break block17;
                                }
                                single$iv = element$iv2;
                                found$iv = true;
                            }
                            psiReferenceArray = object = !found$iv ? null : single$iv;
                        }
                        if (psiReferenceArray == null || (object = object.getRangeInElement()) == null) break block21;
                        PsiReference[] it = single$iv = object;
                        boolean bl5 = false;
                        object = !it.isEmpty() ? single$iv : null;
                        if (object != null) break block22;
                    }
                    return false;
                }
                PsiReference[] authRange = object;
                PsiReference[] $this$filterIsInstance$iv = reference;
                boolean $i$f$filterIsInstance = false;
                single$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof UrlPathReference)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List urlPathReferences = (List)destination$iv$iv;
                TextRange textRange = schemeRange.union((TextRange)authRange);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"union(...)");
                TextRange baseRange = textRange;
                Iterable $this$none$iv = urlPathReferences;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        UrlPathReference it = (UrlPathReference)element$iv;
                        boolean bl6 = false;
                        if (!it.getRangeInElement().intersectsStrict(baseRange)) continue;
                        bl = false;
                        break block18;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u000bJ\u001b\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReferenceInjector$MappedReferences;", "", "forPsiElement", "", "Lcom/intellij/psi/PsiReference;", "host", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "withRootContextProvider", "rooContextProvider", "Lcom/intellij/microservices/url/references/UrlPathContext;", "Empty", "intellij.platform.lang"})
    public static interface MappedReferences {
        @NotNull
        public PsiReference[] forPsiElement(@NotNull PsiElement var1);

        @NotNull
        public MappedReferences withRootContextProvider(@NotNull UrlPathContext var1);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReferenceInjector$MappedReferences$Empty;", "Lcom/intellij/microservices/url/references/UrlPathReferenceInjector$MappedReferences;", "<init>", "()V", "forPsiElement", "", "Lcom/intellij/psi/PsiReference;", "host", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "withRootContextProvider", "rooContextProvider", "Lcom/intellij/microservices/url/references/UrlPathContext;", "intellij.platform.lang"})
        public static final class Empty
        implements MappedReferences {
            @NotNull
            public static final Empty INSTANCE = new Empty();

            private Empty() {
            }

            @Override
            @NotNull
            public PsiReference[] forPsiElement(@NotNull PsiElement host) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiReference.EMPTY_ARRAY;
            }

            @Override
            @NotNull
            public MappedReferences withRootContextProvider(@NotNull UrlPathContext rooContextProvider) {
                Intrinsics.checkNotNullParameter((Object)rooContextProvider, (String)"rooContextProvider");
                return this;
            }
        }
    }
}

