/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ui.UINumericRange;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.actions.CaretStopOptions;
import com.intellij.openapi.editor.ex.BidiTextDirection;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EditorSettings", storages={@Storage(value="editor.xml")}, category=SettingsCategory.CODE, perClient=true)
public class EditorSettingsExternalizable
implements PersistentStateComponent<OptionSet> {
    @Deprecated(forRemoval=true)
    @NonNls
    public static final String PROP_DOC_COMMENT_RENDERING = "DocCommentRendering";
    public static final UINumericRange BLINKING_RANGE = new UINumericRange(500, 10, 1500);
    public static final UINumericRange TOOLTIPS_DELAY_RANGE = new UINumericRange(500, 1, 5000);
    private static final String SOFT_WRAP_FILE_MASKS_ENABLED_DEFAULT = "*";
    @NonNls
    private static final String SOFT_WRAP_FILE_MASKS_DISABLED_DEFAULT = "*.md; *.txt; *.rst; *.adoc";
    private static final String COMPOSITE_PROPERTY_SEPARATOR = ":";
    @NotNull
    private final OsSpecificState myOsSpecificState;
    private final Set<SoftWrapAppliancePlaces> myPlacesToUseSoftWraps;
    private OptionSet myOptions;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final Map<String, Boolean> myDefaultBreadcrumbVisibility;
    private int myBlockIndent;
    @NonNls
    public static final String STRIP_TRAILING_SPACES_NONE = "None";
    @NonNls
    public static final String STRIP_TRAILING_SPACES_CHANGED = "Changed";
    @NonNls
    public static final String STRIP_TRAILING_SPACES_WHOLE = "Whole";

    public EditorSettingsExternalizable() {
        this((OsSpecificState)ApplicationManager.getApplication().getService(OsSpecificState.class));
    }

    @NonInjectable
    @ApiStatus.Internal
    public EditorSettingsExternalizable(@NotNull OsSpecificState state) {
        if (state == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(0);
        }
        this.myPlacesToUseSoftWraps = EnumSet.noneOf(SoftWrapAppliancePlaces.class);
        this.myOptions = new OptionSet();
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myDefaultBreadcrumbVisibility = new HashMap<String, Boolean>();
        this.myOsSpecificState = state;
    }

    public static EditorSettingsExternalizable getInstance() {
        return (EditorSettingsExternalizable)ApplicationManager.getApplication().getService(EditorSettingsExternalizable.class);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(2);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
        Disposer.register((Disposable)disposable, () -> this.myPropertyChangeSupport.removePropertyChangeListener(listener));
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.myPropertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @NotNull
    public OptionSet getState() {
        OptionSet optionSet = this.myOptions;
        if (optionSet == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(3);
        }
        return optionSet;
    }

    public void loadState(@NotNull OptionSet state) {
        if (state == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(4);
        }
        this.myOptions = state;
        this.parseRawSoftWraps();
    }

    public void noStateLoaded() {
        this.loadState(new OptionSet());
    }

    private void parseRawSoftWraps() {
        String[] placeNames;
        this.myPlacesToUseSoftWraps.clear();
        if (StringUtil.isEmpty((String)this.myOptions.USE_SOFT_WRAPS)) {
            return;
        }
        for (String placeName : placeNames = this.myOptions.USE_SOFT_WRAPS.split(COMPOSITE_PROPERTY_SEPARATOR)) {
            try {
                SoftWrapAppliancePlaces place = SoftWrapAppliancePlaces.valueOf(placeName);
                this.myPlacesToUseSoftWraps.add(place);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.storeRawSoftWraps();
    }

    private void storeRawSoftWraps() {
        String old;
        String newValue;
        StringBuilder buffer = new StringBuilder();
        for (SoftWrapAppliancePlaces placeToStore : this.myPlacesToUseSoftWraps) {
            buffer.append((Object)placeToStore).append(COMPOSITE_PROPERTY_SEPARATOR);
        }
        if (!buffer.isEmpty()) {
            buffer.setLength(buffer.length() - 1);
        }
        if ((newValue = buffer.toString()).equals(old = this.myOptions.USE_SOFT_WRAPS)) {
            return;
        }
        this.myOptions.USE_SOFT_WRAPS = newValue;
        this.myPropertyChangeSupport.firePropertyChange("useSoftWraps", old, newValue);
    }

    public OptionSet getOptions() {
        return this.myOptions;
    }

    public boolean isRightMarginShown() {
        return this.myOptions.IS_RIGHT_MARGIN_SHOWN;
    }

    public void setRightMarginShown(boolean val) {
        boolean old = this.myOptions.IS_RIGHT_MARGIN_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.IS_RIGHT_MARGIN_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("isRightMarginShown", old, val);
    }

    public boolean isLineNumbersShown() {
        return this.myOptions.ARE_LINE_NUMBERS_SHOWN;
    }

    public void setLineNumbersShown(boolean val) {
        boolean old = this.myOptions.ARE_LINE_NUMBERS_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.ARE_LINE_NUMBERS_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("areLineNumbersShown", old, val);
    }

    public EditorSettings.LineNumerationType getLineNumeration() {
        return this.myOptions.LINE_NUMERATION;
    }

    public void setLineNumeration(EditorSettings.LineNumerationType val) {
        EditorSettings.LineNumerationType old = this.myOptions.LINE_NUMERATION;
        if (old == val) {
            return;
        }
        this.myOptions.LINE_NUMERATION = val;
        this.myPropertyChangeSupport.firePropertyChange("lineNumeration", old, val);
    }

    public boolean areGutterIconsShown() {
        return this.myOptions.ARE_GUTTER_ICONS_SHOWN;
    }

    public void setGutterIconsShown(boolean val) {
        boolean old = this.myOptions.ARE_GUTTER_ICONS_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.ARE_GUTTER_ICONS_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("areGutterIconsShown", old, val);
    }

    public boolean isFoldingOutlineShown() {
        return this.myOptions.IS_FOLDING_OUTLINE_SHOWN;
    }

    public void setFoldingOutlineShown(boolean val) {
        boolean old = this.myOptions.IS_FOLDING_OUTLINE_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.IS_FOLDING_OUTLINE_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("isFoldingOutlineShown", old, val);
    }

    public boolean isFoldingOutlineShownOnlyOnHover() {
        return this.myOptions.IS_FOLDING_OUTLINE_SHOWN_ONLY_ON_HOVER;
    }

    public void setFoldingOutlineShownOnlyOnHover(boolean val) {
        boolean old = this.myOptions.IS_FOLDING_OUTLINE_SHOWN_ONLY_ON_HOVER;
        if (old == val) {
            return;
        }
        this.myOptions.IS_FOLDING_OUTLINE_SHOWN_ONLY_ON_HOVER = val;
        this.myPropertyChangeSupport.firePropertyChange("isFoldingOutlineShownOnlyOnHover", old, val);
    }

    public boolean isFoldingEndingsShown() {
        return this.myOptions.IS_FOLDING_ENDINGS_SHOWN;
    }

    public void setFoldingEndingsShown(boolean val) {
        boolean old = this.myOptions.IS_FOLDING_ENDINGS_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.IS_FOLDING_ENDINGS_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("isFoldingEndingsShown", old, val);
    }

    public boolean isBreadcrumbsAbove() {
        return this.myOptions.SHOW_BREADCRUMBS_ABOVE;
    }

    public boolean setBreadcrumbsAbove(boolean value) {
        boolean old = this.myOptions.SHOW_BREADCRUMBS_ABOVE;
        if (old == value) {
            return false;
        }
        this.myOptions.SHOW_BREADCRUMBS_ABOVE = value;
        this.myPropertyChangeSupport.firePropertyChange("showBreadcrumbsAbove", old, value);
        return true;
    }

    public boolean isBreadcrumbsShown() {
        return this.myOptions.SHOW_BREADCRUMBS;
    }

    public boolean setBreadcrumbsShown(boolean value) {
        boolean old = this.myOptions.SHOW_BREADCRUMBS;
        if (old == value) {
            return false;
        }
        this.myOptions.SHOW_BREADCRUMBS = value;
        this.myPropertyChangeSupport.firePropertyChange("showBreadcrumbs", old, value);
        return true;
    }

    public boolean isBreadcrumbsShownFor(String languageID) {
        Boolean visible = this.myOptions.mapLanguageBreadcrumbs.get(languageID);
        if (visible == null) {
            Boolean defaultVisible = this.getDefaultBreadcrumbVisibility(languageID);
            return defaultVisible == null || defaultVisible != false;
        }
        return visible;
    }

    @Nullable
    private Boolean getDefaultBreadcrumbVisibility(@NotNull String languageID) {
        Boolean defaultVisible;
        if (languageID == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(5);
        }
        if ((defaultVisible = this.myDefaultBreadcrumbVisibility.get(languageID)) == null) {
            for (BreadcrumbsProvider provider : BreadcrumbsProvider.EP_NAME.getExtensionList()) {
                for (Language language : provider.getLanguages()) {
                    this.myDefaultBreadcrumbVisibility.put(language.getID(), provider.isShownByDefault());
                }
            }
            defaultVisible = this.myDefaultBreadcrumbVisibility.get(languageID);
        }
        return defaultVisible;
    }

    public void resetDefaultBreadcrumbVisibility() {
        this.myDefaultBreadcrumbVisibility.clear();
    }

    public boolean hasBreadcrumbSettings(String languageID) {
        return this.myOptions.mapLanguageBreadcrumbs.containsKey(languageID);
    }

    @ApiStatus.Internal
    public boolean hasDefaultBreadcrumbSettings(String languageID) {
        return this.getDefaultBreadcrumbVisibility(languageID) != null;
    }

    public boolean setBreadcrumbsShownFor(String languageID, boolean value) {
        boolean newValue;
        Boolean visible = this.myOptions.mapLanguageBreadcrumbs.put(languageID, value);
        boolean bl = newValue = (visible == null || visible != false) != value;
        if (newValue) {
            this.myPropertyChangeSupport.firePropertyChange("BreadcrumbsPerLanguage", visible, (Object)value);
        }
        return newValue;
    }

    public boolean areStickyLinesShown() {
        return this.myOptions.SHOW_STICKY_LINES;
    }

    public boolean setStickyLinesShown(boolean value) {
        boolean old = this.myOptions.SHOW_STICKY_LINES;
        if (old == value) {
            return false;
        }
        this.myOptions.SHOW_STICKY_LINES = value;
        this.myPropertyChangeSupport.firePropertyChange("showStickyLines", old, value);
        return true;
    }

    public boolean areStickyLinesShownFor(String languageID) {
        Boolean visible = this.myOptions.mapLanguageStickyLines.get(languageID);
        if (visible == null) {
            return true;
        }
        return visible;
    }

    @ApiStatus.Internal
    public List<String> getDisabledStickyLines() {
        return this.myOptions.mapLanguageStickyLines.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public boolean setStickyLinesShownFor(String languageID, boolean value) {
        boolean newValue;
        Boolean visible = this.myOptions.mapLanguageStickyLines.put(languageID, value);
        boolean bl = newValue = (visible == null || visible != false) != value;
        if (newValue) {
            this.myPropertyChangeSupport.firePropertyChange("showStickyLinesPerLanguage", visible, (Object)value);
        }
        return newValue;
    }

    public int getStickyLineLimit() {
        return this.myOptions.STICKY_LINES_LIMIT;
    }

    public void setStickyLineLimit(int limit) {
        int old = this.myOptions.STICKY_LINES_LIMIT;
        if (old == limit) {
            return;
        }
        this.myOptions.STICKY_LINES_LIMIT = limit;
        this.myPropertyChangeSupport.firePropertyChange("stickyLinesLimit", old, limit);
    }

    public boolean isDocCommentRenderingEnabled() {
        return this.myOptions.ENABLE_RENDERED_DOC;
    }

    public void setDocCommentRenderingEnabled(boolean value) {
        boolean oldValue = this.myOptions.ENABLE_RENDERED_DOC;
        this.myOptions.ENABLE_RENDERED_DOC = value;
        if (oldValue != value) {
            this.myPropertyChangeSupport.firePropertyChange(PROP_DOC_COMMENT_RENDERING, oldValue, value);
        }
    }

    public boolean isBlockCursor() {
        return this.myOptions.IS_BLOCK_CURSOR;
    }

    public void setBlockCursor(boolean val) {
        boolean old = this.myOptions.IS_BLOCK_CURSOR;
        if (old == val) {
            return;
        }
        this.myOptions.IS_BLOCK_CURSOR = val;
        this.myPropertyChangeSupport.firePropertyChange("isBlockCursor", old, val);
    }

    public boolean isFullLineHeightCursor() {
        return this.myOptions.IS_FULL_LINE_HEIGHT_CURSOR;
    }

    public void setFullLineHeightCursor(boolean val) {
        boolean old = this.myOptions.IS_FULL_LINE_HEIGHT_CURSOR;
        if (old == val) {
            return;
        }
        this.myOptions.IS_FULL_LINE_HEIGHT_CURSOR = val;
        this.myPropertyChangeSupport.firePropertyChange("isFullLineHeightCursor", old, val);
    }

    public boolean isAnimatedCaret() {
        return this.myOptions.IS_ANIMATED_CARET;
    }

    public void setAnimatedCaret(boolean val) {
        boolean old = this.myOptions.IS_ANIMATED_CARET;
        if (old == val) {
            return;
        }
        this.myOptions.IS_ANIMATED_CARET = val;
        this.myPropertyChangeSupport.firePropertyChange("isAnimatedCaret", old, val);
    }

    public boolean isHighlightSelectionOccurrences() {
        return this.myOptions.IS_HIGHLIGHT_SELECTION_OCCURRENCES;
    }

    public void setHighlightSelectionOccurrences(boolean val) {
        boolean old = this.myOptions.IS_HIGHLIGHT_SELECTION_OCCURRENCES;
        if (old == val) {
            return;
        }
        this.myOptions.IS_HIGHLIGHT_SELECTION_OCCURRENCES = val;
        this.myPropertyChangeSupport.firePropertyChange("isHighlightSelectionOccurrences", old, val);
    }

    public boolean isCaretRowShown() {
        return true;
    }

    public int getBlockIndent() {
        return this.myBlockIndent;
    }

    public void setBlockIndent(int blockIndent) {
        this.myBlockIndent = blockIndent;
    }

    public boolean isSmartHome() {
        return this.myOptions.SMART_HOME;
    }

    public void setSmartHome(boolean val) {
        boolean old = this.myOptions.SMART_HOME;
        if (old == val) {
            return;
        }
        this.myOptions.SMART_HOME = val;
        this.myPropertyChangeSupport.firePropertyChange("smartHome", old, val);
    }

    public boolean isUseSoftWraps() {
        return this.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR);
    }

    public boolean isUseSoftWraps(@NotNull SoftWrapAppliancePlaces place) {
        if (place == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(6);
        }
        return this.myPlacesToUseSoftWraps.contains((Object)place);
    }

    public void setUseSoftWraps(boolean use) {
        this.setUseSoftWraps(use, SoftWrapAppliancePlaces.MAIN_EDITOR);
    }

    public void setUseSoftWraps(boolean use, @NotNull SoftWrapAppliancePlaces place) {
        boolean update;
        if (place == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(7);
        }
        if (!(update = use ^ this.myPlacesToUseSoftWraps.contains((Object)place))) {
            return;
        }
        if (use) {
            this.myPlacesToUseSoftWraps.add(place);
        } else {
            this.myPlacesToUseSoftWraps.remove((Object)place);
        }
        this.storeRawSoftWraps();
        if (place == SoftWrapAppliancePlaces.MAIN_EDITOR) {
            this.setSoftWrapFileMasks(this.getSoftWrapFileMasks());
        }
    }

    public boolean isUseCustomSoftWrapIndent() {
        return this.myOptions.USE_CUSTOM_SOFT_WRAP_INDENT;
    }

    public void setUseCustomSoftWrapIndent(boolean use) {
        boolean old = this.myOptions.USE_CUSTOM_SOFT_WRAP_INDENT;
        if (old == use) {
            return;
        }
        this.myOptions.USE_CUSTOM_SOFT_WRAP_INDENT = use;
        this.myPropertyChangeSupport.firePropertyChange("useCustomSoftWrapIndent", old, use);
    }

    public int getCustomSoftWrapIndent() {
        return this.myOptions.CUSTOM_SOFT_WRAP_INDENT;
    }

    public void setCustomSoftWrapIndent(int indent) {
        int old = this.myOptions.CUSTOM_SOFT_WRAP_INDENT;
        if (old == indent) {
            return;
        }
        this.myOptions.CUSTOM_SOFT_WRAP_INDENT = indent;
        this.myPropertyChangeSupport.firePropertyChange("customSoftWrapIndent", old, indent);
    }

    public int getVerticalScrollOffset() {
        return this.myOptions.VERTICAL_SCROLL_OFFSET;
    }

    public void setVerticalScrollOffset(int offset) {
        int old = this.myOptions.VERTICAL_SCROLL_OFFSET;
        if (old == offset) {
            return;
        }
        this.myOptions.VERTICAL_SCROLL_OFFSET = offset;
        this.myPropertyChangeSupport.firePropertyChange("verticalScrollOffset", old, offset);
    }

    public int getHorizontalScrollOffset() {
        return this.myOptions.HORIZONTAL_SCROLL_OFFSET;
    }

    public void setHorizontalScrollOffset(int offset) {
        int old = this.myOptions.HORIZONTAL_SCROLL_OFFSET;
        if (old == offset) {
            return;
        }
        this.myOptions.HORIZONTAL_SCROLL_OFFSET = offset;
        this.myPropertyChangeSupport.firePropertyChange("horizontalScrollOffset", old, offset);
    }

    public int getVerticalScrollJump() {
        return this.myOptions.VERTICAL_SCROLL_JUMP;
    }

    public void setVerticalScrollJump(int jump) {
        int old = this.myOptions.VERTICAL_SCROLL_JUMP;
        if (old == jump) {
            return;
        }
        this.myOptions.VERTICAL_SCROLL_JUMP = jump;
        this.myPropertyChangeSupport.firePropertyChange("verticalScrollJump", old, jump);
    }

    public int getHorizontalScrollJump() {
        return this.myOptions.HORIZONTAL_SCROLL_JUMP;
    }

    public void setHorizontalScrollJump(int jump) {
        int old = this.myOptions.HORIZONTAL_SCROLL_JUMP;
        if (old == jump) {
            return;
        }
        this.myOptions.HORIZONTAL_SCROLL_JUMP = jump;
        this.myPropertyChangeSupport.firePropertyChange("horizontalScrollJump", old, jump);
    }

    public boolean isVirtualSpace() {
        return this.myOptions.IS_VIRTUAL_SPACE;
    }

    public void setVirtualSpace(boolean val) {
        boolean oldValue = this.myOptions.IS_VIRTUAL_SPACE;
        if (oldValue == val) {
            return;
        }
        this.myOptions.IS_VIRTUAL_SPACE = val;
        this.myPropertyChangeSupport.firePropertyChange("VirtualSpace", oldValue, val);
    }

    public boolean isCaretInsideTabs() {
        return this.myOptions.IS_CARET_INSIDE_TABS;
    }

    public void setCaretInsideTabs(boolean val) {
        boolean old = this.myOptions.IS_CARET_INSIDE_TABS;
        if (old == val) {
            return;
        }
        this.myOptions.IS_CARET_INSIDE_TABS = val;
        this.myPropertyChangeSupport.firePropertyChange("isCaretInsideTabs", old, val);
    }

    public boolean isBlinkCaret() {
        return this.myOptions.IS_CARET_BLINKING;
    }

    public void setBlinkCaret(boolean blinkCaret) {
        boolean old = this.myOptions.IS_CARET_BLINKING;
        if (old == blinkCaret) {
            return;
        }
        this.myOptions.IS_CARET_BLINKING = blinkCaret;
        this.myPropertyChangeSupport.firePropertyChange("isCaretBlinking", old, blinkCaret);
    }

    public int getBlinkPeriod() {
        return BLINKING_RANGE.fit(this.myOptions.CARET_BLINKING_PERIOD);
    }

    public void setBlinkPeriod(int blinkInterval) {
        int old = this.myOptions.CARET_BLINKING_PERIOD;
        int newValue = BLINKING_RANGE.fit(blinkInterval);
        if (old == newValue) {
            return;
        }
        this.myOptions.CARET_BLINKING_PERIOD = newValue;
        this.myPropertyChangeSupport.firePropertyChange("caretBlinkingPeriod", old, newValue);
    }

    public boolean isEnsureNewLineAtEOF() {
        return this.myOptions.IS_ENSURE_NEWLINE_AT_EOF;
    }

    public void setEnsureNewLineAtEOF(boolean ensure) {
        boolean old = this.myOptions.IS_ENSURE_NEWLINE_AT_EOF;
        if (old == ensure) {
            return;
        }
        this.myOptions.IS_ENSURE_NEWLINE_AT_EOF = ensure;
        this.myPropertyChangeSupport.firePropertyChange("isEnsureNewlineAtEof", old, ensure);
    }

    public boolean isRemoveTrailingBlankLines() {
        return this.myOptions.REMOVE_TRAILING_BLANK_LINES;
    }

    public void setRemoveTrailingBlankLines(boolean remove) {
        boolean old = this.myOptions.REMOVE_TRAILING_BLANK_LINES;
        if (old == remove) {
            return;
        }
        this.myOptions.REMOVE_TRAILING_BLANK_LINES = remove;
        this.myPropertyChangeSupport.firePropertyChange("removeTrailingBlankLines", old, remove);
    }

    @StripTrailingSpaces
    public String getStripTrailingSpaces() {
        return this.myOptions.STRIP_TRAILING_SPACES;
    }

    public void setStripTrailingSpaces(@StripTrailingSpaces String stripTrailingSpaces) {
        String old = this.myOptions.STRIP_TRAILING_SPACES;
        if (Objects.equals(old, stripTrailingSpaces)) {
            return;
        }
        this.myOptions.STRIP_TRAILING_SPACES = stripTrailingSpaces;
        this.myPropertyChangeSupport.firePropertyChange("stripTrailingSpaces", old, stripTrailingSpaces);
    }

    public boolean isShowQuickDocOnMouseOverElement() {
        return this.myOptions.SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT && !GeneralSettings.getInstance().isSupportScreenReaders();
    }

    public void setShowQuickDocOnMouseOverElement(boolean show) {
        boolean old = this.myOptions.SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT;
        if (old == show) {
            return;
        }
        this.myOptions.SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT = show;
        this.myPropertyChangeSupport.firePropertyChange("showQuickDocOnMouseOverElement", old, show);
    }

    public boolean isShowInspectionWidget() {
        return this.myOptions.SHOW_INSPECTION_WIDGET;
    }

    public void setShowInspectionWidget(boolean show) {
        boolean old = this.myOptions.SHOW_INSPECTION_WIDGET;
        if (old == show) {
            return;
        }
        this.myOptions.SHOW_INSPECTION_WIDGET = show;
        this.myPropertyChangeSupport.firePropertyChange("showInspectionWidget", old, show);
    }

    @Deprecated
    public int getQuickDocOnMouseOverElementDelayMillis() {
        return this.getTooltipsDelay();
    }

    public int getTooltipsDelay() {
        return TOOLTIPS_DELAY_RANGE.fit(this.myOptions.TOOLTIPS_DELAY_MS);
    }

    public void setTooltipsDelay(int delay) {
        int old = this.myOptions.TOOLTIPS_DELAY_MS;
        int newValue = TOOLTIPS_DELAY_RANGE.fit(delay);
        if (old == newValue) {
            return;
        }
        this.myOptions.TOOLTIPS_DELAY_MS = newValue;
        this.myPropertyChangeSupport.firePropertyChange("tooltipsDelayMs", old, newValue);
    }

    public boolean isShowIntentionBulb() {
        return this.myOptions.SHOW_INTENTION_BULB;
    }

    public void setShowIntentionBulb(boolean show) {
        boolean old = this.myOptions.SHOW_INTENTION_BULB;
        if (old == show) {
            return;
        }
        this.myOptions.SHOW_INTENTION_BULB = show;
        this.myPropertyChangeSupport.firePropertyChange("showIntentionBulb", old, show);
    }

    public boolean isRefrainFromScrolling() {
        return this.myOptions.REFRAIN_FROM_SCROLLING;
    }

    public void setRefrainFromScrolling(boolean b) {
        boolean old = this.myOptions.REFRAIN_FROM_SCROLLING;
        if (old == b) {
            return;
        }
        this.myOptions.REFRAIN_FROM_SCROLLING = b;
        this.myPropertyChangeSupport.firePropertyChange("refrainFromScrolling", old, b);
    }

    public boolean isShowNotificationAfterReformat() {
        return Registry.is((String)"editor.show.notification.after.reformat");
    }

    public boolean isShowNotificationAfterOptimizeImports() {
        return Registry.is((String)"editor.show.notification.after.optimize.imports");
    }

    public boolean isWhitespacesShown() {
        return this.myOptions.IS_WHITESPACES_SHOWN;
    }

    public void setWhitespacesShown(boolean val) {
        boolean old = this.myOptions.IS_WHITESPACES_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.IS_WHITESPACES_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("isWhitespacesShown", old, val);
    }

    public boolean isLeadingWhitespacesShown() {
        return this.myOptions.IS_LEADING_WHITESPACES_SHOWN;
    }

    public void setLeadingWhitespacesShown(boolean val) {
        boolean old = this.myOptions.IS_LEADING_WHITESPACES_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.IS_LEADING_WHITESPACES_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("isLeadingWhitespacesShown", old, val);
    }

    public boolean isInnerWhitespacesShown() {
        return this.myOptions.IS_INNER_WHITESPACES_SHOWN;
    }

    public void setInnerWhitespacesShown(boolean val) {
        boolean old = this.myOptions.IS_INNER_WHITESPACES_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.IS_INNER_WHITESPACES_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("isInnerWhitespacesShown", old, val);
    }

    public boolean isTrailingWhitespacesShown() {
        return this.myOptions.IS_TRAILING_WHITESPACES_SHOWN;
    }

    public void setTrailingWhitespacesShown(boolean val) {
        boolean old = this.myOptions.IS_TRAILING_WHITESPACES_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.IS_TRAILING_WHITESPACES_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("isTrailingWhitespacesShown", old, val);
    }

    public boolean isSelectionWhitespacesShown() {
        return this.myOptions.IS_SELECTION_WHITESPACES_SHOWN;
    }

    public void setSelectionWhitespacesShown(boolean val) {
        boolean old = this.myOptions.IS_SELECTION_WHITESPACES_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.IS_SELECTION_WHITESPACES_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("isSelectionWhitespacesShown", old, val);
    }

    public boolean isAllSoftWrapsShown() {
        return this.myOptions.IS_ALL_SOFTWRAPS_SHOWN;
    }

    public void setAllSoftwrapsShown(boolean val) {
        boolean old = this.myOptions.IS_ALL_SOFTWRAPS_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.IS_ALL_SOFTWRAPS_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("isAllSoftwrapsShown", old, val);
    }

    public boolean isIndentGuidesShown() {
        return this.myOptions.IS_INDENT_GUIDES_SHOWN;
    }

    public void setIndentGuidesShown(boolean val) {
        boolean old = this.myOptions.IS_INDENT_GUIDES_SHOWN;
        if (old == val) {
            return;
        }
        this.myOptions.IS_INDENT_GUIDES_SHOWN = val;
        this.myPropertyChangeSupport.firePropertyChange("isIndentGuidesShown", old, val);
    }

    public boolean isFocusMode() {
        return this.myOptions.IS_FOCUS_MODE;
    }

    public void setFocusMode(boolean val) {
        boolean old = this.myOptions.IS_FOCUS_MODE;
        if (old == val) {
            return;
        }
        this.myOptions.IS_FOCUS_MODE = val;
        this.myPropertyChangeSupport.firePropertyChange("isFocusMode", old, val);
    }

    public boolean isSmoothScrolling() {
        return this.myOptions.IS_ANIMATED_SCROLLING;
    }

    public void setSmoothScrolling(boolean val) {
        boolean old = this.myOptions.IS_ANIMATED_SCROLLING;
        if (old == val) {
            return;
        }
        this.myOptions.IS_ANIMATED_SCROLLING = val;
        this.myPropertyChangeSupport.firePropertyChange("isAnimatedScrolling", old, val);
    }

    public boolean isCamelWords() {
        return this.myOptions.IS_CAMEL_WORDS;
    }

    public void setCamelWords(boolean val) {
        boolean old = this.myOptions.IS_CAMEL_WORDS;
        if (old == val) {
            return;
        }
        this.myOptions.IS_CAMEL_WORDS = val;
        this.myPropertyChangeSupport.firePropertyChange("isCamelWords", old, val);
    }

    public boolean isAdditionalPageAtBottom() {
        return this.myOptions.ADDITIONAL_PAGE_AT_BOTTOM;
    }

    public void setAdditionalPageAtBottom(boolean val) {
        boolean old = this.myOptions.ADDITIONAL_PAGE_AT_BOTTOM;
        if (old == val) {
            return;
        }
        this.myOptions.ADDITIONAL_PAGE_AT_BOTTOM = val;
        this.myPropertyChangeSupport.firePropertyChange("additionalPageAtBottom", old, val);
    }

    public boolean isDndEnabled() {
        return this.myOptions.IS_DND_ENABLED;
    }

    public void setDndEnabled(boolean val) {
        boolean old = this.myOptions.IS_DND_ENABLED;
        if (old == val) {
            return;
        }
        this.myOptions.IS_DND_ENABLED = val;
        this.myPropertyChangeSupport.firePropertyChange("isDndEnabled", old, val);
    }

    public boolean isWheelFontChangeEnabled() {
        return this.myOptions.IS_WHEEL_FONTCHANGE_ENABLED;
    }

    public void setWheelFontChangeEnabled(boolean val) {
        boolean old = this.myOptions.IS_WHEEL_FONTCHANGE_ENABLED;
        if (old == val) {
            return;
        }
        this.myOptions.IS_WHEEL_FONTCHANGE_ENABLED = val;
        this.myPropertyChangeSupport.firePropertyChange("isWheelFontchangeEnabled", old, val);
    }

    public boolean isWheelFontChangePersistent() {
        return this.myOptions.IS_WHEEL_FONTCHANGE_PERSISTENT;
    }

    public void setWheelFontChangePersistent(boolean val) {
        boolean old = this.myOptions.IS_WHEEL_FONTCHANGE_PERSISTENT;
        if (old == val) {
            return;
        }
        this.myOptions.IS_WHEEL_FONTCHANGE_PERSISTENT = val;
        this.myPropertyChangeSupport.firePropertyChange("isWheelFontchangePersistent", old, val);
    }

    public boolean isMouseClickSelectionHonorsCamelWords() {
        return this.myOptions.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS;
    }

    public void setMouseClickSelectionHonorsCamelWords(boolean val) {
        boolean old = this.myOptions.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS;
        if (old == val) {
            return;
        }
        this.myOptions.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS = val;
        this.myPropertyChangeSupport.firePropertyChange("isMouseClickSelectionHonorsCamelWords", old, val);
    }

    public boolean isVariableInplaceRenameEnabled() {
        return this.myOptions.RENAME_VARIABLES_INPLACE;
    }

    public void setVariableInplaceRenameEnabled(boolean val) {
        boolean old = this.myOptions.RENAME_VARIABLES_INPLACE;
        if (old == val) {
            return;
        }
        this.myOptions.RENAME_VARIABLES_INPLACE = val;
        this.myPropertyChangeSupport.firePropertyChange("renameVariablesInplace", old, val);
    }

    public boolean isPreselectRename() {
        return this.myOptions.PRESELECT_RENAME;
    }

    public void setPreselectRename(boolean val) {
        boolean old = this.myOptions.PRESELECT_RENAME;
        if (old == val) {
            return;
        }
        this.myOptions.PRESELECT_RENAME = val;
        this.myPropertyChangeSupport.firePropertyChange("preselectRename", old, val);
    }

    public boolean isShowInlineLocalDialog() {
        return this.myOptions.SHOW_INLINE_DIALOG;
    }

    public void setShowInlineLocalDialog(boolean val) {
        boolean old = this.myOptions.SHOW_INLINE_DIALOG;
        if (old == val) {
            return;
        }
        this.myOptions.SHOW_INLINE_DIALOG = val;
        this.myPropertyChangeSupport.firePropertyChange("showInlineDialog", old, val);
    }

    public boolean addCaretsOnDoubleCtrl() {
        return this.myOptions.ADD_CARETS_ON_DOUBLE_CTRL;
    }

    public void setAddCaretsOnDoubleCtrl(boolean val) {
        boolean old = this.myOptions.ADD_CARETS_ON_DOUBLE_CTRL;
        if (old == val) {
            return;
        }
        this.myOptions.ADD_CARETS_ON_DOUBLE_CTRL = val;
        this.myPropertyChangeSupport.firePropertyChange("addCaretsOnDoubleCtrl", old, val);
    }

    @ApiStatus.Internal
    public BidiTextDirection getBidiTextDirection() {
        return this.myOptions.BIDI_TEXT_DIRECTION;
    }

    @ApiStatus.Internal
    public void setBidiTextDirection(BidiTextDirection direction) {
        BidiTextDirection old = this.myOptions.BIDI_TEXT_DIRECTION;
        if (old == direction) {
            return;
        }
        this.myOptions.BIDI_TEXT_DIRECTION = direction;
        this.myPropertyChangeSupport.firePropertyChange("bidiTextDirection", (Object)old, (Object)direction);
    }

    public boolean isShowIntentionPreview() {
        return this.myOptions.SHOW_INTENTION_PREVIEW;
    }

    public void setShowIntentionPreview(boolean show) {
        boolean old = this.myOptions.SHOW_INTENTION_PREVIEW;
        if (old == show) {
            return;
        }
        this.myOptions.SHOW_INTENTION_PREVIEW = show;
        this.myPropertyChangeSupport.firePropertyChange("showIntentionPreview", old, show);
    }

    public boolean isKeepTrailingSpacesOnCaretLine() {
        return this.myOptions.KEEP_TRAILING_SPACE_ON_CARET_LINE;
    }

    public void setKeepTrailingSpacesOnCaretLine(boolean keep) {
        boolean old = this.myOptions.KEEP_TRAILING_SPACE_ON_CARET_LINE;
        if (old == keep) {
            return;
        }
        this.myOptions.KEEP_TRAILING_SPACE_ON_CARET_LINE = keep;
        this.myPropertyChangeSupport.firePropertyChange("keepTrailingSpaceOnCaretLine", old, keep);
    }

    @NotNull
    public String getSoftWrapFileMasks() {
        String storedValue = this.myOptions.SOFT_WRAP_FILE_MASKS;
        if (storedValue != null) {
            String string = storedValue;
            if (string == null) {
                EditorSettingsExternalizable.$$$reportNull$$$0(8);
            }
            return string;
        }
        return this.isUseSoftWraps() ? SOFT_WRAP_FILE_MASKS_ENABLED_DEFAULT : SOFT_WRAP_FILE_MASKS_DISABLED_DEFAULT;
    }

    public void setSoftWrapFileMasks(@NotNull String value) {
        String old;
        if (value == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(9);
        }
        if (value.equals(old = this.myOptions.SOFT_WRAP_FILE_MASKS)) {
            return;
        }
        this.myOptions.SOFT_WRAP_FILE_MASKS = value;
        this.myPropertyChangeSupport.firePropertyChange("softWrapFileMasks", old, value);
    }

    @ApiStatus.Internal
    @NotNull
    public CaretStopOptions getCaretStopOptions() {
        CaretStopOptions caretStopOptions = this.myOsSpecificState.CARET_STOP_OPTIONS;
        if (caretStopOptions == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(10);
        }
        return caretStopOptions;
    }

    @ApiStatus.Internal
    public void setCaretStopOptions(@NotNull CaretStopOptions options) {
        if (options == null) {
            EditorSettingsExternalizable.$$$reportNull$$$0(11);
        }
        this.myOsSpecificState.CARET_STOP_OPTIONS = options;
    }

    public boolean isUseEditorFontInInlays() {
        return this.myOptions.USE_EDITOR_FONT_IN_INLAYS;
    }

    public void setUseEditorFontInInlays(boolean value) {
        boolean old = this.myOptions.USE_EDITOR_FONT_IN_INLAYS;
        if (old == value) {
            return;
        }
        this.myOptions.USE_EDITOR_FONT_IN_INLAYS = value;
        this.myPropertyChangeSupport.firePropertyChange("useEditorFontInInlays", old, value);
    }

    public boolean isInsertParenthesesAutomatically() {
        return this.myOptions.INSERT_PARENTHESES_AUTOMATICALLY;
    }

    public void setInsertParenthesesAutomatically(boolean value) {
        boolean old = this.myOptions.INSERT_PARENTHESES_AUTOMATICALLY;
        if (old == value) {
            return;
        }
        this.myOptions.INSERT_PARENTHESES_AUTOMATICALLY = value;
        this.myPropertyChangeSupport.firePropertyChange("insertParenthesesAutomatically", old, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/EditorSettingsExternalizable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageID";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/EditorSettingsExternalizable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftWrapFileMasks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretStopOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBreadcrumbVisibility";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUseSoftWraps";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setUseSoftWraps";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSoftWrapFileMasks";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCaretStopOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 10 -> new IllegalStateException(string);
        };
    }

    public static final class PropNames {
        @NonNls
        public static final String PROP_USE_SOFT_WRAPS = "useSoftWraps";
        @NonNls
        public static final String PROP_SOFT_WRAP_FILE_MASKS = "softWrapFileMasks";
        @NonNls
        public static final String PROP_USE_CUSTOM_SOFT_WRAP_INDENT = "useCustomSoftWrapIndent";
        @NonNls
        public static final String PROP_CUSTOM_SOFT_WRAP_INDENT = "customSoftWrapIndent";
        @NonNls
        public static final String PROP_IS_VIRTUAL_SPACE = "VirtualSpace";
        @NonNls
        public static final String PROP_VERTICAL_SCROLL_OFFSET = "verticalScrollOffset";
        @NonNls
        public static final String PROP_VERTICAL_SCROLL_JUMP = "verticalScrollJump";
        @NonNls
        public static final String PROP_HORIZONTAL_SCROLL_OFFSET = "horizontalScrollOffset";
        @NonNls
        public static final String PROP_HORIZONTAL_SCROLL_JUMP = "horizontalScrollJump";
        @NonNls
        public static final String PROP_IS_CARET_INSIDE_TABS = "isCaretInsideTabs";
        @NonNls
        public static final String PROP_STRIP_TRAILING_SPACES = "stripTrailingSpaces";
        @NonNls
        public static final String PROP_IS_ENSURE_NEWLINE_AT_EOF = "isEnsureNewlineAtEof";
        @NonNls
        public static final String PROP_REMOVE_TRAILING_BLANK_LINES = "removeTrailingBlankLines";
        @NonNls
        public static final String PROP_SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT = "showQuickDocOnMouseOverElement";
        @NonNls
        public static final String PROP_SHOW_INSPECTION_WIDGET = "showInspectionWidget";
        @NonNls
        public static final String PROP_TOOLTIPS_DELAY_MS = "tooltipsDelayMs";
        @NonNls
        public static final String PROP_SHOW_INTENTION_BULB = "showIntentionBulb";
        @NonNls
        public static final String PROP_IS_CARET_BLINKING = "isCaretBlinking";
        @NonNls
        public static final String PROP_CARET_BLINKING_PERIOD = "caretBlinkingPeriod";
        @NonNls
        public static final String PROP_IS_RIGHT_MARGIN_SHOWN = "isRightMarginShown";
        @NonNls
        public static final String PROP_ARE_LINE_NUMBERS_SHOWN = "areLineNumbersShown";
        @NonNls
        public static final String PROP_ARE_LINE_NUMBERS_AFTER_ICONS = "areLineNumbersAfterIcons";
        @NonNls
        public static final String PROP_LINE_NUMERATION = "lineNumeration";
        @NonNls
        public static final String PROP_ARE_GUTTER_ICONS_SHOWN = "areGutterIconsShown";
        @NonNls
        public static final String PROP_IS_FOLDING_OUTLINE_SHOWN = "isFoldingOutlineShown";
        @NonNls
        public static final String PROP_IS_FOLDING_OUTLINE_SHOWN_ONLY_ON_HOVER = "isFoldingOutlineShownOnlyOnHover";
        @NonNls
        public static final String PROP_IS_FOLDING_ENDINGS_SHOWN = "isFoldingEndingsShown";
        @NonNls
        public static final String PROP_SHOW_BREADCRUMBS_ABOVE = "showBreadcrumbsAbove";
        @NonNls
        public static final String PROP_SHOW_BREADCRUMBS = "showBreadcrumbs";
        @NonNls
        public static final String PROP_SHOW_STICKY_LINES = "showStickyLines";
        @NonNls
        public static final String PROP_SHOW_STICKY_LINES_PER_LANGUAGE = "showStickyLinesPerLanguage";
        @NonNls
        public static final String PROP_STICKY_LINES_LIMIT = "stickyLinesLimit";
        @NonNls
        public static final String PROP_ENABLE_RENDERED_DOC = "DocCommentRendering";
        @NonNls
        public static final String PROP_SHOW_INTENTION_PREVIEW = "showIntentionPreview";
        @NonNls
        public static final String PROP_USE_EDITOR_FONT_IN_INLAYS = "useEditorFontInInlays";
        @NonNls
        public static final String PROP_SMART_HOME = "smartHome";
        @NonNls
        public static final String PROP_IS_BLOCK_CURSOR = "isBlockCursor";
        @NonNls
        public static final String PROP_IS_FULL_LINE_HEIGHT_CURSOR = "isFullLineHeightCursor";
        @NonNls
        public static final String PROP_IS_ANIMATED_CARET = "isAnimatedCaret";
        @NonNls
        public static final String PROP_IS_HIGHLIGHT_SELECTION_OCCURRENCES = "isHighlightSelectionOccurrences";
        @NonNls
        public static final String PROP_IS_WHITESPACES_SHOWN = "isWhitespacesShown";
        @NonNls
        public static final String PROP_IS_LEADING_WHITESPACES_SHOWN = "isLeadingWhitespacesShown";
        @NonNls
        public static final String PROP_IS_INNER_WHITESPACES_SHOWN = "isInnerWhitespacesShown";
        @NonNls
        public static final String PROP_IS_TRAILING_WHITESPACES_SHOWN = "isTrailingWhitespacesShown";
        @NonNls
        public static final String PROP_IS_SELECTION_WHITESPACES_SHOWN = "isSelectionWhitespacesShown";
        @NonNls
        public static final String PROP_IS_ALL_SOFTWRAPS_SHOWN = "isAllSoftwrapsShown";
        @NonNls
        public static final String PROP_IS_INDENT_GUIDES_SHOWN = "isIndentGuidesShown";
        @NonNls
        public static final String PROP_IS_FOCUS_MODE = "isFocusMode";
        @NonNls
        public static final String PROP_IS_ANIMATED_SCROLLING = "isAnimatedScrolling";
        @NonNls
        public static final String PROP_IS_CAMEL_WORDS = "isCamelWords";
        @NonNls
        public static final String PROP_ADDITIONAL_PAGE_AT_BOTTOM = "additionalPageAtBottom";
        @NonNls
        public static final String PROP_IS_DND_ENABLED = "isDndEnabled";
        @NonNls
        public static final String PROP_IS_WHEEL_FONTCHANGE_ENABLED = "isWheelFontchangeEnabled";
        @NonNls
        public static final String PROP_IS_WHEEL_FONTCHANGE_PERSISTENT = "isWheelFontchangePersistent";
        @NonNls
        public static final String PROP_IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS = "isMouseClickSelectionHonorsCamelWords";
        @NonNls
        public static final String PROP_RENAME_VARIABLES_INPLACE = "renameVariablesInplace";
        @NonNls
        public static final String PROP_PRESELECT_RENAME = "preselectRename";
        @NonNls
        public static final String PROP_SHOW_INLINE_DIALOG = "showInlineDialog";
        @NonNls
        public static final String PROP_REFRAIN_FROM_SCROLLING = "refrainFromScrolling";
        @NonNls
        public static final String PROP_ADD_CARETS_ON_DOUBLE_CTRL = "addCaretsOnDoubleCtrl";
        @NonNls
        public static final String PROP_BIDI_TEXT_DIRECTION = "bidiTextDirection";
        @NonNls
        public static final String PROP_KEEP_TRAILING_SPACE_ON_CARET_LINE = "keepTrailingSpaceOnCaretLine";
        @NonNls
        public static final String PROP_INSERT_PARENTHESES_AUTOMATICALLY = "insertParenthesesAutomatically";
        @NonNls
        public static final String PROP_BREADCRUMBS_PER_LANGUAGE = "BreadcrumbsPerLanguage";
    }

    @State(name="OsSpecificEditorSettings", storages={@Storage(value="editor.os-specific.xml", roamingType=RoamingType.PER_OS)}, category=SettingsCategory.CODE)
    @ApiStatus.Internal
    public static final class OsSpecificState
    implements PersistentStateComponent<OsSpecificState> {
        public CaretStopOptions CARET_STOP_OPTIONS = new CaretStopOptions();

        public OsSpecificState getState() {
            return this;
        }

        public void loadState(@NotNull OsSpecificState state) {
            if (state == null) {
                OsSpecificState.$$$reportNull$$$0(0);
            }
            this.CARET_STOP_OPTIONS = state.CARET_STOP_OPTIONS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/editor/ex/EditorSettingsExternalizable$OsSpecificState", "loadState"));
        }
    }

    public static final class OptionSet {
        public String LINE_SEPARATOR;
        public String USE_SOFT_WRAPS;
        public String SOFT_WRAP_FILE_MASKS;
        public boolean USE_CUSTOM_SOFT_WRAP_INDENT = true;
        public int CUSTOM_SOFT_WRAP_INDENT = 0;
        public boolean IS_VIRTUAL_SPACE = false;
        public int VERTICAL_SCROLL_OFFSET = 1;
        public int VERTICAL_SCROLL_JUMP = 0;
        public int HORIZONTAL_SCROLL_OFFSET = 3;
        public int HORIZONTAL_SCROLL_JUMP = 0;
        public boolean IS_CARET_INSIDE_TABS;
        @NonNls
        public String STRIP_TRAILING_SPACES = "Changed";
        public boolean IS_ENSURE_NEWLINE_AT_EOF = false;
        public boolean REMOVE_TRAILING_BLANK_LINES = false;
        public boolean SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT = true;
        public boolean SHOW_INSPECTION_WIDGET = true;
        public int TOOLTIPS_DELAY_MS;
        public boolean SHOW_INTENTION_BULB;
        public boolean IS_CARET_BLINKING;
        public int CARET_BLINKING_PERIOD;
        public boolean IS_RIGHT_MARGIN_SHOWN;
        public boolean ARE_LINE_NUMBERS_SHOWN;
        @NotNull
        public EditorSettings.LineNumerationType LINE_NUMERATION;
        public boolean ARE_GUTTER_ICONS_SHOWN;
        public boolean IS_FOLDING_OUTLINE_SHOWN;
        public boolean IS_FOLDING_OUTLINE_SHOWN_ONLY_ON_HOVER;
        public boolean IS_FOLDING_ENDINGS_SHOWN;
        public boolean SHOW_BREADCRUMBS_ABOVE;
        public boolean SHOW_BREADCRUMBS;
        public boolean SHOW_STICKY_LINES;
        public int STICKY_LINES_LIMIT;
        public boolean ENABLE_RENDERED_DOC;
        public boolean SHOW_INTENTION_PREVIEW;
        public boolean USE_EDITOR_FONT_IN_INLAYS;
        public boolean SMART_HOME;
        public boolean IS_BLOCK_CURSOR;
        public boolean IS_FULL_LINE_HEIGHT_CURSOR;
        public boolean IS_ANIMATED_CARET;
        public boolean IS_HIGHLIGHT_SELECTION_OCCURRENCES;
        public boolean IS_WHITESPACES_SHOWN;
        public boolean IS_LEADING_WHITESPACES_SHOWN;
        public boolean IS_INNER_WHITESPACES_SHOWN;
        public boolean IS_TRAILING_WHITESPACES_SHOWN;
        public boolean IS_SELECTION_WHITESPACES_SHOWN;
        public boolean IS_ALL_SOFTWRAPS_SHOWN;
        public boolean IS_INDENT_GUIDES_SHOWN;
        public boolean IS_FOCUS_MODE;
        public boolean IS_ANIMATED_SCROLLING;
        public boolean IS_CAMEL_WORDS;
        public boolean ADDITIONAL_PAGE_AT_BOTTOM;
        public boolean IS_DND_ENABLED;
        public boolean IS_WHEEL_FONTCHANGE_ENABLED;
        public boolean IS_WHEEL_FONTCHANGE_PERSISTENT;
        public boolean IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS;
        public boolean RENAME_VARIABLES_INPLACE;
        public boolean PRESELECT_RENAME;
        public boolean SHOW_INLINE_DIALOG;
        public boolean REFRAIN_FROM_SCROLLING;
        public boolean ADD_CARETS_ON_DOUBLE_CTRL;
        @ApiStatus.Internal
        public BidiTextDirection BIDI_TEXT_DIRECTION;
        public boolean SHOW_PARAMETER_NAME_HINTS;
        public boolean KEEP_TRAILING_SPACE_ON_CARET_LINE;
        public boolean INSERT_PARENTHESES_AUTOMATICALLY;
        private final Map<String, Boolean> mapLanguageBreadcrumbs;
        private final Map<String, Boolean> mapLanguageStickyLines;

        public Map<String, Boolean> getLanguageBreadcrumbsMap() {
            return this.mapLanguageBreadcrumbs;
        }

        public Map<String, Boolean> getLanguageStickyLines() {
            return this.mapLanguageStickyLines;
        }

        public OptionSet() {
            PropertiesComponent properties;
            this.TOOLTIPS_DELAY_MS = EditorSettingsExternalizable.TOOLTIPS_DELAY_RANGE.initial;
            this.SHOW_INTENTION_BULB = true;
            this.IS_CARET_BLINKING = true;
            this.CARET_BLINKING_PERIOD = EditorSettingsExternalizable.BLINKING_RANGE.initial;
            this.IS_RIGHT_MARGIN_SHOWN = true;
            this.ARE_LINE_NUMBERS_SHOWN = true;
            this.LINE_NUMERATION = EditorSettings.LineNumerationType.ABSOLUTE;
            this.ARE_GUTTER_ICONS_SHOWN = true;
            this.IS_FOLDING_OUTLINE_SHOWN = true;
            this.IS_FOLDING_OUTLINE_SHOWN_ONLY_ON_HOVER = true;
            this.IS_FOLDING_ENDINGS_SHOWN = false;
            this.SHOW_BREADCRUMBS_ABOVE = false;
            this.SHOW_BREADCRUMBS = true;
            this.SHOW_STICKY_LINES = true;
            this.STICKY_LINES_LIMIT = 5;
            this.ENABLE_RENDERED_DOC = false;
            this.SHOW_INTENTION_PREVIEW = true;
            this.USE_EDITOR_FONT_IN_INLAYS = false;
            this.SMART_HOME = true;
            this.IS_BLOCK_CURSOR = false;
            this.IS_FULL_LINE_HEIGHT_CURSOR = false;
            this.IS_ANIMATED_CARET = false;
            this.IS_HIGHLIGHT_SELECTION_OCCURRENCES = true;
            this.IS_WHITESPACES_SHOWN = false;
            this.IS_LEADING_WHITESPACES_SHOWN = true;
            this.IS_INNER_WHITESPACES_SHOWN = true;
            this.IS_TRAILING_WHITESPACES_SHOWN = true;
            this.IS_SELECTION_WHITESPACES_SHOWN = true;
            this.IS_ALL_SOFTWRAPS_SHOWN = false;
            this.IS_INDENT_GUIDES_SHOWN = true;
            this.IS_FOCUS_MODE = false;
            this.IS_ANIMATED_SCROLLING = true;
            this.IS_CAMEL_WORDS = false;
            this.ADDITIONAL_PAGE_AT_BOTTOM = false;
            this.IS_DND_ENABLED = true;
            this.IS_WHEEL_FONTCHANGE_ENABLED = false;
            this.IS_WHEEL_FONTCHANGE_PERSISTENT = false;
            this.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS = true;
            this.RENAME_VARIABLES_INPLACE = true;
            this.PRESELECT_RENAME = true;
            this.SHOW_INLINE_DIALOG = true;
            this.REFRAIN_FROM_SCROLLING = false;
            this.ADD_CARETS_ON_DOUBLE_CTRL = true;
            this.BIDI_TEXT_DIRECTION = BidiTextDirection.CONTENT_BASED;
            this.SHOW_PARAMETER_NAME_HINTS = true;
            this.KEEP_TRAILING_SPACE_ON_CARET_LINE = true;
            this.INSERT_PARENTHESES_AUTOMATICALLY = true;
            this.mapLanguageBreadcrumbs = new HashMap<String, Boolean>();
            this.mapLanguageStickyLines = new HashMap<String, Boolean>();
            Application application = ApplicationManager.getApplication();
            if (application != null && (properties = PropertiesComponent.getInstance()) != null) {
                this.INSERT_PARENTHESES_AUTOMATICALLY = properties.getBoolean("js.insert.parentheses.on.completion", true);
            }
        }

        public void setLanguageBreadcrumbsMap(Map<String, Boolean> map) {
            if (this.mapLanguageBreadcrumbs != map) {
                this.mapLanguageBreadcrumbs.clear();
                this.mapLanguageBreadcrumbs.putAll(map);
            }
        }

        public void setLanguageStickyLines(Map<String, Boolean> map) {
            if (this.mapLanguageStickyLines != map) {
                this.mapLanguageStickyLines.clear();
                this.mapLanguageStickyLines.putAll(map);
            }
        }
    }

    public static @interface StripTrailingSpaces {
    }
}

