/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackgroundTaskUtil {
    private static final Logger LOG = Logger.getInstance(BackgroundTaskUtil.class);

    @RequiresEdt
    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<? super ProgressIndicator, ? extends Runnable> backgroundTask, @Nullable Runnable onSlowAction) {
        if (backgroundTask == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return BackgroundTaskUtil.executeAndTryWait(backgroundTask, onSlowAction, 300L, false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public static ProgressIndicator executeAndTryWait(@NotNull Function<? super ProgressIndicator, ? extends Runnable> backgroundTask, @Nullable Runnable onSlowAction, long waitMillis, boolean bl) {
        void forceEDT;
        if (backgroundTask == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ModalityState modality = ModalityState.current();
        if (forceEDT != false) {
            EmptyProgressIndicator indicator2 = new EmptyProgressIndicator(modality);
            try {
                Runnable callback2 = (Runnable)ProgressManager.getInstance().runProcess(() -> BackgroundTaskUtil.lambda$executeAndTryWait$0(backgroundTask, (ProgressIndicator)indicator2), (ProgressIndicator)indicator2);
                BackgroundTaskUtil.finish(callback2, (ProgressIndicator)indicator2);
            }
            catch (ProcessCanceledException callback2) {
            }
            catch (Throwable t) {
                LOG.error(t);
            }
            EmptyProgressIndicator emptyProgressIndicator = indicator2;
            if (emptyProgressIndicator == null) {
                BackgroundTaskUtil.$$$reportNull$$$0(2);
            }
            return emptyProgressIndicator;
        }
        Pair<? extends Runnable, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (callback, indicator) -> ApplicationManager.getApplication().invokeLater(() -> BackgroundTaskUtil.finish(callback, indicator), modality), modality, waitMillis);
        Runnable callback3 = (Runnable)pair.first;
        ProgressIndicator indicator3 = (ProgressIndicator)pair.second;
        if (callback3 != null) {
            BackgroundTaskUtil.finish(callback3, indicator3);
        } else if (onSlowAction != null) {
            onSlowAction.run();
        }
        ProgressIndicator progressIndicator = indicator3;
        if (progressIndicator == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(3);
        }
        return progressIndicator;
    }

    @RequiresEdt
    private static void finish(@NotNull Runnable result, @NotNull ProgressIndicator indicator) {
        if (result == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!indicator.isCanceled()) {
            result.run();
        }
    }

    @Nullable
    public static <T> T tryComputeFast(@NotNull Function<? super ProgressIndicator, ? extends T> backgroundTask, long waitMillis) {
        if (backgroundTask == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(6);
        }
        Pair<? extends T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(backgroundTask, (result, indicator) -> {}, ModalityState.defaultModalityState(), waitMillis);
        Object result2 = pair.first;
        ProgressIndicator indicator2 = (ProgressIndicator)pair.second;
        indicator2.cancel();
        return (T)result2;
    }

    @Nullable
    public static <T> T computeInBackgroundAndTryWait(@NotNull Computable<? extends T> computable, @NotNull Consumer<? super T> asyncCallback, long waitMillis) {
        if (computable == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(7);
        }
        if (asyncCallback == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(8);
        }
        Pair<T, ProgressIndicator> pair = BackgroundTaskUtil.computeInBackgroundAndTryWait(indicator -> computable.compute(), (result, indicator) -> asyncCallback.consume(result), ModalityState.defaultModalityState(), waitMillis);
        return (T)pair.first;
    }

    @NotNull
    private static <T> Pair<T, ProgressIndicator> computeInBackgroundAndTryWait(@NotNull Function<? super ProgressIndicator, ? extends T> task, @NotNull PairConsumer<? super T, ? super ProgressIndicator> asyncCallback, @NotNull ModalityState modality, long waitMillis) {
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(9);
        }
        if (asyncCallback == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(10);
        }
        if (modality == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(11);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(modality);
        indicator.start();
        Helper helper = new Helper();
        ApplicationManager.getApplication().executeOnPooledThread(() -> BackgroundTaskUtil.lambda$computeInBackgroundAndTryWait$7(task, (ProgressIndicator)indicator, helper, asyncCallback));
        Object result = null;
        if (helper.await(waitMillis)) {
            result = helper.getResult();
        }
        Pair pair = Pair.create(result, (Object)indicator);
        if (pair == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @NotNull
    public static ProgressIndicator executeOnPooledThread(@NotNull Disposable parent, @NotNull Runnable runnable) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(13);
        }
        if (runnable == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(14);
        }
        return BackgroundTaskUtil.execute(AppExecutorUtil.getAppExecutorService(), parent, runnable);
    }

    @NotNull
    public static ProgressIndicator execute(@NotNull Executor executor, @NotNull Disposable parent, @NotNull Runnable runnable) {
        if (executor == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(15);
        }
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(16);
        }
        if (runnable == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(17);
        }
        ProgressIndicator progressIndicator = BackgroundTaskUtil.submitTask((Executor)executor, (Disposable)parent, (Runnable)runnable).indicator;
        if (progressIndicator == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(18);
        }
        return progressIndicator;
    }

    @NotNull
    public static BackgroundTask<?> submitTask(@NotNull Disposable parent, @NotNull Runnable runnable) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(19);
        }
        if (runnable == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(20);
        }
        return BackgroundTaskUtil.submitTask((Executor)AppExecutorUtil.getAppExecutorService(), parent, runnable);
    }

    @NotNull
    public static BackgroundTask<?> submitTask(@NotNull Executor executor, @NotNull Disposable parent, @NotNull Runnable task) {
        if (executor == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(21);
        }
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(22);
        }
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(23);
        }
        return BackgroundTaskUtil.createBackgroundTask(executor, () -> {
            task.run();
            return null;
        }, task.toString(), parent);
    }

    @NotNull
    public static <T> BackgroundTask<T> submitTask(@NotNull Executor executor, @NotNull Disposable parent, @NotNull Computable<? extends T> task) {
        if (executor == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(24);
        }
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(25);
        }
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(26);
        }
        return BackgroundTaskUtil.createBackgroundTask(executor, task, task.toString(), parent);
    }

    @NotNull
    private static <T> BackgroundTask<T> createBackgroundTask(@NotNull Executor executor, @NotNull Computable<? extends T> task, @NotNull @NlsSafe String taskName, @NotNull Disposable parent) {
        if (executor == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(27);
        }
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(28);
        }
        if (taskName == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(29);
        }
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(30);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        AtomicReference<CompletableFuture<Object>> futureRef = new AtomicReference<CompletableFuture<Object>>();
        Disposable disposable = () -> BackgroundTaskUtil.lambda$createBackgroundTask$9((ProgressIndicator)indicator, futureRef, taskName);
        CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> BackgroundTaskUtil.lambda$createBackgroundTask$11(parent, disposable, task, (ProgressIndicator)indicator), executor);
        future.whenComplete((o, e) -> Disposer.dispose((Disposable)disposable));
        futureRef.set(future);
        return new BackgroundTask<Object>(parent, (ProgressIndicator)indicator, future);
    }

    private static void tryAwaitFuture(@NotNull Future<?> future, @NotNull @NlsSafe String taskName) {
        if (future == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(31);
        }
        if (taskName == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(32);
        }
        try {
            future.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof CancellationException)) {
                LOG.error((Throwable)e);
            }
        }
        catch (CancellationException e) {
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.debug("Couldn't await background process on disposal: " + taskName);
        }
    }

    public static <T> T runUnderDisposeAwareIndicator(@NotNull Disposable parent, @NotNull Supplier<? extends T> task) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(33);
        }
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(34);
        }
        return BackgroundTaskUtil.runUnderDisposeAwareIndicator(parent, task, ProgressManager.getInstance().getProgressIndicator());
    }

    public static <T> T runUnderDisposeAwareIndicator(@NotNull Disposable parent, @NotNull Supplier<? extends T> task, @Nullable ProgressIndicator parentIndicator) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(35);
        }
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(36);
        }
        Ref ref = new Ref();
        BackgroundTaskUtil.runUnderDisposeAwareIndicator(parent, () -> ref.set(task.get()), parentIndicator);
        return (T)ref.get();
    }

    public static void runUnderDisposeAwareIndicator(@NotNull Disposable parent, @NotNull Runnable task) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(37);
        }
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(38);
        }
        BackgroundTaskUtil.runUnderDisposeAwareIndicator(parent, task, ProgressManager.getInstance().getProgressIndicator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUnderDisposeAwareIndicator(@NotNull Disposable parent, @NotNull Runnable task, @Nullable ProgressIndicator parentIndicator) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(39);
        }
        if (task == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(40);
        }
        SensitiveProgressWrapper indicator = parentIndicator instanceof StandardProgressIndicator ? new SensitiveProgressWrapper(parentIndicator) : new EmptyProgressIndicator(ModalityState.defaultModalityState());
        Disposable disposable = () -> BackgroundTaskUtil.lambda$runUnderDisposeAwareIndicator$14((ProgressIndicator)indicator);
        try {
            ProgressManager.getInstance().runProcess(() -> {
                if (!BackgroundTaskUtil.registerIfParentNotDisposed(parent, disposable)) {
                    throw new ProcessCanceledException();
                }
                task.run();
            }, (ProgressIndicator)indicator);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private static boolean registerIfParentNotDisposed(@NotNull Disposable parent, @NotNull Disposable disposable) {
        if (parent == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(41);
        }
        if (disposable == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(42);
        }
        if (parent instanceof ComponentManager && ((ComponentManager)parent).isDisposed()) {
            return false;
        }
        return Disposer.tryRegister((Disposable)parent, (Disposable)disposable);
    }

    @NotNull
    public static <L> L syncPublisher(@NotNull Project project, @NotNull Topic<L> topic) throws ProcessCanceledException {
        if (project == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(43);
        }
        if (topic == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(44);
        }
        Object object = project.getMessageBus().syncPublisher(topic);
        if (object == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(45);
        }
        return (L)object;
    }

    @NotNull
    public static <L> L syncPublisher(@NotNull Topic<L> topic) throws ProcessCanceledException {
        if (topic == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(46);
        }
        Object object = ReadAction.compute(() -> {
            if (ApplicationManager.getApplication().isDisposed()) {
                throw new ProcessCanceledException();
            }
            return ApplicationManager.getApplication().getMessageBus().syncPublisher(topic);
        });
        if (object == null) {
            BackgroundTaskUtil.$$$reportNull$$$0(47);
        }
        return (L)object;
    }

    private static /* synthetic */ void lambda$runUnderDisposeAwareIndicator$14(ProgressIndicator indicator) {
        if (indicator.isRunning()) {
            indicator.cancel();
        }
    }

    private static /* synthetic */ Object lambda$createBackgroundTask$11(Disposable parent, Disposable disposable, Computable task, ProgressIndicator indicator) {
        return ProgressManager.getInstance().runProcess(() -> {
            if (!BackgroundTaskUtil.registerIfParentNotDisposed(parent, disposable)) {
                throw new ProcessCanceledException();
            }
            return task.compute();
        }, indicator);
    }

    private static /* synthetic */ void lambda$createBackgroundTask$9(ProgressIndicator indicator, AtomicReference futureRef, String taskName) {
        Future future;
        if (indicator.isRunning()) {
            indicator.cancel();
        }
        if ((future = (Future)futureRef.get()) != null) {
            BackgroundTaskUtil.tryAwaitFuture(future, taskName);
        }
    }

    private static /* synthetic */ void lambda$computeInBackgroundAndTryWait$7(Function task, ProgressIndicator indicator, Helper helper, PairConsumer asyncCallback) {
        ProgressManager.getInstance().runProcess(() -> {
            Object result = task.fun((Object)indicator);
            if (!helper.setResult(result)) {
                asyncCallback.consume(result, (Object)indicator);
            }
        }, indicator);
    }

    private static /* synthetic */ Runnable lambda$executeAndTryWait$0(Function backgroundTask, ProgressIndicator indicator) {
        return (Runnable)backgroundTask.fun((Object)indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 12, 18, 45, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundTask";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 18: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/BackgroundTaskUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncCallback";
                break;
            }
            case 9: 
            case 23: 
            case 26: 
            case 28: 
            case 34: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 30: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 15: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/BackgroundTaskUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "executeAndTryWait";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInBackgroundAndTryWait";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeAndTryWait";
                break;
            }
            case 2: 
            case 3: 
            case 12: 
            case 18: 
            case 45: 
            case 47: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "finish";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryComputeFast";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeInBackgroundAndTryWait";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "submitTask";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createBackgroundTask";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "tryAwaitFuture";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runUnderDisposeAwareIndicator";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "registerIfParentNotDisposed";
                break;
            }
            case 43: 
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 12, 18, 45, 47 -> new IllegalStateException(string);
        };
    }

    private static final class Helper<T> {
        private static final Object INITIAL_STATE = ObjectUtils.sentinel((String)"INITIAL_STATE");
        private static final Object SLOW_OPERATION_STATE = ObjectUtils.sentinel((String)"SLOW_OPERATION_STATE");
        private final Semaphore mySemaphore = new Semaphore(0);
        private final AtomicReference<Object> myResultRef = new AtomicReference<Object>(INITIAL_STATE);

        private Helper() {
        }

        public boolean setResult(T result) {
            boolean isFast = this.myResultRef.compareAndSet(INITIAL_STATE, result);
            this.mySemaphore.release();
            return isFast;
        }

        public boolean await(long waitMillis) {
            try {
                this.mySemaphore.tryAcquire(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myResultRef.compareAndSet(INITIAL_STATE, SLOW_OPERATION_STATE);
        }

        public T getResult() {
            Object result = this.myResultRef.get();
            assert (result != INITIAL_STATE && result != SLOW_OPERATION_STATE);
            return (T)result;
        }
    }

    public static final class BackgroundTask<T> {
        @NotNull
        private final Disposable parent;
        @NotNull
        private final ProgressIndicator indicator;
        @NotNull
        private final CompletableFuture<T> future;

        public BackgroundTask(@NotNull Disposable parent, @NotNull ProgressIndicator indicator, @NotNull CompletableFuture<T> future) {
            if (parent == null) {
                BackgroundTask.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                BackgroundTask.$$$reportNull$$$0(1);
            }
            if (future == null) {
                BackgroundTask.$$$reportNull$$$0(2);
            }
            this.parent = parent;
            this.indicator = indicator;
            this.future = future;
        }

        @NotNull
        public Disposable getParent() {
            Disposable disposable = this.parent;
            if (disposable == null) {
                BackgroundTask.$$$reportNull$$$0(3);
            }
            return disposable;
        }

        @NotNull
        public ProgressIndicator getIndicator() {
            ProgressIndicator progressIndicator = this.indicator;
            if (progressIndicator == null) {
                BackgroundTask.$$$reportNull$$$0(4);
            }
            return progressIndicator;
        }

        @NotNull
        public CompletableFuture<T> getFuture() {
            CompletableFuture<T> completableFuture = this.future;
            if (completableFuture == null) {
                BackgroundTask.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }

        public void cancel() {
            this.indicator.cancel();
        }

        public void awaitCompletion() throws ExecutionException {
            while (!this.future.isDone() && !Disposer.isDisposed((Disposable)this.parent)) {
                try {
                    if (this.future.get(1L, TimeUnit.SECONDS) == null) continue;
                    break;
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ControlFlowException) break;
                    throw e;
                }
                catch (TimeoutException e) {
                }
                catch (Exception e) {
                    if (e.getCause() instanceof ControlFlowException) break;
                    throw new RuntimeException(e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/progress/util/BackgroundTaskUtil$BackgroundTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/progress/util/BackgroundTaskUtil$BackgroundTask";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndicator";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

