/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.ex;

import com.intellij.openapi.application.PathManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/project/ex/P3PathsEx;", "", "projectStoreBaseDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getSystemDir", "getConfigDir", "getPluginsDir", "getLogDir", "Companion", "intellij.platform.ide.core.impl"})
@ApiStatus.Experimental
@ApiStatus.Internal
public final class P3PathsEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path projectStoreBaseDir;
    @ApiStatus.Experimental
    @NotNull
    public static final String PER_PROJECT_FOLDER = "INTERNAL_P3_FOLDER";

    public P3PathsEx(@NotNull Path projectStoreBaseDir) {
        Intrinsics.checkNotNullParameter((Object)projectStoreBaseDir, (String)"projectStoreBaseDir");
        this.projectStoreBaseDir = projectStoreBaseDir;
    }

    @NotNull
    public final Path getSystemDir() {
        Path path = PathManager.getOriginalSystemDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getOriginalSystemDir(...)");
        return Companion.getSystemDir(path, this.projectStoreBaseDir);
    }

    @NotNull
    public final Path getConfigDir() {
        Path path = PathManager.getOriginalConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getOriginalConfigDir(...)");
        return Companion.getSystemDir(path, this.projectStoreBaseDir);
    }

    @NotNull
    public final Path getPluginsDir() {
        return Companion.getPluginsDir();
    }

    @NotNull
    public final Path getLogDir() {
        Path path = PathManager.getOriginalLogDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getOriginalLogDir(...)");
        return Companion.getLogDir(path, this.projectStoreBaseDir);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/project/ex/P3PathsEx$Companion;", "", "<init>", "()V", "PER_PROJECT_FOLDER", "", "getSystemDir", "Ljava/nio/file/Path;", "baseSystemDir", "projectStoreBaseDir", "getConfigDir", "getPluginsDir", "getLogDir", "getPerProjectDir", "parent", "projectLocationHash", "intellij.platform.ide.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getSystemDir(@NotNull Path baseSystemDir, @NotNull Path projectStoreBaseDir) {
            Intrinsics.checkNotNullParameter((Object)baseSystemDir, (String)"baseSystemDir");
            Intrinsics.checkNotNullParameter((Object)projectStoreBaseDir, (String)"projectStoreBaseDir");
            return this.getPerProjectDir(baseSystemDir, projectStoreBaseDir);
        }

        @NotNull
        public final Path getConfigDir(@NotNull Path baseSystemDir, @NotNull Path projectStoreBaseDir) {
            Intrinsics.checkNotNullParameter((Object)baseSystemDir, (String)"baseSystemDir");
            Intrinsics.checkNotNullParameter((Object)projectStoreBaseDir, (String)"projectStoreBaseDir");
            return this.getPerProjectDir(baseSystemDir, projectStoreBaseDir);
        }

        @NotNull
        public final Path getPluginsDir() {
            Path path = PathManager.getPluginsDir();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPluginsDir(...)");
            return path;
        }

        @NotNull
        public final Path getLogDir(@NotNull Path baseSystemDir, @NotNull Path projectStoreBaseDir) {
            Intrinsics.checkNotNullParameter((Object)baseSystemDir, (String)"baseSystemDir");
            Intrinsics.checkNotNullParameter((Object)projectStoreBaseDir, (String)"projectStoreBaseDir");
            return this.getPerProjectDir(baseSystemDir, projectStoreBaseDir);
        }

        private final Path getPerProjectDir(Path parent, Path projectStoreBaseDir) {
            Path path = parent.resolve(P3PathsEx.PER_PROJECT_FOLDER).resolve(this.projectLocationHash(projectStoreBaseDir));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private final String projectLocationHash(Path projectStoreBaseDir) {
            return PathsKt.getName((Path)projectStoreBaseDir) + "_" + Integer.toHexString(PathsKt.getInvariantSeparatorsPathString((Path)projectStoreBaseDir).hashCode());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

