/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.values;

import java.lang.reflect.Field;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassSerializer {
    @NotNull
    private final String myInstanceName;
    @NotNull
    private final Object myInstance;

    public ClassSerializer(@NotNull String instanceName, @NotNull Object o) {
        if (instanceName == null) {
            ClassSerializer.$$$reportNull$$$0(0);
        }
        if (o == null) {
            ClassSerializer.$$$reportNull$$$0(1);
        }
        this.myInstanceName = instanceName;
        this.myInstance = o;
    }

    @Nullable
    public Object read(@NotNull String name) {
        if (name == null) {
            ClassSerializer.$$$reportNull$$$0(2);
        }
        try {
            Field field = ClassSerializer.getPreparedField(this.myInstance.getClass().getField(name));
            if (field == null) {
                return null;
            }
            return field.get(this.myInstance);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Contract(value="_, _, false -> null")
    @Nullable
    public Object write(@NotNull String name, @NotNull Object value, boolean retPrevValue) {
        if (name == null) {
            ClassSerializer.$$$reportNull$$$0(3);
        }
        if (value == null) {
            ClassSerializer.$$$reportNull$$$0(4);
        }
        try {
            Field field = ClassSerializer.getPreparedField(this.myInstance.getClass().getField(name));
            if (field != null) {
                Object ret = retPrevValue ? field.get(this.myInstance) : null;
                field.set(this.myInstance, value);
                return ret;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public static Field getPreparedField(Field field) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        if ((field.getModifiers() & 0x18) != 0) {
            return null;
        }
        if (type != Integer.TYPE && type != Boolean.TYPE) {
            return null;
        }
        if (field.getName().startsWith("my")) {
            return null;
        }
        return field;
    }

    @NotNull
    public String getInstanceName() {
        String string = this.myInstanceName;
        if (string == null) {
            ClassSerializer.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (o instanceof ClassSerializer) {
            ClassSerializer other = (ClassSerializer)o;
            return other.myInstance.equals(this.myInstance);
        }
        return false;
    }

    public int hashCode() {
        return this.myInstance.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/extractor/values/ClassSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/extractor/values/ClassSerializer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

