/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface PsiReferenceProcessor {
    public boolean execute(PsiReference var1);

    public static class CollectElements
    implements PsiReferenceProcessor {
        private final Collection<PsiReference> myCollection;

        public CollectElements(Collection<PsiReference> collection) {
            this.myCollection = Collections.synchronizedCollection(collection);
        }

        public CollectElements() {
            this(new ArrayList<PsiReference>());
        }

        public PsiReference @NotNull [] toArray() {
            PsiReference[] psiReferenceArray = this.myCollection.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                CollectElements.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }

        public PsiReference @NotNull [] toArray(PsiReference[] array) {
            PsiReference[] psiReferenceArray = this.myCollection.toArray(array);
            if (psiReferenceArray == null) {
                CollectElements.$$$reportNull$$$0(1);
            }
            return psiReferenceArray;
        }

        @Override
        public boolean execute(PsiReference element) {
            this.myCollection.add(element);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/PsiReferenceProcessor$CollectElements", "toArray"));
        }
    }
}

