/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightDisplayKey {
    private static final Logger LOG = Logger.getInstance(HighlightDisplayKey.class);
    private static final Map<String, HighlightDisplayKey> ourShortNameToKeyMap = new ConcurrentHashMap<String, HighlightDisplayKey>();
    private static final Map<String, HighlightDisplayKey> ourIdToKeyMap = new ConcurrentHashMap<String, HighlightDisplayKey>();
    private static final Map<HighlightDisplayKey, Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String>> ourKeyToDisplayNameMap = new ConcurrentHashMap<HighlightDisplayKey, Computable<String>>();
    private static final Map<HighlightDisplayKey, String> ourKeyToAlternativeIDMap = new ConcurrentHashMap<HighlightDisplayKey, String>();
    private final String myShortName;
    private final String myID;

    @Nullable
    public static HighlightDisplayKey find(@NonNls @NotNull String shortName) {
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(0);
        }
        return ourShortNameToKeyMap.get(shortName);
    }

    @Nullable
    public static HighlightDisplayKey findById(@NonNls @NotNull String id) {
        HighlightDisplayKey key;
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(1);
        }
        if ((key = ourIdToKeyMap.get(id)) != null) {
            return key;
        }
        key = HighlightDisplayKey.find(id);
        if (key != null && key.getID().equals(id)) {
            return key;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String shortName, @NotNull String displayName, @NotNull @NonNls String id) {
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(3);
        }
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(4);
        }
        return HighlightDisplayKey.register(shortName, (Computable<String>)new Computable.PredefinedValueComputable((Object)displayName), id);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String shortName, @NotNull Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String> displayName, @NotNull @NonNls String id) {
        HighlightDisplayKey key;
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(5);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(6);
        }
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(7);
        }
        if ((key = HighlightDisplayKey.find(shortName)) != null) {
            LOG.error("Key with shortName '" + shortName + "' already registered with display name: '" + HighlightDisplayKey.getDisplayNameByKey(key) + "' while calling register(Display name='" + (String)displayName.compute() + "', ID='" + id + "')");
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = new HighlightDisplayKey(shortName, id);
        ourKeyToDisplayNameMap.put(highlightDisplayKey, displayName);
        return highlightDisplayKey;
    }

    @ApiStatus.Internal
    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String shortName, @NotNull Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String> displayName, @NotNull @NonNls String id, @NonNls @Nullable String alternativeID, @NotNull Object offender) {
        HighlightDisplayKey key;
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(8);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(9);
        }
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(10);
        }
        if (offender == null) {
            HighlightDisplayKey.$$$reportNull$$$0(11);
        }
        if ((key = HighlightDisplayKey.find(shortName)) != null) {
            Class<Object> clazz;
            if (offender instanceof InspectionToolWrapper) {
                InspectionToolWrapper tw = (InspectionToolWrapper)offender;
                clazz = tw.getDescriptionContextClass();
            } else {
                clazz = offender.getClass();
            }
            Class<?> pluginClass = clazz;
            PluginException.logPluginError((Logger)LOG, (String)("Key with shortName '" + shortName + "' already registered with display name: '" + HighlightDisplayKey.getDisplayNameByKey(key) + "' while calling register(Display name='" + (String)displayName.compute() + "', ID='" + id + "')"), null, pluginClass);
            return null;
        }
        HighlightDisplayKey newKey = new HighlightDisplayKey(shortName, id);
        ourKeyToDisplayNameMap.put(newKey, displayName);
        if (alternativeID != null) {
            ourKeyToAlternativeIDMap.put(newKey, alternativeID);
        }
        return newKey;
    }

    public static void unregister(@NotNull String shortName) {
        HighlightDisplayKey key;
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(12);
        }
        if ((key = ourShortNameToKeyMap.remove(shortName)) != null) {
            ourIdToKeyMap.remove(key.myID);
            ourKeyToAlternativeIDMap.remove(key);
            ourKeyToDisplayNameMap.remove(key);
        }
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String shortName, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String displayName) {
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(13);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(14);
        }
        return HighlightDisplayKey.findOrRegister(shortName, displayName, null);
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String shortName, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String displayName, @NonNls @Nullable String id) {
        HighlightDisplayKey key;
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(15);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(16);
        }
        if ((key = HighlightDisplayKey.find(shortName)) == null) {
            id = id != null ? id : shortName;
            key = new HighlightDisplayKey(shortName, id);
            ourKeyToDisplayNameMap.put(key, (Computable<String>)new Computable.PredefinedValueComputable((Object)displayName));
        }
        HighlightDisplayKey highlightDisplayKey = key;
        if (highlightDisplayKey == null) {
            HighlightDisplayKey.$$$reportNull$$$0(17);
        }
        return highlightDisplayKey;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String getDisplayNameByKey(@Nullable HighlightDisplayKey key) {
        if (key == null) {
            return null;
        }
        Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String> computable = ourKeyToDisplayNameMap.get(key);
        return computable == null ? null : (String)computable.compute();
    }

    public static String getAlternativeID(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            HighlightDisplayKey.$$$reportNull$$$0(18);
        }
        return ourKeyToAlternativeIDMap.get(key);
    }

    @Deprecated
    @ApiStatus.Internal
    public HighlightDisplayKey(@NonNls @NotNull String shortName, @NonNls @NotNull String ID) {
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(19);
        }
        if (ID == null) {
            HighlightDisplayKey.$$$reportNull$$$0(20);
        }
        this.myShortName = shortName;
        this.myID = ID;
        ourShortNameToKeyMap.put(this.myShortName, this);
        if (!Objects.equals(ID, shortName)) {
            ourIdToKeyMap.put(ID, this);
        }
    }

    public String toString() {
        return this.myShortName;
    }

    public String getShortName() {
        return this.myShortName;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            HighlightDisplayKey.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offender";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/HighlightDisplayKey";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/HighlightDisplayKey";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrRegister";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findOrRegister";
                break;
            }
            case 17: 
            case 21: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeID";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 21 -> new IllegalStateException(string);
        };
    }
}

