/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.modcompletion;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcompletion.ModCompletionItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNullByDefault;

@NotNullByDefault
public abstract class PsiUpdateCompletionItem<T>
implements ModCompletionItem {
    private final String myLookupString;
    private final T myContext;

    protected PsiUpdateCompletionItem(String lookupString, T context) {
        this.myLookupString = lookupString;
        this.myContext = context;
    }

    public T contextObject() {
        return this.myContext;
    }

    @Override
    public String mainLookupString() {
        return this.myLookupString;
    }

    @Override
    public ModCommand perform(ActionContext actionContext, ModCompletionItem.InsertionContext insertionContext) {
        String lookupString = this.mainLookupString();
        int completionStart = actionContext.selection().getStartOffset();
        int prefixEnd = actionContext.selection().getEndOffset();
        int updatedCaretPos = completionStart + lookupString.length();
        ActionContext finalActionContext = actionContext.withSelection(TextRange.create((int)updatedCaretPos, (int)updatedCaretPos)).withOffset(updatedCaretPos);
        return ModCommand.psiUpdate(finalActionContext, doc -> doc.deleteString(completionStart, prefixEnd), updater -> {
            Document document = updater.getDocument();
            document.replaceString(completionStart, insertionContext.mode() == ModCompletionItem.InsertionMode.OVERWRITE ? this.calculateEndOffsetForOverwrite(document, completionStart) : completionStart, (CharSequence)lookupString);
            updater.moveCaretTo(updatedCaretPos);
            this.update(actionContext.withOffset(updatedCaretPos).withSelection(TextRange.create((int)completionStart, (int)updatedCaretPos)), insertionContext, (ModPsiUpdater)updater);
        });
    }

    protected int calculateEndOffsetForOverwrite(Document document, int startFrom) {
        int idEnd;
        CharSequence text = document.getCharsSequence();
        for (idEnd = startFrom; idEnd < text.length() && Character.isJavaIdentifierPart(text.charAt(idEnd)); ++idEnd) {
        }
        return idEnd;
    }

    public abstract void update(ActionContext var1, ModCompletionItem.InsertionContext var2, ModPsiUpdater var3);

    public String toString() {
        return this.mainLookupString();
    }
}

