/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBaseKt;
import com.intellij.ResourceBundleWithParentEnumeration;
import com.intellij.openapi.util.NlsSafe;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\bH\u0007J8\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\r\u0010\u000f\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\u00102\u0012\u0010\u0011\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\bH\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019H\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/IntelliJResourceBundle;", "Ljava/util/ResourceBundle;", "reader", "Ljava/io/Reader;", "<init>", "(Ljava/io/Reader;)V", "lookup", "", "", "parent", "getParent", "()Ljava/util/ResourceBundle;", "getMessageOrNull", "key", "getMessage", "defaultValue", "Lorg/jetbrains/annotations/Nls;", "params", "", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "handleGetObject", "getKeys", "Ljava/util/Enumeration;", "handleKeySet", "", "intellij.platform.util"})
@ApiStatus.Internal
public final class IntelliJResourceBundle
extends ResourceBundle {
    @NotNull
    private final Map<String, String> lookup;

    public IntelliJResourceBundle(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        Properties properties = new Properties();
        properties.load(reader);
        this.lookup = new HashMap(properties);
    }

    @Nullable
    public final ResourceBundle getParent() {
        return this.parent;
    }

    @NlsSafe
    @Nullable
    public final String getMessageOrNull(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String string = this.lookup.get(key);
        if (string == null) {
            return null;
        }
        String value = string;
        return BundleBaseKt.postProcessResolvedValue(value, key, true, this);
    }

    @NlsSafe
    @NotNull
    public final String getMessage(@NotNull String key, @Nullable String defaultValue, @Nullable Object[] params) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        String value = this.lookup.get(key);
        if (value == null) {
            String string = defaultValue;
            if (string == null) {
                string = BundleBaseKt.useDefaultValue(this, key);
            }
            value = string;
            bl = false;
        } else {
            bl = true;
        }
        boolean resourceFound = bl;
        return BundleBaseKt.postProcessResolvedValue(BundleBaseKt.postprocessValue(this, value, params), key, resourceFound, this);
    }

    @Override
    @Nullable
    protected String handleGetObject(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.getMessageOrNull(key);
    }

    @Override
    @NotNull
    public Enumeration<String> getKeys() {
        Enumeration enumeration;
        ResourceBundle parent = this.parent;
        if (parent == null) {
            Enumeration enumeration2 = Collections.enumeration((Collection)this.lookup.keySet());
            enumeration = enumeration2;
            Intrinsics.checkNotNullExpressionValue(enumeration2, "enumeration(...)");
        } else {
            Set<String> set = this.lookup.keySet();
            Enumeration<String> enumeration3 = parent.getKeys();
            Intrinsics.checkNotNullExpressionValue(enumeration3, "getKeys(...)");
            enumeration = new ResourceBundleWithParentEnumeration(set, enumeration3);
        }
        return enumeration;
    }

    @Override
    @NotNull
    protected Set<String> handleKeySet() {
        return this.lookup.keySet();
    }
}

