/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.PeekableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000b\u001a\u00020\nH\u0096\u0082\u0004J\u000f\u0010\f\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\rJ\r\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/containers/PeekableIteratorWrapper;", "T", "Lcom/intellij/util/containers/PeekableIterator;", "myIterator", "", "<init>", "(Ljava/util/Iterator;)V", "myValue", "Ljava/lang/Object;", "myValidValue", "", "hasNext", "next", "()Ljava/lang/Object;", "peek", "advance", "", "intellij.platform.util.base.multiplatform"})
public class PeekableIteratorWrapper<T>
implements PeekableIterator<T> {
    @NotNull
    private final Iterator<T> myIterator;
    @Nullable
    private T myValue;
    private boolean myValidValue;

    public PeekableIteratorWrapper(@NotNull Iterator<? extends T> myIterator) {
        Intrinsics.checkNotNullParameter(myIterator, "myIterator");
        this.myIterator = myIterator;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.myValidValue;
    }

    @Override
    public T next() {
        if (this.myValidValue) {
            T t = this.myValue;
            Intrinsics.checkNotNull(t);
            T save = t;
            this.advance();
            return save;
        }
        throw new NoSuchElementException();
    }

    @Override
    public T peek() {
        if (this.myValidValue) {
            T t = this.myValue;
            Intrinsics.checkNotNull(t);
            return t;
        }
        throw new NoSuchElementException();
    }

    private final void advance() {
        this.myValidValue = this.myIterator.hasNext();
        this.myValue = this.myValidValue ? this.myIterator.next() : null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

