/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.DarkReplacer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.LazyIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CachedImageIconKt;
import com.intellij.ui.icons.FilteredIcon;
import com.intellij.ui.icons.HiDPIImage;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.icons.ImageDataByPathLoaderKt;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.RgbImageFilterSupplier;
import com.intellij.ui.icons.ScaledIconCacheKt;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.net.URL;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u0005H\u0007J\b\u0010\u0011\u001a\u00020\u0005H\u0007J\u0015\u0010\u0012\u001a\u00020\u00132\u000b\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0007J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u000b\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u0005H\u0007J\b\u0010\u001d\u001a\u00020\u0005H\u0007J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0007J.\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0007J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010 \u001a\u0004\u0018\u00010!H\u0007J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\fH\u0007J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u001a\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u001e\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00132\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0007J\u0010\u0010)\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u0013H\u0007J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013H\u0007J\u0018\u0010+\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H\u0007J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013H\u0007J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010/\u001a\u000200H\u0007J\u0010\u00101\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013H\u0007J\u0018\u00102\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u00103\u001a\u00020\fH\u0007J\u0010\u00104\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u00105\u001a\u00020\u00132\u000e\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001307H\u0007\u00a8\u00069"}, d2={"Lcom/intellij/openapi/util/IconLoader;", "", "<init>", "()V", "installPathPatcher", "", "patcher", "Lcom/intellij/openapi/util/IconPathPatcher;", "installPostPathPatcher", "removePathPatcher", "setUseDarkIcons", "useDarkIcons", "", "setFilter", "filter", "Ljava/awt/image/ImageFilter;", "clearCache", "clearCacheInTests", "getIcon", "Ljavax/swing/Icon;", "path", "", "Lorg/jetbrains/annotations/NonNls;", "findIcon", "aClass", "Ljava/lang/Class;", "classLoader", "Ljava/lang/ClassLoader;", "activate", "deactivate", "deferUrlResolve", "strict", "url", "Ljava/net/URL;", "storeToCache", "findResolvedIcon", "toImage", "Ljava/awt/Image;", "icon", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "isGoodSize", "getDisabledIcon", "filterIcon", "filterSupplier", "Lcom/intellij/ui/icons/RgbImageFilterSupplier;", "getTransparentIcon", "alpha", "", "getIconSnapshot", "getDarkIcon", "dark", "detachClassLoader", "createLazy", "producer", "Ljava/util/function/Supplier;", "CachedImageIcon", "intellij.platform.util.ui"})
public final class IconLoader {
    @NotNull
    public static final IconLoader INSTANCE = new IconLoader();

    private IconLoader() {
    }

    @JvmStatic
    public static final void installPathPatcher(@NotNull IconPathPatcher patcher) {
        Intrinsics.checkNotNullParameter((Object)patcher, (String)"patcher");
        IconUtilKt.updateTransform((Function1<? super IconTransform, IconTransform>)((Function1)arg_0 -> IconLoader.installPathPatcher$lambda$0(patcher, arg_0)));
    }

    @ApiStatus.Internal
    public final void installPostPathPatcher(@NotNull IconPathPatcher patcher) {
        Intrinsics.checkNotNullParameter((Object)patcher, (String)"patcher");
        IconUtilKt.updateTransform((Function1<? super IconTransform, IconTransform>)((Function1)arg_0 -> IconLoader.installPostPathPatcher$lambda$0(patcher, arg_0)));
    }

    @JvmStatic
    public static final void removePathPatcher(@NotNull IconPathPatcher patcher) {
        Intrinsics.checkNotNullParameter((Object)patcher, (String)"patcher");
        IconUtilKt.updateTransform((Function1<? super IconTransform, IconTransform>)((Function1)arg_0 -> IconLoader.removePathPatcher$lambda$0(patcher, arg_0)));
    }

    @JvmStatic
    public static final void setUseDarkIcons(boolean useDarkIcons) {
        IconUtilKt.updateTransform((Function1<? super IconTransform, IconTransform>)((Function1)arg_0 -> IconLoader.setUseDarkIcons$lambda$0(useDarkIcons, arg_0)));
    }

    @JvmStatic
    public static final void setFilter(@NotNull ImageFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        IconUtilKt.updateTransform((Function1<? super IconTransform, IconTransform>)((Function1)arg_0 -> IconLoader.setFilter$lambda$0(filter, arg_0)));
    }

    @JvmStatic
    public static final void clearCache() {
        CachedImageIconKt.pathTransformGlobalModCount.incrementAndGet();
        IconUtilKt.clearCacheOnUpdateTransform();
    }

    @TestOnly
    public final void clearCacheInTests() {
        IconLoaderKt.access$getIconCache$p().invalidateAll();
        IconUtilKt.clearCacheOnUpdateTransform();
        CachedImageIconKt.pathTransformGlobalModCount.incrementAndGet();
    }

    @Deprecated(message="Use {@link #getIcon(String, ClassLoader)}", level=DeprecationLevel.ERROR)
    @JvmStatic
    @NotNull
    public static final Icon getIcon(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Class clazz = ReflectionUtil.getGrandCallerClass();
        if (clazz == null) {
            throw new IllegalStateException(path.toString());
        }
        return IconLoader.getIcon(path, clazz);
    }

    @Deprecated(message="Use {@link #findIcon(String, ClassLoader)}.", level=DeprecationLevel.ERROR)
    @JvmStatic
    @Nullable
    public static final Icon findIcon(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Class clazz = ReflectionUtil.getGrandCallerClass();
        if (clazz == null) {
            return null;
        }
        Class callerClass = clazz;
        ClassLoader classLoader = callerClass.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return IconLoader.findIcon(path, classLoader);
    }

    @JvmStatic
    @NotNull
    public static final Icon getIcon(@NotNull String path, @NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        ClassLoader classLoader = aClass.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        Icon icon = IconLoaderKt.findIconUsingDeprecatedImplementation$default(path, classLoader, aClass, null, false, 8, null);
        if (icon == null) {
            throw new IllegalStateException("Icon cannot be found in '" + path + "', class='" + aClass.getName() + "'");
        }
        return icon;
    }

    @JvmStatic
    @NotNull
    public static final Icon getIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Icon icon = IconLoader.findIcon(path, classLoader);
        if (icon == null) {
            throw new IllegalStateException("Icon cannot be found in '" + path + "', classLoader='" + classLoader + "'");
        }
        return icon;
    }

    @JvmStatic
    @TestOnly
    public static final void activate() {
        ScaledIconCacheKt.isIconActivated = true;
    }

    @JvmStatic
    @TestOnly
    public static final void deactivate() {
        ScaledIconCacheKt.isIconActivated = false;
    }

    @JvmStatic
    @Nullable
    public static final Icon findIcon(@NotNull String path, @NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        ClassLoader classLoader = aClass.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return IconLoaderKt.findIconUsingNewImplementation$default(path, classLoader, null, 4, null);
    }

    @JvmStatic
    @Nullable
    public static final Icon findIcon(@NotNull String path, @NotNull Class<?> aClass, boolean deferUrlResolve, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        if (deferUrlResolve) {
            ClassLoader classLoader = aClass.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
            return IconLoaderKt.findIconUsingDeprecatedImplementation$default(path, classLoader, aClass, null, strict, 8, null);
        }
        ClassLoader classLoader = aClass.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return IconLoaderKt.findIconUsingNewImplementation$default(path, classLoader, null, 4, null);
    }

    @JvmStatic
    @Nullable
    public static final Icon findIcon(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        Pair key = new Pair((Object)url.toString(), null);
        return (Icon)IconLoaderKt.access$getIconCache$p().get((Object)key, arg_0 -> IconLoader.findIcon$lambda$1(arg_0 -> IconLoader.findIcon$lambda$0(url, arg_0), arg_0));
    }

    @JvmStatic
    @Nullable
    public static final Icon findIcon(@Nullable URL url, boolean storeToCache) {
        if (url == null) {
            return null;
        }
        Pair key = new Pair((Object)url.toString(), null);
        if (storeToCache) {
            return (Icon)IconLoaderKt.access$getIconCache$p().get((Object)key, arg_0 -> IconLoader.findIcon$lambda$3(arg_0 -> IconLoader.findIcon$lambda$2(url, arg_0), arg_0));
        }
        com.intellij.ui.icons.CachedImageIcon cachedImageIcon = (com.intellij.ui.icons.CachedImageIcon)IconLoaderKt.access$getIconCache$p().getIfPresent((Object)key);
        return cachedImageIcon != null ? (Icon)cachedImageIcon : (Icon)new com.intellij.ui.icons.CachedImageIcon(url, null, 2, null);
    }

    @JvmStatic
    @Nullable
    public static final Icon findIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return ImageDataByPathLoaderKt.findIconByPath$default(path, classLoader, IconLoaderKt.access$getIconCache$p(), null, 8, null);
    }

    @JvmStatic
    @Nullable
    public static final Icon findResolvedIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Icon icon = IconLoaderKt.findIconUsingNewImplementation$default(path, classLoader, null, 4, null);
        return icon instanceof com.intellij.ui.icons.CachedImageIcon && ((com.intellij.ui.icons.CachedImageIcon)icon).getRealIcon() == CachedImageIconKt.getEMPTY_ICON() ? null : icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Image toImage(@NotNull Icon icon, @Nullable ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Icon effectiveIcon = icon;
        if (effectiveIcon instanceof RetrievableIcon) {
            effectiveIcon = IconUtilKt.getOriginIcon((RetrievableIcon)effectiveIcon);
        }
        if (effectiveIcon instanceof com.intellij.ui.icons.CachedImageIcon) {
            return ((com.intellij.ui.icons.CachedImageIcon)effectiveIcon).resolveImage$intellij_platform_util_ui(scaleContext);
        }
        if (effectiveIcon instanceof ImageIcon) {
            return ((ImageIcon)effectiveIcon).getImage();
        }
        if (effectiveIcon.getIconWidth() <= 0 || effectiveIcon.getIconHeight() <= 0) {
            return null;
        }
        BufferedImage image = null;
        if (GraphicsEnvironment.isHeadless()) {
            BufferedImage bufferedImage = ImageUtil.createImage(scaleContext, (double)effectiveIcon.getIconWidth(), (double)effectiveIcon.getIconHeight(), 2, PaintUtil.RoundingMode.ROUND);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            image = bufferedImage;
        } else {
            BufferedImage bufferedImage;
            ScaleContext effectiveScaleContext;
            ScaleContext scaleContext2 = scaleContext;
            if (scaleContext2 == null) {
                scaleContext2 = ScaleContext.Companion.create();
            }
            if (StartupUiUtil.INSTANCE.isJreHiDPI(effectiveScaleContext = scaleContext2)) {
                bufferedImage = new HiDPIImage(effectiveScaleContext, (double)effectiveIcon.getIconWidth(), (double)effectiveIcon.getIconHeight(), 3, PaintUtil.RoundingMode.ROUND);
            } else {
                BufferedImage bufferedImage2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(PaintUtil.RoundingMode.ROUND.round(effectiveScaleContext.apply((double)effectiveIcon.getIconWidth(), DerivedScaleType.DEV_SCALE)), PaintUtil.RoundingMode.ROUND.round(effectiveScaleContext.apply((double)effectiveIcon.getIconHeight(), DerivedScaleType.DEV_SCALE)), 3);
                Intrinsics.checkNotNull((Object)bufferedImage2);
                bufferedImage = bufferedImage2;
            }
            image = bufferedImage;
        }
        Graphics2D g = image.createGraphics();
        try {
            effectiveIcon.paintIcon(null, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    public static /* synthetic */ Image toImage$default(Icon icon, ScaleContext scaleContext, int n, Object object) {
        if ((n & 2) != 0) {
            scaleContext = null;
        }
        return IconLoader.toImage(icon, scaleContext);
    }

    @JvmStatic
    public static final boolean isGoodSize(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    @JvmStatic
    @NotNull
    public static final Icon getDisabledIcon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return IconUtilKt.getDisabledIcon(icon, null);
    }

    @ApiStatus.Internal
    @NotNull
    public final Icon filterIcon(@NotNull Icon icon, @NotNull RgbImageFilterSupplier filterSupplier) {
        Icon effectiveIcon;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)filterSupplier, (String)"filterSupplier");
        if (icon instanceof EmptyIcon) {
            return icon;
        }
        Icon icon2 = effectiveIcon = icon instanceof LazyIcon ? ((LazyIcon)icon).getOrComputeIcon() : icon;
        if (!IconUtilKt.checkIconSize(effectiveIcon)) {
            return CachedImageIconKt.getEMPTY_ICON();
        }
        return effectiveIcon instanceof com.intellij.ui.icons.CachedImageIcon ? ((com.intellij.ui.icons.CachedImageIcon)effectiveIcon).createWithFilter$intellij_platform_util_ui(filterSupplier) : (Icon)((Object)new FilteredIcon(effectiveIcon, filterSupplier));
    }

    @JvmStatic
    @NotNull
    public static final Icon getTransparentIcon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    @JvmStatic
    @NotNull
    public static final Icon getTransparentIcon(@NotNull Icon icon, float alpha) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return new RetrievableIcon(icon, alpha){
            final /* synthetic */ Icon $icon;
            final /* synthetic */ float $alpha;
            {
                this.$icon = $icon;
                this.$alpha = $alpha;
            }

            public Icon retrieveIcon() {
                return this.$icon;
            }

            public int getIconHeight() {
                return this.$icon.getIconHeight();
            }

            public int getIconWidth() {
                return this.$icon.getIconWidth();
            }

            public Icon replaceBy(IconReplacer replacer) {
                Intrinsics.checkNotNullParameter((Object)replacer, (String)"replacer");
                Icon icon = replacer.replaceIcon(this.$icon);
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"replaceIcon(...)");
                return IconLoader.getTransparentIcon(icon, this.$alpha);
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                GraphicsUtil.paintWithAlpha(g, this.$alpha, () -> getTransparentIcon.1.paintIcon$lambda$0(this.$icon, c, g, x, y));
            }

            private static final void paintIcon$lambda$0(Icon $icon, Component $c, Graphics $g, int $x, int $y) {
                $icon.paintIcon($c, $g, $x, $y);
            }
        };
    }

    @Deprecated(message="Not needed")
    @JvmStatic
    @NotNull
    public static final Icon getIconSnapshot(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return icon instanceof com.intellij.ui.icons.CachedImageIcon ? ((com.intellij.ui.icons.CachedImageIcon)icon).getRealIcon() : icon;
    }

    @JvmStatic
    @NotNull
    public static final Icon getDarkIcon(@NotNull Icon icon, boolean dark) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        DarkReplacer replacer = dark ? IconLoaderKt.access$getOurDarkReplacer$p() : IconLoaderKt.access$getOurLightReplacer$p();
        return replacer.replaceIcon(icon);
    }

    @JvmStatic
    public static final void detachClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        IconLoaderKt.access$getIconCache$p().asMap().entrySet().removeIf(arg_0 -> IconLoader.detachClassLoader$lambda$1(arg_0 -> IconLoader.detachClassLoader$lambda$0(classLoader, arg_0), arg_0));
    }

    @JvmStatic
    @NotNull
    public static final Icon createLazy(@NotNull Supplier<? extends Icon> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        return new LazyIcon(producer);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Image toImage(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return IconLoader.toImage$default(icon, null, 2, null);
    }

    private static final IconTransform installPathPatcher$lambda$0(IconPathPatcher $patcher, IconTransform it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.withPathPatcher($patcher);
    }

    private static final IconTransform installPostPathPatcher$lambda$0(IconPathPatcher $patcher, IconTransform it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.withPostPathPatcher($patcher);
    }

    private static final IconTransform removePathPatcher$lambda$0(IconPathPatcher $patcher, IconTransform it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.withoutPathPatcher($patcher);
    }

    private static final IconTransform setUseDarkIcons$lambda$0(boolean $useDarkIcons, IconTransform it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.withDark($useDarkIcons);
    }

    private static final IconTransform setFilter$lambda$0(ImageFilter $filter, IconTransform it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.withFilter($filter);
    }

    private static final com.intellij.ui.icons.CachedImageIcon findIcon$lambda$0(URL $url, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new com.intellij.ui.icons.CachedImageIcon($url, null, 2, null);
    }

    private static final com.intellij.ui.icons.CachedImageIcon findIcon$lambda$1(Function1 $tmp0, Object p0) {
        return (com.intellij.ui.icons.CachedImageIcon)$tmp0.invoke(p0);
    }

    private static final com.intellij.ui.icons.CachedImageIcon findIcon$lambda$2(URL $url, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new com.intellij.ui.icons.CachedImageIcon($url, null, 2, null);
    }

    private static final com.intellij.ui.icons.CachedImageIcon findIcon$lambda$3(Function1 $tmp0, Object p0) {
        return (com.intellij.ui.icons.CachedImageIcon)$tmp0.invoke(p0);
    }

    private static final boolean detachClassLoader$lambda$0(ClassLoader $classLoader, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Pair key = (Pair)entry.getKey();
        com.intellij.ui.icons.CachedImageIcon icon = (com.intellij.ui.icons.CachedImageIcon)entry.getValue();
        return icon.detachClassLoader$intellij_platform_util_ui($classLoader) || key.getSecond() == $classLoader;
    }

    private static final boolean detachClassLoader$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Deprecated(message="Unused", replaceWith=@ReplaceWith(expression="com.intellij.ui.icons.CachedImageIcon", imports={}), level=DeprecationLevel.ERROR)
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/util/IconLoader$CachedImageIcon;", "Lcom/intellij/ui/icons/CachedImageIcon;", "loader", "Lcom/intellij/ui/icons/ImageDataLoader;", "<init>", "(Lcom/intellij/ui/icons/ImageDataLoader;)V", "intellij.platform.util.ui"})
    public static class CachedImageIcon
    extends com.intellij.ui.icons.CachedImageIcon {
        private CachedImageIcon(ImageDataLoader loader) {
            super(loader, null);
        }
    }
}

