/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.HiDPIScaledGraphics;
import com.intellij.util.ui.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B1\b\u0014\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fB)\b\u0017\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u000fB)\b\u0014\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0010B!\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0013B\u0019\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\u0015J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\tJ\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\b\u0010 \u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\u0012\u0010 \u001a\u00020\u00032\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010!\u001a\u00020\u00032\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020\u0003J\b\u0010'\u001a\u00020(H\u0016J\u0006\u0010)\u001a\u00020(R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/intellij/util/JBHiDPIScaledImage;", "Ljava/awt/image/BufferedImage;", "width", "", "height", "type", "<init>", "(III)V", "scale", "", "roundingMode", "Lcom/intellij/ui/paint/PaintUtil$RoundingMode;", "(DDDILcom/intellij/ui/paint/PaintUtil$RoundingMode;)V", "image", "Ljava/awt/Image;", "(Ljava/awt/Image;III)V", "(Ljava/awt/Image;DDI)V", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "(Ljava/awt/Image;Lcom/intellij/ui/scale/ScaleContext;I)V", "sysScale", "(Ljava/awt/Image;D)V", "delegate", "getDelegate", "()Ljava/awt/Image;", "userWidth", "userHeight", "getScale", "()D", "scaleFactor", "targetUserWidth", "targetUserHeight", "getWidth", "getHeight", "observer", "Ljava/awt/image/ImageObserver;", "getUserWidth", "getUserHeight", "getRealWidth", "createGraphics", "Ljava/awt/Graphics2D;", "createUnscaledGraphics", "intellij.platform.util.ui"})
@ApiStatus.Internal
@ApiStatus.NonExtendable
public class JBHiDPIScaledImage
extends BufferedImage {
    @Nullable
    private final Image delegate;
    private final double userWidth;
    private final double userHeight;
    private final double scale;

    @Nullable
    public final Image getDelegate() {
        return this.delegate;
    }

    public final double getScale() {
        return this.scale;
    }

    @Deprecated(message="Use IconManager instead.")
    public JBHiDPIScaledImage(int width, int height, int type) {
        this(JBUIScale.sysScale(), width, height, type, PaintUtil.RoundingMode.FLOOR);
    }

    protected JBHiDPIScaledImage(double scale, double width, double height, int type, @NotNull PaintUtil.RoundingMode roundingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)roundingMode), (String)"roundingMode");
        super(roundingMode.round(width * scale), roundingMode.round(height * scale), type);
        this.delegate = null;
        this.userWidth = width;
        this.userHeight = height;
        this.scale = scale;
    }

    @Deprecated(message="Use IconManager instead.")
    @ApiStatus.ScheduledForRemoval
    public JBHiDPIScaledImage(@NotNull Image image, int width, int height, int type) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this(image, (double)width, (double)height, type);
    }

    protected JBHiDPIScaledImage(@NotNull Image image, double width, double height, int type) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super(1, 1, type);
        this.delegate = image;
        this.userWidth = width;
        this.userHeight = height;
        this.scale = this.userWidth > 0.0 ? (double)this.delegate.getWidth(null) / this.userWidth : 1.0;
    }

    public JBHiDPIScaledImage(@NotNull Image image, @NotNull ScaleContext scaleContext, int type) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        super(1, 1, type);
        this.delegate = image;
        this.scale = scaleContext.getScale(ScaleType.SYS_SCALE);
        this.userWidth = (double)this.delegate.getWidth(null) / this.scale;
        this.userHeight = (double)this.delegate.getHeight(null) / this.scale;
    }

    public JBHiDPIScaledImage(@NotNull Image image, double sysScale) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super(1, 1, 2);
        this.delegate = image;
        this.scale = sysScale;
        this.userWidth = (double)this.delegate.getWidth(null) / this.scale;
        this.userHeight = (double)this.delegate.getHeight(null) / this.scale;
    }

    @NotNull
    public final JBHiDPIScaledImage scale(double scaleFactor) {
        Image image = this.delegate;
        if (image == null) {
            image = this;
        }
        Image img = image;
        int w = (int)(scaleFactor * (double)this.getRealWidth());
        Image image2 = this.delegate;
        int h = (int)(scaleFactor * (double)(image2 != null ? image2.getHeight(null) : super.getHeight(null)));
        if (w <= 0 || h <= 0) {
            return this;
        }
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(img), (Scalr.Method)Scalr.Method.QUALITY, (int)w, (int)h, (BufferedImageOp[])new BufferedImageOp[0]);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"resize(...)");
        Image scaled = bufferedImage;
        double newUserWidth = (double)w / this.scale;
        double newUserHeight = (double)h / this.scale;
        if (this.delegate != null) {
            return new JBHiDPIScaledImage(scaled, newUserWidth, newUserHeight, this.getType());
        }
        JBHiDPIScaledImage newImg = new JBHiDPIScaledImage(this.scale, newUserWidth, newUserHeight, this.getType(), PaintUtil.RoundingMode.ROUND);
        Graphics2D g = newImg.createGraphics();
        g.drawImage(scaled, 0, 0, MathKt.roundToInt((double)newUserWidth), MathKt.roundToInt((double)newUserHeight), 0, 0, scaled.getWidth(null), scaled.getHeight(null), null);
        g.dispose();
        return newImg;
    }

    @NotNull
    public final JBHiDPIScaledImage scale(int targetUserWidth, int targetUserHeight) {
        Image image = this.delegate;
        if (image == null) {
            image = this;
        }
        Image img = image;
        int w = this.getUserWidth();
        int h = this.getUserHeight();
        if (w <= 0 || h <= 0 || w == targetUserWidth && h == targetUserHeight) {
            return this;
        }
        int targetWidth = MathKt.roundToInt((double)((double)targetUserWidth * this.scale));
        int targetHeight = MathKt.roundToInt((double)((double)targetUserHeight * this.scale));
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(img), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])new BufferedImageOp[0]);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"resize(...)");
        Image scaled = bufferedImage;
        if (this.delegate != null) {
            return new JBHiDPIScaledImage(scaled, (double)targetUserWidth, (double)targetUserHeight, this.getType());
        }
        JBHiDPIScaledImage newImg = new JBHiDPIScaledImage(this.scale, targetUserWidth, targetUserHeight, this.getType(), PaintUtil.RoundingMode.ROUND);
        Graphics2D g = newImg.createGraphics();
        g.drawImage(scaled, 0, 0, targetUserWidth, targetUserHeight, 0, 0, scaled.getWidth(null), scaled.getHeight(null), null);
        g.dispose();
        return newImg;
    }

    @Override
    public int getWidth() {
        return this.getWidth(null);
    }

    @Override
    public int getHeight() {
        return this.getHeight(null);
    }

    @Override
    public int getWidth(@Nullable ImageObserver observer) {
        return this.delegate == null ? super.getWidth(observer) : MathKt.roundToInt((double)this.userWidth);
    }

    @Override
    public int getHeight(@Nullable ImageObserver observer) {
        return this.delegate == null ? super.getHeight(observer) : MathKt.roundToInt((double)this.userHeight);
    }

    public final int getUserWidth() {
        return this.delegate == null ? MathKt.roundToInt((double)((double)super.getWidth(null) / this.scale)) : MathKt.roundToInt((double)this.userWidth);
    }

    public final int getUserHeight() {
        return this.delegate == null ? MathKt.roundToInt((double)((double)super.getHeight(null) / this.scale)) : MathKt.roundToInt((double)this.userHeight);
    }

    public final int getRealWidth() {
        Image image = this.delegate;
        return image != null ? image.getWidth(null) : super.getWidth(null);
    }

    @Override
    @NotNull
    public Graphics2D createGraphics() {
        Graphics2D g = super.createGraphics();
        if (this.delegate == null) {
            g.scale(this.scale, this.scale);
            return new HiDPIScaledGraphics(g);
        }
        Intrinsics.checkNotNull((Object)g);
        return g;
    }

    @NotNull
    public final Graphics2D createUnscaledGraphics() {
        Graphics2D graphics2D = super.createGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
        return graphics2D;
    }
}

