/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.svg.SvgImageDecoder;
import com.intellij.util.io.URLUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.ImageDecoder;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.URLImageSource;

public final class JBImageToolkit {
    private static final URLStreamHandler dataImageStreamUrlHandler = new DataImageURLStreamHandler();

    public static Image createImage(String filename) {
        return JBImageToolkit.createImage(new FileImageSource(filename){

            @Override
            public ImageDecoder getDecoder(InputStream is) {
                return JBImageToolkit.getWithCustomDecoders(this, is, x$0 -> super.getDecoder((InputStream)x$0));
            }
        });
    }

    public static Image createImage(URL url) {
        return JBImageToolkit.createImage(new URLImageSource(url){

            @Override
            public ImageDecoder getDecoder(InputStream is) {
                return JBImageToolkit.getWithCustomDecoders(this, is, x$0 -> super.getDecoder((InputStream)x$0));
            }
        });
    }

    public static Image createImage(byte[] imagedata) {
        return JBImageToolkit.createImage(imagedata, 0, imagedata.length);
    }

    public static Image createImage(byte[] data, int offset, int length) {
        return JBImageToolkit.createImage(new ByteArrayImageSource(data, offset, length){

            @Override
            public ImageDecoder getDecoder(InputStream is) {
                return JBImageToolkit.getWithCustomDecoders(this, is, x$0 -> super.getDecoder((InputStream)x$0));
            }
        });
    }

    public static Image createImage(ImageProducer producer) {
        return Toolkit.getDefaultToolkit().createImage(producer);
    }

    public static boolean prepareImage(@NotNull Image img, int w, int h, @Nullable ImageObserver o) {
        if (img == null) {
            JBImageToolkit.$$$reportNull$$$0(0);
        }
        return Toolkit.getDefaultToolkit().prepareImage(img, w, h, o);
    }

    @ApiStatus.Internal
    public static URL tryBuildDataImageUrl(@NotNull String url) throws MalformedURLException {
        if (url == null) {
            JBImageToolkit.$$$reportNull$$$0(1);
        }
        if (url.startsWith("data:image/") && url.contains(",")) {
            return new URL(null, url, dataImageStreamUrlHandler);
        }
        return null;
    }

    @ApiStatus.Internal
    public static ImageDecoder getWithCustomDecoders(InputStreamImageSource source, InputStream stream, Function<InputStream, ImageDecoder> originalGetDecoder) {
        InputStream bufferedStream = !stream.markSupported() ? new BufferedInputStream(stream) : stream;
        ImageDecoder result = originalGetDecoder.apply(bufferedStream);
        if (result != null) {
            return result;
        }
        return SvgImageDecoder.Companion.detect(source, bufferedStream, -1, -1);
    }

    private JBImageToolkit() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "img";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/JBImageToolkit";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareImage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "tryBuildDataImageUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DataImageURLStreamHandler
    extends URLStreamHandler {
        private DataImageURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(final URL u) {
            return new URLConnection(this, u){

                @Override
                public void connect() {
                    this.connected = true;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    this.connect();
                    List parts = StringUtil.split((String)u.toString(), (String)",");
                    if (parts.size() == 2) {
                        boolean isBase64 = ((String)parts.get(0)).endsWith(";base64");
                        String encodedImage = (String)parts.get(1);
                        return new ByteArrayInputStream(isBase64 ? Base64.getDecoder().decode(encodedImage) : URLUtil.decode((String)encodedImage).getBytes(StandardCharsets.UTF_8));
                    }
                    throw new IOException("Malformed data url: " + String.valueOf(u));
                }
            };
        }
    }
}

