/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;
import java.util.ArrayList;

public final class SplitBySeparatorPolicy
extends FilePathSplittingPolicy {
    @Override
    public String getPresentableName(File file, int length) {
        Object s;
        String absolutePath = file.getPath();
        if (absolutePath.length() <= length) {
            return absolutePath;
        }
        String name = file.getName();
        if (length < name.length()) {
            return "...";
        }
        if (length == name.length()) {
            return name;
        }
        ArrayList<String> components = SplitBySeparatorPolicy.getComponents(file);
        int currentLength = 0;
        ArrayList<Object> end = new ArrayList<Object>();
        ArrayList<Object> begin = new ArrayList<Object>();
        int size = components.size();
        int mult = 1;
        int currentIndex = 0;
        for (int i = size - 1; i >= 0 && (currentLength += ((String)(s = (String)components.get(currentIndex))).length()) <= length - 3; --i) {
            if (mult > 0) {
                end.add(s);
            } else {
                begin.add(s);
            }
            currentIndex += i * mult;
            mult *= -1;
        }
        if (end.isEmpty()) {
            return name;
        }
        StringBuilder result = new StringBuilder();
        for (String string : begin) {
            result.append(string);
        }
        result.append("...");
        for (int i = end.size() - 1; i >= 0; --i) {
            result.append((String)end.get(i));
        }
        return result.toString();
    }

    private static ArrayList<String> getComponents(File file) {
        ArrayList<String> result = new ArrayList<String>();
        File current = file;
        while (current != null) {
            result.add(SplitBySeparatorPolicy.getFileName(current));
            if ((current = current.getParentFile()) == null) continue;
            result.add(File.separator);
        }
        return result;
    }

    private static String getFileName(File current) {
        String result = current.getName();
        if (!result.isEmpty()) {
            return result;
        }
        String path = current.getPath();
        return path.substring(0, path.length() - 1);
    }
}

