/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.protobuf.ProtoeditorCoreIcons;
import com.intellij.protobuf.ide.PbIdeBundle;
import com.intellij.protobuf.ide.gutter.PbNavigationUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH\u0014J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/protobuf/ide/gutter/PbLanguageSpecificLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "<init>", "()V", "getName", "", "isAcceptableElement", "", "element", "Lcom/intellij/psi/PsiElement;", "collectNavigationMarkers", "", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "createImplementedElementMarker", "identifier", "identifierOwner", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "hasProtoDefinition", "psiElement", "intellij.protoeditor.core"})
public abstract class PbLanguageSpecificLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    @Nullable
    public String getName() {
        return PbIdeBundle.message("line.marker.navigate.to.declaration", new Object[0]);
    }

    protected abstract boolean isAcceptableElement(@NotNull PsiElement var1);

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (!(element instanceof PsiNameIdentifierOwner)) {
            return;
        }
        PsiElement psiElement = ((PsiNameIdentifierOwner)element).getIdentifyingElement();
        if (psiElement == null) {
            return;
        }
        PsiElement anchor = psiElement;
        if (!this.isAcceptableElement(element) || !this.hasProtoDefinition(element)) {
            return;
        }
        result.add(this.createImplementedElementMarker(anchor, (PsiNameIdentifierOwner)element));
    }

    private final RelatedItemLineMarkerInfo<PsiElement> createImplementedElementMarker(PsiElement identifier, PsiNameIdentifierOwner identifierOwner) {
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = NavigationGutterIconBuilder.create((Icon)ProtoeditorCoreIcons.GoToDeclaration).setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(PbIdeBundle.message("line.marker.navigate.to.declaration", new Object[0])).setEmptyPopupText(PbIdeBundle.message("line.marker.no.declarations.found", new Object[0])).setTargets(NotNullLazyValue.lazy(() -> PbLanguageSpecificLineMarkerProvider.createImplementedElementMarker$lambda$0(identifierOwner))).createLineMarkerInfo(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"createLineMarkerInfo(...)");
        return relatedItemLineMarkerInfo;
    }

    private final boolean hasProtoDefinition(PsiElement psiElement) {
        return SequencesKt.any(PbNavigationUtilsKt.findProtoDefinitions(psiElement));
    }

    private static final Collection createImplementedElementMarker$lambda$0(PsiNameIdentifierOwner $identifierOwner) {
        return SequencesKt.toList(PbNavigationUtilsKt.findProtoDefinitions((PsiElement)$identifierOwner));
    }
}

