/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.refactoring;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.refactoring.PbDuplicatedImportAnalyzerKt;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/protobuf/lang/refactoring/PbImportOptimizer;", "Lcom/intellij/lang/ImportOptimizer;", "<init>", "()V", "supports", "", "file", "Lcom/intellij/psi/PsiFile;", "processFile", "Ljava/lang/Runnable;", "intellij.protoeditor.core"})
public final class PbImportOptimizer
implements ImportOptimizer {
    public boolean supports(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof PbFile;
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof PbFile) || ((PbFile)file).getImportStatements().isEmpty()) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"INSTANCE");
            return runnable;
        }
        Collection<PbImportStatement> duplicates = PbDuplicatedImportAnalyzerKt.collectDuplicatedImportsSkipOriginal((PbFile)file);
        return () -> PbImportOptimizer.processFile$lambda$0(file, duplicates);
    }

    private static final void processFile$lambda$0(PsiFile $file, Collection $duplicates) {
        PbDuplicatedImportAnalyzerKt.removeDuplicatedImports((PbFile)$file, CollectionsKt.toSet((Iterable)$duplicates));
    }
}

