/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.jpa;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.jpa.DataSourceRelatedReferenceFixProvider;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.jpb.model.backend.ds.DataSourceLoader;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.liquibase.jpa.CreateDiffChangeLogActionFix;
import com.intellij.liquibase.orm.LiquibaseHelper;
import com.intellij.liquibase.orm.extension.OrmDiffModelProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/liquibase/jpa/LiquibaseUnresolvedColumnFixProvider;", "Lcom/intellij/jpa/DataSourceRelatedReferenceFixProvider;", "<init>", "()V", "getQuickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "reference", "Lcom/intellij/jpa/ORMReferencesUtil$DataSourceRelatedReference;", "(Lcom/intellij/jpa/ORMReferencesUtil$DataSourceRelatedReference;)[Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.liquibase.jpa"})
@SourceDebugExtension(value={"SMAP\nLiquibaseUnresolvedColumnFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseUnresolvedColumnFixProvider.kt\ncom/intellij/liquibase/jpa/LiquibaseUnresolvedColumnFixProvider\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,78:1\n18#2:79\n*S KotlinDebug\n*F\n+ 1 LiquibaseUnresolvedColumnFixProvider.kt\ncom/intellij/liquibase/jpa/LiquibaseUnresolvedColumnFixProvider\n*L\n37#1:79\n*E\n"})
public final class LiquibaseUnresolvedColumnFixProvider
implements DataSourceRelatedReferenceFixProvider {
    @NotNull
    public LocalQuickFix[] getQuickFixes(@NotNull ORMReferencesUtil.DataSourceRelatedReference<?> reference) {
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
        OrmFramework ormFramework = reference.getOrmFramework();
        Intrinsics.checkNotNullExpressionValue((Object)ormFramework, (String)"getOrmFramework(...)");
        if (OrmDiffModelProvider.Companion.findForFramework(ormFramework) == null) {
            return new LocalQuickFix[0];
        }
        Project project = reference.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)reference.getElement());
        if (!LiquibaseHelper.Companion.getInstance(project2).isLiquibaseSupported(project2, module)) {
            return new LocalQuickFix[0];
        }
        DataSourceLoader dataSourceLoader = DataSourceLoader.Companion.getInstance(project2);
        OrmFramework ormFramework2 = reference.getOrmFramework();
        Intrinsics.checkNotNullExpressionValue((Object)ormFramework2, (String)"getOrmFramework(...)");
        if (dataSourceLoader.getReverseEngineeringDataStores(ormFramework2).isEmpty()) {
            return new LocalQuickFix[0];
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)reference.getElement());
        if (uElement != null) {
            UElement $this$getParentOfType_u24default$iv = uElement;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            uElement = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
            if (uElement != null && (uElement = uElement.getJavaPsi()) != null) {
                UElement it = uElement;
                boolean bl = false;
                OrmFramework ormFramework3 = reference.getOrmFramework();
                Intrinsics.checkNotNullExpressionValue((Object)ormFramework3, (String)"getOrmFramework(...)");
                AbstractRdbmsStore dataSource = OrmUtil.INSTANCE.getAssociatedDataStore((PsiClass)it, ormFramework3);
                if (dataSource == null) {
                    return new LocalQuickFix[0];
                }
            }
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new CreateDiffChangeLogActionFix(reference)};
        return localQuickFixArray;
    }
}

