/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend.frame;

import com.intellij.ide.ui.colors.ColorId;
import com.intellij.ide.ui.colors.ColorIdKt;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.FrontendXDebuggerEvaluator;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.FrontendXDebuggerEvaluatorKt;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.FrontendXValueContainer;
import com.intellij.platform.debugger.impl.rpc.SerializableSimpleTextAttributes;
import com.intellij.platform.debugger.impl.rpc.XContainerId;
import com.intellij.platform.debugger.impl.rpc.XSourcePositionDto;
import com.intellij.platform.debugger.impl.rpc.XStackFrameBackgroundColor;
import com.intellij.platform.debugger.impl.rpc.XStackFrameDto;
import com.intellij.platform.debugger.impl.rpc.XStackFrameId;
import com.intellij.platform.debugger.impl.rpc.XStackFramePresentation;
import com.intellij.platform.debugger.impl.rpc.XStackFramePresentationFragment;
import com.intellij.platform.debugger.impl.rpc.XStackTraceDtoKt;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XStackFrameUiPresentationContainer;
import com.intellij.xdebugger.impl.frame.XStackFrameWithSeparatorAbove;
import com.intellij.xdebugger.impl.rpc.RpcDtoUtilsKt;
import java.awt.Color;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001>B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u0004\u0018\u00010#J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010\u0011\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020(2\u0006\u0010/\u001a\u000200H\u0016J\u000e\u00102\u001a\u00020(2\u0006\u00103\u001a\u000204J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020!05H\u0016J\b\u00106\u001a\u00020,H\u0016J\u000f\u00107\u001a\t\u0018\u000108\u00a2\u0006\u0002\b9H\u0016J\u0014\u0010:\u001a\u00020,2\b\u0010;\u001a\u0004\u0018\u00010&H\u0096\u0082\u0004J\n\u0010<\u001a\u00020=H\u0096\u0080\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/frame/FrontendXStackFrame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "Lcom/intellij/xdebugger/impl/frame/XStackFrameWithSeparatorAbove;", "project", "Lcom/intellij/openapi/project/Project;", "frameDto", "Lcom/intellij/platform/debugger/impl/rpc/XStackFrameDto;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/debugger/impl/rpc/XStackFrameDto;Lkotlinx/coroutines/CoroutineScope;)V", "id", "Lcom/intellij/platform/debugger/impl/rpc/XStackFrameId;", "getId", "()Lcom/intellij/platform/debugger/impl/rpc/XStackFrameId;", "evaluator", "Lcom/intellij/platform/debugger/impl/frontend/evaluate/quick/FrontendXDebuggerEvaluator;", "getEvaluator", "()Lcom/intellij/platform/debugger/impl/frontend/evaluate/quick/FrontendXDebuggerEvaluator;", "evaluator$delegate", "Lkotlin/Lazy;", "xValueContainer", "Lcom/intellij/platform/debugger/impl/frontend/evaluate/quick/FrontendXValueContainer;", "backgroundColor", "Ljava/awt/Color;", "getBackgroundColor", "()Ljava/awt/Color;", "canDropFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/platform/debugger/impl/frontend/frame/FrontendXStackFrame$CanDropState;", "getCanDropFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "currentUiPresentation", "Lcom/intellij/xdebugger/frame/XStackFrameUiPresentationContainer;", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getAlternativeSourcePosition", "getEqualityObject", "", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "isDocumentEvaluator", "", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "customizeTextPresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "customizePresentation", "newUiPresentation", "presentation", "Lcom/intellij/platform/debugger/impl/rpc/XStackFramePresentation;", "Lkotlinx/coroutines/flow/Flow;", "hasSeparatorAbove", "getCaptionAboveOf", "", "Lcom/intellij/openapi/util/NlsContexts$Separator;", "equals", "other", "hashCode", "", "CanDropState", "intellij.platform.debugger.impl.frontend"})
@SourceDebugExtension(value={"SMAP\nFrontendXStackFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendXStackFrame.kt\ncom/intellij/platform/debugger/impl/frontend/frame/FrontendXStackFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1915#2,2:130\n*S KotlinDebug\n*F\n+ 1 FrontendXStackFrame.kt\ncom/intellij/platform/debugger/impl/frontend/frame/FrontendXStackFrame\n*L\n88#1:130,2\n*E\n"})
public final class FrontendXStackFrame
extends XStackFrame
implements XStackFrameWithSeparatorAbove {
    @NotNull
    private final XStackFrameDto frameDto;
    @NotNull
    private final Lazy evaluator$delegate;
    @NotNull
    private final FrontendXValueContainer xValueContainer;
    @NotNull
    private final MutableStateFlow<CanDropState> canDropFlow;
    @NotNull
    private final MutableStateFlow<XStackFrameUiPresentationContainer> currentUiPresentation;

    public FrontendXStackFrame(@NotNull Project project, @NotNull XStackFrameDto frameDto, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)frameDto, (String)"frameDto");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.frameDto = frameDto;
        this.evaluator$delegate = LazyKt.lazy(() -> FrontendXStackFrame.evaluator_delegate$lambda$0(project, cs, this));
        this.xValueContainer = new FrontendXValueContainer(project, cs, false, (XContainerId)this.getId());
        this.canDropFlow = StateFlowKt.MutableStateFlow((Object)((Object)CanDropState.Companion.fromThreeState(this.frameDto.getCanDrop())));
        this.currentUiPresentation = StateFlowKt.MutableStateFlow((Object)new XStackFrameUiPresentationContainer());
    }

    @NotNull
    public final XStackFrameId getId() {
        return this.frameDto.getStackFrameId();
    }

    private final FrontendXDebuggerEvaluator getEvaluator() {
        Lazy lazy = this.evaluator$delegate;
        return (FrontendXDebuggerEvaluator)((Object)lazy.getValue());
    }

    @Nullable
    public final Color getBackgroundColor() {
        XStackFrameBackgroundColor xStackFrameBackgroundColor = this.frameDto.getBackgroundColor();
        return xStackFrameBackgroundColor != null && (xStackFrameBackgroundColor = xStackFrameBackgroundColor.getColorId()) != null ? ColorIdKt.color((ColorId)xStackFrameBackgroundColor) : null;
    }

    @NotNull
    public final MutableStateFlow<CanDropState> getCanDropFlow() {
        return this.canDropFlow;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        XSourcePositionDto xSourcePositionDto = this.frameDto.getSourcePosition();
        return xSourcePositionDto != null ? RpcDtoUtilsKt.sourcePosition((XSourcePositionDto)xSourcePositionDto) : null;
    }

    @Nullable
    public final XSourcePosition getAlternativeSourcePosition() {
        XSourcePositionDto xSourcePositionDto = this.frameDto.getAlternativeSourcePosition();
        return xSourcePositionDto != null ? RpcDtoUtilsKt.sourcePosition((XSourcePositionDto)xSourcePositionDto) : null;
    }

    @Nullable
    public Object getEqualityObject() {
        return this.frameDto.getEqualityObject();
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.xValueContainer.computeChildren(node);
    }

    public boolean isDocumentEvaluator() {
        return this.frameDto.getEvaluator().getCanEvaluateInDocument();
    }

    @NotNull
    public XDebuggerEvaluator getEvaluator() {
        return this.getEvaluator();
    }

    public void customizeTextPresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        XStackFramePresentation xStackFramePresentation = this.frameDto.getTextPresentation();
        List fragments = xStackFramePresentation.component1();
        IconId iconId = xStackFramePresentation.component2();
        String tooltipText = xStackFramePresentation.component3();
        IconId iconId2 = iconId;
        component.setIcon(iconId2 != null ? IconIdKt.icon((IconId)iconId2) : null);
        component.setToolTipText(tooltipText);
        for (XStackFramePresentationFragment xStackFramePresentationFragment : fragments) {
            String text = xStackFramePresentationFragment.component1();
            SerializableSimpleTextAttributes attributes = xStackFramePresentationFragment.component2();
            component.append(text, XStackTraceDtoKt.toSimpleTextAttributes((SerializableSimpleTextAttributes)attributes));
        }
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ((XStackFrameUiPresentationContainer)this.currentUiPresentation.getValue()).customizePresentation(component);
    }

    public final void newUiPresentation(@NotNull XStackFramePresentation presentation) {
        XStackFrameUiPresentationContainer xStackFrameUiPresentationContainer;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        XStackFrameUiPresentationContainer $this$newUiPresentation_u24lambda_u240 = xStackFrameUiPresentationContainer = new XStackFrameUiPresentationContainer();
        boolean bl = false;
        IconId iconId = presentation.getIconId();
        $this$newUiPresentation_u24lambda_u240.setIcon(iconId != null ? IconIdKt.icon((IconId)iconId) : null);
        $this$newUiPresentation_u24lambda_u240.setToolTipText(presentation.getTooltipText());
        Iterable $this$forEach$iv = presentation.getFragments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XStackFramePresentationFragment xStackFramePresentationFragment = (XStackFramePresentationFragment)element$iv;
            boolean bl2 = false;
            String text = xStackFramePresentationFragment.component1();
            SerializableSimpleTextAttributes attributes = xStackFramePresentationFragment.component2();
            $this$newUiPresentation_u24lambda_u240.append(text, XStackTraceDtoKt.toSimpleTextAttributes((SerializableSimpleTextAttributes)attributes));
        }
        XStackFrameUiPresentationContainer presentationContainer = xStackFrameUiPresentationContainer;
        this.currentUiPresentation.setValue((Object)presentationContainer);
    }

    @NotNull
    public Flow<XStackFrameUiPresentationContainer> customizePresentation() {
        return (Flow)this.currentUiPresentation;
    }

    public boolean hasSeparatorAbove() {
        return this.frameDto.getCaptionInfo().getHasSeparatorAbove();
    }

    @Nullable
    public String getCaptionAboveOf() {
        return this.frameDto.getCaptionInfo().getCaption();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FrontendXStackFrame && Intrinsics.areEqual((Object)((FrontendXStackFrame)((Object)other)).getId(), (Object)this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private static final FrontendXDebuggerEvaluator evaluator_delegate$lambda$0(Project $project, CoroutineScope $cs, FrontendXStackFrame this$0) {
        return FrontendXDebuggerEvaluatorKt.createFrontendXDebuggerEvaluator($project, $cs, this$0.frameDto.getEvaluator(), this$0.getId());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0080\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/frame/FrontendXStackFrame$CanDropState;", "", "state", "Lcom/intellij/util/ThreeState;", "<init>", "(Ljava/lang/String;ILcom/intellij/util/ThreeState;)V", "getState", "()Lcom/intellij/util/ThreeState;", "UNSURE", "COMPUTING", "YES", "NO", "Companion", "intellij.platform.debugger.impl.frontend"})
    public static final class CanDropState
    extends Enum<CanDropState> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final ThreeState state;
        public static final /* enum */ CanDropState UNSURE;
        public static final /* enum */ CanDropState COMPUTING;
        public static final /* enum */ CanDropState YES;
        public static final /* enum */ CanDropState NO;
        private static final /* synthetic */ CanDropState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CanDropState(ThreeState state) {
            this.state = state;
        }

        @NotNull
        public final ThreeState getState() {
            return this.state;
        }

        public static CanDropState[] values() {
            return (CanDropState[])$VALUES.clone();
        }

        public static CanDropState valueOf(String value) {
            return Enum.valueOf(CanDropState.class, value);
        }

        @NotNull
        public static EnumEntries<CanDropState> getEntries() {
            return $ENTRIES;
        }

        static {
            UNSURE = new CanDropState(ThreeState.UNSURE);
            COMPUTING = new CanDropState(ThreeState.UNSURE);
            YES = new CanDropState(ThreeState.YES);
            NO = new CanDropState(ThreeState.NO);
            $VALUES = canDropStateArray = new CanDropState[]{CanDropState.UNSURE, CanDropState.COMPUTING, CanDropState.YES, CanDropState.NO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/frame/FrontendXStackFrame$CanDropState$Companion;", "", "<init>", "()V", "fromThreeState", "Lcom/intellij/platform/debugger/impl/frontend/frame/FrontendXStackFrame$CanDropState;", "state", "Lcom/intellij/util/ThreeState;", "fromBoolean", "value", "", "intellij.platform.debugger.impl.frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CanDropState fromThreeState(@NotNull ThreeState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                return switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                    case 1 -> YES;
                    case 2 -> NO;
                    case 3 -> UNSURE;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            @NotNull
            public final CanDropState fromBoolean(boolean value) {
                return value ? YES : NO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 3, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[ThreeState.values().length];
                    try {
                        nArray[ThreeState.YES.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ThreeState.NO.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ThreeState.UNSURE.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

