/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.packageChecker.java.JavaLibraryDependency;
import com.intellij.packageChecker.model.LibraryDependency;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.PackageType;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOGGER_CATEGORY", "", "packageTypes", "", "Lcom/intellij/packageChecker/model/PackageType;", "createPackage", "Lcom/intellij/packageChecker/model/Package;", "Lcom/intellij/openapi/roots/libraries/Library;", "project", "Lcom/intellij/openapi/project/Project;", "getPackageFromLibraryName", "javaLibraryDependencies", "", "Lcom/intellij/packageChecker/model/LibraryDependency;", "module", "Lcom/intellij/openapi/module/Module;", "getPackageFromLibraryDescriptor", "intellij.packageChecker.java"})
public final class JavaPackageUtilKt {
    @NotNull
    private static final String LOGGER_CATEGORY = "org.jetbrains.security.dependencies.calculator";
    @NotNull
    private static final Map<String, PackageType> packageTypes;

    @Nullable
    public static final Package createPackage(@NotNull Library $this$createPackage, @NotNull Project project) {
        Library library;
        Object $this$createPackage_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)$this$createPackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Logger logger = Logger.getInstance((String)LOGGER_CATEGORY);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        Library library2 = $this$createPackage;
        try {
            $this$createPackage_u24lambda_u240 = library2;
            boolean bl = false;
            Package pkg = JavaPackageUtilKt.getPackageFromLibraryName($this$createPackage_u24lambda_u240, project);
            if (pkg == null) {
                pkg = JavaPackageUtilKt.getPackageFromLibraryDescriptor($this$createPackage_u24lambda_u240, project);
            }
            if (logger2.isDebugEnabled() && pkg == null) {
                logger2.debug("cannot create package from library with presentableName: " + $this$createPackage_u24lambda_u240.getPresentableName());
            }
            $this$createPackage_u24lambda_u240 = Result.constructor-impl((Object)pkg);
        }
        catch (Throwable bl) {
            $this$createPackage_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        library2 = $this$createPackage_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)library2);
        if (throwable == null) {
            library = library2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            logger2.warn(e);
            library = null;
        }
        return (Package)library;
    }

    private static final Package getPackageFromLibraryName(Library $this$getPackageFromLibraryName, Project project) {
        Package package_;
        String[] stringArray;
        List splitLibName;
        String string = $this$getPackageFromLibraryName.getName();
        if (string == null) {
            String string2 = $this$getPackageFromLibraryName.getPresentableName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
        }
        if ((splitLibName = StringsKt.split$default((CharSequence)string, (String[])(stringArray = new String[]{":"}), (boolean)false, (int)0, (int)6, null)).size() == 4) {
            String type = (String)splitLibName.get(0);
            String namespace = (String)splitLibName.get(1);
            String name = (String)splitLibName.get(2);
            String version = (String)splitLibName.get(3);
            PackageType packageType = packageTypes.get(type);
            if (packageType != null) {
                PackageType packageType2 = packageType;
                boolean bl = false;
                package_ = Package.Companion.create(project, packageType2, ((Object)StringsKt.trim((CharSequence)namespace)).toString(), ((Object)StringsKt.trim((CharSequence)name)).toString(), ((Object)StringsKt.trim((CharSequence)version)).toString());
            } else {
                package_ = null;
            }
        } else {
            package_ = null;
        }
        return package_;
    }

    @NotNull
    public static final List<LibraryDependency> javaLibraryDependencies(@NotNull Module module) {
        List list;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        List $this$javaLibraryDependencies_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary(arg_0 -> JavaPackageUtilKt.javaLibraryDependencies$lambda$0$1(arg_0 -> JavaPackageUtilKt.javaLibraryDependencies$lambda$0$0($this$javaLibraryDependencies_u24lambda_u240, arg_0), arg_0));
        return CollectionsKt.build((List)list);
    }

    private static final Package getPackageFromLibraryDescriptor(Library $this$getPackageFromLibraryDescriptor, Project project) {
        Package package_;
        RepositoryLibraryProperties repositoryLibraryProperties;
        LibraryEx libraryEx = $this$getPackageFromLibraryDescriptor instanceof LibraryEx ? (LibraryEx)$this$getPackageFromLibraryDescriptor : null;
        if (libraryEx == null) {
            return null;
        }
        LibraryEx libraryEx2 = libraryEx;
        if (libraryEx2.isDisposed()) {
            return null;
        }
        LibraryProperties libraryProperties = libraryEx2.getProperties();
        RepositoryLibraryProperties repositoryLibraryProperties2 = repositoryLibraryProperties = libraryProperties instanceof RepositoryLibraryProperties ? (RepositoryLibraryProperties)libraryProperties : null;
        if (repositoryLibraryProperties != null && (libraryProperties = repositoryLibraryProperties.getRepositoryLibraryDescriptor()) != null) {
            LibraryProperties it = libraryProperties;
            boolean bl = false;
            if (it.getGroupId() == null || it.getArtifactId() == null || it.getVersion() == null) {
                package_ = null;
            } else {
                String string = it.getGroupId();
                String string2 = it.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
                String string3 = it.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
                package_ = Package.Companion.create(project, PackageType.maven, string, string2, string3);
            }
        } else {
            package_ = null;
        }
        return package_;
    }

    private static final boolean javaLibraryDependencies$lambda$0$0(List $this_buildList, Library lib) {
        Intrinsics.checkNotNull((Object)lib);
        return $this_buildList.add(new JavaLibraryDependency(lib));
    }

    private static final boolean javaLibraryDependencies$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Maven", (Object)((Object)PackageType.maven)), TuplesKt.to((Object)"Gradle", (Object)((Object)PackageType.maven)), TuplesKt.to((Object)"Amper", (Object)((Object)PackageType.maven))};
        packageTypes = MapsKt.mapOf((Pair[])pairArray);
    }
}

