/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.openapi.module.Module;
import com.intellij.packageChecker.service.VulnerableApiService;
import com.intellij.psi.HintedPsiElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/packageChecker/java/VulnerablePathHintedVisitor;", "Lcom/intellij/psi/PsiElementVisitor;", "Lcom/intellij/psi/HintedPsiElementVisitor;", "plugin", "Lorg/jetbrains/uast/UastLanguagePlugin;", "visitor", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "module", "Lcom/intellij/openapi/module/Module;", "directOnly", "", "<init>", "(Lorg/jetbrains/uast/UastLanguagePlugin;Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;Lcom/intellij/openapi/module/Module;Z)V", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "getHintPsiElements", "", "Ljava/lang/Class;", "intellij.packageChecker.java"})
final class VulnerablePathHintedVisitor
extends PsiElementVisitor
implements HintedPsiElementVisitor {
    @NotNull
    private final UastLanguagePlugin plugin;
    @NotNull
    private final AbstractUastNonRecursiveVisitor visitor;
    @NotNull
    private final Module module;
    private final boolean directOnly;

    public VulnerablePathHintedVisitor(@NotNull UastLanguagePlugin plugin, @NotNull AbstractUastNonRecursiveVisitor visitor, @NotNull Module module, boolean directOnly) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.plugin = plugin;
        this.visitor = visitor;
        this.module = module;
        this.directOnly = directOnly;
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (VulnerableApiService.Companion.getInstance(this.module).vulnerablePathsExisted()) {
            UElement uElement = this.plugin.convertElementWithParent(element, UCallExpression.class);
            UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
            if (uCallExpression == null) {
                return;
            }
            UCallExpression uElement2 = uCallExpression;
            String string = uElement2.getMethodName();
            if (string == null) {
                return;
            }
            String methodName = string;
            if (VulnerableApiService.Companion.getInstance(this.module).isSuspiciousMethodName(methodName) && (!this.directOnly || uElement2.getSourcePsi() == element)) {
                uElement2.accept((UastVisitor)this.visitor);
            }
        }
    }

    @NotNull
    public List<Class<?>> getHintPsiElements() {
        Class[] classArray = new Class[]{UCallExpression.class};
        return this.plugin.getPossiblePsiSourceTypes(classArray).toList();
    }
}

