/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.javascript;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.navigation.JSDeclarationEvaluator;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.service.VulnerableApiService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/packageChecker/javascript/NpmVulnerableApiCodeInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "<init>", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.packageChecker.javascript"})
public final class NpmVulnerableApiCodeInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!(holder.getFile() instanceof JSFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new Visitor(holder);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/packageChecker/javascript/NpmVulnerableApiCodeInspection$Visitor;", "Lcom/intellij/lang/javascript/psi/JSElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "module", "Lcom/intellij/openapi/module/Module;", "visitJSCallExpression", "", "node", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "retrievePath", "", "file", "Lcom/intellij/psi/PsiFile;", "intellij.packageChecker.javascript"})
    @SourceDebugExtension(value={"SMAP\nNpmVulnerableApiCodeInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmVulnerableApiCodeInspection.kt\ncom/intellij/packageChecker/javascript/NpmVulnerableApiCodeInspection$Visitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n3938#2:64\n4474#2,2:65\n1586#3:67\n1661#3,3:68\n*S KotlinDebug\n*F\n+ 1 NpmVulnerableApiCodeInspection.kt\ncom/intellij/packageChecker/javascript/NpmVulnerableApiCodeInspection$Visitor\n*L\n35#1:64\n35#1:65,2\n35#1:67\n35#1:68,3\n*E\n"})
    private static final class Visitor
    extends JSElementVisitor {
        @NotNull
        private final ProblemsHolder holder;
        @Nullable
        private final Module module;

        public Visitor(@NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
            this.module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.holder.getFile()));
        }

        /*
         * WARNING - void declaration
         */
        public void visitJSCallExpression(@NotNull JSCallExpression node) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitJSCallExpression(node);
            if (this.module == null) {
                return;
            }
            if (!VulnerableApiService.Companion.getInstance(this.module).vulnerablePathsExisted()) {
                return;
            }
            JSExpression jSExpression = node.getMethodExpression();
            JSReferenceExpression jSReferenceExpression = jSExpression instanceof JSReferenceExpression ? (JSReferenceExpression)jSExpression : null;
            if (jSReferenceExpression == null) {
                return;
            }
            JSReferenceExpression referenceExpression = jSReferenceExpression;
            ResolveResult[] resolveResultArray = referenceExpression.multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            Object[] $this$filter$iv = resolveResultArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (ResolveResult element$iv$iv : $this$filterTo$iv$iv) {
                ResolveResult it = element$iv$iv;
                boolean bl = false;
                if (!it.isValidResult()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ResolveResult element$iv$iv;
                element$iv$iv = (ResolveResult)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getElement());
            }
            PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (psiElement == null) {
                return;
            }
            PsiElement resolve = psiElement;
            if (resolve instanceof PsiNamedElement) {
                if (((PsiNamedElement)resolve).getName() == null) {
                    return;
                }
                VulnerableApiService vulnerableApiService = VulnerableApiService.Companion.getInstance(this.module);
                String string = ((PsiNamedElement)resolve).getName();
                Intrinsics.checkNotNull((Object)string);
                if (!vulnerableApiService.isSuspiciousMethodName(string)) {
                    return;
                }
            }
            JSFunction jSFunction = ($i$f$map = JSDeclarationEvaluator.adjustDeclaration((PsiElement)resolve, (PsiElement)((PsiElement)referenceExpression))) instanceof JSFunction ? (JSFunction)$i$f$map : null;
            if (jSFunction == null) {
                return;
            }
            JSFunction resolved = jSFunction;
            String string = resolved.getQualifiedName();
            if (string == null) {
                return;
            }
            String qualifiedName = string;
            PsiFile psiFile = resolved.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            String string2 = this.retrievePath(psiFile);
            if (string2 == null) {
                return;
            }
            String path = string2;
            String surrogateFqn = path + "." + qualifiedName;
            VulnerableApiService.registerProblemIfVulnerable$default(VulnerableApiService.Companion.getInstance(this.module), surrogateFqn, this.holder, (PsiElement)node, null, 8, null);
        }

        private final String retrievePath(PsiFile file) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            String string = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"/node_modules/", (boolean)false, (int)2, null)) {
                return null;
            }
            String string2 = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            return StringsKt.substringAfter$default((String)string2, (String)"/node_modules/", null, (int)2, null);
        }
    }
}

