/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/model/MultiLoaderWrapper;", "Ljava/lang/ClassLoader;", "parent", "myDelegates", "", "<init>", "(Ljava/lang/ClassLoader;Ljava/util/Collection;)V", "findClass", "Ljava/lang/Class;", "name", "", "intellij.platform.externalSystem"})
public final class MultiLoaderWrapper
extends ClassLoader {
    @NotNull
    private final Collection<ClassLoader> myDelegates;

    public MultiLoaderWrapper(@NotNull ClassLoader parent, @NotNull Collection<? extends ClassLoader> myDelegates) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(myDelegates, (String)"myDelegates");
        super(parent);
        this.myDelegates = myDelegates;
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (ClassLoader delegate : this.myDelegates) {
            try {
                Class<?> clazz = Class.forName(name, false, delegate);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }
}

