/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.regex.CaffeineCachingRegexProvider;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.jetbrains.plugins.textmate.regex.RegexFactory;
import org.jetbrains.plugins.textmate.regex.RegexProvider;
import org.jetbrains.plugins.textmate.regex.TextMateString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ/\u0010\u0010\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0011\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/textmate/regex/CaffeineCachingRegexProvider;", "Lorg/jetbrains/plugins/textmate/regex/RegexProvider;", "regexFactory", "Lorg/jetbrains/plugins/textmate/regex/RegexFactory;", "<init>", "(Lorg/jetbrains/plugins/textmate/regex/RegexFactory;)V", "REGEX_CACHE", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lorg/jetbrains/plugins/textmate/regex/RegexFacade;", "withRegex", "T", "pattern", "body", "Lkotlin/Function1;", "(Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withString", "string", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "intellij.textmate"})
public final class CaffeineCachingRegexProvider
implements RegexProvider {
    @NotNull
    private final RegexFactory regexFactory;
    @NotNull
    private final Cache<CharSequence, RegexFacade> REGEX_CACHE;

    public CaffeineCachingRegexProvider(@NotNull RegexFactory regexFactory) {
        Intrinsics.checkNotNullParameter((Object)regexFactory, (String)"regexFactory");
        this.regexFactory = regexFactory;
        Cache cache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.MINUTES).removalListener((RemovalListener)REGEX_CACHE.1.INSTANCE).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getDefault())).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.REGEX_CACHE = cache;
    }

    public <T> T withRegex(@NotNull CharSequence pattern, @NotNull Function1<? super RegexFacade, ? extends T> body) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Object object = this.REGEX_CACHE.get((Object)pattern, arg_0 -> CaffeineCachingRegexProvider.withRegex$lambda$1(arg_0 -> CaffeineCachingRegexProvider.withRegex$lambda$0(this, pattern, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (T)body.invoke(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withString(@NotNull CharSequence string, @NotNull Function1<? super TextMateString, ? extends T> body) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        AutoCloseable autoCloseable = (AutoCloseable)this.regexFactory.string(string);
        Throwable throwable = null;
        try {
            object = body.invoke((Object)autoCloseable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (T)object;
    }

    private static final RegexFacade withRegex$lambda$0(CaffeineCachingRegexProvider this$0, CharSequence $pattern, CharSequence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.regexFactory.regex($pattern);
    }

    private static final RegexFacade withRegex$lambda$1(Function1 $tmp0, Object p0) {
        return (RegexFacade)$tmp0.invoke(p0);
    }
}

