/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.core.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.liquibase.core.msg.LiquibaseResourceBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JV\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2.\u0010\u0010\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0012`\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/liquibase/core/inspection/DuplicateChangesetIdAndAuthorInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "getGroupDisplayName", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "processChangeSets", "", "rootTag", "Lcom/intellij/psi/xml/XmlTag;", "changeSetIdsAndAuthors", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "visited", "", "hasTheSameDbms", "tag", "tags", "", "intellij.liquibase.core"})
@SourceDebugExtension(value={"SMAP\nDuplicateChangesetIdAndAuthorInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateChangesetIdAndAuthorInspection.kt\ncom/intellij/liquibase/core/inspection/DuplicateChangesetIdAndAuthorInspection\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n383#2,7:80\n1#3:87\n1586#4:88\n1661#4,3:89\n1586#4:92\n1661#4,3:93\n*S KotlinDebug\n*F\n+ 1 DuplicateChangesetIdAndAuthorInspection.kt\ncom/intellij/liquibase/core/inspection/DuplicateChangesetIdAndAuthorInspection\n*L\n44#1:80,7\n70#1:88\n70#1:89,3\n73#1:92\n73#1:93,3\n*E\n"})
public final class DuplicateChangesetIdAndAuthorInspection
extends LocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = LiquibaseResourceBundle.message("inspection.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ DuplicateChangesetIdAndAuthorInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitFile(PsiFile psiFile) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                if (psiFile instanceof XmlFile) {
                    HashMap<K, V> changeSetIdsAndAuthors = new HashMap<K, V>();
                    XmlTag rootTag = ((XmlFile)psiFile).getRootTag();
                    if (rootTag != null) {
                        DuplicateChangesetIdAndAuthorInspection.access$processChangeSets(this.this$0, rootTag, this.$holder, changeSetIdsAndAuthors, new LinkedHashSet<E>());
                    }
                }
                super.visitFile(psiFile);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void processChangeSets(XmlTag rootTag, ProblemsHolder holder, HashMap<String, List<XmlTag>> changeSetIdsAndAuthors, Set<XmlTag> visited) {
        if (!visited.add(rootTag)) {
            return;
        }
        XmlTag[] xmlTagArray = rootTag.findSubTags("changeSet");
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"findSubTags(...)");
        for (XmlTag changeSetTag : xmlTagArray) {
            TextRange authorChangeRange;
            TextRange idTextRange;
            Object object;
            void $this$getOrPut$iv;
            XmlAttribute idAttribute = changeSetTag.getAttribute("id");
            XmlAttribute authorAttribute = changeSetTag.getAttribute("author");
            if (idAttribute == null || authorAttribute == null) continue;
            String changeSetId = idAttribute.getValue();
            String changeSetAuthor = authorAttribute.getValue();
            CharSequence charSequence = changeSetId;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)changeSetAuthor) == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            String pair = changeSetId + changeSetAuthor;
            Map map = changeSetIdsAndAuthors;
            String key$iv = pair;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List tags = (List)object;
            Intrinsics.checkNotNull((Object)changeSetTag);
            tags.add(changeSetTag);
            if (tags.size() <= 1 || !this.hasTheSameDbms(changeSetTag, tags)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)idAttribute.getValueTextRange().shiftRight(3), (String)"shiftRight(...)");
            holder.registerProblem((PsiElement)idAttribute, idTextRange, LiquibaseResourceBundle.message("inspection.DuplicateChangeSetIdInspection", new Object[0]), new LocalQuickFix[0]);
            Intrinsics.checkNotNullExpressionValue((Object)authorAttribute.getValueTextRange().shiftRight(7), (String)"shiftRight(...)");
            holder.registerProblem((PsiElement)authorAttribute, authorChangeRange, LiquibaseResourceBundle.message("inspection.DuplicateChangeSetIdInspection", new Object[0]), new LocalQuickFix[0]);
        }
        XmlTag[] xmlTagArray2 = rootTag.getSubTags();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray2, (String)"getSubTags(...)");
        for (XmlTag subTag : xmlTagArray2) {
            Intrinsics.checkNotNull((Object)subTag);
            this.processChangeSets(subTag, holder, changeSetIdsAndAuthors, visited);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasTheSameDbms(XmlTag tag, List<? extends XmlTag> tags) {
        Collection collection;
        Object object;
        XmlAttribute xmlAttribute = tag.getAttribute("dbms");
        Object object2 = xmlAttribute;
        if (xmlAttribute == null) return true;
        String string = object2.getValue();
        object2 = string;
        if (string == null) return true;
        Object object3 = object = object2;
        boolean bl = false;
        if (((CharSequence)object3).length() <= 0) return true;
        boolean bl2 = true;
        if (!bl2) return true;
        Object object2 = object;
        object2 = object2;
        if (object4 == null) return true;
        String[] stringArray = new String[]{","};
        List list = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        object2 = list;
        if (list == null) return true;
        Iterable $this$map$iv = (Iterable)object2;
        boolean bl3 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : iterable) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        List tagDbms = (List)destination$iv$iv;
        Iterator<? extends XmlTag> iterator = tags.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Object object5;
            XmlTag xmlTag = iterator.next();
            if (Intrinsics.areEqual((Object)tag, (Object)xmlTag)) continue;
            XmlAttribute xmlAttribute2 = xmlTag.getAttribute("dbms");
            Object object6 = xmlAttribute2;
            if (xmlAttribute2 == null) return true;
            String string3 = object6.getValue();
            object6 = string3;
            if (string3 == null) return true;
            Object object7 = object5 = object6;
            boolean bl5 = false;
            if (((CharSequence)object7).length() <= 0) return true;
            boolean bl6 = true;
            if (!bl6) return true;
            Object object6 = object5;
            object6 = object6;
            if (object8 == null) return true;
            String[] stringArray2 = new String[]{","};
            List list2 = StringsKt.split$default((CharSequence)((CharSequence)object6), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            object6 = list2;
            if (list2 == null) return true;
            Iterable $this$map$iv2 = (Iterable)object6;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string4 = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl7 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List xmlDbms = (List)destination$iv$iv2;
            if (!((Collection)CollectionsKt.intersect((Iterable)tagDbms, (Iterable)xmlDbms)).isEmpty()) {
                return true;
            }
            boolean bl8 = false;
            if (bl8) return true;
        }
        return false;
    }

    public static final /* synthetic */ void access$processChangeSets(DuplicateChangesetIdAndAuthorInspection $this, XmlTag rootTag, ProblemsHolder holder, HashMap changeSetIdsAndAuthors, Set visited) {
        $this.processChangeSets(rootTag, holder, changeSetIdsAndAuthors, visited);
    }
}

