/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.FragmentedSettings;
import com.intellij.execution.ui.FragmentedSettingsBuilder;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class NestedGroupFragment<S extends FragmentedSettings>
extends SettingsEditorFragment<S, JComponent> {
    private final NotNullLazyValue<List<SettingsEditorFragment<S, ?>>> myChildren = NotNullLazyValue.createValue(() -> {
        List<SettingsEditorFragment<S, ?>> children = this.createChildren();
        for (SettingsEditorFragment<S, ?> child : children) {
            Disposer.register((Disposable)this, child);
            child.addSettingsEditorListener(editor -> {
                if (child.isSelected()) {
                    this.setSelected(true);
                }
                this.updateVisibility();
                this.fireEditorStateChanged();
            });
        }
        return children;
    });
    private JComponent myGroupComponent;

    protected NestedGroupFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, Predicate<? super S> initialSelection) {
        super(id, name, group, null, null, null, initialSelection);
    }

    @Override
    public final List<SettingsEditorFragment<S, ?>> getChildren() {
        return (List)this.myChildren.getValue();
    }

    @Override
    public String getChildrenGroupName() {
        return this.getName();
    }

    @Override
    public void setSelected(boolean selected2) {
        super.setSelected(selected2);
        this.updateVisibility();
    }

    @Override
    public boolean isSelected() {
        return ContainerUtil.exists(this.getChildren(), fragment -> fragment.isSelected());
    }

    @Override
    public boolean isInitiallyVisible(S s) {
        return super.isInitiallyVisible(s) || ContainerUtil.exists(this.getChildren(), fragment -> fragment.isInitiallyVisible(s));
    }

    @Override
    @ApiStatus.Internal
    public boolean isAvailable() {
        return super.isAvailable() && ContainerUtil.exists(this.getChildren(), SettingsEditorFragment::isAvailable);
    }

    private void updateVisibility() {
        this.myGroupComponent.setVisible(this.isSelected());
    }

    @Override
    protected void resetEditorFrom(@NotNull S s) {
        if (s == null) {
            NestedGroupFragment.$$$reportNull$$$0(0);
        }
        for (SettingsEditorFragment<S, ?> child : this.getChildren()) {
            child.resetEditorFrom(s);
        }
        this.updateVisibility();
    }

    @Override
    protected void applyEditorTo(@NotNull S s) {
        if (s == null) {
            NestedGroupFragment.$$$reportNull$$$0(1);
        }
        for (SettingsEditorFragment<S, ?> child : this.getChildren()) {
            child.applyEditorTo(s);
        }
    }

    protected abstract List<SettingsEditorFragment<S, ?>> createChildren();

    @NotNull
    protected FragmentedSettingsBuilder<S> getBuilder() {
        return new FragmentedSettingsBuilder<S>(this.getChildren(), this, (Disposable)this);
    }

    @Override
    @NotNull
    protected JComponent createEditor() {
        FragmentedSettingsBuilder<S> builder = this.getBuilder();
        this.myGroupComponent = builder.createCompoundEditor();
        if (this.myComponent == null) {
            this.myComponent = this.myGroupComponent;
        }
        this.updateVisibility();
        JComponent jComponent = this.myGroupComponent;
        if (jComponent == null) {
            NestedGroupFragment.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/NestedGroupFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/NestedGroupFragment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

