/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.ClientProperty;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MnemonicWrapper<T extends JComponent>
implements Runnable,
PropertyChangeListener {
    @NotNull
    final T myComponent;
    private final String myTextProperty;
    private final String myCodeProperty;
    private final String myIndexProperty;
    private TextWithMnemonic myTextWithMnemonic;
    private boolean myFocusable;
    private boolean myEvent;
    private boolean myMnemonicChanged;
    private boolean myRunScheduled;

    public static MnemonicWrapper<?> getWrapper(Component component) {
        if (component == null || ClientProperty.isTrue((Component)component, MnemonicHelper.DISABLE_MNEMONIC_PROCESSING)) {
            return null;
        }
        for (PropertyChangeListener listener2 : component.getPropertyChangeListeners()) {
            if (!(listener2 instanceof MnemonicWrapper)) continue;
            MnemonicWrapper wrapper = (MnemonicWrapper)listener2;
            wrapper.run();
            return wrapper;
        }
        if (component instanceof JMenuItem) {
            return new MenuWrapper((AbstractButton)component);
        }
        if (component instanceof AbstractButton) {
            return new ButtonWrapper((AbstractButton)component);
        }
        if (component instanceof JLabel) {
            return new LabelWrapper((JLabel)component);
        }
        return null;
    }

    private MnemonicWrapper(@NotNull T component, String text, String code, String index) {
        if (component == null) {
            MnemonicWrapper.$$$reportNull$$$0(0);
        }
        this.myComponent = component;
        this.myTextProperty = text;
        this.myCodeProperty = code;
        this.myIndexProperty = index;
        this.myFocusable = this.isFocusable();
        ((Container)this.myComponent).addPropertyChangeListener(this);
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean disabled = !LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() || UISettings.getShadowInstance().getDisableMnemonicsInControls();
        try {
            Component component;
            int index;
            InputMap map;
            int code;
            this.myEvent = true;
            if (this.myTextWithMnemonic == null) {
                this.myTextWithMnemonic = this.createTextWithMnemonic();
            } else if (this.myMnemonicChanged) {
                try {
                    this.myTextWithMnemonic = this.myTextWithMnemonic.withMnemonicIndex(this.getMnemonicIndex());
                }
                catch (IndexOutOfBoundsException cause) {
                    this.myTextWithMnemonic = this.myTextWithMnemonic.withMnemonicIndex(-1);
                    String message = "cannot change mnemonic index " + String.valueOf(this.myComponent);
                    Logger.getInstance(MnemonicWrapper.class).warn(message, (Throwable)cause);
                }
            }
            String text = this.myTextWithMnemonic.getText(!disabled);
            if (!text.equals(Strings.notNullize((String)this.getText()))) {
                this.setText(text);
            }
            int n = code = disabled ? 0 : this.myTextWithMnemonic.getMnemonicCode();
            if (code != this.getMnemonicCode()) {
                this.setMnemonicCode(code);
            }
            if (SystemInfo.isMac && Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl", (boolean)true) && (map = ((JComponent)this.myComponent).getInputMap(2)) != null) {
                this.updateInputMap(map, code);
            }
            int n2 = index = disabled ? -1 : this.myTextWithMnemonic.getMnemonicIndex();
            if (index != this.getMnemonicIndex()) {
                try {
                    this.setMnemonicIndex(index);
                }
                catch (IllegalArgumentException cause) {
                    StringBuilder sb = new StringBuilder("cannot set mnemonic index ");
                    if (this.myMnemonicChanged) {
                        sb.append("if mnemonic changed ");
                    }
                    String message = sb.append(this.myComponent).toString();
                    Logger.getInstance(MnemonicWrapper.class).warn(message, (Throwable)cause);
                }
            }
            if ((component = this.getFocusableComponent()) != null) {
                component.setFocusable(disabled || this.myFocusable);
            }
        }
        finally {
            this.myEvent = false;
            this.myMnemonicChanged = false;
            this.myRunScheduled = false;
        }
    }

    @Override
    public final void propertyChange(PropertyChangeEvent event) {
        if (!this.myEvent && this.myTextWithMnemonic != null) {
            String property = event.getPropertyName();
            if (this.myTextProperty.equals(property)) {
                this.myTextWithMnemonic = null;
                this.updateRequest();
            } else if (this.myCodeProperty.equals(property)) {
                this.myMnemonicChanged = true;
                this.updateRequest();
            } else if (this.myIndexProperty.equals(property)) {
                this.myMnemonicChanged = true;
                this.updateRequest();
            } else if ("focusable".equals(property) || "labelFor".equals(property)) {
                this.myFocusable = this.isFocusable();
                this.updateRequest();
            }
        }
    }

    private TextWithMnemonic createTextWithMnemonic() {
        String text = this.getText();
        if (Strings.isEmpty((String)text)) {
            return TextWithMnemonic.EMPTY;
        }
        TextWithMnemonic mnemonic = TextWithMnemonic.fromMnemonicText((String)text, (boolean)false);
        if (mnemonic != null) {
            return mnemonic;
        }
        int index = this.getMnemonicIndex();
        return 0 <= index && index < text.length() ? TextWithMnemonic.fromPlainTextWithIndex((String)text, (int)index) : TextWithMnemonic.fromPlainText((String)text, (char)((char)this.getMnemonicCode()));
    }

    private void updateRequest() {
        if (!this.myRunScheduled) {
            this.myRunScheduled = true;
            SwingUtilities.invokeLater(this);
        }
    }

    private boolean isFocusable() {
        Component component = this.getFocusableComponent();
        return component == null || component.isFocusable();
    }

    @Nullable
    Component getFocusableComponent() {
        return this.myComponent;
    }

    @Nls
    abstract String getText();

    abstract void setText(@Nls String var1);

    abstract int getMnemonicCode();

    abstract void setMnemonicCode(int var1);

    abstract int getMnemonicIndex();

    abstract void setMnemonicIndex(int var1);

    abstract void updateInputMap(InputMap var1, int var2);

    static KeyStroke fixMacKeyStroke(KeyStroke stroke, InputMap map, int code, boolean onKeyRelease, String action) {
        if (stroke != null && code != stroke.getKeyCode()) {
            map.remove(stroke);
            stroke = null;
        }
        if (stroke == null && code != 0) {
            stroke = KeyStroke.getKeyStroke(code, 512, onKeyRelease);
            map.put(stroke, action);
        }
        return stroke;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/MnemonicWrapper", "<init>"));
    }

    private static final class MenuWrapper
    extends AbstractButtonWrapper {
        private KeyStroke myStrokePressed;

        private MenuWrapper(@NotNull AbstractButton component) {
            if (component == null) {
                MenuWrapper.$$$reportNull$$$0(0);
            }
            super(component);
        }

        @Override
        void updateInputMap(InputMap map, int code) {
            this.myStrokePressed = MenuWrapper.fixMacKeyStroke(this.myStrokePressed, map, code, false, "selectMenu");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/MnemonicWrapper$MenuWrapper", "<init>"));
        }
    }

    private static final class ButtonWrapper
    extends AbstractButtonWrapper {
        private KeyStroke myStrokePressed;
        private KeyStroke myStrokeReleased;

        private ButtonWrapper(@NotNull AbstractButton component) {
            if (component == null) {
                ButtonWrapper.$$$reportNull$$$0(0);
            }
            super(component);
        }

        @Override
        void updateInputMap(InputMap map, int code) {
            this.myStrokePressed = ButtonWrapper.fixMacKeyStroke(this.myStrokePressed, map, code, false, "pressed");
            this.myStrokeReleased = ButtonWrapper.fixMacKeyStroke(this.myStrokeReleased, map, code, true, "released");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/MnemonicWrapper$ButtonWrapper", "<init>"));
        }
    }

    private static final class LabelWrapper
    extends MnemonicWrapper<JLabel> {
        private KeyStroke myStrokePress;
        private KeyStroke myStrokeRelease;

        private LabelWrapper(@NotNull JLabel component) {
            if (component == null) {
                LabelWrapper.$$$reportNull$$$0(0);
            }
            super(component, "text", "displayedMnemonic", "displayedMnemonicIndex");
        }

        @Override
        void updateInputMap(InputMap map, int code) {
            this.myStrokePress = LabelWrapper.fixMacKeyStroke(this.myStrokePress, map, code, false, "press");
            this.myStrokeRelease = LabelWrapper.fixMacKeyStroke(this.myStrokeRelease, map, code, true, "release");
        }

        @Override
        String getText() {
            return ((JLabel)this.myComponent).getText();
        }

        @Override
        void setText(String text) {
            ((JLabel)this.myComponent).setText(text);
        }

        @Override
        int getMnemonicCode() {
            return ((JLabel)this.myComponent).getDisplayedMnemonic();
        }

        @Override
        void setMnemonicCode(int code) {
            ((JLabel)this.myComponent).setDisplayedMnemonic(code);
        }

        @Override
        int getMnemonicIndex() {
            return ((JLabel)this.myComponent).getDisplayedMnemonicIndex();
        }

        @Override
        void setMnemonicIndex(int index) {
            ((JLabel)this.myComponent).setDisplayedMnemonicIndex(index);
        }

        @Override
        @Nullable
        Component getFocusableComponent() {
            return ((JLabel)this.myComponent).getLabelFor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/MnemonicWrapper$LabelWrapper", "<init>"));
        }
    }

    private static abstract class AbstractButtonWrapper
    extends MnemonicWrapper<AbstractButton> {
        private AbstractButtonWrapper(@NotNull AbstractButton component) {
            if (component == null) {
                AbstractButtonWrapper.$$$reportNull$$$0(0);
            }
            super(component, "text", "mnemonic", "displayedMnemonicIndex");
        }

        @Override
        String getText() {
            return ((AbstractButton)this.myComponent).getText();
        }

        @Override
        void setText(String text) {
            ((AbstractButton)this.myComponent).setText(text);
        }

        @Override
        int getMnemonicCode() {
            return ((AbstractButton)this.myComponent).getMnemonic();
        }

        @Override
        void setMnemonicCode(int code) {
            ((AbstractButton)this.myComponent).setMnemonic(code);
        }

        @Override
        int getMnemonicIndex() {
            return ((AbstractButton)this.myComponent).getDisplayedMnemonicIndex();
        }

        @Override
        void setMnemonicIndex(int index) {
            ((AbstractButton)this.myComponent).setDisplayedMnemonicIndex(index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/MnemonicWrapper$AbstractButtonWrapper", "<init>"));
        }
    }
}

