/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.StringJoiner;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public final class MacKeymapUtil {
    public static final String ESCAPE = "\u238b";
    public static final String TAB = "\u21e5";
    public static final String TAB_BACK = "\u21e4";
    public static final String CAPS_LOCK = "\u21ea";
    public static final String SHIFT = "\u21e7";
    public static final String CONTROL = "\u2303";
    public static final String OPTION = "\u2325";
    public static final String APPLE = "\uf8ff";
    public static final String COMMAND = "\u2318";
    public static final String SPACE = "\u2423";
    public static final String RETURN = "\u23ce";
    public static final String BACKSPACE = "\u232b";
    public static final String DELETE = "\u2326";
    public static final String HOME = "\u2196";
    public static final String END = "\u2198";
    public static final String PAGE_UP = "\u21de";
    public static final String PAGE_DOWN = "\u21df";
    public static final String UP = "\u2191";
    public static final String DOWN = "\u2193";
    public static final String LEFT = "\u2190";
    public static final String RIGHT = "\u2192";
    public static final String CLEAR = "\u2327";
    public static final String NUMBER_LOCK = "\u21ed";
    public static final String ENTER = "\u2324";
    public static final String EJECT = "\u23cf";
    public static final String POWER3 = "\u233d";
    public static final String NUM_PAD = "\u2328";

    @NotNull
    public static String getModifiersText(@JdkConstants.InputEventMask int modifiers, String delimiter) {
        StringJoiner buf = new StringJoiner(delimiter != null ? delimiter : "");
        if ((modifiers & 2) != 0) {
            buf.add(MacKeymapUtil.get(CONTROL, "Ctrl+"));
        }
        if ((modifiers & 8) != 0) {
            buf.add(MacKeymapUtil.get(OPTION, "Alt+"));
        }
        if ((modifiers & 1) != 0) {
            buf.add(MacKeymapUtil.get(SHIFT, "Shift+"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.add(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.add(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        if ((modifiers & 4) != 0) {
            buf.add(MacKeymapUtil.get(COMMAND, "Cmd+"));
        }
        String string = buf.toString();
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    static String getModifiersText(@JdkConstants.InputEventMask int modifiers) {
        return MacKeymapUtil.getModifiersText(modifiers, null);
    }

    @NotNull
    public static String getKeyText(int code) {
        if (!MacKeymapUtil.isNativeShortcutSymbolsDisabled()) {
            Object object = switch (code) {
                case 8 -> MacKeymapUtil.get(BACKSPACE, "Backspace");
                case 27 -> MacKeymapUtil.get(ESCAPE, "Escape");
                case 20 -> MacKeymapUtil.get(CAPS_LOCK, "Caps Lock");
                case 9 -> MacKeymapUtil.get(TAB, "Tab");
                case 32 -> "Space";
                case 127 -> MacKeymapUtil.get(DELETE, "Delete");
                case 36 -> MacKeymapUtil.get(HOME, "Home");
                case 35 -> MacKeymapUtil.get(END, "End");
                case 33 -> MacKeymapUtil.get(PAGE_UP, "Page Up");
                case 34 -> MacKeymapUtil.get(PAGE_DOWN, "Page Down");
                case 38 -> MacKeymapUtil.get(UP, "Up Arrow");
                case 40 -> MacKeymapUtil.get(DOWN, "Down Arrow");
                case 37 -> MacKeymapUtil.get(LEFT, "Left Arrow");
                case 39 -> MacKeymapUtil.get(RIGHT, "Right Arrow");
                case 144 -> MacKeymapUtil.get(NUMBER_LOCK, "Num Lock");
                case 10 -> MacKeymapUtil.get(RETURN, "Return");
                case 520 -> MacKeymapUtil.get(NUM_PAD, "NumPad");
                case 106 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + " *";
                case 45, 109 -> "-";
                case 107, 521 -> "+";
                case 111 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "/";
                case 96 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "0";
                case 97 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "1";
                case 98 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "2";
                case 99 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "3";
                case 100 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "4";
                case 101 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "5";
                case 102 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "6";
                case 103 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "7";
                case 104 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "8";
                case 105 -> MacKeymapUtil.get(NUM_PAD, "NumPad") + "9";
                case 0 -> "fn";
                default -> KeyEvent.getKeyText(code);
            };
            if (object == null) {
                MacKeymapUtil.$$$reportNull$$$0(1);
            }
            return object;
        }
        String string = KeyEvent.getKeyText(code);
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getKeyStrokeText(@NotNull KeyStroke keyStroke, String delimiter, boolean onlyDelimIntoModifiersAndKey) {
        if (keyStroke == null) {
            MacKeymapUtil.$$$reportNull$$$0(3);
        }
        String modifiers = MacKeymapUtil.getModifiersText(keyStroke.getModifiers());
        String key = KeymapUtil.getKeyText(keyStroke.getKeyCode());
        if (!onlyDelimIntoModifiersAndKey) {
            modifiers = MacKeymapUtil.getModifiersText(keyStroke.getModifiers(), delimiter);
        }
        if (delimiter != null) {
            if (modifiers.isEmpty()) {
                String string = key;
                if (string == null) {
                    MacKeymapUtil.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = modifiers + delimiter + key;
            if (string == null) {
                MacKeymapUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = modifiers + key;
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getKeyStrokeText(@NotNull KeyStroke keyStroke) {
        if (keyStroke == null) {
            MacKeymapUtil.$$$reportNull$$$0(7);
        }
        return MacKeymapUtil.getKeyStrokeText(keyStroke, null, true);
    }

    @NotNull
    private static String get(@NotNull String value2, @NotNull String replacement) {
        if (value2 == null) {
            MacKeymapUtil.$$$reportNull$$$0(8);
        }
        if (replacement == null) {
            MacKeymapUtil.$$$reportNull$$$0(9);
        }
        if (MacKeymapUtil.isNativeShortcutSymbolsDisabled()) {
            String string = replacement;
            if (string == null) {
                MacKeymapUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = StartupUiUtil.getLabelFont().canDisplayUpTo(value2) == -1 ? value2 : replacement;
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean isNativeShortcutSymbolsDisabled() {
        return AdvancedSettings.getInstanceIfCreated() != null && AdvancedSettings.getBoolean((String)"ide.macos.disable.native.shortcut.symbols");
    }

    @NotNull
    public static String getKeyModifiersTextForMacOSLeopard(@JdkConstants.InputEventMask int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 4) != 0) {
            buf.append(COMMAND);
        }
        if ((modifiers & 2) != 0) {
            buf.append(Toolkit.getProperty("AWT.control", "Ctrl"));
        }
        if ((modifiers & 8) != 0) {
            buf.append(OPTION);
        }
        if ((modifiers & 1) != 0) {
            buf.append(Toolkit.getProperty("AWT.shift", "Shift"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        String string = buf.toString();
        if (string == null) {
            MacKeymapUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/MacKeymapUtil";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/MacKeymapUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokeText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyModifiersTextForMacOSLeopard";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStrokeText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

