/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageUiEventsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.MacOtherAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientDisposableProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.DialogWrapperPeerFactory;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.ExitActionType;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ToolbarService;
import com.intellij.ui.UIBundle;
import com.intellij.ui.UiInterceptors;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.util.Alarm;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DialogWrapper {
    private static final Logger LOG = Logger.getInstance(DialogWrapper.class);
    private final JPanel myRoot;
    @ApiStatus.Internal
    @NotNull
    public static final String IS_VISUAL_PADDING_COMPENSATED_ON_COMPONENT_LEVEL_KEY = "isVisualPaddingCompensatedOnComponentLevel";
    @ApiStatus.Internal
    @NotNull
    public static final Key<Boolean> KEEP_POPUPS_OPEN = Key.create((String)"KEEP_POPUPS_OPEN");
    public static final int OK_EXIT_CODE = 0;
    public static final int CANCEL_EXIT_CODE = 1;
    public static final int CLOSE_EXIT_CODE = 1;
    public static final int NEXT_USER_EXIT_CODE = 2;
    public static final String DEFAULT_ACTION = "DefaultAction";
    public static final String FOCUSED_ACTION = "FocusedAction";
    public static final String MAC_ACTION_ORDER = "MacActionOrder";
    public static final int DEFAULT_ACTION_ORDER = 100;
    public static final Object DIALOG_CONTENT_PANEL_PROPERTY = new Object();
    @Deprecated
    public static final Color ERROR_FOREGROUND_COLOR = NamedColorUtil.getErrorForeground();
    private static final String NO_AUTO_RESIZE = "NoAutoResizeAndFit";
    @NotNull
    protected final Disposable myDisposable;
    @NotNull
    private final DialogWrapperPeer myPeer;
    private final Map<Action, JButton> myButtonMap;
    private final boolean myCreateSouthSection;
    private final List<JBOptionButton> optionButtons;
    private final Alarm myValidationAlarm;
    private boolean myClosed;
    private boolean myDisposed;
    private int myExitCode;
    private float myHorizontalStretch;
    private float myVerticalStretch;
    private int myButtonAlignment;
    private boolean myCrossClosesWindow;
    private JComponent myPreferredFocusedComponentFromPanel;
    private Computable<? extends Point> myInitialLocationCallback;
    private final Rectangle myUserBounds;
    private boolean myUserLocationSet;
    private boolean myUserSizeSet;
    private Dimension myActualSize;
    private List<ValidationInfo> myInfo;
    @Nullable
    private com.intellij.openapi.ui.DoNotAskOption myDoNotAsk;
    private Action myYesAction;
    private Action myNoAction;
    private int myCurrentOptionsButtonIndex;
    private boolean myResizeInProgress;
    private ComponentAdapter myResizeListener;
    private DialogPanel myDialogPanel;
    private ErrorText myErrorText;
    private int myValidationDelay;
    private boolean myValidationStarted;
    private boolean myKeepPopupsOpen;
    @NonNls
    @Nullable
    private String invocationPlace;
    private boolean useWriteIntentReadAction;
    protected Action myOKAction;
    protected Action myCancelAction;
    protected Action myHelpAction;
    protected boolean myPerformAction;
    protected JCheckBox myCheckBoxDoNotShowDialog;
    protected JComponent myPreferredFocusedComponent;
    private static final JBValue BASE_BUTTON_GAP = new JBValue.Float(12.0f);
    private final PropertyChangeListener myRepaintOnNameChangeListener;

    @NotNull
    public static Border createDefaultBorder() {
        return new JBEmptyBorder((Insets)UIUtil.getRegularPanelInsets());
    }

    protected DialogWrapper(@Nullable Project project, boolean canBeParent) {
        this(project, canBeParent, IdeModalityType.IDE);
    }

    protected DialogWrapper(@Nullable Project project, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(0);
        }
        this(project, null, canBeParent, ideModalityType);
    }

    protected DialogWrapper(@Nullable Project project, @Nullable Component parentComponent, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(1);
        }
        this(project, parentComponent, canBeParent, ideModalityType, true);
    }

    protected DialogWrapper(@Nullable Project project, @Nullable Component parentComponent, boolean canBeParent, @NotNull IdeModalityType ideModalityType, boolean createSouth) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(2);
        }
        this(project, parentComponent, canBeParent, ideModalityType, createSouth, true);
    }

    protected DialogWrapper(@Nullable Project project, @Nullable Component parentComponent, boolean canBeParent, @NotNull IdeModalityType ideModalityType, boolean createSouth, boolean createTitleBar) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(3);
        }
        this.myRoot = new JPanel();
        this.myDisposable = new Disposable(){

            @NonNls
            public String toString() {
                return DialogWrapper.this.toString();
            }

            public void dispose() {
                DialogWrapper.this.dispose();
            }
        };
        this.myButtonMap = new LinkedHashMap<Action, JButton>();
        this.optionButtons = new ArrayList<JBOptionButton>();
        this.myValidationAlarm = new Alarm(this.getContinuousValidationThreadToUse(), this.myDisposable);
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myUserBounds = new Rectangle();
        this.myInfo = List.of();
        this.myCurrentOptionsButtonIndex = -1;
        this.myValidationDelay = 300;
        this.invocationPlace = null;
        this.useWriteIntentReadAction = true;
        this.myRepaintOnNameChangeListener = evt -> {
            if ("Name".equals(evt.getPropertyName())) {
                this.repaint();
            }
        };
        ThreadingAssertions.assertEventDispatchThread();
        this.myPeer = parentComponent == null ? this.createPeer(project, canBeParent, project == null ? IdeModalityType.IDE : ideModalityType) : this.createPeer(parentComponent, canBeParent);
        this.myCreateSouthSection = createSouth;
        this.initResizeListener();
        this.createDefaultActions();
        if (createTitleBar && this.myPeer.getWindow() != null && LoadingState.COMPONENTS_LOADED.isOccurred()) {
            ToolbarService.Companion.getInstance().setTransparentTitleBar(this.myPeer.getWindow(), this.myPeer.getRootPane(), (Function1<? super Runnable, Unit>)((Function1)runnable -> {
                Disposer.register((Disposable)this.myDisposable, () -> runnable.run());
                return Unit.INSTANCE;
            }));
        }
    }

    protected final void initResizeListener() {
        Window window = this.myPeer.getWindow();
        if (window == null) {
            return;
        }
        this.myResizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (!DialogWrapper.this.myResizeInProgress) {
                    DialogWrapper.this.myActualSize = DialogWrapper.this.myPeer.getSize();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Updated the actual size to " + String.valueOf(DialogWrapper.this.myActualSize) + " because the dialog has been resized");
                    }
                    if (DialogWrapper.this.myErrorText != null && DialogWrapper.this.myErrorText.isVisible()) {
                        DialogWrapper.this.myActualSize.height -= DialogWrapper.this.myErrorText.getMinimumSize().height;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Adjusted the actual size to " + String.valueOf(DialogWrapper.this.myActualSize) + " to account for the minimum height of the error text");
                        }
                    }
                }
            }
        };
        window.addComponentListener(this.myResizeListener);
        Disposer.register((Disposable)this.myDisposable, this::disposeResizeListener);
    }

    private void disposeResizeListener() {
        Window window = this.getWindow();
        if (window != null && this.myResizeListener != null) {
            window.removeComponentListener(this.myResizeListener);
            this.myResizeListener = null;
        }
    }

    protected DialogWrapper(@Nullable Project project) {
        this(project, true);
    }

    protected DialogWrapper(boolean canBeParent) {
        this((Project)null, canBeParent);
    }

    @Deprecated
    protected DialogWrapper(boolean canBeParent, boolean applicationModalIfPossible) {
        this(null, canBeParent, applicationModalIfPossible);
    }

    protected DialogWrapper(Project project, boolean canBeParent, boolean applicationModalIfPossible) {
        this.myRoot = new JPanel();
        this.myDisposable = new /* invalid duplicate definition of identical inner class */;
        this.myButtonMap = new LinkedHashMap<Action, JButton>();
        this.optionButtons = new ArrayList<JBOptionButton>();
        this.myValidationAlarm = new Alarm(this.getContinuousValidationThreadToUse(), this.myDisposable);
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myUserBounds = new Rectangle();
        this.myInfo = List.of();
        this.myCurrentOptionsButtonIndex = -1;
        this.myValidationDelay = 300;
        this.invocationPlace = null;
        this.useWriteIntentReadAction = true;
        this.myRepaintOnNameChangeListener = evt -> {
            if ("Name".equals(evt.getPropertyName())) {
                this.repaint();
            }
        };
        DialogWrapper.ensureEventDispatchThread();
        Window owner2 = null;
        if (ApplicationManager.getApplication() != null) {
            owner2 = project != null ? WindowManager.getInstance().suggestParentWindow(project) : WindowManager.getInstance().findVisibleFrame();
        }
        this.myPeer = this.createPeer(owner2, canBeParent, applicationModalIfPossible);
        this.myCreateSouthSection = true;
        this.createDefaultActions();
    }

    protected DialogWrapper(@NotNull Component parent, boolean canBeParent) {
        if (parent == null) {
            DialogWrapper.$$$reportNull$$$0(4);
        }
        this.myRoot = new JPanel();
        this.myDisposable = new /* invalid duplicate definition of identical inner class */;
        this.myButtonMap = new LinkedHashMap<Action, JButton>();
        this.optionButtons = new ArrayList<JBOptionButton>();
        this.myValidationAlarm = new Alarm(this.getContinuousValidationThreadToUse(), this.myDisposable);
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myUserBounds = new Rectangle();
        this.myInfo = List.of();
        this.myCurrentOptionsButtonIndex = -1;
        this.myValidationDelay = 300;
        this.invocationPlace = null;
        this.useWriteIntentReadAction = true;
        this.myRepaintOnNameChangeListener = evt -> {
            if ("Name".equals(evt.getPropertyName())) {
                this.repaint();
            }
        };
        DialogWrapper.ensureEventDispatchThread();
        this.myCreateSouthSection = true;
        this.myPeer = this.createPeer(parent, canBeParent);
        this.createDefaultActions();
    }

    protected DialogWrapper(@NotNull Function<? super DialogWrapper, ? extends DialogWrapperPeer> peerFactory) {
        if (peerFactory == null) {
            DialogWrapper.$$$reportNull$$$0(5);
        }
        this.myRoot = new JPanel();
        this.myDisposable = new /* invalid duplicate definition of identical inner class */;
        this.myButtonMap = new LinkedHashMap<Action, JButton>();
        this.optionButtons = new ArrayList<JBOptionButton>();
        this.myValidationAlarm = new Alarm(this.getContinuousValidationThreadToUse(), this.myDisposable);
        this.myExitCode = 1;
        this.myHorizontalStretch = 1.0f;
        this.myVerticalStretch = 1.0f;
        this.myButtonAlignment = 4;
        this.myCrossClosesWindow = true;
        this.myUserBounds = new Rectangle();
        this.myInfo = List.of();
        this.myCurrentOptionsButtonIndex = -1;
        this.myValidationDelay = 300;
        this.invocationPlace = null;
        this.useWriteIntentReadAction = true;
        this.myRepaintOnNameChangeListener = evt -> {
            if ("Name".equals(evt.getPropertyName())) {
                this.repaint();
            }
        };
        this.myPeer = peerFactory.apply(this);
        this.myCreateSouthSection = false;
        this.createDefaultActions();
    }

    @NlsContexts.Checkbox
    @NotNull
    protected String getDoNotShowMessage() {
        String string = UIBundle.message("dialog.options.do.not.show", new Object[0]);
        if (string == null) {
            DialogWrapper.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setDoNotAskOption(@Nullable com.intellij.openapi.ui.DoNotAskOption doNotAsk) {
        this.myDoNotAsk = doNotAsk;
    }

    @Deprecated(forRemoval=true)
    public void setDoNotAskOption(@Nullable DoNotAskOption doNotAsk) {
        this.myDoNotAsk = doNotAsk;
    }

    @NotNull
    protected Alarm.ThreadToUse getContinuousValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.SWING_THREAD;
        if (threadToUse == null) {
            DialogWrapper.$$$reportNull$$$0(7);
        }
        return threadToUse;
    }

    protected boolean postponeValidation() {
        return true;
    }

    protected boolean continuousValidation() {
        return this.myDialogPanel == null;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return null;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        DialogPanel dialogPanel;
        ArrayList<ValidationInfo> result2 = new ArrayList<ValidationInfo>();
        ValidationInfo vi = this.doValidate();
        if (vi != null) {
            result2.add(vi);
        }
        if ((dialogPanel = this.myDialogPanel) != null) {
            result2.addAll(dialogPanel.validateAll());
        }
        ArrayList<ValidationInfo> arrayList = result2;
        if (arrayList == null) {
            DialogWrapper.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public void setValidationDelay(int delay) {
        this.myValidationDelay = delay;
    }

    protected void updateErrorInfo(@NotNull List<ValidationInfo> info) {
        if (info == null) {
            DialogWrapper.$$$reportNull$$$0(9);
        }
        if (!this.myInfo.equals(info)) {
            SwingUtilities.invokeLater(() -> {
                if (this.myDisposed) {
                    return;
                }
                this.setErrorInfoAll(info);
                this.getOKAction().setEnabled(ContainerUtil.all((Collection)info, info1 -> info1.okEnabled));
            });
        }
    }

    protected void createDefaultActions() {
        this.myOKAction = new OkAction();
        this.myCancelAction = new CancelAction();
        this.myHelpAction = new HelpAction(this::doHelpAction);
    }

    public void setUndecorated(boolean undecorated) {
        this.myPeer.setUndecorated(undecorated);
    }

    public final void addMouseListener(@NotNull MouseListener listener2) {
        if (listener2 == null) {
            DialogWrapper.$$$reportNull$$$0(10);
        }
        this.myPeer.addMouseListener(listener2);
    }

    public final void addMouseListener(@NotNull MouseMotionListener listener2) {
        if (listener2 == null) {
            DialogWrapper.$$$reportNull$$$0(11);
        }
        this.myPeer.addMouseListener(listener2);
    }

    public final void addKeyListener(@NotNull KeyListener listener2) {
        if (listener2 == null) {
            DialogWrapper.$$$reportNull$$$0(12);
        }
        this.myPeer.addKeyListener(listener2);
    }

    public final void close(int exitCode, boolean isOk, ExitActionType exitActionType) {
        this.logCloseDialogEvent(exitCode, exitActionType);
        DialogWrapper.ensureEventDispatchThread();
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        this.myExitCode = exitCode;
        this.disposeResizeListener();
        if (isOk) {
            this.processDoNotAskOnOk(exitCode);
        } else {
            this.processDoNotAskOnCancel();
        }
        if (LoadingState.COMPONENTS_LOADED.isOccurred() && this.useWriteIntentReadAction) {
            WriteIntentReadAction.run(() -> Disposer.dispose((Disposable)this.myDisposable));
        } else {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    public final void close(int exitCode, boolean isOk) {
        this.close(exitCode, isOk, ExitActionType.UNDEFINED);
    }

    public final void close(int exitCode, ExitActionType exitActionType) {
        this.close(exitCode, exitCode != 1, exitActionType);
    }

    public final void close(int exitCode) {
        this.close(exitCode, exitCode != 1, ExitActionType.UNDEFINED);
    }

    @Nullable
    protected Border createContentPaneBorder() {
        if (this.getStyle() == DialogStyle.COMPACT) {
            if (SystemInfoRt.isWindows && SystemInfo.isJetBrainsJvm) {
                return JBUI.Borders.customLineTop((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
            }
            return JBUI.Borders.empty();
        }
        return DialogWrapper.createDefaultBorder();
    }

    protected static boolean isMoveHelpButtonLeft() {
        return true;
    }

    private static boolean isRemoveHelpButton() {
        return !ApplicationInfo.contextHelpAvailable() || Registry.is((String)"ide.remove.help.button.from.dialogs", (boolean)false);
    }

    protected JComponent createSouthPanel() {
        ArrayList<Action> actions = new ArrayList(ContainerUtil.filter((Object[])this.createActions(), (Condition)Conditions.notNull()));
        List<Object> leftSideActions = new ArrayList(ContainerUtil.filter((Object[])this.createLeftSideActions(), (Condition)Conditions.notNull()));
        Action helpAction = this.getHelpAction();
        boolean addHelpToLeftSide = false;
        if (DialogWrapper.isRemoveHelpButton()) {
            actions.remove(helpAction);
        } else if (!actions.contains(helpAction) && this.getHelpId() == null) {
            helpAction.setEnabled(false);
        } else if (DialogWrapper.isMoveHelpButtonLeft() && actions.remove(helpAction) && !leftSideActions.contains(helpAction)) {
            addHelpToLeftSide = true;
        }
        if (!Registry.is((String)"ide.allow.merge.buttons", (boolean)true)) {
            actions = DialogWrapper.flattenOptionsActions(actions);
            leftSideActions = DialogWrapper.flattenOptionsActions(leftSideActions);
        }
        if (SystemInfoRt.isMac) {
            Action macOtherAction = (Action)ContainerUtil.find(actions, MacOtherAction.class::isInstance);
            if (macOtherAction != null) {
                leftSideActions.add(macOtherAction);
                actions.remove(macOtherAction);
            }
            this.sortActionsOnMac(actions);
        }
        List<JButton> leftSideButtons = this.createButtons(leftSideActions);
        List<JButton> rightSideButtons = this.createButtons(actions);
        this.myButtonMap.clear();
        for (JButton button2 : ContainerUtil.concat(leftSideButtons, rightSideButtons)) {
            this.myButtonMap.put(button2.getAction(), button2);
            if (!(button2 instanceof JBOptionButton)) continue;
            this.optionButtons.add((JBOptionButton)button2);
        }
        JPanel result2 = this.createSouthPanel(leftSideButtons, rightSideButtons, addHelpToLeftSide);
        if (LoadingState.COMPONENTS_REGISTERED.isOccurred() && ApplicationManager.getApplication() != null) {
            Touchbar.setButtonActions(result2, leftSideButtons, rightSideButtons, null);
        }
        return result2;
    }

    @Contract(mutates="param1")
    protected void sortActionsOnMac(@NotNull List<Action> actions) {
        if (actions == null) {
            DialogWrapper.$$$reportNull$$$0(13);
        }
        actions.sort(Comparator.comparing(action -> Objects.requireNonNullElse((Integer)action.getValue(MAC_ACTION_ORDER), action.getValue(DEFAULT_ACTION) == null ? 0 : 100)));
    }

    @NotNull
    protected JButton createHelpButton(@NotNull Insets insets) {
        if (insets == null) {
            DialogWrapper.$$$reportNull$$$0(14);
        }
        JButton helpButton = DialogWrapper.createHelpButton(this.getHelpAction());
        this.setHelpTooltip(helpButton);
        helpButton.setMargin(insets);
        JButton jButton = helpButton;
        if (jButton == null) {
            DialogWrapper.$$$reportNull$$$0(15);
        }
        return jButton;
    }

    private static JButton createHelpButton(@NotNull Action action) {
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(16);
        }
        JButton helpButton = new JButton(action);
        helpButton.putClientProperty("JButton.buttonType", "help");
        helpButton.setText("");
        helpButton.addPropertyChangeListener("ancestor", evt -> {
            if (evt.getNewValue() == null) {
                HelpTooltip.dispose((JComponent)evt.getSource());
            }
        });
        helpButton.getAccessibleContext().setAccessibleName(UIBundle.message("dialog.options.help.button.accessible.name", new Object[0]));
        helpButton.getAccessibleContext().setAccessibleDescription(ActionsBundle.actionDescription("HelpTopics"));
        return helpButton;
    }

    protected void setHelpTooltip(@NotNull JButton helpButton) {
        if (helpButton == null) {
            DialogWrapper.$$$reportNull$$$0(17);
        }
        helpButton.setToolTipText(ActionsBundle.actionDescription("HelpTopics"));
    }

    @NotNull
    private static List<Action> flattenOptionsActions(@NotNull List<? extends Action> actions) {
        if (actions == null) {
            DialogWrapper.$$$reportNull$$$0(18);
        }
        ArrayList<Action> newActions = new ArrayList<Action>();
        for (Action action : actions) {
            newActions.add(action);
            if (!(action instanceof OptionAction)) continue;
            OptionAction it = (OptionAction)action;
            for (Action option : it.getOptions()) {
                option.putValue(MAC_ACTION_ORDER, action.getValue(DEFAULT_ACTION) != null ? 99 : 0);
                newActions.add(option);
            }
        }
        ArrayList<Action> arrayList = newActions;
        if (arrayList == null) {
            DialogWrapper.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    protected boolean shouldAddErrorNearButtons() {
        return false;
    }

    @NotNull
    protected DialogStyle getStyle() {
        DialogStyle dialogStyle = DialogStyle.NO_STYLE;
        if (dialogStyle == null) {
            DialogWrapper.$$$reportNull$$$0(20);
        }
        return dialogStyle;
    }

    protected boolean toBeShown() {
        return !this.myCheckBoxDoNotShowDialog.isSelected();
    }

    @NotNull
    private List<JButton> createButtons(@NotNull List<? extends Action> actions) {
        if (actions == null) {
            DialogWrapper.$$$reportNull$$$0(21);
        }
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        for (Action action : actions) {
            buttons.add(this.createJButtonForAction(action));
        }
        ArrayList<JButton> arrayList = buttons;
        if (arrayList == null) {
            DialogWrapper.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    protected JPanel createSouthPanel(@NotNull List<? extends JButton> leftSideButtons, @NotNull List<? extends JButton> rightSideButtons, boolean addHelpToLeftSide) {
        if (leftSideButtons == null) {
            DialogWrapper.$$$reportNull$$$0(23);
        }
        if (rightSideButtons == null) {
            DialogWrapper.$$$reportNull$$$0(24);
        }
        SouthPanel panel2 = new SouthPanel(this.getStyle());
        if (this.myDoNotAsk != null) {
            this.myCheckBoxDoNotShowDialog = new JCheckBox(this.myDoNotAsk.getDoNotShowMessage());
            this.myCheckBoxDoNotShowDialog.setVisible(this.myDoNotAsk.canBeHidden());
            this.myCheckBoxDoNotShowDialog.setSelected(!this.myDoNotAsk.isToBeShown());
            DialogUtil.registerMnemonic(this.myCheckBoxDoNotShowDialog, '&');
        }
        JComponent doNotAskCheckbox = this.createDoNotAskCheckbox();
        NonOpaquePanel lrButtonsPanel = new NonOpaquePanel(new GridBagLayout());
        JBInsets insets = JBInsets.emptyInsets();
        if (!rightSideButtons.isEmpty() || !leftSideButtons.isEmpty()) {
            JPanel buttonsPanel;
            GridBag bag = new GridBag().setDefaultInsets((Insets)insets);
            if (!leftSideButtons.isEmpty()) {
                buttonsPanel = this.createButtonsPanel(leftSideButtons);
                if (!rightSideButtons.isEmpty()) {
                    buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
                }
                lrButtonsPanel.add((Component)buttonsPanel, bag.next());
            }
            lrButtonsPanel.add(Box.createHorizontalGlue(), bag.next().weightx(1.0).fillCellHorizontally());
            if (!rightSideButtons.isEmpty()) {
                buttonsPanel = this.createButtonsPanel(rightSideButtons);
                if (this.shouldAddErrorNearButtons()) {
                    lrButtonsPanel.add((Component)this.myErrorText, bag.next());
                    lrButtonsPanel.add(Box.createHorizontalStrut(10), bag.next());
                }
                lrButtonsPanel.add((Component)buttonsPanel, bag.next());
            }
            if (0 == this.myButtonAlignment && doNotAskCheckbox == null) {
                lrButtonsPanel.add(Box.createHorizontalGlue(), bag.next().weightx(1.0).fillCellHorizontally());
            }
        }
        JButton helpButton = null;
        if (addHelpToLeftSide) {
            helpButton = this.createHelpButton((Insets)insets);
        }
        JPanel eastPanel = this.createSouthAdditionalPanel();
        if (helpButton != null || doNotAskCheckbox != null || eastPanel != null) {
            JPanel leftPanel = new JPanel(new BorderLayout());
            if (helpButton != null) {
                leftPanel.add((Component)helpButton, "West");
            }
            if (doNotAskCheckbox != null) {
                doNotAskCheckbox.setBorder((Border)JBUI.Borders.emptyRight((int)20));
                leftPanel.add((Component)doNotAskCheckbox, "Center");
            }
            if (eastPanel != null) {
                leftPanel.add((Component)eastPanel, "East");
            }
            panel2.add((Component)leftPanel, "West");
        }
        panel2.add((Component)lrButtonsPanel, "Center");
        if (this.getStyle() == DialogStyle.COMPACT) {
            Color color = UIManager.getColor("DialogWrapper.southPanelDivider");
            CustomLineBorder line = new CustomLineBorder(color != null ? color : OnePixelDivider.BACKGROUND, 1, 0, 0, 0);
            panel2.setBorder(new CompoundBorder((Border)line, (Border)JBUI.Borders.empty((int)8, (int)12)));
        } else {
            panel2.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        }
        SouthPanel southPanel = panel2;
        if (southPanel == null) {
            DialogWrapper.$$$reportNull$$$0(25);
        }
        return southPanel;
    }

    @Nullable
    protected JComponent createDoNotAskCheckbox() {
        return this.myCheckBoxDoNotShowDialog != null && this.myCheckBoxDoNotShowDialog.isVisible() ? this.myCheckBoxDoNotShowDialog : null;
    }

    @NotNull
    protected JPanel createButtonsPanel(@NotNull List<? extends JButton> buttons) {
        if (buttons == null) {
            DialogWrapper.$$$reportNull$$$0(26);
        }
        return DialogWrapper.layoutButtonsPanel(buttons);
    }

    @NotNull
    public static JPanel layoutButtonsPanel(@NotNull List<? extends JButton> buttons) {
        if (buttons == null) {
            DialogWrapper.$$$reportNull$$$0(27);
        }
        NonOpaquePanel buttonsPanel = new NonOpaquePanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        for (int i = 0; i < buttons.size(); ++i) {
            JComponent button2 = buttons.get(i);
            Insets insets = button2.getInsets();
            buttonsPanel.add(button2);
            if (i >= buttons.size() - 1) continue;
            int gap = BASE_BUTTON_GAP.get() - insets.left - insets.right;
            buttonsPanel.add(Box.createRigidArea(new Dimension(gap, 0)));
        }
        NonOpaquePanel nonOpaquePanel = buttonsPanel;
        if (nonOpaquePanel == null) {
            DialogWrapper.$$$reportNull$$$0(28);
        }
        return nonOpaquePanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        return null;
    }

    @Nullable
    protected JButton getButton(@NotNull Action action) {
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(29);
        }
        return this.myButtonMap.get(action);
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button2 = DialogWrapper.createJButtonForAction(action, this.getRootPane());
        int mnemonic = button2.getMnemonic();
        Object name = action.getValue("Name");
        if (mnemonic == 89 && "Yes".equals(name)) {
            this.myYesAction = action;
        } else if (mnemonic == 78 && "No".equals(name)) {
            this.myNoAction = action;
        }
        if (action.getValue(FOCUSED_ACTION) != null) {
            this.myPreferredFocusedComponent = button2;
        }
        return button2;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static JButton createJButtonForAction(@NotNull Action action, @Nullable JRootPane rootPane) {
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(30);
        }
        if (!(action instanceof OptionAction)) ** GOTO lbl-1000
        optionAction = (OptionAction)action;
        if (Registry.is((String)"ide.allow.merge.buttons", (boolean)true)) {
            optionButton = new JBOptionButton(optionAction, optionAction.getOptions());
            optionButton.setOptionTooltipText(JBOptionButton.getDefaultTooltip());
            button = optionButton;
        } else lbl-1000:
        // 2 sources

        {
            v0 = button = action instanceof DialogWrapperAction != false ? new JButton(action) : new JButton(action){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void fireActionPerformed(ActionEvent event) {
                    DialogWrapper wrapper;
                    Window window = ComponentUtil.getWindow((Component)this);
                    if (window instanceof DialogWrapperDialog) {
                        DialogWrapperDialog dwd = (DialogWrapperDialog)((Object)window);
                        v0 = dwd.getDialogWrapper();
                    } else {
                        v0 = wrapper = null;
                    }
                    if (wrapper != null && (wrapper.myClosed || wrapper.myPerformAction)) {
                        return;
                    }
                    if (wrapper != null) {
                        wrapper.myPerformAction = true;
                    }
                    try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                        super.fireActionPerformed(event);
                    }
                    finally {
                        if (wrapper != null) {
                            wrapper.myPerformAction = false;
                        }
                    }
                }
            };
        }
        if (SystemInfoRt.isMac) {
            button.putClientProperty("JButton.buttonType", "text");
        }
        pair = DialogWrapper.extractMnemonic(button.getText());
        button.setText((String)pair.second);
        mnemonic = (Integer)pair.first;
        value = action.getValue("MnemonicKey");
        if (value instanceof Integer) {
            mnemonic = (Integer)value;
        }
        button.setMnemonic(mnemonic);
        if (action.getValue("DefaultAction") != null && rootPane != null) {
            rootPane.setDefaultButton(button);
        }
        v1 = button;
        if (v1 == null) {
            DialogWrapper.$$$reportNull$$$0(31);
        }
        return v1;
    }

    public static @NotNull Pair<Integer, @Nls String> extractMnemonic(@Nullable @Nls String text) {
        if (text == null) {
            Pair pair = Pair.pair((Object)0, null);
            if (pair == null) {
                DialogWrapper.$$$reportNull$$$0(32);
            }
            return pair;
        }
        int mnemonic = 0;
        @Nls StringBuilder plainText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            int ch = text.charAt(i);
            if (ch == 95 || ch == 38) {
                if (++i >= text.length()) break;
                ch = text.charAt(i);
                if (ch != 95 && ch != 38) {
                    int vk = ch;
                    if (vk >= 97 && vk <= 122) {
                        vk -= 32;
                    }
                    mnemonic = vk;
                }
            }
            plainText.append((char)ch);
        }
        Pair pair = Pair.pair((Object)mnemonic, (Object)plainText.toString());
        if (pair == null) {
            DialogWrapper.$$$reportNull$$$0(33);
        }
        return pair;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
        if (parent == null) {
            DialogWrapper.$$$reportNull$$$0(34);
        }
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, parent, canBeParent);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(35);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(Window owner2, boolean canBeParent, IdeModalityType ideModalityType) {
        if (ideModalityType == IdeModalityType.PROJECT) {
            LOG.error("IdeModalityType.PROJECT is not fully supported and may lead to unexpected problems. Use IdeModalityType.IDE for modal dialogs and IdeModalityType.MODELESS for non-modal ones");
        }
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, owner2, canBeParent, ideModalityType);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(36);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(Window owner2, boolean canBeParent, boolean applicationModalIfPossible) {
        DialogWrapperPeer dialogWrapperPeer = this.createPeer(owner2, canBeParent, applicationModalIfPossible ? IdeModalityType.IDE : IdeModalityType.PROJECT);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(37);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@Nullable Project project, boolean canBeParent, @NotNull IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            DialogWrapper.$$$reportNull$$$0(38);
        }
        if (ideModalityType == IdeModalityType.PROJECT) {
            LOG.error("IdeModalityType.PROJECT is not fully supported and may lead to unexpected problems. Use IdeModalityType.IDE for modal dialogs and IdeModalityType.MODELESS for non-modal ones");
        }
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, project, canBeParent, ideModalityType);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(39);
        }
        return dialogWrapperPeer;
    }

    @NotNull
    protected DialogWrapperPeer createPeer(@Nullable Project project, boolean canBeParent) {
        DialogWrapperPeer dialogWrapperPeer = DialogWrapperPeerFactory.getInstance().createPeer(this, project, canBeParent);
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(40);
        }
        return dialogWrapperPeer;
    }

    @Nullable
    protected JComponent createTitlePane() {
        return null;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return null;
    }

    @Nullable
    protected abstract JComponent createCenterPanel();

    public void toFront() {
        this.myPeer.toFront();
    }

    public void toBack() {
        this.myPeer.toBack();
    }

    protected boolean setAutoAdjustable(boolean autoAdjustable) {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return false;
        }
        rootPane.putClientProperty(NO_AUTO_RESIZE, autoAdjustable ? null : Boolean.TRUE);
        return true;
    }

    public boolean isAutoAdjustable() {
        JRootPane rootPane = this.getRootPane();
        return rootPane == null || rootPane.getClientProperty(NO_AUTO_RESIZE) == null;
    }

    protected void dispose() {
        DialogWrapper.ensureEventDispatchThread();
        this.myValidationAlarm.cancelAllRequests();
        this.myDisposed = true;
        for (JButton button2 : this.myButtonMap.values()) {
            button2.setAction(null);
        }
        this.myButtonMap.clear();
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            if (this.myActualSize != null && this.isAutoAdjustable()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resetting the size on dispose to the actual size " + String.valueOf(this.myActualSize));
                }
                this.setSize(this.myActualSize.width, this.myActualSize.height);
            }
            this.myPeer.dispose();
        }
    }

    @ApiStatus.Internal
    public static void cleanupRootPane(@Nullable JRootPane rootPane) {
        if (rootPane == null) {
            return;
        }
        RepaintManager.currentManager(rootPane).removeInvalidComponent(rootPane);
        Container contentPane = rootPane.getContentPane();
        if (contentPane != null) {
            contentPane.removeAll();
        }
        DialogWrapper.clearOwnFields(rootPane, (Condition<? super Field>)((Condition)field -> {
            String clazz = field.getDeclaringClass().getName();
            if (!clazz.startsWith("java.") && !clazz.startsWith("javax.")) {
                return true;
            }
            String name = field.getName();
            return "clientProperties".equals(name);
        }));
    }

    @ApiStatus.Internal
    public static void cleanupWindowListeners(@Nullable Window window) {
        if (window == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            for (WindowListener listener2 : window.getWindowListeners()) {
                if (!listener2.getClass().getName().startsWith("com.intellij.")) continue;
                window.removeWindowListener(listener2);
            }
        });
    }

    public void doCancelAction() {
        if (this.getCancelAction().isEnabled()) {
            this.close(1, ExitActionType.CANCEL);
        }
    }

    private void processDoNotAskOnCancel() {
        if (this.myDoNotAsk != null && this.myDoNotAsk.shouldSaveOptionsOnCancel() && this.myDoNotAsk.canBeHidden()) {
            this.myDoNotAsk.setToBeShown(this.toBeShown(), 1);
        }
    }

    public void doCancelAction(AWTEvent source) {
        this.recordAction("DialogCancelAction", source);
        this.doCancelAction();
    }

    public void clickDefaultButton() {
        JButton button2 = this.getRootPane().getDefaultButton();
        if (button2 != null) {
            button2.doClick();
        }
    }

    @ApiStatus.Internal
    public final void performOKAction() {
        this.doOKAction();
    }

    @ApiStatus.Internal
    @NotNull
    public final List<ValidationInfo> performValidateAll() {
        List<ValidationInfo> list = this.doValidateAll();
        if (list == null) {
            DialogWrapper.$$$reportNull$$$0(41);
        }
        return list;
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            this.applyFields();
            this.close(0, ExitActionType.OK);
        }
    }

    protected void applyFields() {
        if (this.myDialogPanel != null) {
            this.myDialogPanel.apply();
        }
    }

    protected void processDoNotAskOnOk(int exitCode) {
        if (this.myDoNotAsk != null && this.myDoNotAsk.canBeHidden()) {
            this.myDoNotAsk.setToBeShown(this.toBeShown(), exitCode);
        }
    }

    public boolean shouldCloseOnCross() {
        return this.myCrossClosesWindow;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray;
        Action helpAction = this.getHelpAction();
        if (helpAction == this.myHelpAction && this.getHelpId() == null) {
            Action[] actionArray2 = new Action[2];
            actionArray2[0] = this.getOKAction();
            actionArray = actionArray2;
            actionArray2[1] = this.getCancelAction();
        } else {
            Action[] actionArray3 = new Action[3];
            actionArray3[0] = this.getOKAction();
            actionArray3[1] = this.getCancelAction();
            actionArray = actionArray3;
            actionArray3[2] = helpAction;
        }
        if (actionArray == null) {
            DialogWrapper.$$$reportNull$$$0(42);
        }
        return actionArray;
    }

    protected Action @NotNull [] createLeftSideActions() {
        return new Action[0];
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myOKAction;
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(43);
        }
        return action;
    }

    @NotNull
    protected Action getCancelAction() {
        Action action = this.myCancelAction;
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(44);
        }
        return action;
    }

    @NotNull
    protected Action getHelpAction() {
        Action action = this.myHelpAction;
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(45);
        }
        return action;
    }

    @ApiStatus.Internal
    public void setShouldUseWriteIntentReadAction(boolean value2) {
        this.useWriteIntentReadAction = value2;
    }

    protected boolean isProgressDialog() {
        return false;
    }

    public final boolean isModalProgress() {
        return this.isProgressDialog();
    }

    public Container getContentPane() {
        return this.myPeer.getContentPane();
    }

    public void validate() {
        this.myPeer.validate();
    }

    public void repaint() {
        this.myPeer.repaint();
    }

    @NonNls
    @Nullable
    protected String getDimensionServiceKey() {
        return null;
    }

    @NonNls
    @Nullable
    public final String getDimensionKey() {
        return this.getDimensionServiceKey();
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myPreferredFocusedComponentFromPanel != null) {
            return this.myPreferredFocusedComponentFromPanel;
        }
        return SystemInfoRt.isMac ? this.myPreferredFocusedComponent : null;
    }

    public final float getHorizontalStretch() {
        return this.myHorizontalStretch;
    }

    public final float getVerticalStretch() {
        return this.myVerticalStretch;
    }

    protected final void setHorizontalStretch(float hStretch) {
        this.myHorizontalStretch = hStretch;
    }

    protected final void setVerticalStretch(float vStretch) {
        this.myVerticalStretch = vStretch;
    }

    public final boolean isMaximizable() {
        return this.myPeer.isMaximizable();
    }

    public final void setMaximizable(boolean maximizable) {
        this.myPeer.setMaximizable(maximizable);
    }

    public Window getOwner() {
        return this.myPeer.getOwner();
    }

    public Window getWindow() {
        return this.myPeer.getWindow();
    }

    public JComponent getContentPanel() {
        return (JComponent)this.myPeer.getContentPane();
    }

    public JRootPane getRootPane() {
        return this.myPeer.getRootPane();
    }

    public Dimension getSize() {
        return this.myPeer.getSize();
    }

    @NlsContexts.DialogTitle
    public String getTitle() {
        return this.myPeer.getTitle();
    }

    protected void init() {
        boolean isVisualPaddingCompensatedOnComponentLevel;
        JComponent centerPanel;
        DialogWrapper.ensureEventDispatchThread();
        this.myErrorText = new ErrorText(this.createContentPaneBorder(), this.getErrorTextAlignment());
        this.myErrorText.setVisible(false);
        ComponentAdapter resizeListener = new ComponentAdapter(){
            private int myHeight;

            @Override
            public void componentResized(ComponentEvent e) {
                this.resize(e);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.resize(e);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.resize(e);
            }

            private void resize(ComponentEvent event) {
                int height;
                int n = height = !DialogWrapper.this.myErrorText.isVisible() ? 0 : event.getComponent().getHeight();
                if (height != this.myHeight) {
                    this.myHeight = height;
                    DialogWrapper.this.myResizeInProgress = true;
                    DialogWrapper.this.myErrorText.setMinimumSize(new Dimension(0, height));
                    JRootPane root = DialogWrapper.this.myPeer.getRootPane();
                    if (root != null) {
                        root.validate();
                    }
                    if (DialogWrapper.this.myActualSize != null && !DialogWrapper.this.shouldAddErrorNearButtons()) {
                        DialogWrapper.this.myPeer.setSize(DialogWrapper.this.myActualSize.width, DialogWrapper.this.myActualSize.height + height);
                    }
                    DialogWrapper.this.myErrorText.revalidate();
                    DialogWrapper.this.myResizeInProgress = false;
                }
            }
        };
        this.myErrorText.addComponentListener(resizeListener);
        Disposer.register((Disposable)this.myDisposable, () -> this.myErrorText.removeComponentListener(resizeListener));
        this.myRoot.setLayout(this.createRootLayout());
        this.myPeer.setContentPane(this.myRoot);
        DumbAwareAction toggleShowOptions = DumbAwareAction.create(e -> this.expandNextOptionButton());
        toggleShowOptions.registerCustomShortcutSet((ShortcutSet)JBOptionButton.getDefaultShowPopupShortcut(), (JComponent)this.myRoot, this.myDisposable);
        JComponent titlePane = this.createTitlePane();
        if (titlePane != null) {
            JPanel northSection = new JPanel(new BorderLayout());
            this.myRoot.add((Component)northSection, "North");
            northSection.add((Component)titlePane, "Center");
        }
        JPanel centerSection = new JPanel(new BorderLayout());
        centerSection.setName("centerSection");
        this.myRoot.add((Component)centerSection, "Center");
        JComponent n = this.createNorthPanel();
        if (n != null) {
            centerSection.add((Component)n, "North");
        }
        if ((centerPanel = this.createCenterPanel()) != null) {
            centerPanel.putClientProperty(DIALOG_CONTENT_PANEL_PROPERTY, true);
            centerSection.add((Component)centerPanel, "Center");
            if (centerPanel instanceof DialogPanel) {
                DialogPanel dialogPanel = (DialogPanel)((Object)centerPanel);
                this.myPreferredFocusedComponentFromPanel = dialogPanel.getPreferredFocusedComponent();
                dialogPanel.registerValidators(this.myDisposable, (Function1<? super Map<JComponent, ValidationInfo>, Unit>)((Function1)map -> {
                    this.setOKActionEnabled(ContainerUtil.and(map.values(), info -> info.okEnabled));
                    return Unit.INSTANCE;
                }));
                this.myDialogPanel = dialogPanel;
            }
        }
        boolean bl = isVisualPaddingCompensatedOnComponentLevel = centerPanel == null || centerPanel.getClientProperty(IS_VISUAL_PADDING_COMPENSATED_ON_COMPONENT_LEVEL_KEY) == null;
        if (isVisualPaddingCompensatedOnComponentLevel) {
            this.myRoot.setBorder(this.createContentPaneBorder());
        }
        if (this.myCreateSouthSection) {
            JPanel southSection = new JPanel(new BorderLayout());
            if (!isVisualPaddingCompensatedOnComponentLevel) {
                southSection.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)8, (int)12));
            }
            this.myRoot.add((Component)southSection, "South");
            southSection.add((Component)this.myErrorText, "Center");
            JComponent south = this.createSouthPanel();
            if (south != null) {
                southSection.add((Component)south, "South");
            }
        }
        MnemonicHelper.init(this.myRoot);
        if (!this.postponeValidation()) {
            this.startTrackingValidation();
        }
        if (SystemInfoRt.isWindows || SystemInfoRt.isLinux && Registry.is((String)"ide.linux.enter.on.dialog.triggers.focused.button", (boolean)true)) {
            DialogWrapper.installEnterHook(this.myRoot, this.myDisposable);
        }
        ActionUtil.initActionContextForComponent(this.myRoot);
    }

    protected int getErrorTextAlignment() {
        return 10;
    }

    @NotNull
    protected LayoutManager createRootLayout() {
        return new BorderLayout();
    }

    private static void installEnterHook(JComponent root, Disposable disposable) {
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Component owner2;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((owner2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) instanceof JButton && owner2.isEnabled()) {
                    ((JButton)owner2).doClick();
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                Component owner2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                e.getPresentation().setEnabled(owner2 instanceof JButton && owner2.isEnabled());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    5.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/ui/DialogWrapper$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/ui/DialogWrapper$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), root, disposable);
    }

    private void expandNextOptionButton() {
        if (this.myCurrentOptionsButtonIndex >= 0) {
            this.optionButtons.get(this.myCurrentOptionsButtonIndex).closePopup();
        }
        this.myCurrentOptionsButtonIndex = DialogWrapper.getEnabledIndexCyclic(this.optionButtons, this.myCurrentOptionsButtonIndex, true).orElse(-1);
        if (this.myCurrentOptionsButtonIndex >= 0) {
            this.optionButtons.get(this.myCurrentOptionsButtonIndex).showPopup(null, true);
        }
    }

    protected void startTrackingValidation() {
        if (!this.continuousValidation()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (!this.myValidationStarted) {
                this.myValidationStarted = true;
                this.initValidation();
            }
        });
    }

    protected final void initValidation() {
        if (this.myDisposed) {
            return;
        }
        this.myValidationAlarm.cancelAllRequests();
        Runnable validateRequest = () -> {
            if (this.myDisposed) {
                return;
            }
            this.updateErrorInfo(this.doValidateAll());
            if (this.continuousValidation()) {
                this.initValidation();
            }
        };
        if (this.getContinuousValidationThreadToUse() == Alarm.ThreadToUse.SWING_THREAD) {
            JRootPane rootPane = this.getRootPane();
            this.myValidationAlarm.addRequest(validateRequest, this.myValidationDelay, !LoadingState.COMPONENTS_REGISTERED.isOccurred() || ApplicationManager.getApplication() == null ? null : (rootPane != null ? ModalityState.stateForComponent((Component)rootPane) : ModalityState.current()));
        } else {
            this.myValidationAlarm.addRequest(validateRequest, this.myValidationDelay);
        }
    }

    @NotNull
    protected JComponent createContentPane() {
        return new JPanel();
    }

    public void pack() {
        this.myPeer.pack();
    }

    public boolean setSizeDuringPack() {
        return true;
    }

    @Nullable
    public Dimension getInitialSize() {
        return this.myUserSizeSet ? this.myUserBounds.getSize() : null;
    }

    public Dimension getPreferredSize() {
        return this.myPeer.getPreferredSize();
    }

    @Deprecated(forRemoval=true)
    protected final void setButtonsAlignment(int alignment) {
        if (0 != alignment && 4 != alignment) {
            throw new IllegalArgumentException("unknown alignment: " + alignment);
        }
        this.myButtonAlignment = alignment;
    }

    public final void setCrossClosesWindow(boolean crossClosesWindow) {
        this.myCrossClosesWindow = crossClosesWindow;
    }

    protected final void setCancelButtonText(@NlsContexts.Button @NotNull String text) {
        if (text == null) {
            DialogWrapper.$$$reportNull$$$0(46);
        }
        this.myCancelAction.putValue("Name", text);
    }

    public void setModal(boolean modal) {
        this.myPeer.setModal(modal);
    }

    public boolean isModal() {
        return this.myPeer.isModal();
    }

    @ApiStatus.Experimental
    public boolean isKeepPopupsOpen() {
        return this.myKeepPopupsOpen;
    }

    @ApiStatus.Experimental
    public void setKeepPopupsOpen(boolean keepPopupsOpen) {
        this.myKeepPopupsOpen = keepPopupsOpen;
    }

    public void setOnDeactivationAction(@NotNull Runnable action) {
        if (action == null) {
            DialogWrapper.$$$reportNull$$$0(47);
        }
        this.myPeer.setOnDeactivationAction(this.myDisposable, action);
    }

    public boolean isOKActionEnabled() {
        return this.myOKAction.isEnabled();
    }

    public void setOKActionEnabled(boolean isEnabled) {
        this.myOKAction.setEnabled(isEnabled);
    }

    protected final void setOKButtonIcon(Icon icon) {
        this.myOKAction.putValue("SmallIcon", icon);
    }

    protected final void setOKButtonText(@NlsContexts.Button @NotNull String text) {
        if (text == null) {
            DialogWrapper.$$$reportNull$$$0(48);
        }
        this.myOKAction.putValue("Name", text);
    }

    protected final void setOKButtonMnemonic(int c) {
        this.myOKAction.putValue("MnemonicKey", c);
    }

    protected final void setOKButtonTooltip(@NlsContexts.Tooltip String text) {
        this.myOKAction.putValue("ShortDescription", text);
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return null;
    }

    protected void doHelpAction() {
        if (this.myHelpAction.isEnabled()) {
            this.logClickOnHelpDialogEvent();
            String helpId = this.getHelpId();
            if (helpId != null) {
                HelpManager.getInstance().invokeHelp(helpId);
            } else {
                LOG.error("null topic; dialog=" + String.valueOf(this.getClass()) + "; action=" + String.valueOf(this.getHelpAction().getClass()));
            }
        }
    }

    public boolean isOK() {
        return this.getExitCode() == 0;
    }

    public boolean isVisible() {
        return this.myPeer.isVisible();
    }

    public boolean isShowing() {
        return this.myPeer.isShowing();
    }

    public void setSize(int width, int height) {
        this.myUserBounds.setSize(width, height);
        this.myUserSizeSet = true;
        this.myPeer.setSize(width, height);
    }

    public void setTitle(@NlsContexts.DialogTitle String title) {
        this.myPeer.setTitle(title);
    }

    public boolean isResizable() {
        return this.myPeer.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myPeer.setResizable(resizable);
    }

    @NotNull
    public Point getLocation() {
        Point point = this.myPeer.getLocation();
        if (point == null) {
            DialogWrapper.$$$reportNull$$$0(49);
        }
        return point;
    }

    public void setLocation(@NotNull Point p) {
        if (p == null) {
            DialogWrapper.$$$reportNull$$$0(50);
        }
        this.myUserBounds.setLocation(p);
        this.myUserLocationSet = true;
        this.myPeer.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myUserBounds.setLocation(x, y);
        this.myUserLocationSet = true;
        this.myPeer.setLocation(x, y);
    }

    @ApiStatus.Internal
    public void fitToScreen(Rectangle rect) {
        Rectangle before = null;
        if (LOG.isDebugEnabled()) {
            before = new Rectangle(rect);
        }
        ScreenUtil.fitToScreen((Rectangle)rect);
        if (LOG.isDebugEnabled() && !Objects.equals(before, rect)) {
            LOG.debug("Fitted these bounds to the screen: " + String.valueOf(before) + " -> " + String.valueOf(rect));
        }
    }

    public void centerRelativeToParent() {
        this.myPeer.centerInParent();
    }

    public void show() {
        if (LoadingState.APP_STARTED.isOccurred()) {
            this.logShowDialogEvent();
        }
        this.doShow();
    }

    public boolean showAndGet() {
        if (!this.isModal()) {
            throw new IllegalStateException("The showAndGet() method is for modal dialogs only");
        }
        this.show();
        return this.isOK();
    }

    @Deprecated
    @NotNull
    public AsyncResult<Boolean> showAndGetOk() {
        if (this.isModal()) {
            throw new IllegalStateException("The showAndGetOk() method is for modeless dialogs only");
        }
        AsyncResult result2 = new AsyncResult();
        Disposer.register((Disposable)this.myDisposable, () -> result2.setDone((Object)this.isOK()));
        this.doShow();
        AsyncResult asyncResult = result2;
        if (asyncResult == null) {
            DialogWrapper.$$$reportNull$$$0(51);
        }
        return asyncResult;
    }

    private void doShow() {
        Window window;
        if (UiInterceptors.tryIntercept((Object)this)) {
            return;
        }
        DialogWrapper.ensureEventDispatchThread();
        this.registerKeyboardShortcuts();
        Disposable uiParent = ClientDisposableProvider.getCurrentDisposable();
        if (uiParent != null) {
            Disposer.register((Disposable)uiParent, (Disposable)this.myDisposable);
        }
        if ((window = this.myPeer.getWindow()) != null) {
            ClientProperty.put((Window)window, KEEP_POPUPS_OPEN, (Object)this.myKeepPopupsOpen);
        }
        if (this.useWriteIntentReadAction && !this.isProgressDialog() && ApplicationManager.getApplication() != null) {
            WriteIntentReadAction.run(() -> this.myPeer.show());
        } else {
            this.myPeer.show();
        }
    }

    @Nullable
    public Point getInitialLocation() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using " + (String)(this.myInitialLocationCallback != null ? "the callback (" + String.valueOf(this.myInitialLocationCallback) + ")" : (this.myUserLocationSet ? "the set bounds (" + String.valueOf(this.myUserBounds) + ")" : "null")) + " to get the initial location");
        }
        return this.myInitialLocationCallback != null ? (Point)this.myInitialLocationCallback.compute() : (this.myUserLocationSet ? this.myUserBounds.getLocation() : null);
    }

    public void setInitialLocationCallback(@NotNull Computable<? extends Point> callback) {
        if (callback == null) {
            DialogWrapper.$$$reportNull$$$0(52);
        }
        this.myInitialLocationCallback = callback;
    }

    public void beforeShowCallback() {
    }

    private void registerKeyboardShortcuts() {
        JRootPane rootPane = this.getRootPane();
        if (rootPane == null) {
            return;
        }
        ActionListener cancelKeyboardAction = this.createCancelAction();
        if (cancelKeyboardAction != null) {
            rootPane.registerKeyboardAction(cancelKeyboardAction, KeyStroke.getKeyStroke(27, 0), 2);
            ActionUtil.registerForEveryKeyboardShortcut(this.getRootPane(), cancelKeyboardAction, CommonShortcuts.getCloseActiveWindow());
        }
        if (!DialogWrapper.isRemoveHelpButton() && !this.isProgressDialog()) {
            ActionListener helpAction = e -> this.doHelpAction();
            ActionUtil.registerForEveryKeyboardShortcut(this.getRootPane(), helpAction, CommonShortcuts.getContextHelp());
            rootPane.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        }
        rootPane.registerKeyboardAction(e -> this.focusButton(false), KeyStroke.getKeyStroke(37, 0), 1);
        rootPane.registerKeyboardAction(e -> this.focusButton(true), KeyStroke.getKeyStroke(39, 0), 1);
        if (this.myYesAction != null) {
            rootPane.registerKeyboardAction(this.myYesAction, KeyStroke.getKeyStroke(89, 0), 2);
        }
        if (this.myNoAction != null) {
            rootPane.registerKeyboardAction(this.myNoAction, KeyStroke.getKeyStroke(78, 0), 2);
        }
    }

    @Nullable
    protected ActionListener createCancelAction() {
        return e -> {
            if (!PopupUtil.handleEscKeyEvent()) {
                this.doCancelAction(e);
            }
        };
    }

    @NotNull
    protected Map<Action, JButton> getButtonMap() {
        Map<Action, JButton> map = this.myButtonMap;
        if (map == null) {
            DialogWrapper.$$$reportNull$$$0(53);
        }
        return map;
    }

    private void focusButton(boolean next) {
        ArrayList<JButton> buttons = new ArrayList<JButton>(this.myButtonMap.values());
        int focusedIndex = ContainerUtil.indexOf(buttons, Component::hasFocus);
        if (focusedIndex >= 0) {
            DialogWrapper.getEnabledIndexCyclic(buttons, focusedIndex, next).ifPresent(i -> ((JButton)buttons.get(i)).requestFocus());
        }
    }

    @NotNull
    private static OptionalInt getEnabledIndexCyclic(@NotNull List<? extends Component> components, int currentIndex, boolean next) {
        if (components == null) {
            DialogWrapper.$$$reportNull$$$0(54);
        }
        assert (-1 <= currentIndex && currentIndex <= components.size());
        int start2 = !next && currentIndex == -1 ? components.size() : currentIndex;
        OptionalInt optionalInt = IntStream.range(0, components.size()).map(i -> (next ? start2 + i + 1 : start2 + components.size() - i - 1) % components.size()).filter(i -> ((Component)components.get(i)).isEnabled()).findFirst();
        if (optionalInt == null) {
            DialogWrapper.$$$reportNull$$$0(55);
        }
        return optionalInt;
    }

    private void logCloseDialogEvent(int exitCode, ExitActionType exitActionType) {
        boolean canRecord = this.canRecordDialogId();
        if (canRecord) {
            FeatureUsageUiEventsKt.getUiEventLogger().logCloseDialog(this.getClass(), exitCode, exitActionType, this.invocationPlace);
        }
    }

    private void logShowDialogEvent() {
        boolean canRecord = this.canRecordDialogId();
        if (canRecord) {
            FeatureUsageUiEventsKt.getUiEventLogger().logShowDialog(this.getClass(), this.invocationPlace);
        }
    }

    private void logClickOnHelpDialogEvent() {
        if (!this.canRecordDialogId()) {
            return;
        }
        FeatureUsageUiEventsKt.getUiEventLogger().logClickOnHelpDialog(this.getClass(), this.invocationPlace);
    }

    protected boolean canRecordDialogId() {
        return true;
    }

    @ApiStatus.Internal
    public void setInvocationPlace(@Nullable @NonNls String invocationPlace) {
        this.invocationPlace = invocationPlace;
    }

    private void recordAction(String name, AWTEvent event) {
        if (event instanceof KeyEvent && ApplicationManager.getApplication() != null && LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            ActionsCollector.getInstance().record(name, (KeyEvent)event, this.getClass());
        }
    }

    protected void setErrorText(@NlsContexts.DialogMessage @Nullable String text) {
        this.setErrorText(text, null);
    }

    protected final void setErrorHtml(@Nullable HtmlChunk errorHtml) {
        this.setErrorInfoAll(errorHtml == null ? List.of() : List.of(new ValidationInfo(errorHtml, null)));
    }

    protected final void setErrorHtml(@Nullable HtmlChunk errorHtml, @Nullable JComponent component) {
        this.setErrorInfoAll(errorHtml == null ? List.of() : List.of(new ValidationInfo(errorHtml, component)));
    }

    protected void setErrorText(@NlsContexts.DialogMessage @Nullable String text, @Nullable JComponent component) {
        this.setErrorInfoAll(text == null ? List.of() : List.of(new ValidationInfo(text, component)));
    }

    protected final void setErrorInfoAll(@NotNull List<ValidationInfo> info) {
        if (info == null) {
            DialogWrapper.$$$reportNull$$$0(56);
        }
        if (this.myInfo.equals(info)) {
            return;
        }
        this.updateErrorText(info);
        this.updateComponentErrors(info);
        this.myInfo = info;
    }

    private void updateComponentErrors(@NotNull List<ValidationInfo> info) {
        if (info == null) {
            DialogWrapper.$$$reportNull$$$0(57);
        }
        this.myInfo.stream().filter(vi -> !info.contains(vi)).filter(vi -> vi.component != null).map(vi -> ComponentValidator.getInstance(vi.component)).forEach(c -> c.ifPresent(vi -> vi.updateInfo(null)));
        for (ValidationInfo vi2 : info) {
            JComponent component = vi2.component;
            if (component == null) continue;
            ComponentValidator validator = ComponentValidator.getInstance(component).orElseGet(() -> new ComponentValidator(this.getDisposable()).installOn(component));
            validator.updateInfo(vi2);
        }
    }

    private void updateErrorText(@NotNull List<ValidationInfo> infos) {
        boolean headless;
        ErrorText errorText;
        if (infos == null) {
            DialogWrapper.$$$reportNull$$$0(58);
        }
        if ((errorText = this.myErrorText) == null) {
            return;
        }
        Runnable updateRunnable = () -> {
            if (!this.myDisposed) {
                this.doUpdateErrorText(errorText, infos);
            }
        };
        Application application = ApplicationManager.getApplication();
        boolean bl = headless = application != null && application.isHeadlessEnvironment();
        if (headless) {
            updateRunnable.run();
        } else {
            SwingUtilities.invokeLater(updateRunnable);
        }
    }

    private void doUpdateErrorText(@NotNull ErrorText errorText, @NotNull List<ValidationInfo> infos) {
        if (errorText == null) {
            DialogWrapper.$$$reportNull$$$0(59);
        }
        if (infos == null) {
            DialogWrapper.$$$reportNull$$$0(60);
        }
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        for (ValidationInfo info : infos) {
            if (info.component != null || Strings.isEmptyOrSpaces((CharSequence)info.message)) continue;
            Color color = info.warning ? MessageType.WARNING.getTitleForeground() : NamedColorUtil.getErrorForeground();
            htmlBuilder.append((HtmlChunk)HtmlChunk.raw((String)info.message).wrapWith("left").wrapWith(HtmlChunk.font((String)ColorUtil.toHex((Color)color)))).br();
        }
        boolean needsSizeUpdate = true;
        if (htmlBuilder.isEmpty()) {
            needsSizeUpdate = errorText.clear();
        } else {
            errorText.setText(htmlBuilder.wrapWithHtmlBody().toString());
        }
        if (needsSizeUpdate) {
            this.updateSize();
        }
    }

    protected boolean hasErrors(@NotNull JComponent component) {
        if (component == null) {
            DialogWrapper.$$$reportNull$$$0(61);
        }
        return ContainerUtil.exists(this.myInfo, i -> component.equals(i.component) && !i.warning);
    }

    private void updateSize() {
        if (this.myActualSize == null && !this.myErrorText.isVisible()) {
            Dimension actualSize;
            this.myActualSize = actualSize = this.getSize();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated the actual size to " + String.valueOf(actualSize) + " because the error text is invisible");
            }
        }
    }

    @Nullable
    public static DialogWrapper findInstance(Component c) {
        while (c != null) {
            if (c instanceof DialogWrapperDialog) {
                return ((DialogWrapperDialog)((Object)c)).getDialogWrapper();
            }
            c = c.getParent();
        }
        return null;
    }

    @Nullable
    public static DialogWrapper findInstanceFromFocus() {
        return DialogWrapper.findInstance(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
    }

    @NotNull
    public final DialogWrapperPeer getPeer() {
        DialogWrapperPeer dialogWrapperPeer = this.myPeer;
        if (dialogWrapperPeer == null) {
            DialogWrapper.$$$reportNull$$$0(62);
        }
        return dialogWrapperPeer;
    }

    private static void ensureEventDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("The DialogWrapper can only be used in event dispatch thread. Current thread: " + String.valueOf(Thread.currentThread()));
        }
    }

    @NotNull
    public final Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            DialogWrapper.$$$reportNull$$$0(63);
        }
        return disposable;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void disposeIfNeeded() {
        if (this.isDisposed()) {
            return;
        }
        Disposer.dispose((Disposable)this.getDisposable());
    }

    private static void clearOwnFields(@Nullable Object object, @NotNull Condition<? super Field> selectCondition) {
        if (selectCondition == null) {
            DialogWrapper.$$$reportNull$$$0(64);
        }
        if (object == null) {
            return;
        }
        for (Field each : ReflectionUtil.collectFields(object.getClass())) {
            if ((each.getModifiers() & 0x18) > 0 || !selectCondition.value((Object)each)) continue;
            try {
                ReflectionUtil.resetField((Object)object, (Field)each);
            }
            catch (Exception exception) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 15, 19, 20, 22, 25, 28, 31, 32, 33, 35, 36, 37, 39, 40, 41, 42, 43, 44, 45, 49, 51, 53, 55, 62, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModalityType";
                break;
            }
            case 4: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peerFactory";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 51: 
            case 53: 
            case 55: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/DialogWrapper";
                break;
            }
            case 9: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 16: 
            case 29: 
            case 30: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpButton";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftSideButtons";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightSideButtons";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/DialogWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoNotShowMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContinuousValidationThreadToUse";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createHelpButton";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenOptionsActions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtons";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthPanel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "layoutButtonsPanel";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createJButtonForAction";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMnemonic";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "performValidateAll";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelAction";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpAction";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "showAndGetOk";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtonMap";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIndexCyclic";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getPeer";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 51: 
            case 53: 
            case 55: 
            case 62: 
            case 63: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addKeyListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sortActionsOnMac";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createHelpButton";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setHelpTooltip";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "flattenOptionsActions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createButtons";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createSouthPanel";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createButtonsPanel";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "layoutButtonsPanel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getButton";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createJButtonForAction";
                break;
            }
            case 34: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createPeer";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setCancelButtonText";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setOnDeactivationAction";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setOKButtonText";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setInitialLocationCallback";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledIndexCyclic";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setErrorInfoAll";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "updateComponentErrors";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorText";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateErrorText";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "hasErrors";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "clearOwnFields";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 15, 19, 20, 22, 25, 28, 31, 32, 33, 35, 36, 37, 39, 40, 41, 42, 43, 44, 45, 49, 51, 53, 55, 62, 63 -> new IllegalStateException(string);
        };
    }

    public static enum IdeModalityType {
        IDE,
        PROJECT,
        MODELESS;


        @NotNull
        public Dialog.ModalityType toAwtModality() {
            Dialog.ModalityType modalityType = switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Dialog.ModalityType.APPLICATION_MODAL;
                case 1 -> {
                    LOG.error("IdeModalityType.PROJECT is not fully supported and may lead to unexpected problems. Use IdeModalityType.IDE for modal dialogs and IdeModalityType.MODELESS for non-modal ones");
                    if (Registry.is((String)"ide.treat.project.modality.as.application")) {
                        yield Dialog.ModalityType.APPLICATION_MODAL;
                    }
                    yield Dialog.ModalityType.DOCUMENT_MODAL;
                }
                case 2 -> Dialog.ModalityType.MODELESS;
            };
            if (modalityType == null) {
                IdeModalityType.$$$reportNull$$$0(0);
            }
            return modalityType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/DialogWrapper$IdeModalityType", "toAwtModality"));
        }
    }

    protected class OkAction
    extends DialogWrapperAction {
        protected OkAction() {
            super(CommonBundle.getOkButtonText());
            this.addPropertyChangeListener(DialogWrapper.this.myRepaintOnNameChangeListener);
            this.putValue(DialogWrapper.DEFAULT_ACTION, Boolean.TRUE);
            this.putValue(DialogWrapper.MAC_ACTION_ORDER, 100);
        }

        @Override
        protected void doAction(ActionEvent e) {
            DialogWrapper.this.recordAction("DialogOkAction", EventQueue.getCurrentEvent());
            List<ValidationInfo> infoList = DialogWrapper.this.doValidateAll();
            if (!infoList.isEmpty()) {
                ValidationInfo info = infoList.get(0);
                if (info.component != null && info.component.isVisible()) {
                    IdeFocusManager.getInstance(null).requestFocus((Component)info.component, true);
                }
                DialogWrapper.this.updateErrorInfo(infoList);
                DialogWrapper.this.startTrackingValidation();
                for (ValidationInfo t : infoList) {
                    if (t.okEnabled) continue;
                    return;
                }
            }
            DialogWrapper.this.doOKAction();
        }
    }

    protected final class CancelAction
    extends DialogWrapperAction {
        private CancelAction() {
            super(CommonBundle.getCancelButtonText());
            this.putValue(DialogWrapper.MAC_ACTION_ORDER, -10);
            this.addPropertyChangeListener(DialogWrapper.this.myRepaintOnNameChangeListener);
        }

        @Override
        protected void doAction(ActionEvent e) {
            DialogWrapper.this.doCancelAction(e);
        }
    }

    public static final class HelpAction
    extends AbstractAction {
        @NotNull
        private final Runnable myHelpActionPerformed;

        public HelpAction(@NotNull Runnable helpActionPerformed) {
            if (helpActionPerformed == null) {
                HelpAction.$$$reportNull$$$0(0);
            }
            super(CommonBundle.getHelpButtonText());
            this.myHelpActionPerformed = helpActionPerformed;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myHelpActionPerformed.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpActionPerformed", "com/intellij/openapi/ui/DialogWrapper$HelpAction", "<init>"));
        }
    }

    public static enum DialogStyle {
        NO_STYLE,
        COMPACT;

    }

    private static class SouthPanel
    extends JPanel {
        private final DialogStyle myStyle;

        SouthPanel(@NotNull DialogStyle style) {
            if (style == null) {
                SouthPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myStyle = style;
        }

        @Override
        public Color getBackground() {
            Color bg = UIManager.getColor("DialogWrapper.southPanelBackground");
            if (this.myStyle == DialogStyle.COMPACT && bg != null) {
                return bg;
            }
            return super.getBackground();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/intellij/openapi/ui/DialogWrapper$SouthPanel", "<init>"));
        }
    }

    private static final class ErrorText
    extends JPanel {
        private final JLabel myLabel = new JLabel();

        private ErrorText(@Nullable Border contentBorder, int horizontalAlignment) {
            this.setLayout(new BorderLayout());
            this.myLabel.setBorder(ErrorText.createErrorTextBorder(contentBorder));
            this.myLabel.setHorizontalAlignment(horizontalAlignment);
            JBScrollPane pane = new JBScrollPane(this.myLabel, 21, 31);
            pane.setBorder((Border)JBUI.Borders.empty());
            pane.setBackground(null);
            pane.getViewport().setBackground(null);
            pane.setOpaque(false);
            this.add((Component)pane, "Center");
        }

        public void setText(@NotNull @Nls String errorText) {
            if (errorText == null) {
                ErrorText.$$$reportNull$$$0(0);
            }
            this.myLabel.setText(errorText);
            this.setVisible(true);
        }

        public boolean clear() {
            boolean isCurrentlyVisible = this.isVisible();
            this.myLabel.setBounds(0, 0, 0, 0);
            this.myLabel.setText("");
            this.setVisible(false);
            return isCurrentlyVisible;
        }

        @NotNull
        private static Border createErrorTextBorder(@Nullable Border contentBorder) {
            JBInsets contentInsets = contentBorder != null ? contentBorder.getBorderInsets(null) : JBInsets.emptyInsets();
            JBInsets baseInsets = JBInsets.create((int)16, (int)13);
            return new EmptyBorder(baseInsets.top, baseInsets.left > contentInsets.left ? baseInsets.left - contentInsets.left : 0, baseInsets.bottom > contentInsets.bottom ? baseInsets.bottom - contentInsets.bottom : 0, baseInsets.right > contentInsets.right ? baseInsets.right - contentInsets.right : 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "com/intellij/openapi/ui/DialogWrapper$ErrorText", "setText"));
        }
    }

    protected abstract class DialogWrapperAction
    extends AbstractAction {
        protected DialogWrapperAction(String name) {
            if (name == null) {
                DialogWrapperAction.$$$reportNull$$$0(0);
            }
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (DialogWrapper.this.myClosed) {
                return;
            }
            if (DialogWrapper.this.myPerformAction) {
                return;
            }
            DialogWrapper.this.myPerformAction = true;
            try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                this.doAction(e);
            }
            finally {
                DialogWrapper.this.myPerformAction = false;
            }
        }

        protected abstract void doAction(ActionEvent var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/ui/DialogWrapper$DialogWrapperAction", "<init>"));
        }
    }

    @Deprecated(forRemoval=true)
    public static interface DoNotAskOption
    extends com.intellij.openapi.ui.DoNotAskOption {

        public static abstract class Adapter
        extends DoNotAskOption.Adapter
        implements DoNotAskOption {
        }
    }

    protected class DialogWrapperExitAction
    extends DialogWrapperAction {
        protected final int myExitCode;

        public DialogWrapperExitAction(String name, int exitCode) {
            super(name);
            this.myExitCode = exitCode;
        }

        @Override
        protected void doAction(ActionEvent e) {
            if (this.isEnabled()) {
                DialogWrapper.this.close(this.myExitCode);
            }
        }
    }
}

