/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup.util;

import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\b\u0007\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J=\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/ui/popup/util/RoundedCellRenderer;", "T", "Ljavax/swing/ListCellRenderer;", "renderer", "fixedHeight", "", "<init>", "(Ljavax/swing/ListCellRenderer;Z)V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "cellHasFocus", "(Ljavax/swing/JList;Ljava/lang/Object;IZZ)Ljava/awt/Component;", "getBackground", "Ljava/awt/Color;", "component", "intellij.platform.ide"})
@ApiStatus.Internal
public final class RoundedCellRenderer<T>
implements ListCellRenderer<T> {
    @NotNull
    private final ListCellRenderer<T> renderer;
    private final boolean fixedHeight;

    @JvmOverloads
    public RoundedCellRenderer(@NotNull ListCellRenderer<T> renderer, boolean fixedHeight) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this.renderer = renderer;
        this.fixedHeight = fixedHeight;
    }

    public /* synthetic */ RoundedCellRenderer(ListCellRenderer listCellRenderer2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(listCellRenderer2, bl);
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends T> list, T value2, int index, boolean isSelected, boolean cellHasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (!ExperimentalUI.Companion.isNewUI()) {
            Component component = this.renderer.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
            return component;
        }
        Component unselectedComponent = this.renderer.getListCellRendererComponent(list, value2, index, false, cellHasFocus);
        Intrinsics.checkNotNull((Object)unselectedComponent);
        Color rowBackground = this.getBackground(unselectedComponent, list);
        Component component = this.renderer.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
        Intrinsics.checkNotNull((Object)component);
        SelectablePanel result2 = SelectablePanel.Companion.wrap(component, rowBackground);
        if (this.fixedHeight) {
            PopupUtil.configListRendererFixedHeight(result2);
        } else {
            PopupUtil.configListRendererFlexibleHeight(result2);
        }
        if (isSelected) {
            result2.setSelectionColor(this.getBackground(component, list));
        }
        ((JComponent)component).setOpaque(false);
        return result2;
    }

    private final Color getBackground(Component component, JList<?> list) {
        Color background = component.getBackground();
        return background == UIUtil.getListBackground() ? list.getBackground() : background;
    }

    @JvmOverloads
    public RoundedCellRenderer(@NotNull ListCellRenderer<T> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this(renderer, false, 2, null);
    }
}

