/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout;

import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.UiDslExceptionKt;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Grid;
import com.intellij.ui.dsl.gridLayout.impl.GridImpl;
import com.intellij.ui.dsl.gridLayout.impl.SizeConstrainsData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0018J\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u001c\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010!\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010$\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010%\u001a\u00020&2\b\u0010#\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010'\u001a\u00020&2\b\u0010#\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010(\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010)\u001a\u0004\u0018\u00010\u00182\u0006\u0010*\u001a\u00020\u0017J\u0010\u0010)\u001a\u0004\u0018\u00010\u00182\u0006\u0010+\u001a\u00020\u0005J\u0015\u0010,\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b.R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006/"}, d2={"Lcom/intellij/ui/dsl/gridLayout/GridLayout;", "Ljava/awt/LayoutManager2;", "<init>", "()V", "rootGrid", "Lcom/intellij/ui/dsl/gridLayout/Grid;", "getRootGrid", "()Lcom/intellij/ui/dsl/gridLayout/Grid;", "_rootGrid", "Lcom/intellij/ui/dsl/gridLayout/impl/GridImpl;", "respectMinimumSize", "", "getRespectMinimumSize", "()Z", "setRespectMinimumSize", "(Z)V", "addLayoutComponent", "", "comp", "Ljava/awt/Component;", "constraints", "", "setComponentConstrains", "Ljavax/swing/JComponent;", "Lcom/intellij/ui/dsl/gridLayout/Constraints;", "addLayoutSubGrid", "name", "", "removeLayoutComponent", "preferredLayoutSize", "Ljava/awt/Dimension;", "parent", "Ljava/awt/Container;", "minimumLayoutSize", "maximumLayoutSize", "target", "layoutContainer", "getLayoutAlignmentX", "", "getLayoutAlignmentY", "invalidateLayout", "getConstraints", "component", "grid", "getPreferredSizeData", "Lcom/intellij/ui/dsl/gridLayout/impl/SizeConstrainsData;", "getPreferredSizeData$intellij_platform_ide", "intellij.platform.ide"})
@ApiStatus.Experimental
public final class GridLayout
implements LayoutManager2 {
    @NotNull
    private final GridImpl _rootGrid = new GridImpl();
    @ApiStatus.Internal
    private boolean respectMinimumSize;

    @NotNull
    public final Grid getRootGrid() {
        return this._rootGrid;
    }

    public final boolean getRespectMinimumSize() {
        return this.respectMinimumSize;
    }

    public final void setRespectMinimumSize(boolean bl) {
        this.respectMinimumSize = bl;
    }

    @Override
    public void addLayoutComponent(@Nullable Component comp, @Nullable Object constraints) {
        Constraints checkedConstraints = UiDslExceptionKt.checkConstraints(constraints);
        JComponent checkedComponent = UiDslExceptionKt.checkComponent(comp);
        Grid grid = checkedConstraints.getGrid();
        Intrinsics.checkNotNull((Object)grid, (String)"null cannot be cast to non-null type com.intellij.ui.dsl.gridLayout.impl.GridImpl");
        ((GridImpl)grid).register(checkedComponent, checkedConstraints);
    }

    public final void setComponentConstrains(@NotNull JComponent comp, @NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Grid grid = constraints.getGrid();
        Intrinsics.checkNotNull((Object)grid, (String)"null cannot be cast to non-null type com.intellij.ui.dsl.gridLayout.impl.GridImpl");
        ((GridImpl)grid).setConstraints(comp, constraints);
    }

    @NotNull
    public final Grid addLayoutSubGrid(@NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        if (constraints.getWidthGroup() != null) {
            throw new UiDslException("Sub-grids cannot use widthGroup: " + constraints.getWidthGroup(), null, 2, null);
        }
        Grid grid = constraints.getGrid();
        Intrinsics.checkNotNull((Object)grid, (String)"null cannot be cast to non-null type com.intellij.ui.dsl.gridLayout.impl.GridImpl");
        return ((GridImpl)grid).registerSubGrid(constraints);
    }

    @Override
    public void addLayoutComponent(@Nullable String name, @Nullable Component comp) {
        throw new UiDslException("Method addLayoutComponent(name: String?, comp: Component?) is not supported", null, 2, null);
    }

    @Override
    public void removeLayoutComponent(@Nullable Component comp) {
        if (!this._rootGrid.unregister(UiDslExceptionKt.checkComponent(comp))) {
            throw new UiDslException("Component has not been registered: " + comp, null, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Dimension preferredLayoutSize(@Nullable Container parent) {
        if (parent == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Dimension dimension = this.getPreferredSizeData$intellij_platform_ide(parent).getPreferredSize();
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Dimension minimumLayoutSize(@Nullable Container parent) {
        if (!this.respectMinimumSize) {
            return this.preferredLayoutSize(parent);
        }
        if (parent == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Dimension dimension = this.getPreferredSizeData$intellij_platform_ide(parent).getMinimumSize();
            return dimension;
        }
    }

    @Override
    @NotNull
    public Dimension maximumLayoutSize(@Nullable Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(@Nullable Container parent) {
        if (parent == null) {
            throw new UiDslException("Parent is null", null, 2, null);
        }
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            int n = parent.getWidth();
            int n2 = parent.getHeight();
            Insets insets = parent.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            this._rootGrid.layout(n, n2, insets, this.respectMinimumSize);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public float getLayoutAlignmentX(@Nullable Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(@Nullable Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(@Nullable Container target) {
    }

    @Nullable
    public final Constraints getConstraints(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return this._rootGrid.getConstraints(component);
    }

    @Nullable
    public final Constraints getConstraints(@NotNull Grid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        return this._rootGrid.getConstraints(grid);
    }

    @ApiStatus.Internal
    @NotNull
    public final SizeConstrainsData getPreferredSizeData$intellij_platform_ide(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Insets insets = parent.getInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        return this._rootGrid.getSizeConstrainsData(insets, this.respectMinimumSize);
    }
}

