/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LightColors;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.BulkListModelKt;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchInputMethodRequests;
import com.intellij.util.Function;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.im.InputMethodRequests;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListWithFilter<T>
extends JPanel
implements UiCompatibleDataProvider {
    private final JList<T> myList;
    private final SearchTextField mySearchField;
    private final NameFilteringListModel<T> myModel;
    private final JScrollPane myScrollPane;
    private final MySpeedSearch mySpeedSearch;
    private final boolean mySearchFieldWithoutBorder;
    private boolean myAutoPackHeight;
    private final boolean mySearchAlwaysVisible;

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            ListWithFilter.$$$reportNull$$$0(0);
        }
        sink.set(PlatformDataKeys.SPEED_SEARCH_TEXT, (Object)this.mySearchField.getText());
    }

    @NotNull
    public static <T> JComponent wrap(@NotNull JList<? extends T> list, @NotNull JScrollPane scrollPane2, @Nullable Function<? super T, String> namer) {
        if (list == null) {
            ListWithFilter.$$$reportNull$$$0(1);
        }
        if (scrollPane2 == null) {
            ListWithFilter.$$$reportNull$$$0(2);
        }
        return ListWithFilter.wrap(list, scrollPane2, namer, false);
    }

    @NotNull
    public static <T> JComponent wrap(@NotNull JList<? extends T> list, @NotNull JScrollPane scrollPane2, @Nullable Function<? super T, String> namer, boolean highlightAllOccurrences) {
        if (list == null) {
            ListWithFilter.$$$reportNull$$$0(3);
        }
        if (scrollPane2 == null) {
            ListWithFilter.$$$reportNull$$$0(4);
        }
        return new ListWithFilter<T>(list, scrollPane2, namer, highlightAllOccurrences, false, false);
    }

    @NotNull
    public static <T> JComponent wrap(@NotNull JList<? extends T> list, @NotNull JScrollPane scrollPane2, @Nullable Function<? super T, String> namer, boolean highlightAllOccurrences, boolean searchFieldAlwaysVisible, boolean searchFieldWithoutBorder) {
        if (list == null) {
            ListWithFilter.$$$reportNull$$$0(5);
        }
        if (scrollPane2 == null) {
            ListWithFilter.$$$reportNull$$$0(6);
        }
        return new ListWithFilter<T>(list, scrollPane2, namer, highlightAllOccurrences, searchFieldAlwaysVisible, searchFieldWithoutBorder);
    }

    private ListWithFilter(@NotNull JList<T> list, @NotNull JScrollPane scrollPane2, @Nullable Function<? super T, String> namer, boolean highlightAllOccurrences, boolean searchAlwaysVisible, boolean searchFieldWithoutBorder) {
        if (list == null) {
            ListWithFilter.$$$reportNull$$$0(7);
        }
        if (scrollPane2 == null) {
            ListWithFilter.$$$reportNull$$$0(8);
        }
        super(new BorderLayout());
        this.mySearchField = new SearchTextField(false);
        this.myAutoPackHeight = true;
        if (list instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)((Object)list)).getEmptyText().setText(UIBundle.message("message.noMatchesFound", new Object[0]));
        }
        this.myList = list;
        this.myScrollPane = scrollPane2;
        this.mySearchAlwaysVisible = searchAlwaysVisible;
        this.mySearchFieldWithoutBorder = searchFieldWithoutBorder;
        this.mySearchField.getTextEditor().setFocusable(false);
        this.mySearchField.setVisible(this.mySearchAlwaysVisible);
        Color background = list.getBackground();
        if (this.mySearchFieldWithoutBorder) {
            this.mySearchField.setBorder(IdeBorderFactory.createBorder(8));
            this.mySearchField.getTextEditor().setBorder((Border)JBUI.Borders.empty());
            if (background != null) {
                UIUtil.setBackgroundRecursively((Component)this.mySearchField, (Color)background);
            }
        }
        this.add((Component)this.mySearchField, "North");
        this.add((Component)this.myScrollPane, "Center");
        this.mySpeedSearch = new MySpeedSearch(highlightAllOccurrences);
        this.mySpeedSearch.setEnabled(namer != null);
        this.myList.addKeyListener(this.mySpeedSearch);
        int selectedIndex = this.myList.getSelectedIndex();
        int modelSize = this.myList.getModel().getSize();
        this.myModel = new NameFilteringListModel<T>(this.myList.getModel(), namer, (Condition<? super String>)((Condition)this.mySpeedSearch::shouldBeShowing), (Computable<String>)((Computable)() -> StringUtil.notNullize((String)this.mySpeedSearch.getFilter())));
        this.myList.setModel(this.myModel);
        if (this.myModel.getSize() == modelSize) {
            this.myList.setSelectedIndex(selectedIndex);
        }
        this.myList.getActionMap().put(TransferHandler.getPasteAction().getValue("Name"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListWithFilter.this.mySpeedSearch.type((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor));
                ListWithFilter.this.mySpeedSearch.update();
            }
        });
        this.setBackground(background);
        this.enableInputMethods(true);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
        }
    }

    public boolean resetFilter() {
        boolean hadPattern = this.mySpeedSearch.isHoldingFilter();
        if (this.mySearchField.isVisible()) {
            this.mySpeedSearch.reset();
        }
        return hadPattern;
    }

    public SpeedSearch getSpeedSearch() {
        return this.mySpeedSearch;
    }

    private void onSpeedSearchPatternChanged() {
        T prevSelection = this.myList.getSelectedValue();
        BulkListModelKt.refilterListModelInBulk(this.myList);
        if (this.myModel.getSize() > 0) {
            int fullMatchIndex;
            int n = fullMatchIndex = this.mySpeedSearch.isHoldingFilter() ? this.myModel.getClosestMatchIndex() : this.myModel.getElementIndex(prevSelection);
            if (fullMatchIndex != -1) {
                ScrollingUtil.selectItem(this.myList, fullMatchIndex);
            }
            if (this.myModel.getSize() <= this.myList.getSelectedIndex() || !this.myModel.contains(this.myList.getSelectedValue())) {
                ScrollingUtil.selectItem(this.myList, 0);
            }
        } else {
            this.mySpeedSearch.noHits();
            this.revalidate();
        }
    }

    @NotNull
    public JList<T> getList() {
        JList<T> jList = this.myList;
        if (jList == null) {
            ListWithFilter.$$$reportNull$$$0(9);
        }
        return jList;
    }

    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            ListWithFilter.$$$reportNull$$$0(10);
        }
        return jScrollPane;
    }

    public void setAutoPackHeight(boolean autoPackHeight) {
        this.myAutoPackHeight = autoPackHeight;
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.mySpeedSearch.getInputMethodRequests();
    }

    @Override
    public void processInputMethodEvent(InputMethodEvent e) {
        this.mySearchField.getTextEditor().dispatchEvent(e);
        this.mySpeedSearch.updatePattern(this.mySearchField.getText());
        this.mySpeedSearch.update();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollPane";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/speedSearch/ListWithFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/speedSearch/ListWithFilter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }

    private final class MySpeedSearch
    extends SpeedSearch {
        boolean searchFieldShown;
        boolean myInUpdate;

        private MySpeedSearch(boolean highlightAllOccurrences) {
            super(highlightAllOccurrences);
            this.searchFieldShown = ListWithFilter.this.mySearchAlwaysVisible;
            ListWithFilter.this.mySearchField.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (MySpeedSearch.this.myInUpdate) {
                        return;
                    }
                    if (ListWithFilter.this.mySearchField.getText().isEmpty()) {
                        ListWithFilter.this.mySpeedSearch.reset();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/speedSearch/ListWithFilter$MySpeedSearch$1", "textChanged"));
                }
            });
            this.installSupplyTo(ListWithFilter.this.myList);
        }

        @Override
        public void update() {
            this.myInUpdate = true;
            Color searchBg = ListWithFilter.this.mySearchFieldWithoutBorder ? ListWithFilter.this.myList.getBackground() : UIUtil.getTextFieldBackground();
            ListWithFilter.this.mySearchField.getTextEditor().setBackground(searchBg);
            ListWithFilter.this.onSpeedSearchPatternChanged();
            ListWithFilter.this.mySearchField.setText(this.getFilter());
            if (!ListWithFilter.this.mySearchAlwaysVisible) {
                if (this.shouldBeActive() && !this.searchFieldShown) {
                    ListWithFilter.this.mySearchField.setVisible(true);
                    this.searchFieldShown = true;
                } else if (!this.shouldBeActive() && this.searchFieldShown) {
                    ListWithFilter.this.mySearchField.setVisible(false);
                    this.searchFieldShown = false;
                }
            }
            this.myInUpdate = false;
            this.revalidate();
        }

        @Override
        public void noHits() {
            ListWithFilter.this.mySearchField.getTextEditor().setBackground(LightColors.RED);
        }

        private void revalidate() {
            JBPopup popup2 = PopupUtil.getPopupContainerFor(ListWithFilter.this.mySearchField);
            if (popup2 != null) {
                popup2.pack(false, ListWithFilter.this.myAutoPackHeight);
            }
            ListWithFilter.this.revalidate();
        }

        @Override
        public boolean isSupported() {
            return true;
        }

        @Override
        @NotNull
        public JComponent getTextField() {
            SearchTextField searchTextField = ListWithFilter.this.mySearchField;
            if (searchTextField == null) {
                MySpeedSearch.$$$reportNull$$$0(0);
            }
            return searchTextField;
        }

        @Override
        protected void doActivate() {
            this.update();
        }

        @Override
        public InputMethodRequests getInputMethodRequests() {
            return new SpeedSearchInputMethodRequests(){

                @Override
                protected InputMethodRequests getDelegate() {
                    if (MySpeedSearch.this.searchFieldShown) {
                        return ListWithFilter.this.mySearchField.getTextEditor().getInputMethodRequests();
                    }
                    return null;
                }

                @Override
                protected void ensurePopupIsShown() {
                    if (!MySpeedSearch.this.searchFieldShown) {
                        ListWithFilter.this.mySearchField.setVisible(true);
                        MySpeedSearch.this.searchFieldShown = true;
                    }
                }
            };
        }

        @Override
        public void selectTextRange(int begin, int length) {
            if (this.searchFieldShown) {
                ListWithFilter.this.mySearchField.getTextEditor().select(begin, begin + length);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/speedSearch/ListWithFilter$MySpeedSearch", "getTextField"));
        }
    }
}

