/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splittable;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class TabSideSplitter
implements Splittable,
PropertyChangeListener {
    @NotNull
    private final JBTabsImpl tabs;
    private int sideTabsLimit;
    private final OnePixelDivider divider;

    TabSideSplitter(@NotNull JBTabsImpl tabs) {
        if (tabs == null) {
            TabSideSplitter.$$$reportNull$$$0(0);
        }
        this.sideTabsLimit = JBTabsImpl.DEFAULT_MAX_TAB_WIDTH;
        this.tabs = tabs;
        this.tabs.addPropertyChangeListener(JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY.toString(), this);
        this.divider = new OnePixelDivider(false, this);
    }

    OnePixelDivider getDivider() {
        return this.divider;
    }

    public float getMinProportion(boolean first) {
        return Math.min(0.5f, (float)JBTabsImpl.MIN_TAB_WIDTH / (float)Math.max(1, this.tabs.getWidth()));
    }

    public void setProportion(float proportion) {
        int width = this.tabs.getWidth();
        if (this.tabs.getTabsPosition() == JBTabsPosition.left) {
            this.setSideTabsLimit((int)Math.max((float)JBTabsImpl.MIN_TAB_WIDTH, proportion * (float)width));
        } else if (this.tabs.getTabsPosition() == JBTabsPosition.right) {
            this.setSideTabsLimit(width - (int)Math.max((float)JBTabsImpl.MIN_TAB_WIDTH, proportion * (float)width));
        }
    }

    int getSideTabsLimit() {
        return this.sideTabsLimit;
    }

    void setSideTabsLimit(int sideTabsLimit) {
        if (this.sideTabsLimit != sideTabsLimit) {
            JComponent page;
            this.sideTabsLimit = sideTabsLimit;
            this.tabs.putClientProperty(JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY, this.sideTabsLimit);
            this.tabs.relayout$intellij_platform_ide(true, true);
            TabInfo info = this.tabs.getSelectedInfo();
            JComponent jComponent = page = info != null ? info.getComponent() : null;
            if (page != null) {
                page.revalidate();
                page.repaint();
            }
        }
    }

    public boolean getOrientation() {
        return false;
    }

    public void setOrientation(boolean verticalSplit) {
    }

    public void setDragging(boolean dragging) {
    }

    @NotNull
    public Component asComponent() {
        JBTabsImpl jBTabsImpl = this.tabs;
        if (jBTabsImpl == null) {
            TabSideSplitter.$$$reportNull$$$0(1);
        }
        return jBTabsImpl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() != this.tabs) {
            return;
        }
        Integer limit = (Integer)ClientProperty.get((Component)this.tabs, JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY);
        if (limit == null) {
            limit = JBTabsImpl.DEFAULT_MAX_TAB_WIDTH;
        }
        this.setSideTabsLimit(limit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/impl/TabSideSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/impl/TabSideSplitter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

