/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class SingleRowLayoutStrategy {
    private static final int MIN_TAB_WIDTH = 50;
    final SingleRowLayout myLayout;
    final JBTabsImpl myTabs;

    protected SingleRowLayoutStrategy(SingleRowLayout layout) {
        this.myLayout = layout;
        this.myTabs = this.myLayout.tabs;
    }

    abstract int getMoreRectAxisSize();

    abstract int getEntryPointAxisSize();

    public abstract int getStartPosition(SingleRowPassInfo var1);

    public abstract int getToFitLength(SingleRowPassInfo var1);

    public abstract int getLengthIncrement(Dimension var1);

    public abstract int getAdditionalLength(SingleRowPassInfo var1);

    public abstract int getMinPosition(Rectangle var1);

    public abstract int getMaxPosition(Rectangle var1);

    protected abstract int getFixedFitLength(SingleRowPassInfo var1);

    public Rectangle getLayoutRect(SingleRowPassInfo data, int position, int length) {
        return this.getLayoutRec(data, position, this.getFixedPosition(data), length, this.getFixedFitLength(data));
    }

    protected abstract Rectangle getLayoutRec(SingleRowPassInfo var1, int var2, int var3, int var4, int var5);

    protected abstract int getFixedPosition(SingleRowPassInfo var1);

    protected abstract Rectangle getTitleRect(SingleRowPassInfo var1);

    public abstract Rectangle getMoreRect(SingleRowPassInfo var1);

    public abstract Rectangle getEntryPointRect(SingleRowPassInfo var1);

    public abstract boolean isToCenterTextWhenStretched();

    public abstract ShapeTransform createShapeTransform(Rectangle var1);

    public abstract void layoutComp(SingleRowPassInfo var1);

    public boolean isSideComponentOnTabs() {
        return false;
    }

    public abstract boolean isDragOut(TabLabel var1, int var2, int var3);

    @NotNull
    public Point adjustDropPoint(@NotNull Point point) {
        if (point == null) {
            SingleRowLayoutStrategy.$$$reportNull$$$0(0);
        }
        Point point2 = point;
        if (point2 == null) {
            SingleRowLayoutStrategy.$$$reportNull$$$0(1);
        }
        return point2;
    }

    public abstract boolean drawPartialOverflowTabs();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/impl/singleRow/SingleRowLayoutStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/impl/singleRow/SingleRowLayoutStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustDropPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustDropPoint";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static class Right
    extends Vertical {
        Right(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                this.myTabs.layoutComp(data, 0, 0, -this.myTabs.getHeaderFitSize().width, 0);
            }
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Right(labelRec);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return data.layoutSize.width - this.myTabs.getHeaderFitSize().width - data.insets.right;
        }

        @Override
        public Rectangle getEntryPointRect(SingleRowPassInfo data) {
            Dimension entryPointSize = this.myTabs.getEntryPointPreferredSize();
            Insets insets = this.myTabs.getActionsInsets();
            if (ExperimentalUI.isNewUI()) {
                return new Rectangle(data.layoutSize.width - entryPointSize.width - insets.right, this.myTabs.getHeight() - entryPointSize.height - data.insets.bottom - insets.bottom, entryPointSize.width, entryPointSize.height);
            }
            return new Rectangle(data.layoutSize.width - this.myTabs.getHeaderFitSize().width, this.myTabs.getHeight() - entryPointSize.height - data.insets.bottom - insets.bottom, this.myTabs.getHeaderFitSize().width, entryPointSize.height);
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            Dimension entryPointSize = this.myTabs.getEntryPointPreferredSize();
            Dimension moreToolbarSize = this.myTabs.getMoreToolbarPreferredSize();
            Insets insets = this.myTabs.getActionsInsets();
            if (ExperimentalUI.isNewUI()) {
                return new Rectangle(data.layoutSize.width - moreToolbarSize.width - entryPointSize.width - insets.right, this.myTabs.getHeight() - moreToolbarSize.height - data.insets.bottom - insets.bottom, moreToolbarSize.width, moreToolbarSize.height);
            }
            return new Rectangle(data.layoutSize.width - this.myTabs.getHeaderFitSize().width, this.myTabs.getHeight() - moreToolbarSize.height - entryPointSize.height - data.insets.bottom - insets.bottom, this.myTabs.getHeaderFitSize().width, moreToolbarSize.height);
        }

        @Override
        protected Rectangle getTitleRect(SingleRowPassInfo data) {
            return new Rectangle(data.layoutSize.width - this.myTabs.getHeaderFitSize().width, 0, this.myTabs.getHeaderFitSize().width, this.myTabs.getTitleWrapper().getPreferredSize().height);
        }
    }

    static class Left
    extends Vertical {
        Left(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                this.myTabs.layoutComp(data, this.myTabs.getHeaderFitSize().width, 0, 0, 0);
            }
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Left(labelRec);
        }

        @Override
        protected Rectangle getTitleRect(SingleRowPassInfo data) {
            return new Rectangle(0, 0, this.myTabs.getHeaderFitSize().width, this.myTabs.getTitleWrapper().getPreferredSize().height);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return data.insets.left;
        }

        @Override
        public Rectangle getEntryPointRect(SingleRowPassInfo data) {
            Insets insets = this.myTabs.getActionsInsets();
            Dimension entryPointSize = this.myTabs.getEntryPointPreferredSize();
            if (ExperimentalUI.isNewUI()) {
                return new Rectangle(this.myTabs.getHeaderFitSize().width - entryPointSize.width - data.insets.right - insets.right - 1, this.myTabs.getHeight() - entryPointSize.height - data.insets.bottom - insets.bottom, entryPointSize.width, entryPointSize.height);
            }
            return new Rectangle(data.insets.left + JBTabsImpl.getSelectionTabVShift(), this.myTabs.getHeight() - entryPointSize.height - data.insets.bottom - insets.bottom, this.myTabs.getHeaderFitSize().width, entryPointSize.height);
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            Dimension entryPointSize = this.myTabs.getEntryPointPreferredSize();
            Dimension moreToolbarSize = this.myTabs.getMoreToolbarPreferredSize();
            Insets insets = this.myTabs.getActionsInsets();
            if (ExperimentalUI.isNewUI()) {
                return new Rectangle(this.myTabs.getHeaderFitSize().width - entryPointSize.width - moreToolbarSize.width - data.insets.right - insets.right - 1, this.myTabs.getHeight() - moreToolbarSize.height - data.insets.bottom - insets.bottom, moreToolbarSize.width, moreToolbarSize.height);
            }
            return new Rectangle(data.insets.left + JBTabsImpl.getSelectionTabVShift(), this.myTabs.getHeight() - moreToolbarSize.height - entryPointSize.height - data.insets.bottom - insets.bottom - insets.top, this.myTabs.getHeaderFitSize().width, moreToolbarSize.height);
        }
    }

    static abstract class Vertical
    extends SingleRowLayoutStrategy {
        protected Vertical(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
            Rectangle bounds = tabLabel.getBounds();
            if (bounds.y + bounds.height + deltaX < 0 || bounds.y + bounds.height > tabLabel.getParent().getHeight()) {
                return true;
            }
            return (double)Math.abs(deltaX) > (double)tabLabel.getWidth() * TabLayout.getDragOutMultiplier();
        }

        @Override
        public boolean isToCenterTextWhenStretched() {
            return false;
        }

        @Override
        int getEntryPointAxisSize() {
            return this.myTabs.getEntryPointPreferredSize().height;
        }

        @Override
        int getMoreRectAxisSize() {
            return this.myTabs.getMoreToolbarPreferredSize().height;
        }

        @Override
        public int getStartPosition(SingleRowPassInfo data) {
            return data.insets.top;
        }

        @Override
        public int getToFitLength(SingleRowPassInfo data) {
            int length = this.myTabs.getHeight() - data.insets.top - data.insets.bottom;
            if (!ExperimentalUI.isNewUI()) {
                int entryPointHeight = data.entryPointAxisSize;
                Insets toolbarInsets = this.myTabs.getActionsInsets();
                int insets = toolbarInsets.top + toolbarInsets.bottom;
                length = (int)((float)length - ((float)entryPointHeight + (float)insets * Math.signum(entryPointHeight)));
            }
            return length;
        }

        @Override
        public int getLengthIncrement(Dimension labelPrefSize) {
            return labelPrefSize.height;
        }

        @Override
        public int getAdditionalLength(SingleRowPassInfo data) {
            return ExperimentalUI.isNewUI() ? JBUI.scale((int)32) : 0;
        }

        @Override
        public int getMinPosition(Rectangle bounds) {
            return (int)bounds.getMinY();
        }

        @Override
        public int getMaxPosition(Rectangle bounds) {
            return (int)bounds.getMaxY();
        }

        @Override
        public int getFixedFitLength(SingleRowPassInfo data) {
            return this.myTabs.getHeaderFitSize().width;
        }

        @Override
        public Rectangle getLayoutRec(SingleRowPassInfo data, int position, int fixedPos, int length, int fixedFitLength) {
            Rectangle baseRect = new Rectangle(fixedPos, position, fixedFitLength, length);
            if (!ExperimentalUI.isNewUI()) {
                return baseRect;
            }
            Rectangle rect = this.myTabs.getMoreToolbar().getComponent().isVisible() && !data.moreRect.isEmpty() ? data.moreRect : data.entryPointRect;
            Rectangle leftmostButtonRect = new Rectangle(rect.x - this.myTabs.getActionsInsets().left, rect.y, rect.width, rect.height);
            Rectangle intersection = baseRect.intersection(leftmostButtonRect);
            if ((double)intersection.height > (double)length * 0.4) {
                return new Rectangle(baseRect.x, baseRect.y, leftmostButtonRect.x - baseRect.x, baseRect.height);
            }
            return baseRect;
        }

        @Override
        public boolean drawPartialOverflowTabs() {
            return ExperimentalUI.isNewUI();
        }
    }

    static final class Bottom
    extends Horizontal {
        Bottom(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                this.myTabs.layoutComp(data, 0, 0, 0, -this.myTabs.getHeaderFitSize().height);
            }
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return this.myTabs.getSize().height - data.insets.bottom - this.myTabs.getHeaderFitSize().height;
        }

        @Override
        public Rectangle getEntryPointRect(SingleRowPassInfo data) {
            int x = this.myTabs.isEditorTabs() ? data.layoutSize.width - this.myTabs.getActionsInsets().right - data.entryPointAxisSize : data.position;
            return new Rectangle(x, this.getFixedPosition(data), data.entryPointAxisSize, this.myTabs.getHeaderFitSize().height);
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            int x = this.myTabs.isEditorTabs() ? data.layoutSize.width - this.myTabs.getActionsInsets().right - data.moreRectAxisSize : data.position;
            return new Rectangle(x -= data.entryPointAxisSize, this.getFixedPosition(data), data.moreRectAxisSize, this.myTabs.getHeaderFitSize().height);
        }

        @Override
        protected Rectangle getTitleRect(SingleRowPassInfo data) {
            return new Rectangle(0, this.getFixedPosition(data), this.myTabs.getTitleWrapper().getPreferredSize().width, this.myTabs.getHeaderFitSize().height);
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Bottom(labelRec);
        }
    }

    static class Top
    extends Horizontal {
        Top(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isSideComponentOnTabs() {
            return this.myTabs.getHorizontalSide() && this.myTabs.isSideComponentOnTabs();
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Top(labelRec);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return data.insets.top;
        }

        @Override
        public Rectangle getEntryPointRect(SingleRowPassInfo data) {
            int x = this.myTabs.isEditorTabs() ? data.layoutSize.width - this.myTabs.getActionsInsets().right - data.entryPointAxisSize : data.position;
            return new Rectangle(x, 1, data.entryPointAxisSize, this.myTabs.getHeaderFitSize().height);
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            int x = this.myTabs.isEditorTabs() ? data.layoutSize.width - this.myTabs.getActionsInsets().right - data.moreRectAxisSize : data.position;
            return new Rectangle(x -= data.entryPointAxisSize, 1, data.moreRectAxisSize, this.myTabs.getHeaderFitSize().height);
        }

        @Override
        protected Rectangle getTitleRect(SingleRowPassInfo data) {
            return new Rectangle(0, 0, this.myTabs.getTitleWrapper().getPreferredSize().width, this.myTabs.getHeaderFitSize().height);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                JComponent vToolbar = (JComponent)data.vToolbar.get();
                int vToolbarWidth = vToolbar != null ? vToolbar.getPreferredSize().width : 0;
                int vSeparatorWidth = vToolbarWidth > 0 ? this.myTabs.separatorWidth : 0;
                int x = vToolbarWidth > 0 ? vToolbarWidth + vSeparatorWidth : 0;
                JComponent hToolbar = (JComponent)data.hToolbar.get();
                JComponent hfToolbar = (JComponent)data.hfToolbar.get();
                int hToolbarHeight = !this.myTabs.isSideComponentOnTabs() && hToolbar != null ? hToolbar.getPreferredSize().height : 0;
                int y = this.myTabs.getHeaderFitSize().height + Math.max(hToolbarHeight, 0);
                JComponent comp = (JComponent)data.component.get();
                if (hfToolbar != null && this.myTabs.isSideComponentOnTabs()) {
                    Rectangle rec = new Rectangle(data.insets.left, data.insets.top, hfToolbar.getPreferredSize().width, this.myTabs.getHeaderFitSize().height - JBUI.scale((int)1));
                    this.myTabs.layout(hfToolbar, rec);
                }
                if (hToolbar != null) {
                    compBounds = this.myTabs.layoutComp(x, y, comp, 0, 0);
                    if (this.myTabs.isSideComponentOnTabs()) {
                        int toolbarX = (!data.moreRect.isEmpty() ? (int)data.moreRect.getMaxX() : data.position) + this.myTabs.getToolbarInset();
                        Rectangle rec = new Rectangle(toolbarX, data.insets.top, this.myTabs.getSize().width - data.insets.left - toolbarX, this.myTabs.getHeaderFitSize().height - JBUI.scale((int)1));
                        this.myTabs.layout(hToolbar, rec);
                    } else {
                        int toolbarHeight = hToolbar.getPreferredSize().height;
                        this.myTabs.layout(hToolbar, compBounds.x, compBounds.y - toolbarHeight, compBounds.width, toolbarHeight);
                    }
                } else if (vToolbar != null) {
                    if (this.myTabs.isSideComponentBefore()) {
                        compBounds = this.myTabs.layoutComp(x, y, comp, 0, 0);
                        this.myTabs.layout(vToolbar, compBounds.x - vToolbarWidth - vSeparatorWidth, compBounds.y, vToolbarWidth, compBounds.height);
                    } else {
                        int width = vToolbarWidth > 0 ? this.myTabs.getWidth() - vToolbarWidth - vSeparatorWidth : this.myTabs.getWidth();
                        Rectangle compBounds = this.myTabs.layoutComp(new Rectangle(0, y, width, this.myTabs.getHeight()), comp, 0, 0);
                        this.myTabs.layout(vToolbar, compBounds.x + compBounds.width + vSeparatorWidth, compBounds.y, vToolbarWidth, compBounds.height);
                    }
                } else {
                    this.myTabs.layoutComp(x, y, comp, 0, 0);
                }
            }
        }
    }

    static abstract class Horizontal
    extends SingleRowLayoutStrategy {
        protected Horizontal(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isToCenterTextWhenStretched() {
            return true;
        }

        @Override
        public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
            Rectangle bounds = tabLabel.getBounds();
            if (bounds.x + bounds.width + deltaX < 0 || bounds.x + bounds.width > tabLabel.getParent().getWidth()) {
                return true;
            }
            return (double)Math.abs(deltaY) > (double)tabLabel.getHeight() * TabLayout.getDragOutMultiplier();
        }

        @Override
        @NotNull
        public Point adjustDropPoint(@NotNull Point point) {
            SingleRowPassInfo layout;
            if (point == null) {
                Horizontal.$$$reportNull$$$0(0);
            }
            if ((layout = this.myLayout.lastSingRowLayout) == null) {
                Point point2 = point;
                if (point2 == null) {
                    Horizontal.$$$reportNull$$$0(1);
                }
                return point2;
            }
            Rectangle rowRect = layout.getHeaderRectangle();
            int dropTolerance = JBUI.scale((int)15);
            Point adjustedPoint = new Point(point);
            if (adjustedPoint.y >= rowRect.y - dropTolerance && adjustedPoint.y <= rowRect.y + rowRect.height + dropTolerance) {
                adjustedPoint.y = rowRect.y + rowRect.height / 2;
            }
            Point point3 = adjustedPoint;
            if (point3 == null) {
                Horizontal.$$$reportNull$$$0(2);
            }
            return point3;
        }

        @Override
        public int getMoreRectAxisSize() {
            return this.myTabs.getMoreToolbarPreferredSize().width;
        }

        @Override
        public int getEntryPointAxisSize() {
            return this.myTabs.getEntryPointPreferredSize().width;
        }

        @Override
        public int getToFitLength(SingleRowPassInfo data) {
            JComponent hfToolbar;
            int length = this.myTabs.getWidth() - data.insets.left - data.insets.right;
            JComponent hToolbar = (JComponent)data.hToolbar.get();
            if (hToolbar != null) {
                length -= hToolbar.getMinimumSize().width;
            }
            if ((hfToolbar = (JComponent)data.hfToolbar.get()) != null) {
                length -= hfToolbar.getPreferredSize().width;
            }
            length += this.getStartPosition(data);
            int entryPointWidth = this.myTabs.getEntryPointPreferredSize().width;
            Insets toolbarInsets = this.myTabs.getActionsInsets();
            int insets = toolbarInsets.left + toolbarInsets.right;
            length = (int)((float)length - ((float)entryPointWidth + (float)insets * Math.signum(entryPointWidth)));
            return length;
        }

        @Override
        public int getLengthIncrement(Dimension labelPrefSize) {
            return this.myTabs.isEditorTabs() ? Math.max(labelPrefSize.width, 50) : labelPrefSize.width;
        }

        @Override
        public int getAdditionalLength(SingleRowPassInfo data) {
            JComponent hfToolbar = (JComponent)data.hfToolbar.get();
            return hfToolbar == null ? 0 : hfToolbar.getPreferredSize().width;
        }

        @Override
        public int getMinPosition(Rectangle bounds) {
            return (int)bounds.getX();
        }

        @Override
        public int getMaxPosition(Rectangle bounds) {
            return (int)bounds.getMaxX();
        }

        @Override
        public int getFixedFitLength(SingleRowPassInfo data) {
            return this.myTabs.getHeaderFitSize().height;
        }

        @Override
        public Rectangle getLayoutRec(SingleRowPassInfo data, int position, int fixedPos, int length, int fixedFitLength) {
            return new Rectangle(position, fixedPos, length, fixedFitLength);
        }

        @Override
        public int getStartPosition(SingleRowPassInfo data) {
            JComponent hfToolbar = (JComponent)data.hfToolbar.get();
            return hfToolbar == null ? data.insets.left : data.insets.left + hfToolbar.getPreferredSize().width;
        }

        @Override
        public boolean drawPartialOverflowTabs() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tabs/impl/singleRow/SingleRowLayoutStrategy$Horizontal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tabs/impl/singleRow/SingleRowLayoutStrategy$Horizontal";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustDropPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustDropPoint";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

