/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SingleRowPassInfo
extends LayoutPassInfo {
    private final JBTabsImpl tabs;
    final Dimension layoutSize;
    final int contentCount;
    int position;
    int requiredLength;
    int toFitLength;
    public final List<TabInfo> toLayout;
    public final List<TabInfo> toDrop;
    final int entryPointAxisSize;
    final int moreRectAxisSize;
    public WeakReference<JComponent> hfToolbar;
    public WeakReference<JComponent> hToolbar;
    public WeakReference<JComponent> vToolbar;
    public Insets insets;
    public WeakReference<JComponent> component;
    public Rectangle tabRectangle;
    final int scrollOffset;

    public SingleRowPassInfo(SingleRowLayout layout, List<TabInfo> visibleInfos) {
        super(visibleInfos);
        this.tabs = layout.tabs;
        this.layoutSize = this.tabs.getSize();
        this.contentCount = this.tabs.getTabCount();
        this.toLayout = new ArrayList<TabInfo>();
        this.toDrop = new ArrayList<TabInfo>();
        this.entryPointAxisSize = layout.getStrategy().getEntryPointAxisSize();
        this.moreRectAxisSize = layout.getStrategy().getMoreRectAxisSize();
        this.scrollOffset = layout.getScrollOffset();
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    @NotNull
    public Rectangle getHeaderRectangle() {
        Rectangle rectangle = (Rectangle)this.tabRectangle.clone();
        if (rectangle == null) {
            SingleRowPassInfo.$$$reportNull$$$0(0);
        }
        return rectangle;
    }

    @Override
    public int getRequiredLength() {
        return this.requiredLength;
    }

    @Override
    public int getScrollExtent() {
        if (this.tabs.isHorizontalTabs()) {
            return !this.moreRect.isEmpty() ? this.moreRect.x - this.tabs.getActionsInsets().left : (!this.entryPointRect.isEmpty() ? this.entryPointRect.x - this.tabs.getActionsInsets().left : this.layoutSize.width);
        }
        if (ExperimentalUI.isNewUI()) {
            return this.layoutSize.height;
        }
        return !this.moreRect.isEmpty() ? this.moreRect.y - this.tabs.getActionsInsets().top : (!this.entryPointRect.isEmpty() ? this.entryPointRect.y - this.tabs.getActionsInsets().top : this.layoutSize.height);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/impl/singleRow/SingleRowPassInfo", "getHeaderRectangle"));
    }
}

