/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.themes;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001f\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0016\u0010\u0016\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u0014\u0010\u001c\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007R\u0014\u0010\u001e\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000fR\u0014\u0010 \u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000fR\u0014\u0010\"\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000fR\u0014\u0010$\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000fR\u0016\u0010&\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000fR\u0014\u0010(\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000fR\u0014\u0010*\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/intellij/ui/tabs/impl/themes/EditorTabTheme;", "Lcom/intellij/ui/tabs/impl/themes/TabTheme;", "<init>", "()V", "topBorderThickness", "", "getTopBorderThickness", "()I", "globalScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getGlobalScheme", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "background", "Ljava/awt/Color;", "getBackground", "()Ljava/awt/Color;", "borderColor", "getBorderColor", "underlineColor", "getUnderlineColor", "inactiveUnderlineColor", "getInactiveUnderlineColor", "underlinedTabBackground", "getUnderlinedTabBackground", "underlinedTabForeground", "getUnderlinedTabForeground", "underlineHeight", "getUnderlineHeight", "underlineArc", "getUnderlineArc", "hoverBackground", "getHoverBackground", "hoverInactiveBackground", "getHoverInactiveBackground", "hoverSelectedBackground", "getHoverSelectedBackground", "hoverSelectedInactiveBackground", "getHoverSelectedInactiveBackground", "underlinedTabInactiveBackground", "getUnderlinedTabInactiveBackground", "underlinedTabInactiveForeground", "getUnderlinedTabInactiveForeground", "inactiveColoredTabBackground", "getInactiveColoredTabBackground", "intellij.platform.ide"})
public final class EditorTabTheme
implements TabTheme {
    @Override
    public int getTopBorderThickness() {
        return ExperimentalUI.Companion.isNewUI() ? 1 : TabTheme.super.getTopBorderThickness();
    }

    @NotNull
    public final EditorColorsScheme getGlobalScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        return editorColorsScheme;
    }

    @Override
    @NotNull
    public Color getBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.background();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background(...)");
        return color;
    }

    @Override
    @NotNull
    public Color getBorderColor() {
        JBColor jBColor = JBColor.namedColor((String)"EditorTabs.underTabsBorderColor", (Color)JBUI.CurrentTheme.EditorTabs.borderColor());
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        return (Color)jBColor;
    }

    @Override
    @NotNull
    public Color getUnderlineColor() {
        Color color = this.getGlobalScheme().getColor(EditorColors.TAB_UNDERLINE);
        if (color == null) {
            Color color2 = JBUI.CurrentTheme.EditorTabs.underlineColor();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"underlineColor(...)");
        }
        return color;
    }

    @Override
    @NotNull
    public Color getInactiveUnderlineColor() {
        Color color = this.getGlobalScheme().getColor(EditorColors.TAB_UNDERLINE_INACTIVE);
        if (color == null) {
            Color color2 = JBUI.CurrentTheme.EditorTabs.inactiveUnderlineColor();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"inactiveUnderlineColor(...)");
        }
        return color;
    }

    @Override
    @Nullable
    public Color getUnderlinedTabBackground() {
        Color color = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED).getBackgroundColor();
        if (color == null) {
            color = JBUI.CurrentTheme.EditorTabs.underlinedTabBackground();
        }
        return color;
    }

    @Override
    @NotNull
    public Color getUnderlinedTabForeground() {
        Color color = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED).getForegroundColor();
        if (color == null) {
            Color color2 = JBUI.CurrentTheme.EditorTabs.underlinedTabForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"underlinedTabForeground(...)");
        }
        return color;
    }

    @Override
    public int getUnderlineHeight() {
        return JBUI.CurrentTheme.EditorTabs.underlineHeight();
    }

    @Override
    public int getUnderlineArc() {
        return JBUI.CurrentTheme.EditorTabs.underlineArc();
    }

    @Override
    @NotNull
    public Color getHoverBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.hoverBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"hoverBackground(...)");
        return color;
    }

    @Override
    @NotNull
    public Color getHoverInactiveBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.hoverBackground((boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"hoverBackground(...)");
        return color;
    }

    @Override
    @NotNull
    public Color getHoverSelectedBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.hoverBackground((boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"hoverBackground(...)");
        return color;
    }

    @Override
    @NotNull
    public Color getHoverSelectedInactiveBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.hoverBackground((boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"hoverBackground(...)");
        return color;
    }

    @Override
    @Nullable
    public Color getUnderlinedTabInactiveBackground() {
        Color color = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED_INACTIVE).getBackgroundColor();
        if (color == null) {
            color = this.getUnderlinedTabBackground();
        }
        return color;
    }

    @Override
    @NotNull
    public Color getUnderlinedTabInactiveForeground() {
        Color color = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED_INACTIVE).getForegroundColor();
        if (color == null) {
            color = this.getUnderlinedTabForeground();
        }
        return color;
    }

    @Override
    @NotNull
    public Color getInactiveColoredTabBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.inactiveColoredFileBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"inactiveColoredFileBackground(...)");
        return color;
    }
}

