/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.event.InputEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleNode
extends PresentableNodeDescriptor<Object>
implements ComparableObject,
LeafState.Supplier {
    protected static final SimpleNode[] NO_CHILDREN = new SimpleNode[0];

    protected SimpleNode(Project project) {
        this(project, null);
    }

    protected SimpleNode(Project project, @Nullable NodeDescriptor parentDescriptor) {
        super(project, parentDescriptor);
        this.myName = "";
    }

    protected SimpleNode(SimpleNode parent) {
        this(parent == null ? null : parent.myProject, (NodeDescriptor)parent);
    }

    public SimpleNode getChildToHighlightAt(int index) {
        return this.getChildAt(index);
    }

    protected SimpleNode() {
        super(null, null);
    }

    public String toString() {
        return this.getName();
    }

    public int getWeight() {
        return 10;
    }

    protected SimpleTextAttributes getErrorAttributes() {
        return new SimpleTextAttributes(8, this.getColor(), (Color)JBColor.RED);
    }

    protected SimpleTextAttributes getPlainAttributes() {
        Color color = this.getColor();
        return color == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : new SimpleTextAttributes(0, color);
    }

    @Nullable
    protected Object updateElement() {
        return this.getElement();
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            SimpleNode.$$$reportNull$$$0(0);
        }
        Object newElement = this.updateElement();
        if (this.getElement() != newElement) {
            presentation.setChanged(true);
        }
        if (newElement == null) {
            return;
        }
        this.doUpdate(presentation);
        this.fillFallbackProperties(presentation);
    }

    private void fillFallbackProperties(PresentationData presentation) {
        this.fillFallbackText(presentation);
        this.fillFallbackIcon(presentation);
        this.fillFallbackColor(presentation);
    }

    private void fillFallbackText(PresentationData presentation) {
        String text = SimpleNode.getColoredTextAsPlainText((PresentationData)presentation);
        if (text == null) {
            text = presentation.getPresentableText();
        }
        if (text == null) {
            text = this.myName;
        }
        presentation.setPresentableText(text);
    }

    private void fillFallbackIcon(PresentationData presentation) {
        if (presentation.getIcon(false) == null) {
            presentation.setIcon(this.myClosedIcon);
        }
    }

    private void fillFallbackColor(PresentationData presentation) {
        if (presentation.getForcedTextForeground() == null) {
            presentation.setForcedTextForeground(this.myColor);
        }
    }

    protected void doUpdate(@NotNull PresentationData presentation) {
        if (presentation == null) {
            SimpleNode.$$$reportNull$$$0(1);
        }
    }

    public Object getElement() {
        return this;
    }

    public final SimpleNode getParent() {
        return (SimpleNode)this.getParentDescriptor();
    }

    public int getIndex(SimpleNode child) {
        SimpleNode[] kids = this.getChildren();
        return ArrayUtil.indexOf((Object[])kids, (Object)((Object)child));
    }

    public abstract SimpleNode @NotNull [] getChildren();

    public void handleSelection(SimpleTree tree) {
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
    }

    @NotNull
    public LeafState getLeafState() {
        if (this.isAlwaysShowPlus()) {
            LeafState leafState = LeafState.NEVER;
            if (leafState == null) {
                SimpleNode.$$$reportNull$$$0(2);
            }
            return leafState;
        }
        if (this.isAlwaysLeaf()) {
            LeafState leafState = LeafState.ALWAYS;
            if (leafState == null) {
                SimpleNode.$$$reportNull$$$0(3);
            }
            return leafState;
        }
        LeafState leafState = LeafState.DEFAULT;
        if (leafState == null) {
            SimpleNode.$$$reportNull$$$0(4);
        }
        return leafState;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    public boolean isAutoExpandNode() {
        return false;
    }

    public boolean isAlwaysLeaf() {
        return false;
    }

    public boolean shouldHaveSeparator() {
        return false;
    }

    public Object @NotNull [] getEqualityObjects() {
        if (NONE == null) {
            SimpleNode.$$$reportNull$$$0(5);
        }
        return NONE;
    }

    public int getChildCount() {
        return this.getChildren().length;
    }

    public SimpleNode getChildAt(int i) {
        return this.getChildren()[i];
    }

    public final boolean equals(Object o) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)o);
    }

    public final int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/treeStructure/SimpleNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/treeStructure/SimpleNode";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

