/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.internal;

import com.intellij.util.net.DisabledProxyAuthPromptsManager;
import com.intellij.util.net.HttpConfigurable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/net/internal/HttpConfigurableToDisabledPromptsManager;", "Lcom/intellij/util/net/DisabledProxyAuthPromptsManager;", "getHttpConfigurable", "Lkotlin/Function0;", "Lcom/intellij/util/net/HttpConfigurable;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "httpConfigurable", "()Lcom/intellij/util/net/HttpConfigurable;", "disablePromptedAuthentication", "", "host", "", "port", "", "isPromptedAuthenticationDisabled", "", "enablePromptedAuthentication", "enableAllPromptedAuthentications", "intellij.platform.ide"})
final class HttpConfigurableToDisabledPromptsManager
implements DisabledProxyAuthPromptsManager {
    @NotNull
    private final Function0<HttpConfigurable> getHttpConfigurable;

    public HttpConfigurableToDisabledPromptsManager(@NotNull Function0<? extends HttpConfigurable> getHttpConfigurable) {
        Intrinsics.checkNotNullParameter(getHttpConfigurable, (String)"getHttpConfigurable");
        this.getHttpConfigurable = getHttpConfigurable;
    }

    private final HttpConfigurable getHttpConfigurable() {
        return (HttpConfigurable)this.getHttpConfigurable.invoke();
    }

    @Override
    public synchronized void disablePromptedAuthentication(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.getHttpConfigurable().USE_HTTP_PROXY && Intrinsics.areEqual((Object)this.getHttpConfigurable().PROXY_HOST, (Object)host) && this.getHttpConfigurable().PROXY_PORT == port) {
            this.getHttpConfigurable().AUTHENTICATION_CANCELLED = true;
        } else {
            this.getHttpConfigurable().setGenericPasswordCanceled(host, port);
        }
    }

    @Override
    public synchronized boolean isPromptedAuthenticationDisabled(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this.getHttpConfigurable().USE_HTTP_PROXY && Intrinsics.areEqual((Object)this.getHttpConfigurable().PROXY_HOST, (Object)host) && this.getHttpConfigurable().PROXY_PORT == port ? this.getHttpConfigurable().AUTHENTICATION_CANCELLED : this.getHttpConfigurable().isGenericPasswordCanceled(host, port);
    }

    @Override
    public synchronized void enablePromptedAuthentication(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.getHttpConfigurable().USE_HTTP_PROXY && Intrinsics.areEqual((Object)this.getHttpConfigurable().PROXY_HOST, (Object)host) && this.getHttpConfigurable().PROXY_PORT == port) {
            this.getHttpConfigurable().AUTHENTICATION_CANCELLED = false;
        } else {
            this.getHttpConfigurable().removeGenericPasswordCancellation(host, port);
        }
    }

    @Override
    public synchronized void enableAllPromptedAuthentications() {
        this.getHttpConfigurable().AUTHENTICATION_CANCELLED = false;
        this.getHttpConfigurable().clearGenericCancellations();
    }
}

