/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text.matching;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.text.matching.RussianToEnglishKeyboardLayoutConverter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public final class KeyboardLayoutUtil {
    private static final Map<Character, Character> ourLLtoASCII = new ConcurrentHashMap<Character, Character>();

    @Nullable
    public static Character getAsciiForChar(char a) {
        Character c = ourLLtoASCII.get(Character.valueOf(a));
        if (c != null) {
            return c;
        }
        if (ourLLtoASCII.isEmpty() || SystemInfoRt.isLinux) {
            char lc = Character.toLowerCase(a);
            c = RussianToEnglishKeyboardLayoutConverter.INSTANCE.convert(lc);
            if (c == null) {
                return null;
            }
            return Character.valueOf(lc == a ? c.charValue() : Character.toUpperCase(c.charValue()));
        }
        return null;
    }

    public static void storeAsciiForChar(int keyCode, char keyChar, int asciiFirstKeyCode, int asciiLastKeyCode) {
        if (keyCode < asciiFirstKeyCode || asciiLastKeyCode < keyCode) {
            return;
        }
        if ('a' <= keyChar && keyChar <= 'z' || 'A' <= keyChar && keyChar <= 'Z') {
            return;
        }
        if (ourLLtoASCII.containsKey(Character.valueOf(keyChar))) {
            return;
        }
        char converted = (char)(97 + (keyCode - asciiFirstKeyCode));
        if (Character.isUpperCase(keyChar)) {
            converted = Character.toUpperCase(converted);
        }
        ourLLtoASCII.put(Character.valueOf(keyChar), Character.valueOf(converted));
    }
}

