/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatusText {
    public static final SimpleTextAttributes DEFAULT_ATTRIBUTES = SimpleTextAttributes.GRAYED_ATTRIBUTES;
    private static final int DEFAULT_Y_GAP = 2;
    @Nullable
    private Component myOwner;
    @Nullable
    private Component myMouseTarget;
    @NotNull
    private final MouseMotionListener myMouseMotionListener;
    @NotNull
    private final ClickListener myClickListener;
    @NotNull
    private final HierarchyListener myHierarchyListener;
    private boolean myIsDefaultText;
    private boolean myInLoadingPanel;
    private String myText = "";
    private int yGap = 2;
    private boolean forceGapAfterLastLine = false;
    private final List<Column> columns = new ArrayList<Column>(List.of(new Column(this)));
    private boolean myHasActiveClickListeners;
    private boolean myShowAboveCenter = true;
    private Font myFont = null;
    private boolean myCenterAlignText = true;

    protected StatusText(JComponent owner2) {
        this();
        this.attachTo(owner2);
    }

    public StatusText() {
        this.myClickListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                ActionListener actionListener;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getButton() == 1 && clickCount == 1 && (actionListener = StatusText.this.findActionListenerAt(e.getPoint())) != null) {
                    actionListener.actionPerformed(new ActionEvent(e, 0, ""));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/StatusText$1", "onClick"));
            }
        };
        this.myMouseMotionListener = new MouseAdapter(){
            private Cursor myOriginalCursor;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (StatusText.this.isStatusVisibleInner()) {
                    if (StatusText.this.findActionListenerAt(e.getPoint()) != null) {
                        if (this.myOriginalCursor == null) {
                            this.myOriginalCursor = StatusText.this.myMouseTarget.getCursor();
                            StatusText.this.myMouseTarget.setCursor(Cursor.getPredefinedCursor(12));
                        }
                    } else if (this.myOriginalCursor != null) {
                        StatusText.this.myMouseTarget.setCursor(this.myOriginalCursor);
                        this.myOriginalCursor = null;
                    }
                }
            }
        };
        this.myHierarchyListener = event -> {
            if ((event.getChangeFlags() & 4L) <= 0L) {
                return;
            }
            this.myInLoadingPanel = UIUtil.getParentOfType(JBLoadingPanel.class, (Component)this.myOwner) != null;
        };
        this.setText(StatusText.getDefaultEmptyText(), DEFAULT_ATTRIBUTES);
        this.myIsDefaultText = true;
    }

    protected boolean isFontSet() {
        return this.myFont != null;
    }

    public void setFont(@NotNull Font font) {
        if (font == null) {
            StatusText.$$$reportNull$$$0(0);
        }
        this.setFontImpl(font);
    }

    public void resetFont() {
        this.setFontImpl(null);
    }

    private void setFontImpl(Font font) {
        for (Column column : this.columns) {
            for (Fragment fragment : column.fragments) {
                fragment.myComponent.setFont(font);
            }
        }
        this.myFont = font;
    }

    public boolean isCenterAlignText() {
        return this.myCenterAlignText;
    }

    public void setCenterAlignText(boolean centerAlignText) {
        this.myCenterAlignText = centerAlignText;
    }

    public void attachTo(@Nullable Component owner2) {
        this.attachTo(owner2, owner2);
    }

    public void attachTo(@Nullable Component owner2, @Nullable Component mouseTarget) {
        if (this.myOwner != null) {
            this.myOwner.removeHierarchyListener(this.myHierarchyListener);
        }
        if (this.myMouseTarget != null) {
            this.myClickListener.uninstall(this.myMouseTarget);
            this.myMouseTarget.removeMouseMotionListener(this.myMouseMotionListener);
        }
        this.myOwner = owner2;
        this.myMouseTarget = mouseTarget;
        if (this.myMouseTarget != null) {
            this.myClickListener.installOn(this.myMouseTarget);
            this.myMouseTarget.addMouseMotionListener(this.myMouseMotionListener);
        }
        if (this.myOwner != null) {
            this.myOwner.addHierarchyListener(this.myHierarchyListener);
        }
    }

    private boolean isStatusVisibleInner() {
        if (!this.isStatusVisible()) {
            return false;
        }
        if (!this.myInLoadingPanel) {
            return true;
        }
        JBLoadingPanel loadingPanel = (JBLoadingPanel)UIUtil.getParentOfType(JBLoadingPanel.class, (Component)this.myOwner);
        return loadingPanel == null || !loadingPanel.isLoading();
    }

    protected abstract boolean isStatusVisible();

    @Nullable
    private static ActionListener findListener(@NotNull SimpleColoredComponent component, @NotNull List<? extends ActionListener> listeners, int xCoord) {
        int index;
        if (component == null) {
            StatusText.$$$reportNull$$$0(1);
        }
        if (listeners == null) {
            StatusText.$$$reportNull$$$0(2);
        }
        if ((index = component.findFragmentAt(xCoord)) >= 0 && index < listeners.size()) {
            return listeners.get(index);
        }
        return null;
    }

    @Nullable
    private ActionListener findActionListenerAt(Point point) {
        if (!this.myHasActiveClickListeners || !this.isStatusVisibleInner()) {
            return null;
        }
        point = SwingUtilities.convertPoint(this.myMouseTarget, point, this.myOwner);
        Rectangle commonBounds = this.getTextComponentBound();
        if (commonBounds.contains(point)) {
            for (int columnId = 0; columnId < this.columns.size(); ++columnId) {
                ActionListener listener2 = this.getListener(columnId, point, commonBounds);
                if (listener2 == null) continue;
                return listener2;
            }
        }
        return null;
    }

    @Nullable
    private ActionListener getListener(int columnId, Point point, Rectangle commonBounds) {
        Point primaryLocation = this.getColumnLocation(columnId, commonBounds);
        Column column = this.columns.get(columnId);
        for (Fragment fragment : column.fragments) {
            ActionListener listener2;
            Rectangle fragmentBounds = this.getFragmentBounds(column, primaryLocation, commonBounds, fragment);
            if (!fragmentBounds.contains(new Point(point.x, point.y)) || (listener2 = StatusText.findListener(fragment.myComponent, fragment.myClickListeners, point.x - fragmentBounds.x)) == null) continue;
            return listener2;
        }
        return null;
    }

    protected Rectangle getTextComponentBound() {
        Rectangle ownerRec = this.myOwner == null ? new Rectangle(0, 0, 0, 0) : this.myOwner.getBounds();
        Dimension size = this.getPreferredSize();
        int x = (ownerRec.width - size.width) / 2;
        int y = (ownerRec.height - size.height) / (this.myShowAboveCenter ? 3 : 2);
        return new Rectangle(x, y, size.width, size.height);
    }

    public Point getPointBelow() {
        Rectangle textComponentBound = this.getTextComponentBound();
        return new Point(textComponentBound.x, textComponentBound.y + textComponentBound.height);
    }

    public final boolean isShowAboveCenter() {
        return this.myShowAboveCenter;
    }

    public final StatusText setShowAboveCenter(boolean showAboveCenter) {
        this.myShowAboveCenter = showAboveCenter;
        return this;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            StatusText.$$$reportNull$$$0(3);
        }
        return string;
    }

    public StatusText setText(@NlsContexts.StatusText String text) {
        return this.setText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText setText(@NlsContexts.StatusText String text, SimpleTextAttributes attrs) {
        return this.clear().appendText(text, attrs);
    }

    public StatusText clear() {
        this.myText = "";
        for (Column column : this.columns) {
            column.fragments.clear();
        }
        this.myHasActiveClickListeners = false;
        this.repaintOwner();
        return this;
    }

    private void repaintOwner() {
        if (this.myOwner != null && this.myOwner.isShowing() && this.isStatusVisibleInner()) {
            this.myOwner.repaint();
        }
    }

    public StatusText appendText(@NlsContexts.StatusText String text) {
        return this.appendText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText appendText(@NlsContexts.StatusText String text, SimpleTextAttributes attrs) {
        return this.appendText(text, attrs, null);
    }

    public StatusText appendText(@NlsContexts.StatusText String text, SimpleTextAttributes attrs, ActionListener listener2) {
        if (this.myIsDefaultText) {
            this.clear();
            this.myIsDefaultText = false;
        }
        this.myText = this.myText + text;
        return this.appendText(0, Math.max(0, this.columns.get((int)0).fragments.size() - 1), null, text, attrs, listener2);
    }

    public StatusText appendText(int columnIndex, int rowIndex, @Nullable Icon icon, @NlsContexts.StatusText String text, @NotNull SimpleTextAttributes attrs, @Nullable ActionListener listener2) {
        if (attrs == null) {
            StatusText.$$$reportNull$$$0(4);
        }
        Fragment fragment = this.getOrCreateFragment(columnIndex, rowIndex);
        fragment.myComponent.setIcon(icon);
        fragment.myComponent.append(text, attrs);
        fragment.myClickListeners.add(listener2);
        this.myHasActiveClickListeners |= listener2 != null;
        this.updateBounds();
        this.repaintOwner();
        return this;
    }

    public StatusText appendText(int columnIndex, int rowIndex, @NlsContexts.StatusText String text, @NotNull SimpleTextAttributes attrs, @Nullable ActionListener listener2) {
        if (attrs == null) {
            StatusText.$$$reportNull$$$0(5);
        }
        return this.appendText(columnIndex, rowIndex, null, text, attrs, listener2);
    }

    private void updateBounds() {
        for (Column column : this.columns) {
            this.updateBounds(column);
        }
    }

    private void updateBounds(Column column) {
        Fragment fragment;
        int i;
        Dimension size = new Dimension();
        for (i = 0; i < column.fragments.size(); ++i) {
            fragment = column.fragments.get(i);
            Dimension d = fragment.myComponent.getPreferredSize();
            fragment.boundsInColumn.setBounds(0, size.height, d.width, d.height);
            size.height += d.height;
            if (i != column.fragments.size() - 1 || this.forceGapAfterLastLine) {
                size.height += JBUIScale.scale((int)fragment.gapAfter);
            }
            size.width = Math.max(size.width, d.width);
        }
        if (this.myCenterAlignText) {
            for (i = 0; i < column.fragments.size(); ++i) {
                fragment = column.fragments.get(i);
                fragment.boundsInColumn.x += (size.width - fragment.boundsInColumn.width) / 2;
            }
        }
        column.preferredSize.setSize(size);
    }

    public Iterable<JComponent> getWrappedFragmentsIterable() {
        return new Iterable<JComponent>(){

            @Override
            @NotNull
            public Iterator<JComponent> iterator() {
                Iterator<JComponent> iterator = StatusText.this.columns.stream().flatMap(column -> column.fragments.stream()).map(fragment -> fragment.myComponent).toList().iterator();
                if (iterator == null) {
                    3.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/StatusText$3", "iterator"));
            }
        };
    }

    private Fragment getOrCreateFragment(int columnIndex, int rowIndex) {
        Fragment fragment;
        if (this.columns.size() < columnIndex) {
            throw new IllegalStateException("Cannot add text to column " + columnIndex + " as there are only " + this.columns.size() + " columns available");
        }
        if (this.columns.size() == columnIndex) {
            Column column = new Column(this);
            column.fragments.add(new Fragment(this.yGap));
            this.columns.add(column);
            return column.fragments.get(0);
        }
        Column column = this.columns.get(columnIndex);
        if (column.fragments.size() < rowIndex) {
            throw new IllegalStateException("Cannot add text to rowIndex " + rowIndex + " as in column " + columnIndex + " there are " + column.fragments.size() + " rows only");
        }
        if (column.fragments.size() == rowIndex) {
            fragment = new Fragment(this.yGap);
            if (this.myFont != null) {
                fragment.myComponent.setFont(this.myFont);
            }
            column.fragments.add(fragment);
        } else {
            fragment = column.fragments.get(rowIndex);
        }
        return fragment;
    }

    @NotNull
    public StatusText appendSecondaryText(@NlsContexts.StatusText @NotNull String text, @NotNull SimpleTextAttributes attrs, @Nullable ActionListener listener2) {
        if (text == null) {
            StatusText.$$$reportNull$$$0(6);
        }
        if (attrs == null) {
            StatusText.$$$reportNull$$$0(7);
        }
        StatusText statusText = this.appendText(0, 1, null, text, attrs, listener2);
        if (statusText == null) {
            StatusText.$$$reportNull$$$0(8);
        }
        return statusText;
    }

    @NotNull
    public StatusText appendLine(@NlsContexts.StatusText @NotNull String text) {
        if (text == null) {
            StatusText.$$$reportNull$$$0(9);
        }
        StatusText statusText = this.appendLine(text, DEFAULT_ATTRIBUTES, null);
        if (statusText == null) {
            StatusText.$$$reportNull$$$0(10);
        }
        return statusText;
    }

    public StatusText appendLine(@NlsContexts.StatusText @NotNull String text, @NotNull SimpleTextAttributes attrs, @Nullable ActionListener listener2) {
        if (text == null) {
            StatusText.$$$reportNull$$$0(11);
        }
        if (attrs == null) {
            StatusText.$$$reportNull$$$0(12);
        }
        return this.appendLine(null, text, attrs, listener2);
    }

    public StatusText appendLine(@Nullable Icon icon, @NlsContexts.StatusText @NotNull String text, @NotNull SimpleTextAttributes attrs, @Nullable ActionListener listener2) {
        if (text == null) {
            StatusText.$$$reportNull$$$0(13);
        }
        if (attrs == null) {
            StatusText.$$$reportNull$$$0(14);
        }
        if (this.myIsDefaultText) {
            this.clear();
            this.myIsDefaultText = false;
        }
        return this.appendText(0, this.columns.get((int)0).fragments.size(), icon, text, attrs, listener2);
    }

    @NotNull
    public StatusText withUnscaledGapAfter(int gap) {
        this.yGap = gap;
        StatusText statusText = this;
        if (statusText == null) {
            StatusText.$$$reportNull$$$0(15);
        }
        return statusText;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public StatusText forceGapAfterLastLine() {
        this.forceGapAfterLastLine = true;
        StatusText statusText = this;
        if (statusText == null) {
            StatusText.$$$reportNull$$$0(16);
        }
        return statusText;
    }

    public void paint(Component owner2, Graphics g) {
        if (!this.isStatusVisibleInner()) {
            return;
        }
        if (owner2 == this.myOwner) {
            this.doPaintStatusText(g, this.getTextComponentBound());
        } else {
            this.paintOnComponentUnderViewport(owner2, g);
        }
    }

    private void paintOnComponentUnderViewport(Component component, Graphics g) {
        JBViewport viewport = (JBViewport)ObjectUtils.tryCast((Object)this.myOwner, JBViewport.class);
        if (viewport == null || viewport.getView() != component || viewport.isPaintingNow()) {
            return;
        }
        Rectangle textBoundsInViewport = this.getTextComponentBound();
        int xInOwner = textBoundsInViewport.x - component.getX();
        int yInOwner = textBoundsInViewport.y - component.getY();
        Rectangle textBoundsInOwner = new Rectangle(xInOwner, yInOwner, textBoundsInViewport.width, textBoundsInViewport.height);
        this.doPaintStatusText(g, textBoundsInOwner);
        viewport.repaint(textBoundsInViewport);
    }

    private Point getColumnLocation(int columnIndex, Rectangle bounds) {
        Column column = this.columns.get(columnIndex);
        if (this.columns.size() == 1) {
            return new Point(bounds.x + (bounds.width - column.preferredSize.width) / 2, bounds.y);
        }
        if (columnIndex == 0) {
            return new Point(bounds.x, bounds.y);
        }
        if (columnIndex == this.columns.size() - 1) {
            return new Point(bounds.x + bounds.width - column.preferredSize.width, bounds.y);
        }
        int allColumnsWidth = this.columns.stream().mapToInt(it -> it.preferredSize.width).sum();
        int gap = (bounds.width - allColumnsWidth) / (this.columns.size() - 1);
        int prevColumnsWidth = this.columns.stream().limit(columnIndex).mapToInt(it -> it.preferredSize.width).sum();
        return new Point(bounds.x + prevColumnsWidth + columnIndex * gap, bounds.y);
    }

    private void doPaintStatusText(@NotNull Graphics g, @NotNull Rectangle bounds) {
        if (g == null) {
            StatusText.$$$reportNull$$$0(17);
        }
        if (bounds == null) {
            StatusText.$$$reportNull$$$0(18);
        }
        for (int columnId = 0; columnId < this.columns.size(); ++columnId) {
            this.paintColumnInBounds(this.columns.get(columnId), g, this.getColumnLocation(columnId, bounds), bounds);
        }
    }

    @NotNull
    protected Rectangle adjustComponentBounds(@NotNull JComponent component, @NotNull Rectangle bounds) {
        if (component == null) {
            StatusText.$$$reportNull$$$0(19);
        }
        if (bounds == null) {
            StatusText.$$$reportNull$$$0(20);
        }
        Dimension size = component.getPreferredSize();
        int width = Math.min(size.width, bounds.width);
        int height = Math.min(size.height, bounds.height);
        if (this.columns.size() == 1) {
            return new Rectangle(bounds.x + (bounds.width - width) / 2, bounds.y, width, height);
        }
        return component == this.getComponent() ? new Rectangle(bounds.x, bounds.y, width, height) : new Rectangle(bounds.x + bounds.width - width, bounds.y, width, height);
    }

    private void paintColumnInBounds(Column column, Graphics g, Point location, Rectangle bounds) {
        for (Fragment fragment : column.fragments) {
            Rectangle r = this.getFragmentBounds(column, location, bounds, fragment);
            StatusText.paintComponentInBounds(fragment.myComponent, g, r);
        }
    }

    @NotNull
    private Rectangle getFragmentBounds(Column column, Point columnLocation, Rectangle bounds, Fragment fragment) {
        Rectangle r = new Rectangle();
        r.setBounds(fragment.boundsInColumn);
        r.x += columnLocation.x;
        r.y += columnLocation.y;
        if (column.fragments.size() == 1) {
            r = this.adjustComponentBounds(fragment.myComponent, bounds);
        }
        Rectangle rectangle = r;
        if (rectangle == null) {
            StatusText.$$$reportNull$$$0(21);
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintComponentInBounds(@NotNull SimpleColoredComponent component, @NotNull Graphics g, @NotNull Rectangle bounds) {
        if (component == null) {
            StatusText.$$$reportNull$$$0(22);
        }
        if (g == null) {
            StatusText.$$$reportNull$$$0(23);
        }
        if (bounds == null) {
            StatusText.$$$reportNull$$$0(24);
        }
        Graphics2D g2 = (Graphics2D)g.create(bounds.x, bounds.y, bounds.width, bounds.height);
        try {
            component.setBounds(0, 0, bounds.width, bounds.height);
            component.paint(g2);
        }
        finally {
            g2.dispose();
        }
    }

    @NotNull
    public SimpleColoredComponent getComponent() {
        SimpleColoredComponent simpleColoredComponent = this.getOrCreateFragment((int)0, (int)0).myComponent;
        if (simpleColoredComponent == null) {
            StatusText.$$$reportNull$$$0(25);
        }
        return simpleColoredComponent;
    }

    @NotNull
    public SimpleColoredComponent getSecondaryComponent() {
        SimpleColoredComponent simpleColoredComponent = this.getOrCreateFragment((int)0, (int)1).myComponent;
        if (simpleColoredComponent == null) {
            StatusText.$$$reportNull$$$0(26);
        }
        return simpleColoredComponent;
    }

    public Dimension getPreferredSize() {
        int allColumnsWidth = this.columns.stream().mapToInt(it -> it.preferredSize.width).sum();
        int maxColumnHeight = this.columns.stream().mapToInt(it -> it.preferredSize.height).max().orElse(0);
        return new Dimension(allColumnsWidth, maxColumnHeight);
    }

    @NlsContexts.StatusText
    public static String getDefaultEmptyText() {
        return UIBundle.message("message.nothingToShow", new Object[0]);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        for (Column column : this.columns) {
            for (Fragment fragment : column.fragments) {
                if (!text.isEmpty()) {
                    text.append("\n");
                }
                text.append(fragment.myComponent);
            }
        }
        return text.toString();
    }

    @Deprecated(forRemoval=true)
    public StatusText appendText(boolean isPrimaryColumn, int row, @NlsContexts.StatusText String text, SimpleTextAttributes attrs, ActionListener listener2) {
        return this.appendText(isPrimaryColumn ? 0 : 1, row, null, text, attrs, listener2);
    }

    @Deprecated(forRemoval=true)
    public StatusText appendText(boolean isPrimaryColumn, int row, @Nullable Icon icon, @NlsContexts.StatusText String text, SimpleTextAttributes attrs, ActionListener listener2) {
        return this.appendText(isPrimaryColumn ? 0 : 1, row, icon, text, attrs, listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 10, 15, 16, 21, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 1: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/StatusText";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 18: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/StatusText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "appendSecondaryText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLine";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withUnscaledGapAfter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "forceGapAfterLastLine";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragmentBounds";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFont";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findListener";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 21: 
            case 25: 
            case 26: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendSecondaryText";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendLine";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doPaintStatusText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "adjustComponentBounds";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "paintComponentInBounds";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 10, 15, 16, 21, 25, 26 -> new IllegalStateException(string);
        };
    }

    protected final class Column {
        List<Fragment> fragments = new ArrayList<Fragment>();
        private final Dimension preferredSize = new Dimension();

        protected Column(StatusText this$0) {
        }
    }

    protected final class Fragment {
        private final SimpleColoredComponent myComponent = new SimpleColoredComponent(){

            @Override
            protected void revalidateAndRepaint() {
                super.revalidateAndRepaint();
                StatusText.this.updateBounds();
            }

            @Override
            public void updateUI() {
                super.updateUI();
                this.setOpaque(false);
                if (StatusText.this.myFont == null) {
                    this.setFont(StartupUiUtil.getLabelFont());
                }
                StatusText.this.updateBounds();
            }
        };
        private final Rectangle boundsInColumn = new Rectangle();
        private final List<ActionListener> myClickListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        private final int gapAfter;

        Fragment(int gapAfter) {
            this.gapAfter = gapAfter;
            this.myComponent.setOpaque(false);
            this.myComponent.setFont(StartupUiUtil.getLabelFont());
        }
    }
}

