/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.instrumentation.InstrumentationStrategy;
import com.intellij.rt.coverage.instrumentation.data.ProjectContext;
import com.intellij.rt.coverage.instrumentation.dataAccess.EmptyCoverageDataAccess;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.InputStream;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class UnloadedUtil {
    public static final MethodVisitor EMPTY_METHOD_VISITOR = new MethodVisitor(589824){
        {
            void var1_1;
        }
    };
    public static final ClassVisitor EMPTY_CLASS_VISITOR = new ClassVisitor(589824){
        {
            void var1_1;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return EMPTY_METHOD_VISITOR;
        }
    };

    /*
     * WARNING - void declaration
     */
    public static void appendUnloaded(ProjectData projectData, ClassFinder classFinder, boolean branchCoverage) {
        void var1_1;
        void var2_3;
        ProjectData projectData2;
        InstrumentationOptions options = UnloadedUtil.createOptionsFromProject(projectData, branchCoverage);
        UnloadedUtil.appendUnloaded(projectData2, new ProjectContext((InstrumentationOptions)var2_3, (ClassFinder)var1_1), true);
    }

    /*
     * WARNING - void declaration
     */
    private static InstrumentationOptions createOptionsFromProject(ProjectData projectData, boolean branchCoverage) {
        ProjectData projectData2;
        void var1_1;
        return new InstrumentationOptions.Builder().setBranchCoverage((boolean)var1_1).setIncludePatterns(projectData.getIncludePatterns()).setExcludePatterns(projectData.getExcludePatterns()).setExcludeAnnotations(projectData2.getAnnotationsToIgnore()).build();
    }

    /*
     * WARNING - void declaration
     */
    public static void appendUnloaded(ProjectData projectData, ProjectContext context) {
        void var1_1;
        UnloadedUtil.appendUnloaded(projectData, (ProjectContext)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private static void appendUnloaded(ProjectData projectData, ProjectContext context, boolean finalizeCoverage) {
        void var2_2;
        void var1_1;
        ProjectData projectData2;
        context.getClassFinder().iterateMatchedClasses(new ClassEntry.Consumer((ProjectContext)var1_1, (boolean)var2_2){
            final /* synthetic */ ProjectContext val$context;
            final /* synthetic */ boolean val$finalizeCoverage;
            {
                this.val$context = projectContext;
                this.val$finalizeCoverage = bl;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void consume(ClassEntry classEntry) {
                ClassData cd = projectData2.getClassData(classEntry.getClassName());
                if (cd != null && cd.getLines() != null && cd.isFullyAnalysed()) {
                    return;
                }
                try {
                    InputStream is = classEntry.getClassInputStream();
                    if (is == null) {
                        return;
                    }
                    UnloadedUtil.access$000(projectData2, classEntry.getClassName(), new ClassReader(is), this.val$context, this.val$finalizeCoverage);
                    return;
                }
                catch (Throwable e) {
                    void var2_3;
                    void var1_1;
                    ErrorReporter.info("Failed to process unloaded class: " + var1_1.getClassName() + ", error: " + e.getMessage(), (Throwable)var2_3);
                    return;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void appendUnloadedClass(ProjectData projectData, String className, ClassReader reader, boolean branchCoverage) {
        void var3_4;
        void var2_2;
        void var1_1;
        ProjectData projectData2;
        InstrumentationOptions options = UnloadedUtil.createOptionsFromProject(projectData, branchCoverage);
        UnloadedUtil.appendUnloadedClass(projectData2, (String)var1_1, (ClassReader)var2_2, new ProjectContext((InstrumentationOptions)var3_4), true);
    }

    /*
     * WARNING - void declaration
     */
    private static void appendUnloadedClass(ProjectData projectData, String className, ClassReader reader, ProjectContext context, boolean finalizeCoverage) {
        LineData[] lineDataArray;
        ClassVisitor cv = InstrumentationStrategy.createInstrumenter(projectData, className, reader, EMPTY_CLASS_VISITOR, context, EmptyCoverageDataAccess.INSTANCE);
        if (cv == null) {
            return;
        }
        lineDataArray.accept(cv, 4);
        ClassData classData = projectData.getClassData(className);
        if (classData == null || classData.getLines() == null) {
            return;
        }
        LineData[] lineDataArray2 = (LineData[])classData.getLines();
        lineDataArray = lineDataArray2;
        lineDataArray = lineDataArray2;
        int n = lineDataArray2.length;
        for (int i = 0; i < n; ++i) {
            LineData line = lineDataArray[i];
            if (line == null) continue;
            classData.registerMethodSignature(line);
        }
        if (finalizeCoverage) {
            void var1_1;
            ProjectData projectData2;
            void var3_3;
            var3_3.dropLineMappings(projectData2, (ClassData)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ProjectData x0, String x1, ClassReader x2, ProjectContext x3, boolean x4) {
        void var3_3;
        void var2_2;
        void var1_1;
        UnloadedUtil.appendUnloadedClass(x0, (String)var1_1, (ClassReader)var2_2, (ProjectContext)var3_3, x4);
    }
}

