/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classFilter;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.FieldVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public class PrivateConstructorOfUtilClassFilter
extends ClassFilter {
    private static final String KOTLIN_OBJECT_CONSTRUCTOR_DESCRIPTOR = "(Lkotlin/jvm/internal/DefaultConstructorMarker;)V";
    private boolean myIsAbstractClass;
    private boolean myHasMethods = false;
    private boolean myAllMethodsStatic = true;
    private boolean myHasConstFields = false;
    private boolean myAllFieldsConst = true;
    private boolean myIsCompanionObject = false;
    private boolean myIsKotlinObject = false;
    private boolean myConstructorIsEmpty = true;
    private List<Integer> myConstructorLines;
    private String myName;

    @Override
    public boolean isApplicable(InstrumentationData context) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        void var2_2;
        void var3_3;
        void var1_1;
        super.visit((int)var1_1, access, name, signature, superName, interfaces);
        this.myName = name;
        this.myIsCompanionObject |= name != null && var3_3.endsWith("$Companion");
        this.myIsAbstractClass = (var2_2 & 0x400) != 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        Type fieldType = Type.getType(descriptor);
        boolean isPublicStaticFinal = (access & 0x19) != 0;
        if (isPublicStaticFinal && "$stable".equals(name) && "I".equals(descriptor)) {
            return super.visitField(access, name, descriptor, signature, value);
        }
        boolean isInstanceField = isPublicStaticFinal && this.isObjectInstanceFieldName(name) && this.myName.equals(fieldType.getInternalName());
        this.myIsKotlinObject |= isInstanceField;
        if (!isInstanceField) {
            boolean isPrimitive = 1 <= fieldType.getSort() && fieldType.getSort() <= 8;
            boolean isString = "Ljava/lang/String;".equals(descriptor);
            boolean isConstField = isPublicStaticFinal && (isPrimitive || isString);
            this.myHasConstFields |= isConstField;
            this.myAllFieldsConst &= isConstField;
        }
        return super.visitField((int)var1_1, (String)var2_2, (String)var3_3, signature, value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        void var2_2;
        void var3_3;
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (PrivateConstructorOfUtilClassFilter.isPrivateDefaultConstructor(access, name, descriptor) || PrivateConstructorOfUtilClassFilter.isKotlinObjectSyntheticConstructor(access, name, (String)var3_3)) {
            return new EmptyConstructorVisitor(mv);
        }
        if (!"<clinit>".equals(var2_2)) {
            void var1_1;
            this.myHasMethods = true;
            this.myAllMethodsStatic &= (var1_1 & 8) != 0;
        }
        return mv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitEnd() {
        if ((this.myAllMethodsStatic || this.isKotlinObjectOrCompanion() && KotlinUtils.isKotlinClass(this.myContext)) && this.myConstructorIsEmpty && this.myConstructorLines != null && !this.isSealedClassConstructor()) {
            for (int line : this.myConstructorLines) {
                void var2_2;
                void var3_3;
                boolean hasOnlyConstFields;
                boolean isKotlinObjectWithSingleLine = this.isKotlinObjectOrCompanion() && KotlinUtils.isKotlinClass(this.myContext) && this.myContext.getLineCount() <= 1;
                boolean bl = hasOnlyConstFields = !this.myHasMethods && this.myAllFieldsConst && (this.myHasConstFields || this.myIsCompanionObject);
                if (var3_3 != false && !hasOnlyConstFields) continue;
                this.myContext.removeLine((int)var2_2);
            }
        }
        super.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSealedClassConstructor() {
        void var1_1;
        Boolean value = this.myContext.get(Key.IS_SEALED_CLASS);
        if (value != null && var1_1.booleanValue()) {
            return true;
        }
        return this.myIsAbstractClass && KotlinUtils.isKotlinClass(this.myContext);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isObjectInstanceFieldName(String name) {
        void var1_1;
        return "INSTANCE".equals(name) || "$$INSTANCE".equals(var1_1);
    }

    private boolean isKotlinObjectOrCompanion() {
        return this.myIsCompanionObject || this.myIsKotlinObject;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isPrivateDefaultConstructor(int access, String name, String descriptor) {
        void var2_2;
        void var1_1;
        return (access & 2) != 0 && "<init>".equals(var1_1) && "()V".equals(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isKotlinObjectSyntheticConstructor(int access, String name, String descriptor) {
        void var2_2;
        void var1_1;
        return (access & 0x1001) != 0 && "<init>".equals(var1_1) && KOTLIN_OBJECT_CONSTRUCTOR_DESCRIPTOR.equals(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void addLine(int line) {
        void var1_1;
        if (this.myConstructorLines == null) {
            this.myConstructorLines = new ArrayList<Integer>();
        }
        this.myConstructorLines.add((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(PrivateConstructorOfUtilClassFilter x0, int x1) {
        void var1_1;
        x0.addLine((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$102(PrivateConstructorOfUtilClassFilter x0, boolean x1) {
        void var1_1;
        x0.myConstructorIsEmpty = var1_1;
        return x0.myConstructorIsEmpty;
    }

    private class EmptyConstructorVisitor
    extends MethodVisitor {
        private boolean myALoadVisited;
        private boolean myInvokeSpecialVisited;

        /*
         * WARNING - void declaration
         */
        public EmptyConstructorVisitor(MethodVisitor methodVisitor) {
            void var2_2;
            super(589824, (MethodVisitor)var2_2);
            this.myALoadVisited = false;
            this.myInvokeSpecialVisited = false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitLineNumber(int line, Label start) {
            void var1_1;
            void var2_2;
            super.visitLineNumber(line, (Label)var2_2);
            PrivateConstructorOfUtilClassFilter.access$000(PrivateConstructorOfUtilClassFilter.this, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitVarInsn(int opcode, int var) {
            void var2_2;
            void var1_1;
            super.visitVarInsn(opcode, var);
            if (var1_1 == 25 && var2_2 == false) {
                this.myALoadVisited = true;
                return;
            }
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            void var3_3;
            void var2_2;
            void var1_1;
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            if (this.myALoadVisited && var1_1 == 183 && var2_2 != null && "<init>".equals(var3_3) && "()V".equals(descriptor)) {
                this.myInvokeSpecialVisited = true;
                return;
            }
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitInsn(int opcode) {
            void var1_1;
            super.visitInsn(opcode);
            if (this.myInvokeSpecialVisited && opcode == 177) {
                return;
            }
            if (opcode == 191 || var1_1 == 89) {
                return;
            }
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            void var3_3;
            void var2_2;
            void var1_1;
            super.visitInvokeDynamicInsn((String)var1_1, (String)var2_2, (Handle)var3_3, bootstrapMethodArguments);
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            void var3_3;
            void var2_2;
            void var1_1;
            super.visitFieldInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor);
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            void var2_2;
            void var1_1;
            super.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTypeInsn(int opcode, String type) {
            void var1_1;
            void var2_2;
            super.visitTypeInsn(opcode, (String)var2_2);
            if (var1_1 == 187) {
                return;
            }
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitIntInsn(int opcode, int operand) {
            void var2_2;
            void var1_1;
            super.visitIntInsn((int)var1_1, (int)var2_2);
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitLdcInsn(Object value) {
            void var1_1;
            super.visitLdcInsn(var1_1);
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitJumpInsn(int opcode, Label label) {
            void var2_2;
            void var1_1;
            super.visitJumpInsn((int)var1_1, (Label)var2_2);
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitIincInsn(int var, int increment) {
            void var2_2;
            void var1_1;
            super.visitIincInsn((int)var1_1, (int)var2_2);
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            void var3_3;
            void var2_2;
            void var1_1;
            super.visitLookupSwitchInsn((Label)var1_1, (int[])var2_2, (Label[])var3_3);
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            void var3_3;
            void var2_2;
            void var1_1;
            super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
            PrivateConstructorOfUtilClassFilter.access$102(PrivateConstructorOfUtilClassFilter.this, false);
        }
    }
}

