/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.TransferableIdeId;
import com.intellij.ide.startup.importSettings.controllers.TransferSettingsController;
import com.intellij.ide.startup.importSettings.data.BaseSetting;
import com.intellij.ide.startup.importSettings.data.DataForSave;
import com.intellij.ide.startup.importSettings.data.DataToApply;
import com.intellij.ide.startup.importSettings.data.DialogImportData;
import com.intellij.ide.startup.importSettings.data.ExternalProductService;
import com.intellij.ide.startup.importSettings.data.IconProductSize;
import com.intellij.ide.startup.importSettings.data.Multiple;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.models.FeatureInfo;
import com.intellij.ide.startup.importSettings.models.ILookAndFeel;
import com.intellij.ide.startup.importSettings.models.Keymap;
import com.intellij.ide.startup.importSettings.models.PluginFeature;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.SettingsPreferences;
import com.intellij.ide.startup.importSettings.models.SettingsPreferencesKind;
import com.intellij.ide.startup.importSettings.transfer.ExternalProductInfo;
import com.intellij.ide.startup.importSettings.transfer.IconExKt;
import com.intellij.ide.startup.importSettings.transfer.SettingTransferProductServiceKt;
import com.intellij.ide.startup.importSettings.transfer.ThirdPartyProductInfo;
import com.intellij.ide.startup.importSettings.transfer.ThirdPartyProductSettingItemProvider;
import com.intellij.ide.startup.importSettings.transfer.TransferSettingsProgress;
import com.intellij.ide.startup.importSettings.transfer.TransferSettingsWizardListener;
import com.intellij.ide.startup.importSettings.transfer.TransferableSetting;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00142\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/SettingTransferProductService;", "Lcom/intellij/ide/startup/importSettings/data/ExternalProductService;", "productId", "Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "ideVersions", "Lkotlinx/coroutines/Deferred;", "", "", "Lcom/intellij/ide/startup/importSettings/transfer/ThirdPartyProductInfo;", "importController", "Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsController;", "<init>", "(Lcom/intellij/ide/startup/importSettings/TransferableIdeId;Lkotlinx/coroutines/Deferred;Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsController;)V", "getProductId", "()Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "loadProductInfos", "productTitle", "getProductTitle", "()Ljava/lang/String;", "products", "", "Lcom/intellij/ide/startup/importSettings/data/Product;", "getImportablePluginIds", "itemId", "getSettings", "Lcom/intellij/ide/startup/importSettings/data/BaseSetting;", "getProductIcon", "Ljavax/swing/Icon;", "size", "Lcom/intellij/ide/startup/importSettings/data/IconProductSize;", "importSettings", "Lcom/intellij/ide/startup/importSettings/data/DialogImportData;", "data", "Lcom/intellij/ide/startup/importSettings/data/DataToApply;", "applyPreferences", "", "product", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "toApply", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nSettingTransferProductService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingTransferProductService.kt\ncom/intellij/ide/startup/importSettings/transfer/SettingTransferProductService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n82#2,2:215\n84#2:221\n82#2,2:222\n84#2:240\n82#2,2:241\n84#2:247\n82#2,3:248\n13#2:251\n1586#3:217\n1661#3,3:218\n812#3,12:224\n1586#3:236\n1661#3,3:237\n777#3:244\n873#3,2:245\n1#4:243\n*S KotlinDebug\n*F\n+ 1 SettingTransferProductService.kt\ncom/intellij/ide/startup/importSettings/transfer/SettingTransferProductService\n*L\n71#1:215,2\n71#1:221\n78#1:222,2\n78#1:240\n87#1:241,2\n87#1:247\n107#1:248,3\n37#1:251\n73#1:217\n73#1:218,3\n82#1:224,12\n82#1:236\n82#1:237,3\n94#1:244\n94#1:245,2\n*E\n"})
public final class SettingTransferProductService
implements ExternalProductService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransferableIdeId productId;
    @NotNull
    private final Deferred<Map<String, ThirdPartyProductInfo>> ideVersions;
    @NotNull
    private final TransferSettingsController importController;
    @NotNull
    private static final Logger logger;

    public SettingTransferProductService(@NotNull TransferableIdeId productId, @NotNull Deferred<? extends Map<String, ThirdPartyProductInfo>> ideVersions2, @NotNull TransferSettingsController importController) {
        Intrinsics.checkNotNullParameter((Object)((Object)productId), (String)"productId");
        Intrinsics.checkNotNullParameter(ideVersions2, (String)"ideVersions");
        Intrinsics.checkNotNullParameter((Object)importController, (String)"importController");
        this.productId = productId;
        this.ideVersions = ideVersions2;
        this.importController = importController;
    }

    @Override
    @NotNull
    public TransferableIdeId getProductId() {
        return this.productId;
    }

    private final Map<String, ThirdPartyProductInfo> loadProductInfos() {
        Deferred<Map<String, ThirdPartyProductInfo>> it = this.ideVersions;
        boolean bl = false;
        if (it.isCompleted()) {
            return (Map)it.getCompleted();
        }
        return (Map)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends ThirdPartyProductInfo>>, Object>(this, null){
            int label;
            final /* synthetic */ SettingTransferProductService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SettingTransferProductService.access$getLogger$cp().warn("Started waiting for transfer provider initialization.");
                        this.label = 1;
                        v0 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends ThirdPartyProductInfo>>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ SettingTransferProductService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = SettingTransferProductService.access$getIdeVersions$p(this.this$0).await((Continuation)this);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, ThirdPartyProductInfo>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var4_2) goto lbl13
lbl12:
                        // 1 sources

                        return var4_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            var2_3 = (Map)v0;
                        }
                        catch (Throwable var3_4) {
                            throw var3_4;
                        }
                        finally {
                            SettingTransferProductService.access$getLogger$cp().warn("Finished waiting for transfer provider initialization.");
                        }
                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, ThirdPartyProductInfo>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Override
    @NotNull
    public String getProductTitle() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getProductId().ordinal()]) {
            case 1 -> "";
            case 2 -> "";
            case 3 -> "";
            case 4 -> "";
            case 5 -> "Visual Studio";
            case 6 -> "Visual Studio for Mac";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Product> products() {
        List list;
        Object object;
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            void $this$mapTo$iv$iv;
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            Collection<ThirdPartyProductInfo> versions2 = this.loadProductInfos().values();
            Iterable $this$map$iv = versions2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ThirdPartyProductInfo thirdPartyProductInfo = (ThirdPartyProductInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(ExternalProductInfo.Companion.ofIdeVersion(it.getProduct()));
            }
            object = Result.constructor-impl((Object)((List)destination$iv$iv));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if ((list = (List)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getImportablePluginIds(@NotNull String itemId) {
        List list;
        Object object;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            Map<String, ThirdPartyProductInfo> versions2 = this.loadProductInfos();
            ThirdPartyProductInfo thirdPartyProductInfo = versions2.get(itemId);
            if (thirdPartyProductInfo == null) {
                return CollectionsKt.emptyList();
            }
            ThirdPartyProductInfo product = thirdPartyProductInfo;
            Settings settings = product.getSettingsQuickly();
            if (settings == null) {
                throw new IllegalStateException(("Cannot load settings for " + itemId + " quickly.").toString());
            }
            Settings settings2 = settings;
            Iterable $this$filterIsInstance$iv = settings2.getPlugins().values();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PluginFeature)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PluginFeature pluginFeature = (PluginFeature)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getPluginId());
            }
            object = Result.constructor-impl((Object)((List)destination$iv$iv));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if ((list = (List)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<BaseSetting> getSettings(@NotNull String itemId) {
        List list;
        Object object;
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Object object2;
            void $this$filterTo$iv$iv;
            Object object3;
            Object p0;
            Object object4;
            List list2;
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            Map<String, ThirdPartyProductInfo> versions2 = this.loadProductInfos();
            ThirdPartyProductInfo thirdPartyProductInfo = versions2.get(itemId);
            if (thirdPartyProductInfo == null) {
                return CollectionsKt.emptyList();
            }
            ThirdPartyProductInfo product = thirdPartyProductInfo;
            Settings settings = product.getSettingsQuickly();
            if (settings == null) {
                throw new IllegalStateException(("Cannot load settings for " + itemId + " quickly.").toString());
            }
            Settings settings2 = settings;
            List $this$getSettings_u24lambda_u240_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl3 = false;
            Object object5 = settings2.getLaf();
            if (object5 != null) {
                object4 = object5;
                TransferableSetting.Companion companion = TransferableSetting.Companion;
                ILookAndFeel p02 = object4;
                boolean bl4 = false;
                TransferableSetting transferableSetting = companion.uiTheme(p02);
                object5 = transferableSetting;
                if (transferableSetting != null) {
                    p0 = (BaseSetting)object5;
                    boolean bl5 = false;
                    $this$getSettings_u24lambda_u240_u240.add(p0);
                }
            }
            if ((object3 = settings2.getKeymap()) != null) {
                object4 = object3;
                p0 = TransferableSetting.Companion;
                Object p03 = object4;
                boolean bl6 = false;
                Multiple multiple = ((TransferableSetting.Companion)p0).keymap((Keymap)p03);
                object3 = multiple;
                if (multiple != null) {
                    p0 = (BaseSetting)object3;
                    boolean bl7 = false;
                    $this$getSettings_u24lambda_u240_u240.add(p0);
                }
            }
            Iterable $this$filter$iv = settings2.getPlugins().values();
            boolean $i$f$filter = false;
            object4 = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FeatureInfo it = (FeatureInfo)element$iv$iv;
                boolean bl8 = false;
                if (!(!it.isHidden())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List it = (List)destination$iv$iv;
            boolean bl9 = false;
            if (!((Collection)it).isEmpty()) {
                $this$getSettings_u24lambda_u240_u240.add(TransferableSetting.Companion.plugins(it));
            }
            if ((object2 = UtilKt.nullize(settings2.getRecentProjects())) != null) {
                List list3 = object2;
                destination$iv$iv = TransferableSetting.Companion;
                List p04 = list3;
                boolean bl10 = false;
                Multiple multiple = ((TransferableSetting.Companion)destination$iv$iv).recentProjects(p04);
                object2 = multiple;
                if (multiple != null) {
                    p0 = (BaseSetting)object2;
                    boolean bl11 = false;
                    $this$getSettings_u24lambda_u240_u240.add(p0);
                }
            }
            $this$getSettings_u24lambda_u240_u240.addAll((Collection)ThirdPartyProductSettingItemProvider.Companion.generateSettingItems(product.getProduct().getTransferableId(), settings2));
            object = Result.constructor-impl((Object)CollectionsKt.build((List)list2));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if ((list = (List)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Icon getProductIcon(@NotNull String itemId, @NotNull IconProductSize size) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)((Object)size), (String)"size");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            ThirdPartyProductInfo thirdPartyProductInfo = this.loadProductInfos().get(itemId);
            if (thirdPartyProductInfo == null) {
                return null;
            }
            ThirdPartyProductInfo info = thirdPartyProductInfo;
            return IconExKt.icon(info.getProduct().getTransferableId(), size);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return (Icon)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
    }

    @Override
    @NotNull
    public DialogImportData importSettings(@NotNull String productId, @NotNull DataToApply data) {
        Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            ThirdPartyProductInfo thirdPartyProductInfo = this.loadProductInfos().get(productId);
            if (thirdPartyProductInfo == null) {
                Object object = new Object[]{productId};
                object = ImportSettingsBundle.INSTANCE.message("transfer.error.product-not-found", (Object[])object);
                throw new IllegalStateException(object.toString());
            }
            ThirdPartyProductInfo info = thirdPartyProductInfo;
            IdeVersion product = info.getProduct();
            this.applyPreferences(product, data);
            TransferSettingsProgress importData = new TransferSettingsProgress(product);
            ProgressIndicator progressIndicator = importData.createProgressIndicatorAdapter();
            LifetimeDefinition importLifetime = new LifetimeDefinition();
            SettingsService.Companion.getInstance().getImportCancelled().advise(importLifetime.getLifetime(), arg_0 -> SettingTransferProductService.importSettings$lambda$0(progressIndicator, arg_0));
            this.importController.addListener(new TransferSettingsWizardListener(importLifetime));
            this.importController.performImport(null, product, progressIndicator);
            return importData;
        }
        catch (Throwable t) {
            if (t instanceof CancellationException) {
                throw t;
            }
            logger.error(t);
            SettingTransferProductServiceKt.access$showImportErrorNotification(t);
            return SettingTransferProductServiceKt.access$dummyImportData();
        }
    }

    private final void applyPreferences(IdeVersion product, DataToApply toApply) {
        Set selectedIds = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)toApply.getImportSettings()), SettingTransferProductService::applyPreferences$lambda$0));
        Settings settings = product.getSettingsCache();
        SettingsPreferences preferences = settings.getPreferences();
        boolean pluginImportRequestedByUser = selectedIds.contains("plugins");
        preferences.set(SettingsPreferencesKind.Laf, selectedIds.contains("ui"));
        preferences.set(SettingsPreferencesKind.SyntaxScheme, selectedIds.contains("ui"));
        preferences.set(SettingsPreferencesKind.Keymap, selectedIds.contains("keymap"));
        preferences.set(SettingsPreferencesKind.Plugins, pluginImportRequestedByUser || !((Collection)toApply.getFeaturedPluginIds()).isEmpty());
        preferences.set(SettingsPreferencesKind.RecentProjects, selectedIds.contains("recentProjects"));
        if (!pluginImportRequestedByUser) {
            settings.getPlugins().clear();
        }
        Sequence featuredPluginsToAdd = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)toApply.getFeaturedPluginIds()), SettingTransferProductService::applyPreferences$lambda$1);
        MapsKt.putAll(settings.getPlugins(), (Sequence)featuredPluginsToAdd);
        Sequence featuresToRemove = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(settings.getPlugins()), SettingTransferProductService::applyPreferences$lambda$2), SettingTransferProductService::applyPreferences$lambda$3);
        settings.getPlugins().keySet().removeAll(SequencesKt.toSet((Sequence)featuresToRemove));
    }

    private static final Unit importSettings$lambda$0(ProgressIndicator $progressIndicator, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $progressIndicator.cancel();
        return Unit.INSTANCE;
    }

    private static final String applyPreferences$lambda$0(DataForSave it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId();
    }

    private static final Pair applyPreferences$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TuplesKt.to((Object)it, (Object)new PluginFeature(null, it, it, null, false, 24, null));
    }

    private static final boolean applyPreferences$lambda$2(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        FeatureInfo feature = (FeatureInfo)entry.getValue();
        return feature instanceof PluginFeature ? PluginManagerCore.isPluginInstalled((PluginId)PluginId.Companion.getId(((PluginFeature)feature).getPluginId())) : true;
    }

    private static final String applyPreferences$lambda$3(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getKey();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Deferred access$getIdeVersions$p(SettingTransferProductService $this) {
        return $this.ideVersions;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingTransferProductService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SettingTransferProductService.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/SettingTransferProductService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransferableIdeId.values().length];
            try {
                nArray[TransferableIdeId.DummyIde.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferableIdeId.VSCode.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferableIdeId.Cursor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferableIdeId.Windsurf.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferableIdeId.VisualStudio.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferableIdeId.VisualStudioForMac.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

