/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer;

import com.intellij.ide.startup.importSettings.controllers.TransferSettingsListener;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsPerformContext;
import com.intellij.ide.startup.importSettings.transfer.SettingTransferProductServiceKt;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.PluginInstallationState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/TransferSettingsWizardListener;", "Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsListener;", "ld", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "importStarted", "", "ideVersion", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "importFailed", "throwable", "", "importPerformed", "context", "Lcom/intellij/ide/startup/importSettings/providers/TransferSettingsPerformContext;", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nSettingTransferProductService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingTransferProductService.kt\ncom/intellij/ide/startup/importSettings/transfer/TransferSettingsWizardListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,214:1\n23#2:215\n23#2:216\n23#2:217\n*S KotlinDebug\n*F\n+ 1 SettingTransferProductService.kt\ncom/intellij/ide/startup/importSettings/transfer/TransferSettingsWizardListener\n*L\n175#1:215\n180#1:216\n186#1:217\n*E\n"})
public final class TransferSettingsWizardListener
implements TransferSettingsListener {
    @NotNull
    private final LifetimeDefinition ld;

    public TransferSettingsWizardListener(@NotNull LifetimeDefinition ld) {
        Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
        this.ld = ld;
    }

    @Override
    public void importStarted(@NotNull IdeVersion ideVersion, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        TransferSettingsWizardListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TransferSettingsWizardListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Settings import from " + ideVersion.getName() + " has been started.");
    }

    @Override
    public void importFailed(@NotNull IdeVersion ideVersion, @NotNull Settings settings, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.ld, (boolean)false, (int)1, null);
        TransferSettingsWizardListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TransferSettingsWizardListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Setting import error from " + ideVersion.getName() + ".", throwable);
        SettingTransferProductServiceKt.access$showImportErrorNotification(throwable);
    }

    @Override
    public void importPerformed(@NotNull IdeVersion ideVersion, @NotNull Settings settings, @NotNull TransferSettingsPerformContext context) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.ld, (boolean)false, (int)1, null);
        TransferSettingsWizardListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TransferSettingsWizardListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Setting import error from " + ideVersion.getName() + " has been finished, plugin state: " + context.getPluginInstallationState() + ".");
        SettingsService.Companion.getInstance().getDoClose().fire((Object)Unit.INSTANCE);
        if (context.getPluginInstallationState() == PluginInstallationState.RestartRequired) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }
}

