/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.settings;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.listeners.JupyterConnectionSettingsListener;
import com.intellij.jupyter.core.jupyter.connections.settings.provider.JupyterConnectionProvider;
import com.intellij.jupyter.core.jupyter.connections.settings.state.JupyterModuleConfigState;
import com.intellij.jupyter.core.jupyter.connections.settings.state.JupyterServerConfigState;
import com.intellij.jupyter.core.jupyter.connections.settings.state.JupyterServerSecretState;
import com.intellij.jupyter.core.jupyter.connections.settings.state.JupyterVirtualFileConfigState;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.jupyter.core.premium.JupyterLicence;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 B2\u00020\u0001:\u0001BB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u000eJ\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u000fJ\u0006\u0010\"\u001a\u00020\u000fJ\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000eH\u0007J \u0010'\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000fH\u0007J\u0016\u0010)\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000eJ\u0018\u0010*\u001a\u00020\u000f2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010$\u001a\u00020%J\u001a\u0010-\u001a\u0004\u0018\u00010\u000f2\b\u0010.\u001a\u0004\u0018\u00010,2\u0006\u0010$\u001a\u00020%J\u0016\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u0002012\u0006\u0010!\u001a\u00020\u000fJ\u0016\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u0002012\u0006\u0010\u001d\u001a\u00020\u000eJ\u000e\u00102\u001a\u00020\u00152\u0006\u00100\u001a\u000201J\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e04J\u0010\u00105\u001a\u0004\u0018\u00010\u000f2\u0006\u00106\u001a\u00020\u000eJ\u0012\u00107\u001a\u0004\u0018\u00010\u000f2\u0006\u0010+\u001a\u000201H\u0002J\u0010\u00108\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u000fH\u0002J\u0010\u00109\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u000fH\u0002J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u001bH\u0002J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u001bH\u0002J\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020\u0015J\u0006\u0010A\u001a\u00020?R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR'\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006C"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "configStorage", "Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterServerConfigState;", "getConfigStorage", "()Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterServerConfigState;", "jupyterFileConfigStorage", "Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState;", "getJupyterFileConfigStorage", "()Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState;", "settings", "", "", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "getSettings", "()Ljava/util/Map;", "settings$delegate", "Lkotlin/Lazy;", "addListener", "", "eventListener", "Lcom/intellij/jupyter/core/jupyter/connections/settings/listeners/JupyterConnectionSettingsListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "getAll", "", "getConfig", "configId", "addOrUpdateConfig", "new", "removeConfig", "config", "getDefaultConfig", "getConfigForModule", "project", "Lcom/intellij/openapi/project/Project;", "moduleFilePath", "setConfigForModule", "modulePath", "removeConfigForModule", "getConfigForVirtualFileOrDefault", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getConfigForVirtualFile", "notebookVirtualFile", "setConfigForFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "removeConfigForFile", "getKnownAuthorities", "", "getConnectionSettingsForAuthority", "authority", "getCachedConfigForVirtualFile", "addInternalConfig", "removeInternalConfig", "loadManaged", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterManagedServerConfig;", "loadConfigured", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterConfiguredServerConfig;", "isMigrated", "", "setIsMigrated", "isMoreThanOneManaged", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterConnectionSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConnectionSettingsManager.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n777#2:232\n873#2,2:233\n296#2,2:237\n296#2,2:239\n1586#2:241\n1661#2,3:242\n296#2,2:245\n296#2,2:247\n1586#2:250\n1661#2,3:251\n1220#2,2:254\n1249#2,4:256\n14060#3,2:235\n1#4:249\n*S KotlinDebug\n*F\n+ 1 JupyterConnectionSettingsManager.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager\n*L\n57#1:232\n57#1:233,2\n110#1:237,2\n111#1:239,2\n170#1:241\n170#1:242,3\n175#1:245,2\n178#1:247,2\n212#1:250\n212#1:251,3\n40#1:254,2\n40#1:256,4\n92#1:235,2\n*E\n"})
public final class JupyterConnectionSettingsManager
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy settings$delegate = LazyKt.lazy(() -> JupyterConnectionSettingsManager.settings_delegate$lambda$0(this));
    @NotNull
    private static final JupyterConnectionSettingsListener notifier = (JupyterConnectionSettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JupyterConnectionSettingsListener.Companion.getJUPYTER_CONFIGS_TOPIC());

    public JupyterConnectionSettingsManager() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JupyterCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ JupyterConnectionSettingsManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.this$0.getSettings();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    private final JupyterServerConfigState getConfigStorage() {
        return JupyterServerConfigState.Companion.getInstance();
    }

    private final JupyterVirtualFileConfigState getJupyterFileConfigStorage() {
        return JupyterVirtualFileConfigState.Companion.getInstance();
    }

    private final Map<String, JupyterServerConfig> getSettings() {
        Lazy lazy = this.settings$delegate;
        return (Map)lazy.getValue();
    }

    public final void addListener(@NotNull JupyterConnectionSettingsListener eventListener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(JupyterConnectionSettingsListener.Companion.getJUPYTER_CONFIGS_TOPIC(), (Object)eventListener);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JupyterServerConfig> getAll() {
        void $this$filterTo$iv$iv;
        boolean isPaid = JupyterLicence.INSTANCE.isPaidVersion();
        Iterable $this$filter$iv = CollectionsKt.toList((Iterable)this.getSettings().values());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JupyterServerConfig it = (JupyterServerConfig)element$iv$iv;
            boolean bl = false;
            JupyterServerConfig jupyterServerConfig = it;
            boolean bl2 = jupyterServerConfig instanceof JupyterManagedServerConfig ? true : (jupyterServerConfig instanceof JupyterConfiguredServerConfig ? isPaid : false);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List serverConfigs = (List)destination$iv$iv;
        List<JupyterServerConfig> additionalConfigs = JupyterConnectionProvider.Companion.getConfigs();
        return CollectionsKt.plus((Collection)serverConfigs, (Iterable)additionalConfigs);
    }

    @Nullable
    public final JupyterServerConfig getConfig(@NotNull String configId) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        JupyterServerConfig jupyterServerConfig = this.getSettings().get(configId);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = JupyterConnectionProvider.Companion.getConfigById(configId);
        }
        return jupyterServerConfig;
    }

    public final void addOrUpdateConfig(@NotNull JupyterServerConfig jupyterServerConfig) {
        Intrinsics.checkNotNullParameter((Object)jupyterServerConfig, (String)"new");
        JupyterServerConfig old = this.getConfig(jupyterServerConfig.getId());
        if (Intrinsics.areEqual((Object)old, (Object)jupyterServerConfig)) {
            return;
        }
        if (old != null) {
            this.removeInternalConfig(old);
            this.addInternalConfig(jupyterServerConfig);
            notifier.connectionUpdated(old, jupyterServerConfig);
        } else {
            this.addInternalConfig(jupyterServerConfig);
            notifier.connectionAdded(jupyterServerConfig);
        }
        JupyterCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Application application = ApplicationManager.getApplication();
                        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                        this.label = 1;
                        Object object2 = StoreUtilKt.saveSettings((ComponentManager)((ComponentManager)application), (boolean)true, (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void removeConfig(@NotNull JupyterServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.removeInternalConfig(config);
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            JupyterModuleConfigState.Companion.getInstance(it).clearConfig(config.getId());
        }
        this.getJupyterFileConfigStorage().clearConfig(config.getId());
        notifier.connectionRemoved(config);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JupyterCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int I$0;
                int I$1;
                int I$2;
                Object L$0;
                Object L$1;
                int label;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $i$f$runInAutoSaveDisabledMode = 0;
                            var3_5 = (AutoCloseable)SaveAndSyncHandler.Companion.getInstance().disableAutoSave();
                            var4_6 = null;
                            it$iv = (AccessToken)var3_5;
                            $i$a$-use-StoreUtilKt$runInAutoSaveDisabledMode$1$iv = 0;
                            $i$a$-runInAutoSaveDisabledMode-JupyterConnectionSettingsManager$removeConfig$2$1 = 0;
                            v0 = ApplicationManager.getApplication();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                            this.L$0 = var3_5;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)it$iv);
                            this.I$0 = $i$f$runInAutoSaveDisabledMode;
                            this.I$1 = $i$a$-use-StoreUtilKt$runInAutoSaveDisabledMode$1$iv;
                            this.I$2 = $i$a$-runInAutoSaveDisabledMode-JupyterConnectionSettingsManager$removeConfig$2$1;
                            this.label = 1;
                            v1 = StoreUtilKt.saveSettings$default((ComponentManager)((ComponentManager)v0), (boolean)false, (Continuation)this, (int)2, null);
                            ** if (v1 != var8_2) goto lbl25
lbl24:
                            // 1 sources

                            return var8_2;
lbl25:
                            // 1 sources

                            ** GOTO lbl37
                        }
                        case 1: {
                            $i$a$-runInAutoSaveDisabledMode-JupyterConnectionSettingsManager$removeConfig$2$1 = this.I$2;
                            $i$a$-use-StoreUtilKt$runInAutoSaveDisabledMode$1$iv = this.I$1;
                            $i$f$runInAutoSaveDisabledMode = this.I$0;
                            it$iv = (AccessToken)this.L$1;
                            var4_6 = null;
                            var3_5 = (AutoCloseable)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl37:
                                // 2 sources

                                var7_15 = Unit.INSTANCE;
                                ** GOTO lbl47
                            }
                            catch (Throwable var6_11) {
                                var4_6 = var6_11;
                                throw var6_11;
                            }
                        }
                        catch (Throwable var6_12) {
                            throw var6_12;
                        }
                        {
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)var3_5, (Throwable)var4_6);
                            }
lbl47:
                            // 1 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    @NotNull
    public final JupyterServerConfig getDefaultConfig() {
        JupyterServerConfig jupyterServerConfig;
        Object v0;
        List<JupyterServerConfig> configs;
        block4: {
            configs = this.getAll();
            Iterable $this$firstOrNull$iv = configs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JupyterServerConfig it = (JupyterServerConfig)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)JupyterManagedServerConfig.Companion.getDEFAULT().getId())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        if ((jupyterServerConfig = (JupyterServerConfig)v0) == null) {
            Object v2;
            block5: {
                Iterable $this$firstOrNull$iv = configs;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JupyterServerConfig it = (JupyterServerConfig)element$iv;
                    boolean bl = false;
                    if (!(it instanceof JupyterManagedServerConfig)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            if ((jupyterServerConfig = (JupyterServerConfig)v2) == null && (jupyterServerConfig = (JupyterServerConfig)CollectionsKt.firstOrNull(configs)) == null) {
                jupyterServerConfig = JupyterManagedServerConfig.Companion.getDEFAULT();
            }
        }
        return jupyterServerConfig;
    }

    @VisibleForTesting
    @NotNull
    public final JupyterServerConfig getConfigForModule(@NotNull Project project, @NotNull String moduleFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleFilePath, (String)"moduleFilePath");
        String string = JupyterModuleConfigState.Companion.getInstance(project).getModuleConfig(moduleFilePath);
        if (string == null) {
            return this.getDefaultConfig();
        }
        String savedConfigId = string;
        JupyterServerConfig jupyterServerConfig = this.getConfig(savedConfigId);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = this.getDefaultConfig();
        }
        JupyterServerConfig config = jupyterServerConfig;
        return config;
    }

    @VisibleForTesting
    public final void setConfigForModule(@NotNull Project project, @NotNull String modulePath, @NotNull JupyterServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        JupyterModuleConfigState.Companion.getInstance(project).registerModuleConfig(modulePath, config.getId());
    }

    @NotNull
    public final JupyterServerConfig removeConfigForModule(@NotNull Project project, @NotNull String moduleFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleFilePath, (String)"moduleFilePath");
        JupyterModuleConfigState moduleConfigState = JupyterModuleConfigState.Companion.getInstance(project);
        String string = moduleConfigState.getModuleConfig(moduleFilePath);
        if (string == null) {
            return this.getDefaultConfig();
        }
        String savedConfigId = string;
        JupyterServerConfig jupyterServerConfig = this.getConfig(savedConfigId);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = this.getDefaultConfig();
        }
        JupyterServerConfig config = jupyterServerConfig;
        return config;
    }

    @NotNull
    public final JupyterServerConfig getConfigForVirtualFileOrDefault(@Nullable BackedNotebookVirtualFile virtualFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JupyterServerConfig jupyterServerConfig = this.getConfigForVirtualFile(virtualFile, project);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = this.getDefaultConfig();
        }
        return jupyterServerConfig;
    }

    @Nullable
    public final JupyterServerConfig getConfigForVirtualFile(@Nullable BackedNotebookVirtualFile notebookVirtualFile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (notebookVirtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile = notebookVirtualFile2.getFile();
        if (virtualFile instanceof JupyterRemoteVirtualFile) {
            String authority = ((JupyterRemoteVirtualFile)virtualFile).getRemotePath().getAuthority();
            return this.getConnectionSettingsForAuthority(authority);
        }
        JupyterServerConfig cachedConfig = this.getCachedConfigForVirtualFile(virtualFile);
        if (cachedConfig != null) {
            return cachedConfig;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        String string = module2.getModuleFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModuleFilePath(...)");
        return this.getConfigForModule(project, string);
    }

    public final void setConfigForFile(@NotNull VirtualFile file, @NotNull JupyterServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.setConfigForFile(file, config.getId());
    }

    public final void setConfigForFile(@NotNull VirtualFile file, @NotNull String configId) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        this.getJupyterFileConfigStorage().registerFileConfig(file, configId);
    }

    public final void removeConfigForFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.getJupyterFileConfigStorage().removeFileConfig(file);
    }

    @NotNull
    public final Collection<String> getKnownAuthorities() {
        JupyterServerConfig it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getConfigStorage().getAllConfigured();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JupyterConfiguredServerConfig jupyterConfiguredServerConfig = (JupyterConfiguredServerConfig)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((JupyterConfiguredServerConfig)it).getName());
        }
        $this$map$iv = JupyterConnectionProvider.Companion.getConfigs();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (JupyterServerConfig)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getAuthority());
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final JupyterServerConfig getConnectionSettingsForAuthority(@NotNull String authority) {
        Object v1;
        block4: {
            Object v0;
            JupyterServerConfig it;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block3: {
                Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
                $this$firstOrNull$iv = this.getAll();
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (JupyterServerConfig)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getAuthority(), (Object)authority)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            JupyterServerConfig baseConnection = v0;
            if (baseConnection != null) {
                return baseConnection;
            }
            $this$firstOrNull$iv = JupyterConnectionProvider.Companion.getConfigs();
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (JupyterServerConfig)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAuthority(), (Object)authority)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    private final JupyterServerConfig getCachedConfigForVirtualFile(VirtualFile virtualFile) {
        JupyterServerConfig jupyterServerConfig;
        JupyterServerConfig config;
        String string = this.getJupyterFileConfigStorage().getFileConfig(virtualFile);
        if (string == null) {
            return null;
        }
        String fileConfigId = string;
        JupyterServerConfig jupyterServerConfig2 = config = this.getConfig(fileConfigId);
        if (jupyterServerConfig2 != null) {
            JupyterServerConfig jupyterServerConfig3;
            JupyterServerConfig it = jupyterServerConfig3 = jupyterServerConfig2;
            boolean bl = false;
            jupyterServerConfig = !Intrinsics.areEqual((Object)it, (Object)this.getDefaultConfig()) ? jupyterServerConfig3 : null;
        } else {
            jupyterServerConfig = null;
        }
        return jupyterServerConfig;
    }

    private final void addInternalConfig(JupyterServerConfig config) {
        JupyterServerConfig jupyterServerConfig = config;
        if (jupyterServerConfig instanceof JupyterConfiguredServerConfig) {
            this.getConfigStorage().addConfigured((JupyterConfiguredServerConfig)config);
            JupyterServerSecretState.INSTANCE.saveConfiguredSettings((JupyterConfiguredServerConfig)config);
            Map<String, JupyterServerConfig> map = this.getSettings();
            Pair pair = TuplesKt.to((Object)((JupyterConfiguredServerConfig)config).getId(), (Object)config);
            map.put((String)pair.getFirst(), (JupyterServerConfig)pair.getSecond());
        } else if (jupyterServerConfig instanceof JupyterManagedServerConfig) {
            this.getConfigStorage().addManaged((JupyterManagedServerConfig)config);
            Map<String, JupyterServerConfig> map = this.getSettings();
            Pair pair = TuplesKt.to((Object)((JupyterManagedServerConfig)config).getId(), (Object)config);
            map.put((String)pair.getFirst(), (JupyterServerConfig)pair.getSecond());
        }
    }

    private final void removeInternalConfig(JupyterServerConfig config) {
        this.getSettings().remove(config.getId());
        JupyterServerSecretState.INSTANCE.removeConfiguredSecret(config);
        JupyterServerConfig jupyterServerConfig = config;
        if (jupyterServerConfig instanceof JupyterConfiguredServerConfig) {
            this.getConfigStorage().removeConfigured((JupyterConfiguredServerConfig)config);
        } else if (jupyterServerConfig instanceof JupyterManagedServerConfig) {
            this.getConfigStorage().removeManaged((JupyterManagedServerConfig)config);
        }
    }

    private final List<JupyterManagedServerConfig> loadManaged() {
        Collection collection;
        Collection collection2 = this.getConfigStorage().getAllManaged();
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOf((Object)JupyterManagedServerConfig.Companion.getDEFAULT());
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JupyterConfiguredServerConfig> loadConfigured() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getConfigStorage().getAllConfigured();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JupyterConfiguredServerConfig jupyterConfiguredServerConfig = (JupyterConfiguredServerConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JupyterServerSecretState.INSTANCE.getUpdateConfiguredSettings((JupyterConfiguredServerConfig)it));
        }
        return (List)destination$iv$iv;
    }

    public final boolean isMigrated() {
        return this.getConfigStorage().isMigrated();
    }

    public final void setIsMigrated() {
        this.getConfigStorage().setMigrated(true);
    }

    public final boolean isMoreThanOneManaged() {
        return Companion.getInstance().getConfigStorage().getManagedSize() >= 2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map settings_delegate$lambda$0(JupyterConnectionSettingsManager this$0) {
        void $this$associateByTo$iv$iv;
        List allConfigs = CollectionsKt.plus((Collection)this$0.loadManaged(), (Iterable)this$0.loadConfigured());
        if (allConfigs.isEmpty()) {
            allConfigs = CollectionsKt.listOf((Object)JupyterManagedServerConfig.Companion.getDEFAULT());
        }
        Iterable $this$associateBy$iv = allConfigs;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            JupyterServerConfig jupyterServerConfig = (JupyterServerConfig)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        return MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager;", "notifier", "Lcom/intellij/jupyter/core/jupyter/connections/settings/listeners/JupyterConnectionSettingsListener;", "getNotifier", "()Lcom/intellij/jupyter/core/jupyter/connections/settings/listeners/JupyterConnectionSettingsListener;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterConnectionSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConnectionSettingsManager.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,231:1\n30#2,2:232\n*S KotlinDebug\n*F\n+ 1 JupyterConnectionSettingsManager.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager$Companion\n*L\n227#1:232,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterConnectionSettingsManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<JupyterConnectionSettingsManager> serviceClass$iv = JupyterConnectionSettingsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterConnectionSettingsManager)object;
        }

        @NotNull
        public final JupyterConnectionSettingsListener getNotifier() {
            return notifier;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

