/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandler;
import com.intellij.jupyter.core.jupyter.data.input.DndToolBarPanelUI;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellToolbarInlayControllerKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputSelectPopupAction;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputVariableName;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputVariablePopup;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.ui.SteadyUIPanel;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.PanelUI;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDnDToolbarPanel;", "Lcom/intellij/notebooks/ui/SteadyUIPanel;", "Lcom/intellij/ide/dnd/DnDNativeTarget;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "variableName", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputVariableName;", "notebookCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "drop", "", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "getDndFilePathOrNull", "Ljava/nio/file/Path;", "file", "Ljava/io/File;", "update", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterDataInputCellToolbarInlayController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputCellToolbarInlayController.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDnDToolbarPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1#2:168\n777#3:169\n873#3,2:170\n*S KotlinDebug\n*F\n+ 1 JupyterDataInputCellToolbarInlayController.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDnDToolbarPanel\n*L\n138#1:169\n138#1:170,2\n*E\n"})
final class JupyterDnDToolbarPanel
extends SteadyUIPanel
implements DnDNativeTarget {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final JupyterDataInputVariableName variableName;
    @NotNull
    private final JupyterCell notebookCell;

    public JupyterDnDToolbarPanel(@NotNull EditorImpl editor, @NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        super((PanelUI)new DndToolBarPanelUI(editor));
        this.editor = editor;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)this.editor);
        Intrinsics.checkNotNull((Object)backedNotebookVirtualFile);
        JupyterNotebook notebook = backedNotebookVirtualFile.getNotebook();
        this.notebookCell = notebook.getCell(cell.getInterval().getOrdinal());
        this.variableName = new JupyterDataInputVariableName(this.notebookCell, notebook.getLanguage());
        AnAction[] anActionArray = new AnAction[]{new JupyterDataInputSelectPopupAction((Editor)this.editor, this.notebookCell), new JupyterDataInputVariablePopup((Editor)this.editor, this.variableName, JupyterDataInputVariableName.Companion.getNameGenerator())};
        DefaultActionGroup actionGroup = new DefaultActionGroup(anActionArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("EditorTab", (ActionGroup)actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setMiniMode(true);
        this.setOpaque(false);
        this.setLayout(new FlowLayout(0, 0, 0));
        toolbar.getComponent().setOpaque(false);
        toolbar.getComponent().setCursor(Cursor.getDefaultCursor());
        toolbar.getComponent().setBorder(BorderFactory.createEmptyBorder());
        toolbar.setTargetComponent((JComponent)this.editor.getContentComponent());
        this.add(toolbar.getComponent());
    }

    public void drop(@NotNull DnDEvent event) {
        Path path;
        block4: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            List fileListData = JupyterDataInputCellToolbarInlayControllerKt.access$extractFilesFromDnDEvent(event);
            for (File it : (Iterable)fileListData) {
                boolean bl = false;
                Path path2 = this.getDndFilePathOrNull(it);
                if (path2 == null) continue;
                path = path2;
                break block4;
            }
            path = null;
        }
        if (path == null) {
            return;
        }
        Path file = path;
        Project project = this.editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = FileDocumentManager.getInstance().getFile((Document)this.editor.getDocument());
        if (object == null || (object = object.toNioPath()) == null) {
            return;
        }
        Object notebookPath = object;
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        JupyterDataInputCellMetadataKt.setFileInfoUndoable(this.notebookCell, file, project2, (Path)notebookPath, (Document)documentEx);
        this.revalidate();
    }

    private final Path getDndFilePathOrNull(File file) {
        TableDataFileDropHandler tableDataFileDropHandler;
        if (!file.isFile()) {
            return null;
        }
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)this.editor);
        if (jupyterNotebook != null) {
            JupyterNotebook it = jupyterNotebook;
            boolean bl = false;
            tableDataFileDropHandler = TableDataFileDropHandler.Companion.findApplicable(it, FilesKt.getExtension((File)file));
        } else {
            tableDataFileDropHandler = null;
        }
        if (tableDataFileDropHandler == null) {
            return null;
        }
        return file.toPath();
    }

    /*
     * WARNING - void declaration
     */
    public boolean update(@NotNull DnDEvent event) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$filter$iv = JupyterDataInputCellToolbarInlayControllerKt.access$extractFilesFromDnDEvent(event);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(this.getDndFilePathOrNull(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fileList = (List)destination$iv$iv;
        if (fileList.isEmpty()) {
            return true;
        }
        event.setHighlighting((Component)((Object)this), 1);
        event.setDropPossible(true);
        return false;
    }
}

