/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.customizer;

import com.intellij.codeWithMe.ClientId;
import com.intellij.idea.AppMode;
import com.intellij.jupyter.core.console.JupyterConsoleUtil;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookCefHealthManager;
import com.intellij.jupyter.core.jupyter.editor.FocusEditorComponentCaretListener;
import com.intellij.jupyter.core.jupyter.editor.JupyterCustomEditorColorsScheme;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorCustomizer;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.editor.SelectClickedCellEventDispatcher;
import com.intellij.jupyter.core.jupyter.editor.customizer.CoreJupyterEditorCustomizer;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.premium.JupyterFearureAvailabilityInfoProvider;
import com.intellij.jupyter.core.premium.JupyterFeatureAvailabilityCheckerKt;
import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeListenerAdapter;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000bH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/customizer/CoreJupyterEditorCustomizer;", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterEditorCustomizer;", "<init>", "()V", "proNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "onEditorCreated", "", "project", "Lcom/intellij/openapi/project/Project;", "jupyterFileEditor", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditor;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "moveCaret", "textEditor", "checkEditorAndPsi", "editor", "Lcom/intellij/openapi/editor/Editor;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "initProFeatures", "updateNotificationPanel", "panel", "customizeNotebookTextEditor", "fileEditor", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nCoreJupyterEditorCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreJupyterEditorCustomizer.kt\ncom/intellij/jupyter/core/jupyter/editor/customizer/CoreJupyterEditorCustomizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,179:1\n1#2:180\n23#3:181\n42#4,3:182\n*S KotlinDebug\n*F\n+ 1 CoreJupyterEditorCustomizer.kt\ncom/intellij/jupyter/core/jupyter/editor/customizer/CoreJupyterEditorCustomizer\n*L\n110#1:181\n175#1:182,3\n*E\n"})
public final class CoreJupyterEditorCustomizer
implements JupyterEditorCustomizer {
    @Nullable
    private EditorNotificationPanel proNotificationPanel;

    @Override
    public void onEditorCreated(@NotNull Project project, @NotNull JupyterFileEditor jupyterFileEditor, @NotNull BackedNotebookVirtualFile virtualFile) {
        AnAction anAction;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jupyterFileEditor, (String)"jupyterFileEditor");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Editor editor = jupyterFileEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        if (!AppMode.isRemoteDevHost()) {
            NotebookEditorModeListenerAdapter.Companion.setupForEditor((Editor)editor2);
        }
        NotebookCefHealthManager.Companion.install((FileEditor)jupyterFileEditor, (Editor)editor2);
        this.customizeNotebookTextEditor(jupyterFileEditor);
        BackedNotebookVirtualFile notebookVirtualFile2 = JupyterFileEditorExtensionsKt.getNotebookFileOrNull((FileEditor)jupyterFileEditor);
        Object object = notebookVirtualFile2;
        if (object != null && (object = (Set)object.getUserData((Key)JupyterCellLinesExtensionsKt.getJUPYTER_EDITOR_KEY())) != null) {
            object.add(editor2);
        }
        EditorUtil.disposeWithEditor((Editor)((Editor)editor2), () -> CoreJupyterEditorCustomizer.onEditorCreated$lambda$0(notebookVirtualFile2, editor2));
        NotebookUtil.INSTANCE.setJupyterConsoleEditor((Editor)editor2, JupyterConsoleUtil.INSTANCE.isJupyterConsoleFile(jupyterFileEditor.getFile()));
        if (NotebookUtil.INSTANCE.isJupyterConsoleEditor((Editor)editor2)) {
            editor2.setContextMenuGroupId("JupyterConsoleEditorPopupActions");
            anAction = ActionManager.getInstance().getAction("JupyterConsoleEditorGutterPopupActions");
            group = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
            editor2.getGutterComponentEx().setGutterPopupGroup(group);
        } else {
            editor2.setContextMenuGroupId("JupyterEditorPopupActions");
            anAction = ActionManager.getInstance().getAction("JupyterEditorGutterPopupActions");
            group = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
            editor2.getGutterComponentEx().setGutterPopupGroup(group);
            if (!AppMode.isRemoteDevHost()) {
                this.moveCaret(jupyterFileEditor);
            }
        }
        Project project2 = jupyterFileEditor.getEditor().getProject();
        if (project2 != null) {
            Project it = project2;
            boolean bl = false;
            anAction = PsiDocumentManager.getInstance((Project)it);
            if (anAction != null) {
                anAction.performForCommittedDocument(jupyterFileEditor.getEditor().getDocument(), () -> CoreJupyterEditorCustomizer.onEditorCreated$lambda$2(this, jupyterFileEditor, virtualFile));
            }
        }
        virtualFile.getFile().putUserData(JupyterCellLinesExtensionsKt.getNOTEBOOK_VIRTUAL_FILE_KEY(), (Object)virtualFile);
        this.initProFeatures(jupyterFileEditor, project);
    }

    private final void moveCaret(JupyterFileEditor textEditor) {
        JupyterCoroutineKt.launchEdt((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(textEditor, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int I$0;
            int label;
            final /* synthetic */ JupyterFileEditor $textEditor;
            {
                this.$textEditor = $textEditor;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!this.$textEditor.isValid()) {
                            return Unit.INSTANCE;
                        }
                        Editor editor = this.$textEditor.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                        Editor editor2 = editor;
                        List<NotebookCellLines.Interval> list = JupyterHelper.INSTANCE.getCellIntervals(editor2);
                        if (list == null) {
                            return Unit.INSTANCE;
                        }
                        List<NotebookCellLines.Interval> cells = list;
                        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull(cells, (int)0);
                        if (interval == null) {
                            return Unit.INSTANCE;
                        }
                        NotebookCellLines.Interval firstCell = interval;
                        int offset = firstCell.getContentRange(editor2).getStartOffset();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)editor2);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(cells);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)firstCell);
                        this.I$0 = offset;
                        this.label = 1;
                        Object object2 = CoroutinesKt.writeIntentReadAction(() -> moveCaret.1.invokeSuspend$lambda$0(editor2, offset), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        int offset = this.I$0;
                        NotebookCellLines.Interval firstCell = (NotebookCellLines.Interval)this.L$2;
                        List cells = (List)this.L$1;
                        Editor editor = (Editor)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Editor $editor, int $offset) {
                $editor.getCaretModel().getPrimaryCaret().moveToOffset($offset);
                return Unit.INSTANCE;
            }
        }));
    }

    private final void checkEditorAndPsi(Editor editor, JupyterNotebook notebook) {
        Project project = editor.getProject();
        if (!(project != null)) {
            boolean $i$a$-check-CoreJupyterEditorCustomizer$checkEditorAndPsi$32 = false;
            String $i$a$-check-CoreJupyterEditorCustomizer$checkEditorAndPsi$32 = "project must be not null";
            throw new IllegalStateException($i$a$-check-CoreJupyterEditorCustomizer$checkEditorAndPsi$32.toString());
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (!(psiFile instanceof JupyterFile)) {
            boolean $i$a$-check-CoreJupyterEditorCustomizer$checkEditorAndPsi$42 = false;
            String $i$a$-check-CoreJupyterEditorCustomizer$checkEditorAndPsi$42 = "psi file must be Jupyter File, but it isn't. The actual value is: " + psiFile;
            throw new IllegalStateException($i$a$-check-CoreJupyterEditorCustomizer$checkEditorAndPsi$42.toString());
        }
        List intervals = (List)ActionsKt.runReadAction(() -> CoreJupyterEditorCustomizer.checkEditorAndPsi$lambda$2(editor));
        if (notebook.cellsCount() != intervals.size()) {
            CoreJupyterEditorCustomizer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CoreJupyterEditorCustomizer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("size of intervals should be equal to the size of nb cells");
        }
    }

    private final void initProFeatures(JupyterFileEditor editor, Project project) {
        Editor editor2 = editor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        JupyterFearureAvailabilityInfoProvider premiumChecker = JupyterFeatureAvailabilityCheckerKt.getJupyterFeatureAvailabilityChecker(editor2);
        boolean isViewOnly = premiumChecker.isViewOnly();
        if (isViewOnly) {
            EditorNotificationPanel panel;
            if (this.proNotificationPanel == null && (panel = premiumChecker.createNotificationPanel(editor)) != null) {
                this.updateNotificationPanel(project, editor, panel);
                this.proNotificationPanel = panel;
            }
        } else if (this.proNotificationPanel != null) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            FileEditor fileEditor = (FileEditor)editor;
            EditorNotificationPanel editorNotificationPanel = this.proNotificationPanel;
            Intrinsics.checkNotNull((Object)editorNotificationPanel);
            fileEditorManager.removeTopComponent(fileEditor, (JComponent)editorNotificationPanel);
            this.proNotificationPanel = null;
        }
        Editor editor3 = editor.getEditor();
        Intrinsics.checkNotNull((Object)editor3, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor3).setViewer(isViewOnly);
    }

    private final void updateNotificationPanel(Project project, JupyterFileEditor editor, EditorNotificationPanel panel) {
        if (editor.getEditor().getContentComponent().isShowing()) {
            FileEditorManager.getInstance((Project)project).addTopComponent((FileEditor)editor, (JComponent)panel);
        } else {
            JComponent jComponent = editor.getEditor().getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            UiNotifyConnector.Companion.doWhenFirstShown$default((UiNotifyConnector.Companion)UiNotifyConnector.Companion, (Component)jComponent, (boolean)false, () -> CoreJupyterEditorCustomizer.updateNotificationPanel$lambda$0(editor, this, project), (int)2, null);
        }
    }

    private final void customizeNotebookTextEditor(JupyterFileEditor fileEditor) {
        EditorSettings editorSettings;
        Editor editor = fileEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        EditorSettings $this$customizeNotebookTextEditor_u24lambda_u240 = editorSettings = editor2.getSettings();
        boolean bl = false;
        $this$customizeNotebookTextEditor_u24lambda_u240.setVariableInplaceRenameEnabled(true);
        $this$customizeNotebookTextEditor_u24lambda_u240.setUseSoftWraps(true);
        $this$customizeNotebookTextEditor_u24lambda_u240.setAdditionalPageAtBottom(true);
        $this$customizeNotebookTextEditor_u24lambda_u240.setRightMarginShown(false);
        $this$customizeNotebookTextEditor_u24lambda_u240.setVerticalScrollOffset(0);
        EditorColorsScheme editorColorsScheme = editor2.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        JupyterCustomEditorColorsScheme scheme = new JupyterCustomEditorColorsScheme(editorColorsScheme);
        editor2.setColorsScheme((EditorColorsScheme)scheme);
        EditorSettings $this$customizeNotebookTextEditor_u24lambda_u241 = $this$customizeNotebookTextEditor_u24lambda_u240 = editor2.getColorsScheme();
        boolean bl2 = false;
        $this$customizeNotebookTextEditor_u24lambda_u241.setColor(EditorColors.RIGHT_MARGIN_COLOR, null);
        NotebookEditorUiUtilKt.bind((ObservableProperty)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)editor2).getCaretRowBackgroundColor(), (Disposable)((Disposable)fileEditor), arg_0 -> CoreJupyterEditorCustomizer.customizeNotebookTextEditor$lambda$2(editor2, arg_0));
        NotebookEditorUiUtilKt.bind((ObservableProperty)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)editor2).getEditorBackgroundColor(), (Disposable)((Disposable)fileEditor), arg_0 -> CoreJupyterEditorCustomizer.customizeNotebookTextEditor$lambda$3(editor2, scheme, arg_0));
        boolean $i$f$service = false;
        Class<SelectClickedCellEventDispatcher> serviceClass$iv = SelectClickedCellEventDispatcher.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((SelectClickedCellEventDispatcher)object).ensureInstalled();
        editor2.getCaretModel().addCaretListener((CaretListener)FocusEditorComponentCaretListener.INSTANCE);
    }

    private static final void onEditorCreated$lambda$0(BackedNotebookVirtualFile $notebookVirtualFile, EditorEx $editor) {
        block0: {
            Object object = $notebookVirtualFile;
            if (object == null || (object = object.getFile()) == null || (object = (Set)object.getUserData((Key)JupyterCellLinesExtensionsKt.getJUPYTER_EDITOR_KEY())) == null) break block0;
            object.remove($editor);
        }
    }

    private static final void onEditorCreated$lambda$2(CoreJupyterEditorCustomizer this$0, JupyterFileEditor $jupyterFileEditor, BackedNotebookVirtualFile $virtualFile) {
        Editor editor = $jupyterFileEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        this$0.checkEditorAndPsi(editor, $virtualFile.getNotebook());
    }

    private static final List checkEditorAndPsi$lambda$2(Editor $editor) {
        return NotebookCellLines.Companion.get($editor).getIntervals();
    }

    private static final Unit updateNotificationPanel$lambda$0(JupyterFileEditor $editor, CoreJupyterEditorCustomizer this$0, Project $project) {
        if (!$editor.getEditor().isDisposed() && this$0.proNotificationPanel != null) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$project);
            FileEditor fileEditor = (FileEditor)$editor;
            EditorNotificationPanel editorNotificationPanel = this$0.proNotificationPanel;
            Intrinsics.checkNotNull((Object)editorNotificationPanel);
            fileEditorManager.addTopComponent(fileEditor, (JComponent)editorNotificationPanel);
        }
        return Unit.INSTANCE;
    }

    private static final Unit customizeNotebookTextEditor$lambda$2(EditorEx $editor, Color it) {
        $editor.getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, it);
        return Unit.INSTANCE;
    }

    private static final Unit customizeNotebookTextEditor$lambda$3(EditorEx $editor, JupyterCustomEditorColorsScheme $scheme, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $editor.setBackgroundColor(it);
        $scheme.setBackgroundColor(it);
        return Unit.INSTANCE;
    }
}

