/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.markdown;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.KeyboardAwareFocusOwner;
import com.intellij.jupyter.core.jupyter.editor.markdown.JupyterMarkdownFontConfigKt;
import com.intellij.jupyter.core.jupyter.editor.markdown.JupyterMarkdownHtmlPaneKt;
import com.intellij.jupyter.core.jupyter.editor.markdown.MarkdownColors;
import com.intellij.jupyter.core.jupyter.editor.markdown.latex.LatexView;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.notebooks.visualization.ui.NotebookEditorUiUtilKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.View;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001dB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\u0017*\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/JupyterMarkdownHtmlPane;", "Ljavax/swing/JEditorPane;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "Lcom/intellij/ide/KeyboardAwareFocusOwner;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "markdown", "", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Ljava/lang/String;)V", "lastWidth", "", "rootStyle", "Ljavax/swing/text/html/StyleSheet;", "currentStyle", "html", "updateUI", "", "skipKeyEventDispatcher", "", "event", "Ljava/awt/event/KeyEvent;", "getPreferredSize", "Ljava/awt/Dimension;", "visibleAreaChanged", "e", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "coerceAtLeastAtEditorWidth", "onUiChange", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterMarkdownHtmlPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterMarkdownHtmlPane.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/JupyterMarkdownHtmlPane\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,227:1\n19#2:228\n*S KotlinDebug\n*F\n+ 1 JupyterMarkdownHtmlPane.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/JupyterMarkdownHtmlPane\n*L\n150#1:228\n*E\n"})
public final class JupyterMarkdownHtmlPane
extends JEditorPane
implements VisibleAreaListener,
KeyboardAwareFocusOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    private int lastWidth;
    @NotNull
    private final StyleSheet rootStyle;
    @Nullable
    private StyleSheet currentStyle;
    @NlsSafe
    @Language(value="HTML")
    @NotNull
    private final String html;
    @NotNull
    private static final Set<Integer> keysToForward;

    public JupyterMarkdownHtmlPane(@NotNull EditorImpl editor, @NotNull String markdown) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
        this.editor = editor;
        this.lastWidth = -1;
        this.rootStyle = new StyleSheet();
        VirtualFile virtualFile = FileDocumentManagerImpl.getInstance().getFile((com.intellij.openapi.editor.Document)this.editor.getDocument());
        Intrinsics.checkNotNull((Object)virtualFile);
        this.html = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n      <html>\n      <head>\n        <base href=\"file:///" + virtualFile.getPath() + "\">\n      </head>\n      <body>\n      <div>\n      " + JupyterMarkdownHtmlPaneKt.access$markdownToHtml(markdown, (Editor)this.editor) + "\n      </div>\n      </body>\n      </html>\n    ";
        this.onUiChange();
        this.setBorder((Border)JBUI.Borders.empty());
        this.setContentType(MimeType.TEXT_HTML.getMimeType());
        Function2[] function2Array = new Function2[]{(arg_0, arg_1) -> JupyterMarkdownHtmlPane._init_$lambda$0(this, arg_0, arg_1)};
        this.setEditorKit(new HTMLEditorKitBuilder().withViewFactoryExtensions(function2Array).withStyleSheet(this.rootStyle).build());
        this.setText(this.html);
        this.putClientProperty("JEditorPane.w3cLengthUnits", true);
        this.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.setEditable(false);
        this.setAutoscrolls(false);
        this.setOpaque(false);
        this.addHyperlinkListener(JupyterMarkdownHtmlPane::_init_$lambda$1);
    }

    @Override
    public void updateUI() {
        this.putClientProperty("caretWidth", 1);
        super.updateUI();
        if (this.editor != null) {
            this.onUiChange();
        }
    }

    public boolean skipKeyEventDispatcher(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(event);
        if (keysToForward.contains(keyStroke.getKeyCode())) {
            return false;
        }
        return this.getInputMap().get(keyStroke) != null;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension oldSize = this.getSize();
        Intrinsics.checkNotNull((Object)oldSize);
        Dimension newSize = this.coerceAtLeastAtEditorWidth(oldSize);
        if (!Intrinsics.areEqual((Object)oldSize, (Object)newSize)) {
            this.setSize(newSize);
        }
        Dimension dimension = super.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return this.coerceAtLeastAtEditorWidth(dimension);
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getNewRectangle().width != this.lastWidth) {
            this.lastWidth = e.getNewRectangle().width;
            this.onUiChange();
            this.revalidate();
        }
    }

    private final Dimension coerceAtLeastAtEditorWidth(Dimension $this$coerceAtLeastAtEditorWidth) {
        int editorWidth = NotebookEditorUiUtilKt.getTextEditingAreaWidth((EditorEx)((EditorEx)this.editor));
        if (editorWidth <= $this$coerceAtLeastAtEditorWidth.width) {
            return $this$coerceAtLeastAtEditorWidth;
        }
        return new Dimension(editorWidth, $this$coerceAtLeastAtEditorWidth.height);
    }

    private final void onUiChange() {
        Pair<Integer, String> pair;
        MarkdownColors it = new MarkdownColors();
        boolean bl = false;
        this.setBackground(it.getBackground());
        this.setForeground(it.getForeground());
        if (this.currentStyle != null) {
            StyleSheet styleSheet = this.currentStyle;
            Intrinsics.checkNotNull((Object)styleSheet);
            this.rootStyle.removeStyleSheet(styleSheet);
        }
        Pair<Integer, String> it2 = pair = new Pair<Integer, String>();
        boolean bl2 = false;
        it2.addStyleSheet(JupyterMarkdownHtmlPaneKt.access$getBrowserConfig(this.editor).getCss());
        it2.addStyleSheet(JupyterMarkdownHtmlPaneKt.loadCss$default("base.css", null, 2, null));
        if (ColorUtil.isDark((Color)this.getBackground())) {
            it2.addStyleSheet(JupyterMarkdownHtmlPaneKt.loadCss$default("darcula.css", null, 2, null));
        }
        Pair<Integer, String> style = pair;
        this.rootStyle.addStyleSheet((StyleSheet)style);
        this.currentStyle = style;
        Document $this$asSafely$iv = this.getDocument();
        boolean $i$f$asSafely = false;
        Document document = $this$asSafely$iv;
        if (!(document instanceof DefaultStyledDocument)) {
            document = null;
        }
        DefaultStyledDocument defaultStyledDocument = (DefaultStyledDocument)document;
        if (defaultStyledDocument != null) {
            DefaultStyledDocument document2 = defaultStyledDocument;
            boolean bl3 = false;
            int newWidth = NotebookEditorUiUtilKt.getTextEditingAreaWidth((EditorEx)((EditorEx)this.editor)) - 1;
            if (newWidth > 0) {
                String styleName = "body";
                Style style2 = document2.getStyle(styleName);
                AttributeSet oldStyle = style2 != null ? (AttributeSet)style2 : (AttributeSet)new SimpleAttributeSet();
                document2.removeStyle(styleName);
                Style newStyle = document2.addStyle(styleName, null);
                Enumeration<?> enumeration = oldStyle.getAttributeNames();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getAttributeNames(...)");
                Iterator iterator = CollectionsKt.iterator(enumeration);
                while (iterator.hasNext()) {
                    Object name = iterator.next();
                    if (Intrinsics.areEqual(name, (Object)"width")) continue;
                    newStyle.addAttribute(name, oldStyle.getAttribute(name));
                }
                newStyle.addAttribute("width", String.valueOf(newWidth));
            }
        }
        pair = JupyterMarkdownFontConfigKt.getFontConfig(this.editor.getFontSize());
        int fontSize = ((Number)pair.component1()).intValue();
        String fontFace = (String)pair.component2();
        this.setFont(new Font(fontFace, 0, fontSize));
    }

    private static final View _init_$lambda$0(JupyterMarkdownHtmlPane this$0, Element elem, View view) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        Intrinsics.checkNotNullParameter((Object)view, (String)"<unused var>");
        return Intrinsics.areEqual((Object)elem.getName(), (Object)"latex") ? (View)new LatexView(elem, (Editor)this$0.editor) : null;
    }

    private static final void _init_$lambda$1(HyperlinkEvent it) {
        if (!Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            return;
        }
        String string = it.getURL().getProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProtocol(...)");
        if (StringsKt.startsWith$default((String)string, (String)"http", (boolean)false, (int)2, null)) {
            BrowserUtil.browse((URL)it.getURL());
        }
    }

    static {
        Object[] objectArray = new Integer[]{10, 27, 38, 40, 39};
        keysToForward = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/JupyterMarkdownHtmlPane$Companion;", "", "<init>", "()V", "keysToForward", "", "", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

