/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.markdown.latex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Element;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.scilab.forge.jlatexmath.JMathTeXException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\n\u001a\u00020\u000bH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/TeXIconWrapper;", "", "icon", "Lorg/scilab/forge/jlatexmath/TeXIcon;", "iconId", "", "<init>", "(Lorg/scilab/forge/jlatexmath/TeXIcon;I)V", "getIcon", "()Lorg/scilab/forge/jlatexmath/TeXIcon;", "toString", "", "Companion", "intellij.jupyter.core"})
public final class TeXIconWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TeXIcon icon;
    private final int iconId;
    @NotNull
    private static final Key<List<TeXIconWrapper>> key;
    @NotNull
    public static final String TAG_NAME = "latex";
    @NotNull
    private static final String ICON_ID_FIELD = "iconid";

    private TeXIconWrapper(TeXIcon icon, int iconId) {
        this.icon = icon;
        this.iconId = iconId;
    }

    @NotNull
    public final TeXIcon getIcon() {
        return this.icon;
    }

    @NotNull
    public String toString() {
        return "<latex iconid='" + this.iconId + "'>";
    }

    public /* synthetic */ TeXIconWrapper(TeXIcon icon, int iconId, DefaultConstructorMarker $constructor_marker) {
        this(icon, iconId);
    }

    static {
        Key key = Key.create((String)"latexDocumentKey");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TeXIconWrapper.key = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cR\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/TeXIconWrapper$Companion;", "", "<init>", "()V", "key", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/jupyter/core/jupyter/editor/markdown/latex/TeXIconWrapper;", "TAG_NAME", "", "ICON_ID_FIELD", "create", "tex", "editor", "Lcom/intellij/openapi/util/UserDataHolder;", "fontSize", "", "fontColor", "Ljava/awt/Color;", "texToIcon", "Lorg/scilab/forge/jlatexmath/TeXIcon;", "getFromUserDataHolder", "userDataHolder", "element", "Ljavax/swing/text/Element;", "alignToSameHeight", "", "inlineFormulas", "", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nTeXIconWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeXIconWrapper.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/latex/TeXIconWrapper$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n13#2:70\n1#3:71\n1915#4,2:72\n1915#4,2:74\n*S KotlinDebug\n*F\n+ 1 TeXIconWrapper.kt\ncom/intellij/jupyter/core/jupyter/editor/markdown/latex/TeXIconWrapper$Companion\n*L\n45#1:70\n60#1:72,2\n63#1:74,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final TeXIconWrapper create(@NotNull String tex, @NotNull UserDataHolder editor, float fontSize, @NotNull Color fontColor) {
            TeXIconWrapper teXIconWrapper;
            Intrinsics.checkNotNullParameter((Object)tex, (String)"tex");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)fontColor, (String)"fontColor");
            ArrayList icons = null;
            icons = editor.getUserData(key);
            if (icons == null) {
                icons = new ArrayList();
                editor.putUserData(key, icons);
            }
            TeXIcon teXIcon = this.texToIcon(tex, fontSize, fontColor);
            if (teXIcon == null) {
                return null;
            }
            TeXIcon icon = teXIcon;
            TeXIconWrapper it = teXIconWrapper = new TeXIconWrapper(icon, ((List)icons).size(), null);
            boolean bl = false;
            ((List)icons).add(it);
            return teXIconWrapper;
        }

        private final TeXIcon texToIcon(String tex, float fontSize, Color fontColor) {
            try {
                TeXIcon teXIcon;
                TeXIcon $this$texToIcon_u24lambda_u240 = teXIcon = new TeXFormula(tex).createTeXIcon(0, fontSize);
                boolean bl = false;
                $this$texToIcon_u24lambda_u240.setForeground(fontColor);
                return teXIcon;
            }
            catch (JMathTeXException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TeXIconWrapper.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
                return null;
            }
        }

        @NotNull
        public final TeXIconWrapper getFromUserDataHolder(@NotNull UserDataHolder userDataHolder, @NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)userDataHolder, (String)"userDataHolder");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            int iconId = Integer.parseInt(element.getAttributes().getAttribute(TeXIconWrapper.ICON_ID_FIELD).toString());
            Object object = userDataHolder.getUserData(key);
            Intrinsics.checkNotNull((Object)object);
            return (TeXIconWrapper)((List)object).get(iconId);
        }

        public final void alignToSameHeight(@NotNull Collection<TeXIconWrapper> inlineFormulas) {
            Float f;
            Float f2;
            Intrinsics.checkNotNullParameter(inlineFormulas, (String)"inlineFormulas");
            Iterator iterator = ((Iterable)inlineFormulas).iterator();
            if (!iterator.hasNext()) {
                f2 = null;
            } else {
                TeXIconWrapper it22 = (TeXIconWrapper)iterator.next();
                boolean bl = false;
                float it22 = it22.getIcon().getBox().getDepth();
                while (iterator.hasNext()) {
                    TeXIconWrapper it32 = (TeXIconWrapper)iterator.next();
                    $i$a$-maxOfOrNull-TeXIconWrapper$Companion$alignToSameHeight$maxDepth$1 = false;
                    float it32 = it32.getIcon().getBox().getDepth();
                    it22 = Math.max(it22, it32);
                }
                f2 = Float.valueOf(it22);
            }
            if (f2 == null) {
                return;
            }
            float maxDepth = f2.floatValue();
            Iterable $this$forEach$iv = inlineFormulas;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TeXIconWrapper it = (TeXIconWrapper)element$iv;
                boolean bl = false;
                it.getIcon().getBox().setDepth(maxDepth);
            }
            Iterator iterator2 = ((Iterable)inlineFormulas).iterator();
            if (!iterator2.hasNext()) {
                f = null;
            } else {
                TeXIconWrapper it42 = (TeXIconWrapper)iterator2.next();
                boolean bl = false;
                float it42 = it42.getIcon().getBox().getHeight();
                while (iterator2.hasNext()) {
                    TeXIconWrapper it52 = (TeXIconWrapper)iterator2.next();
                    $i$a$-maxOfOrNull-TeXIconWrapper$Companion$alignToSameHeight$maxHeight$1 = false;
                    float it52 = it52.getIcon().getBox().getHeight();
                    it42 = Math.max(it42, it52);
                }
                f = Float.valueOf(it42);
            }
            if (f == null) {
                return;
            }
            float maxHeight = f.floatValue();
            Iterable $this$forEach$iv2 = inlineFormulas;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                TeXIconWrapper it = (TeXIconWrapper)element$iv;
                boolean bl = false;
                it.getIcon().getBox().setHeight(maxHeight);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

